/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.devconf.DCName;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentComponentRef;

public class DevelopmentComponentRef
extends DCName
implements IDevelopmentComponentRef {
    private String m_compartment;

    public DevelopmentComponentRef(String name, String vendor, String compartment) {
        super(name, vendor);
        this.m_compartment = compartment;
    }

    public DevelopmentComponentRef(IDCProxy proxy) {
        super(proxy.getName(), proxy.getVendor());
        this.m_compartment = proxy.getCompartment().getName();
    }

    public String getCompartment() {
        return this.m_compartment;
    }

    public void setCompartment(String compartment) {
        this.m_compartment = compartment;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DevelopmentComponentRef)) {
            return false;
        }
        DevelopmentComponentRef ref = (DevelopmentComponentRef)obj;
        return this._dataEqual((DevelopmentComponentRef)obj);
    }

    protected boolean _dataEqual(DevelopmentComponentRef ref) {
        return super._dataEqual(ref) && (this.m_compartment != null ? this.m_compartment.equals(ref.m_compartment) : ref.m_compartment == null);
    }

    public String toString() {
        int length = this.getVendor().length() + this.getName().length() + this.m_compartment.length() + 3;
        StringBuffer b = new StringBuffer(length);
        b.append(this.getVendor()).append('/').append(this.getName()).append('(').append(this.m_compartment).append(')');
        return b.toString();
    }

    public int hashCode() {
        int code = super.hashCode();
        if (this.m_compartment != null) {
            code = 37 * code + this.m_compartment.hashCode();
        }
        return code;
    }
}

