/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.cbs.client.IBuildSpace;
import com.sap.tc.cbs.client.IDCRef;
import com.sap.tc.cbs.client.error.CBSServerException;
import com.sap.tc.cbs.client.error.CommunicationException;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.provider.DCInputProvider;
import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.complib.xml.XMLException;
import com.sap.tc.devconf.DCActivityState;
import com.sap.tc.devconf.DCEventType;
import com.sap.tc.devconf.DCMessageType;
import com.sap.tc.devconf.DCNodeSyncMode;
import com.sap.tc.devconf.DCNodeSyncState;
import com.sap.tc.devconf.DCUsageFilter;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.IDCNodeResult;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.InvalidDefinitionException;
import com.sap.tc.devconf.RepositoryAccessException;
import com.sap.tc.devconf.SyncException;
import com.sap.tc.devconf.impl.DCDependenciesManager;
import com.sap.tc.devconf.impl.DCFileInputProvider;
import com.sap.tc.devconf.impl.DCNodeResult;
import com.sap.tc.devconf.impl.DCProxy;
import com.sap.tc.devconf.impl.DCRepositoryInputProvider;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.impl.FileSystemLayout;
import com.sap.tc.devconf.impl.RepositoryLayout;
import com.sap.tc.devconf.impl.VFSHandler;
import com.sap.tc.devconf.impl.syncdb.ComponentSyncDB;
import com.sap.tc.devconf.impl.syncdb.IDCSyncEntry;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsGenericFolder;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

class DevelopmentComponentNode
implements IDevelopmentComponentNode {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$impl$DevelopmentComponentNode == null ? (class$com$sap$tc$devconf$impl$DevelopmentComponentNode = DevelopmentComponentNode.class$("com.sap.tc.devconf.impl.DevelopmentComponentNode")) : class$com$sap$tc$devconf$impl$DevelopmentComponentNode));
    private final DevelopmentConfiguration m_configuration;
    private DevelopmentComponent m_developmentComponent = null;
    private final Compartment m_compartment;
    private final String m_dcVendor;
    private final String m_dcName;
    private List m_children;
    private boolean m_isActive;
    private boolean m_publicPartsLoaded;
    private FileSystemLayout m_fileSystemLayout;
    private DCDependenciesManager m_dependenciesManager;
    private int m_hashCode;
    private static final int _hashStart = 17;
    private static final int _hashPrime = 37;
    static /* synthetic */ Class class$com$sap$tc$devconf$impl$DevelopmentComponentNode;

    public DevelopmentComponentNode(DevelopmentConfiguration configuration, String compartmentName, String dcVendor, String dcName, boolean isActive) {
        this.m_configuration = configuration;
        this.m_compartment = this.m_configuration.getCompartmentObject(compartmentName);
        this.m_dcVendor = dcVendor;
        this.m_dcName = dcName;
        this.m_isActive = isActive;
        this.computeHashCode();
        this.m_fileSystemLayout = new FileSystemLayout(this.m_configuration, this.getCompartmentName(), this.m_dcVendor, this.m_dcName);
        this.m_dependenciesManager = new DCDependenciesManager(this.m_configuration);
    }

    public DevelopmentComponentNode(DCProxy proxy) {
        this.m_configuration = proxy._getDevelopmentConfiguration();
        this.m_compartment = proxy.getCompartment();
        this.m_dcVendor = proxy.getVendor();
        this.m_dcName = proxy.getName();
        this.computeHashCode();
        this.m_isActive = proxy.isRepresentingActiveState();
        this.m_fileSystemLayout = new FileSystemLayout(this.m_configuration, this.getCompartmentName(), this.m_dcVendor, this.m_dcName);
        this.m_dependenciesManager = new DCDependenciesManager(this.m_configuration);
    }

    public String getName() {
        return this.m_dcName;
    }

    public String getVendor() {
        return this.m_dcVendor;
    }

    public DevelopmentComponent getDevelopmentComponent(boolean withPublicParts) throws RepositoryAccessException, InvalidDefinitionException {
        DevelopmentComponent dc = this.tryGetDCFromProxy();
        if (dc != null) {
            this.m_developmentComponent = dc;
        } else {
            this.loadDCData(withPublicParts);
        }
        return this.m_developmentComponent;
    }

    public IVfsFolder getVfsComponentRootFolder() throws RepositoryAccessException {
        IVfsFolder folder = null;
        if (this.m_configuration.isInOfflineMode()) {
            String message = "cannot get VFSRootFolder while in offline mode";
            throw new RepositoryAccessException(message);
        }
        if (!this.m_compartment.hasSourceState()) {
            String message = "cannot get VFSRootFolder for " + this + ". The compartment does not have a sources in configuration " + this.m_configuration.getConfigurationData().getName();
            throw new RepositoryAccessException(message);
        }
        try {
            if (this._isThisStateAvailableLocally()) {
                IVfsFolderItem folderItem;
                FileSystemLayout fsLayout = new FileSystemLayout(this.m_configuration, this.getCompartmentName(), this.m_dcVendor, this.m_dcName);
                VFSHandler vfsHandler = this.m_configuration.getVFSHandler();
                if (vfsHandler != null && (folderItem = vfsHandler.getFolderItemForLocalPath(fsLayout.getRootFolder())) != null) {
                    folder = folderItem.asFolder();
                }
            } else {
                IVfsWorkspace ws = this.m_configuration.getWorkspaceFromCompartmentID(this.getCompartmentName(), this.m_isActive);
                if (ws != null) {
                    RepositoryLayout rLayout = new RepositoryLayout();
                    folder = this.m_configuration.getVFSHandler().getSubFolderFromVfsFolder((IVfsGenericFolder)ws, rLayout.calculateRemoteDCRoot(this.m_dcVendor, this.m_dcName));
                }
            }
        }
        catch (VfsException e) {
            String m = "DTR client error when getting component root folder: " + e.getMessage();
            throw new RepositoryAccessException(m, e);
        }
        catch (DevConfigException e) {
            String m = "Error when getting component root folder: " + ((Throwable)((Object)e)).getMessage();
            throw new RepositoryAccessException(m, (Throwable)((Object)e));
        }
        return folder;
    }

    public List getChildren() throws RepositoryAccessException, InvalidDefinitionException {
        if (this.m_children == null) {
            List list;
            if (this._isThisStateAvailableLocally()) {
                if (this.isLoadingDataRequired(false)) {
                    this.loadDCDataLocally(false);
                }
                list = this.listChildrenFromDCData();
            } else if (this.m_configuration.isLocalConfiguration() || this.m_configuration.isInOfflineMode()) {
                list = new ArrayList();
            } else {
                boolean loadedFromRemoteServer = false;
                if (this.getDataFromCBS()) {
                    list = this.listChildrenFromBuildServer();
                    loadedFromRemoteServer = true;
                } else {
                    if (this.isLoadingDataRequired(false)) {
                        this.loadDCDataFromRepository(false);
                        loadedFromRemoteServer = true;
                    }
                    list = this.listChildrenFromDCData();
                }
                if (loadedFromRemoteServer && this.m_configuration.isWithBuildServer() && this.m_isActive) {
                    this.updateDCNodesArchiveSyncState(list);
                }
            }
            this.m_children = list;
        }
        return this.m_children;
    }

    private void updateDCNodesArchiveSyncState(List nodes) {
        String thisMethod = "updateChildArchiveSyncState";
        try {
            this.m_configuration.refreshSyncStateOfNodesSynchedAsArchives(this.getCompartmentName(), nodes);
        }
        catch (SyncException e) {
            LOCATION.traceThrowableT(300, thisMethod, "Could not update synch state of child nodes of {}", new Object[]{this}, (Throwable)((Object)e));
            String m = "Could not update synch state of child nodes. Error: " + ((Throwable)((Object)e)).getMessage();
            this.m_configuration.sendDCMessage(this, "", DCMessageType.ERROR, DCEventType.GENERIC_DC_EVENT, m);
        }
        catch (DevConfigException e) {
            LOCATION.traceThrowableT(300, thisMethod, "Could not update synch state of child nodes of {0}", new Object[]{this}, (Throwable)((Object)e));
            String m = "Could not update synch state of child nodes. Error: " + ((Throwable)((Object)e)).getMessage();
            this.m_configuration.sendDCMessage(this, "", DCMessageType.ERROR, DCEventType.GENERIC_DC_EVENT, m);
        }
    }

    private boolean getDataFromCBS() {
        return this.m_isActive && !this.m_compartment.isLocal() && this.m_configuration.isWithBuildServer() && !this.m_compartment.hasSourceState();
    }

    public IDCProxy getDevelopmentComponentProxy() {
        DCProxy proxy;
        try {
            proxy = this._getDCProxy();
        }
        catch (DevConfigException e) {
            LOCATION.catching("getDevelopmentComponentProxy", (Throwable)((Object)e));
            this.m_configuration.sendDCMessage(this, "", DCMessageType.ERROR, DCEventType.GENERIC_DC_EVENT, ((Throwable)((Object)e)).getMessage());
            proxy = null;
        }
        return proxy;
    }

    public DCNodeSyncState getNodeSyncState() {
        return this.m_configuration.calculateSyncStateForDC(this.getCompartmentName(), this.m_dcVendor, this.m_dcName);
    }

    public DCNodeSyncMode getNodeSyncMode() {
        return this.m_configuration.calculateSyncModeForDC(this.getCompartmentName(), this.m_dcVendor, this.m_dcName);
    }

    public void refresh() {
        String thisMethod = "refresh()";
        this.m_developmentComponent = null;
        this.m_children = null;
        try {
            this.m_configuration.refreshProxyCache(this.getCompartmentName(), this.m_dcVendor, this.m_dcName, !this.m_isActive);
        }
        catch (DevConfigException e) {
            LOCATION.traceThrowableT(300, thisMethod, "caught DevConfigException when refreshing chached proxy. Ignoring it.", (Throwable)((Object)e));
        }
    }

    public String getComponentRootFolder() {
        return this.m_fileSystemLayout.getRootFolder();
    }

    public String toString() {
        return this.getCompartmentName() + ":" + this.m_dcVendor + "/" + this.m_dcName;
    }

    public String getCompartmentName() {
        return this.m_compartment.getName();
    }

    public DCActivityState getActivityState() {
        return this.m_configuration.getActivityStateForDC(this.getCompartmentName(), this.m_dcVendor, this.m_dcName);
    }

    public boolean isSynchedAsModifiableSource() {
        DCNodeSyncMode mode = this.getNodeSyncMode();
        return mode == DCNodeSyncMode.SYNCHED_AS_INACTIVE_SOURCE || mode == DCNodeSyncMode.SYNCHED_AS_ACTIVE_SOURCE && this.m_compartment.isModificationAllowed() && this.m_compartment.getSourceState().isLocationChangeable();
    }

    private List listChildrenFromBuildServer() throws RepositoryAccessException {
        ArrayList<DevelopmentComponentNode> list = new ArrayList<DevelopmentComponentNode>();
        try {
            IBuildSpace buildSpace = this.m_configuration._getBuildSpaceProxy();
            IDCRef[] dcrefList = buildSpace.listChildDCs(this.getCompartmentName(), this.m_dcVendor, this.m_dcName);
            int i = 0;
            while (i < dcrefList.length) {
                IDCRef dcRef = dcrefList[i];
                DevelopmentComponentNode node = new DevelopmentComponentNode(this.m_configuration, this.getCompartmentName(), dcRef.getVendor(), dcRef.getName(), this.m_isActive);
                list.add(node);
                ++i;
            }
        }
        catch (DevConfigException e) {
            String msg = "Failed to get list of child DCs for " + this + ". Could not get initialize comuunication with build server: " + ((Throwable)((Object)e)).getMessage();
            throw new RepositoryAccessException(msg, (Throwable)((Object)e));
        }
        catch (CBSServerException e) {
            String msg = "Failed to get list of child DCs for " + this + ": " + e.getMessage();
            throw new RepositoryAccessException(msg, e);
        }
        catch (CommunicationException e) {
            String msg = "Failed to get list of child DCs for " + this + ": " + e.getMessage();
            throw new RepositoryAccessException(msg, e);
        }
        return list;
    }

    private List listChildrenFromDCData() throws RepositoryAccessException, InvalidDefinitionException {
        List dcs;
        ArrayList<DevelopmentComponentNode> list = new ArrayList<DevelopmentComponentNode>();
        if (this.m_developmentComponent != null && (dcs = this.m_developmentComponent.getEnclosedComponents()) != null) {
            int i = 0;
            while (i < dcs.size()) {
                DCReference dcRef = (DCReference)dcs.get(i);
                DevelopmentComponentNode node = new DevelopmentComponentNode(this.m_configuration, this.getCompartmentName(), dcRef.getVendor(), dcRef.getName(), this.m_isActive);
                list.add(node);
                ++i;
            }
        }
        this.m_children = list;
        return this.m_children;
    }

    private void loadDCData(boolean withPublicParts) throws RepositoryAccessException, InvalidDefinitionException {
        String thisMethod = "loadDCData(boolean)";
        LOCATION.debugT(thisMethod, ":withPublicParts =" + withPublicParts);
        if (this.isLoadingDataRequired(withPublicParts)) {
            if (this._isThisStateAvailableLocally()) {
                LOCATION.debugT(thisMethod, "DC already synched. Reading DC data from local file.");
                this.loadDCDataLocally(withPublicParts);
            } else {
                if (this.m_configuration.isInOfflineMode()) {
                    String m = "Cannot load component data for " + this + ". Not found locally and configuration is not online.";
                    throw new RepositoryAccessException(m);
                }
                if (this.m_isActive && !this.hasSourceState() && this.m_configuration.isWithBuildServer()) {
                    if (this.getDataFromCBS()) {
                        LOCATION.debugT("DC not synched. try to get DC data from build server");
                    }
                    this.loadDCDataFromBuildServer();
                } else {
                    LOCATION.debugT(thisMethod, "DC not synched and no build server configured. Try to get DC data from repository.");
                    this.loadDCDataFromRepository(withPublicParts);
                }
            }
        }
    }

    private boolean _isThisStateAvailableLocally() {
        DCNodeSyncMode mode = this.getNodeSyncMode();
        if (mode == DCNodeSyncMode.NOT_SYNCHED) {
            return false;
        }
        return mode == DCNodeSyncMode.LOCAL_ONLY || this.m_isActive && mode == DCNodeSyncMode.SYNCHED_AS_ACTIVE_SOURCE || this.m_isActive && mode == DCNodeSyncMode.SYNCHED_AS_ARCHIVE || !this.m_isActive && mode == DCNodeSyncMode.SYNCHED_AS_INACTIVE_SOURCE;
    }

    private boolean isLoadingDataRequired(boolean withPublicParts) {
        return this.m_developmentComponent == null || withPublicParts && !this.m_publicPartsLoaded;
    }

    private void loadDCDataFromBuildServer() throws RepositoryAccessException {
        String thisMethod = "loadDCDataFromBuildServer(boolean)";
        try {
            LOCATION.debugT(thisMethod, "trying to load DC data from build server");
            this.m_developmentComponent = this.m_configuration.initializeDCFromBuildServer(this.getCompartmentName(), this.m_dcVendor, this.m_dcName);
            this.m_publicPartsLoaded = true;
        }
        catch (DevConfigException e) {
            throw new RepositoryAccessException("Reading of DC meta data from build server failed: " + ((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
        }
    }

    private void loadDCDataFromRepository(boolean withPublicParts) throws RepositoryAccessException, InvalidDefinitionException {
        try {
            IVfsWorkspace ws = this.m_configuration.getWorkspaceFromCompartmentID(this.getCompartmentName(), this.m_isActive);
            if (ws == null) {
                String m = "Cannot get workspace for compartment " + this.getCompartmentName() + "(active=" + this.m_isActive + "). IVfsWorkspace is null.";
                throw new RepositoryAccessException(m);
            }
            DCRepositoryInputProvider provider = new DCRepositoryInputProvider(this.m_configuration, (IVfsGenericFolder)ws, this.m_dcVendor, this.m_dcName);
            this.m_developmentComponent = ComponentFactory.initialize((DCInputProvider)provider, (boolean)withPublicParts);
            if (withPublicParts) {
                this.m_publicPartsLoaded = true;
            }
        }
        catch (XMLException e) {
            String m = "Error when reading component definition from repository. XML parsing error:" + e.getMessage();
            throw new InvalidDefinitionException(m, e);
        }
        catch (IOException e) {
            String m = "Error when reading component definition from repository. I/O error:" + e.getMessage();
            throw new RepositoryAccessException(m, e);
        }
        catch (ProviderException e) {
            String m = "Error when reading component definition from repository:" + e.getMessage();
            throw new RepositoryAccessException(m, e);
        }
        catch (VfsException e) {
            String m = "Error when reading component definition from repository. DTR client error:" + e.getMessage();
            throw new RepositoryAccessException(m, e);
        }
        catch (DevConfigException e) {
            String m = "Error when reading component definition from repository:" + ((Throwable)((Object)e)).getMessage();
            throw new RepositoryAccessException(m, (Throwable)((Object)e));
        }
    }

    private DevelopmentComponent tryGetDCFromProxy() {
        DCProxy cachedProxy;
        String thisMethod = "tryGetDCFromProxy()";
        DevelopmentComponent dc = null;
        if (this.isLocalOnly()) {
            cachedProxy = this.m_configuration.getDcProxyCache().getDCProxyLocal(this.getCompartmentName(), this.m_dcVendor, this.m_dcName);
            if (cachedProxy != null && cachedProxy.isRepresentingActiveState() != this.m_isActive) {
                String m = "Internal Error: states of cached DC proxy and DC node do not match (proxy active: " + cachedProxy.isRepresentingActiveState() + ") for DC " + this;
                IllegalStateException e = new IllegalStateException(m);
                LOCATION.throwing(thisMethod, (Throwable)e);
                throw e;
            }
        } else {
            cachedProxy = this.m_configuration.getDcProxyCache().getDCProxy(this.getCompartmentName(), this.m_dcVendor, this.m_dcName, !this.m_isActive);
        }
        if (cachedProxy != null) {
            dc = cachedProxy.getComponent();
        }
        return dc;
    }

    public final boolean isAvailableInactive() {
        Compartment comp = this.m_configuration.getCompartmentObject(this.getCompartmentName());
        if (!comp.hasInactiveSourceState()) {
            return false;
        }
        return this.isSynchedAsInActiveSource() || this.isLocalOnlySource();
    }

    public boolean isSynchedAsActiveSource() {
        return this.getNodeSyncMode() == DCNodeSyncMode.SYNCHED_AS_ACTIVE_SOURCE;
    }

    public boolean isSynchedAsInActiveSource() {
        return this.getNodeSyncMode() == DCNodeSyncMode.SYNCHED_AS_INACTIVE_SOURCE;
    }

    public boolean isSynchedAsSource() {
        IDCSyncEntry e = this.m_configuration.getComponentSyncDB().getEntry(this.getCompartmentName(), this.m_dcName, this.m_dcVendor);
        if (e == null) {
            return false;
        }
        return e.isSynchedAsSource();
    }

    public boolean isSynchedAsArchives() {
        IDCSyncEntry e = this.m_configuration.getComponentSyncDB().getEntry(this.getCompartmentName(), this.m_dcName, this.m_dcVendor);
        if (e == null) {
            return false;
        }
        return e.isSynchedAsArchives();
    }

    public boolean isInstalledLocally() {
        return this.getNodeSyncMode() == DCNodeSyncMode.LOCAL_ONLY && this.getNodeSyncState() == DCNodeSyncState.INSTALLED;
    }

    public boolean isLocalOnly() {
        return this.getNodeSyncMode() == DCNodeSyncMode.LOCAL_ONLY;
    }

    public boolean isLocalOnlySource() {
        return this.getNodeSyncMode() == DCNodeSyncMode.LOCAL_ONLY && this.getNodeSyncState() != DCNodeSyncState.INSTALLED;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DevelopmentComponentNode)) {
            return false;
        }
        IDevelopmentComponentNode node = (IDevelopmentComponentNode)obj;
        return this._equals(node);
    }

    private boolean _equals(IDevelopmentComponentNode node) {
        return this._isSameDC(node);
    }

    public boolean isAvailableAsSource() {
        return this.isLocalOnlySource() || this.isSynchedAsSource();
    }

    public boolean hasSourceState() {
        Compartment c = this.m_configuration.getCompartmentObject(this.getCompartmentName());
        return c.hasSourceState();
    }

    public boolean isAvailableAsModifiableSource() {
        Compartment compartment = this.m_configuration.getCompartmentObject(this.getCompartmentName());
        DCNodeSyncMode mode = this.getNodeSyncMode();
        if (mode == DCNodeSyncMode.SYNCHED_AS_INACTIVE_SOURCE) {
            return true;
        }
        if (mode == DCNodeSyncMode.LOCAL_ONLY && this.getNodeSyncState() != DCNodeSyncState.INSTALLED) {
            return true;
        }
        return mode == DCNodeSyncMode.SYNCHED_AS_ACTIVE_SOURCE && compartment.isModificationAllowed() && compartment.getSourceState().isLocationChangeable();
    }

    public boolean IsInactive() {
        return !this.m_isActive;
    }

    public IDevelopmentConfiguration getConfiguration() {
        return this.m_configuration;
    }

    public boolean isSameDC(IDevelopmentComponentNode node) {
        if (node == null) {
            return false;
        }
        return this._isSameDC(node);
    }

    public boolean _isSameDC(IDevelopmentComponentNode node) {
        return this.m_configuration == node.getConfiguration() && this.m_compartment.equals(node.getCompartment()) && this.m_dcName.equals(node.getName()) && this.m_dcVendor.equals(node.getVendor());
    }

    public boolean isSameDCState(IDevelopmentComponentNode node) {
        return this.isSameDC(node) && this.m_isActive == !node.IsInactive();
    }

    private void loadDCDataLocally(boolean withPublicParts) throws InvalidDefinitionException {
        try {
            DCFileInputProvider provider = new DCFileInputProvider(this.m_configuration, this.getCompartmentName(), this.m_dcVendor, this.m_dcName);
            this.m_developmentComponent = ComponentFactory.initialize((DCInputProvider)provider, (boolean)withPublicParts);
            if (withPublicParts) {
                this.m_publicPartsLoaded = true;
            }
        }
        catch (XMLException e) {
            String m = "Error when reading component meta data from local file. XML parsing error: " + e.getMessage();
            throw new InvalidDefinitionException(m, e);
        }
        catch (IOException e) {
            String m = "Error when reading component meta data from local file. I/O  error: " + e.getMessage();
            throw new InvalidDefinitionException(m, e);
        }
        catch (ProviderException e) {
            String m = "Error when reading component meta data from local file: " + e.getMessage();
            throw new InvalidDefinitionException(m, e);
        }
    }

    public boolean isStateAvailableLocally() {
        return this._isThisStateAvailableLocally();
    }

    public Compartment getCompartment() {
        return this.m_compartment;
    }

    public boolean isDirty() {
        return this.m_configuration.isDCDirty(this.m_compartment.getName(), this.m_dcVendor, this.m_dcName);
    }

    public IDCProxy getDCProxy() throws DevConfigException {
        return this._getDCProxy();
    }

    private DCProxy _getDCProxy() throws DevConfigException {
        DCProxy proxy;
        if (this.m_developmentComponent != null && this.m_publicPartsLoaded) {
            proxy = this.m_configuration.getDcProxyCache().getDCProxy(this.m_compartment.getName(), this.m_dcVendor, this.m_dcName, !this.m_isActive);
            if (proxy == null) {
                proxy = DCProxy.createDCProxy(this.m_configuration, this.m_compartment.getName(), this.m_dcVendor, this.m_dcName, this.m_isActive, this.m_developmentComponent);
            }
        } else {
            proxy = this.m_configuration._getDCProxy(this.getCompartmentName(), this.m_dcVendor, this.m_dcName, this.m_isActive);
        }
        return proxy;
    }

    public long getSynchedBuildNumber(String buildVariant) {
        IDCSyncEntry entry = this.m_configuration.getComponentSyncDB().getEntry(this.getCompartmentName(), this.m_dcName, this.m_dcVendor);
        return entry != null ? entry.getBuildNumber(buildVariant) : ComponentSyncDB.NOT_SYNCED_BUILD_NUMBER;
    }

    public void unsync() throws SyncException {
        this.m_configuration.unsync(this.m_compartment, this.m_dcVendor, this.m_dcName);
    }

    public IDCNodeResult listUsedDCs(DCUsageFilter filter, boolean searchRemoteInactive) throws RepositoryAccessException, InvalidDefinitionException {
        ArrayList exceptions = new ArrayList();
        Set usedDCs = this.m_dependenciesManager.listDirectlyUsedDCNodes(this, filter, searchRemoteInactive, exceptions);
        return new DCNodeResult(usedDCs, exceptions);
    }

    public IDCNodeResult listUsedDCs(DCUsageFilter filter) throws RepositoryAccessException, InvalidDefinitionException {
        return this.listUsedDCs(filter, false);
    }

    public IDCNodeResult listUsedInfrastructureDCs() throws SyncException, InvalidDefinitionException {
        ArrayList exceptions = new ArrayList();
        Set usedDCs = this.m_dependenciesManager.listInfrastructureDependenciesNodes(this, exceptions);
        return new DCNodeResult(usedDCs, exceptions);
    }

    public boolean isSynched() {
        IDCSyncEntry e = this.m_configuration.getComponentSyncDB().getEntry(this.getCompartmentName(), this.m_dcName, this.m_dcVendor);
        if (e == null) {
            return false;
        }
        return e.isSynched();
    }

    public String getDefinitionPath() {
        return this.m_fileSystemLayout.getComponentDefinitionFile();
    }

    private void computeHashCode() {
        this.m_hashCode = 17;
        this.m_hashCode = 37 * this.m_hashCode + this.m_configuration.hashCode();
        this.m_hashCode = 37 * this.m_hashCode + this.m_compartment.hashCode();
        this.m_hashCode = 37 * this.m_hashCode + this.m_dcName.hashCode();
        this.m_hashCode = 37 * this.m_hashCode + this.m_dcVendor.hashCode();
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public boolean equals(IDevelopmentComponentNode node) {
        if (node == this) {
            return true;
        }
        if (node == null) {
            return false;
        }
        return this._equals(node);
    }

    List _getChildren() {
        return this.m_children;
    }

    public void syncAsArchives(String buildVariant, boolean forcedSync) throws SyncException {
        this.m_configuration.syncAsArchives(this.getCompartmentName(), this.m_dcVendor, this.m_dcName, buildVariant, forcedSync);
    }

    public void syncAsSources(boolean forcedSync) throws SyncException {
        this.m_configuration.syncAsSources(this.getCompartmentName(), this.m_dcVendor, this.m_dcName, !this.m_isActive, forcedSync);
    }

    public void resync(boolean syncForce) throws SyncException {
        try {
            this._getDCProxy().resync(syncForce);
        }
        catch (DevConfigException e) {
            throw new SyncException(((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e), 38, this.m_compartment.getName(), this.m_dcName, this.m_dcVendor);
        }
    }

    public DCNodeSyncState getNodeSyncState(String buldVariant) {
        return this.m_configuration.calculateSyncStateForDC(this.getCompartmentName(), this.m_dcVendor, this.m_dcName, buldVariant);
    }

    public IDevelopmentComponentNode getBuildPlugin() throws DevConfigException {
        return this.m_dependenciesManager.getBuildPlugin(this);
    }

    DevelopmentConfiguration _getConfiguration() {
        return this.m_configuration;
    }

    public IDCNodeResult listUsedDCsRecursively(DCUsageFilter filter, boolean searchRemoteInactive) throws RepositoryAccessException, InvalidDefinitionException {
        return this.m_dependenciesManager.listRecursivelyUsedDCNodes(new IDevelopmentComponentNode[]{this}, filter, searchRemoteInactive);
    }

    public boolean isBroken() {
        return this.m_configuration.isDCBroken(this.m_compartment.getName(), this.m_dcVendor, this.m_dcName);
    }

    public String getDeployableFolder(String buildVariant) {
        return this.m_fileSystemLayout.getDeployRootFolder(buildVariant);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

