/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.buildplugin.api.IDevelopmentComponentInfo;
import com.sap.tc.buildplugin.api.ILocalBuildProperties;
import com.sap.tc.complib.BuildVariant;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.Dependency;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.PPReference;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.devconf.DCNodeSyncMode;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.impl.BuildSettings;
import com.sap.tc.devconf.impl.DCProxy;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.impl.FileSystemLayout;
import com.sap.tc.logging.Location;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class DevelopmentComponentInfo
implements IDevelopmentComponentInfo {
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$impl$DevelopmentComponentInfo == null ? (class$com$sap$tc$devconf$impl$DevelopmentComponentInfo = DevelopmentComponentInfo.class$("com.sap.tc.devconf.impl.DevelopmentComponentInfo")) : class$com$sap$tc$devconf$impl$DevelopmentComponentInfo));
    static final int VERSION = 3;
    private DevelopmentConfiguration m_configuration;
    private String m_compartmentID;
    private String m_buildVariant;
    private DevelopmentComponent m_component;
    private FileSystemLayout m_layout;
    private List m_infrastructurePathList;
    private ILocalBuildProperties m_localBuildProperties;
    private String m_tempGenFolder;
    static /* synthetic */ Class class$com$sap$tc$devconf$impl$DevelopmentComponentInfo;

    private DevelopmentComponentInfo() {
    }

    public DevelopmentComponentInfo(DevelopmentConfiguration devConf, String compartmentID, DevelopmentComponent component, String buildVariant) {
        this.m_configuration = devConf;
        this.m_component = component;
        this.m_compartmentID = compartmentID;
        this.m_buildVariant = buildVariant;
        this.m_layout = new FileSystemLayout(devConf, compartmentID, component.getVendor(), component.getName());
        this.m_tempGenFolder = this.m_layout.getTempVariantGenFolder(this.m_buildVariant);
    }

    public DevelopmentComponent getCurrentComponent() {
        return this.m_component;
    }

    public String getCurrentBuildVariantName() {
        return this.m_buildVariant;
    }

    public BuildVariant getCurrentBuildVariant() {
        Compartment compartment = (Compartment)this.m_configuration.getDevConfObject().getCompartments().get(this.m_compartmentID);
        return (BuildVariant)compartment.getBuildVariants().get(this.m_buildVariant);
    }

    public String getVariantGenFolder() {
        return this.m_layout.getVariantRootFolder(this.m_buildVariant);
    }

    public String getPublicPartGenFolder(String ppName) {
        return this.m_layout.getPublicPartRootFolder(this.m_buildVariant, ppName);
    }

    public String getComponentRootFolder() {
        return this.m_layout.getRootFolder();
    }

    public String getUsedPublicPartGenFolder(PPReference ppRef) {
        return this.m_layout.getUsedPublicPartRootFolder(this.m_buildVariant, ppRef);
    }

    public String getLocaleGenFolder(String locale) {
        return this.m_layout.getLocaleRootFolder(this.m_buildVariant, locale);
    }

    public String getLocaleRootFolder(String locale) {
        return this.m_layout.getLocaleSourceRootFolder(locale);
    }

    public PublicPart.Purpose getUsedPublicPartPurpose(PPReference ppRef) {
        String thisMethod = "getUsedPublicPartPurpose()";
        String usedCompartment = this.m_configuration.getCompartmentIDFromDCReference(this.m_compartmentID, ppRef.getComponent());
        if (usedCompartment == null) {
            return null;
        }
        if (this.m_configuration.isDCAvailableLocally(usedCompartment, ppRef.getComponent().getVendor(), ppRef.getComponent().getName())) {
            PublicPart pp;
            PublicPart.Purpose purpose;
            DCProxy proxy = null;
            try {
                proxy = this.m_configuration._getDCProxyLocalOrActive(usedCompartment, ppRef.getComponent().getVendor(), ppRef.getComponent().getName());
            }
            catch (DevConfigException e) {
                LOCATION.traceThrowableT(300, thisMethod, "Could not initialize used DC Proxy for " + ppRef.getComponent(), (Throwable)((Object)e));
                return null;
            }
            Map ppMap = proxy.getComponent().getPublicParts();
            if (ppMap != null && (purpose = (pp = (PublicPart)ppMap.get(ppRef.getName())).getPurpose()) != null) {
                if (purpose.equals(PublicPart.Purpose.ASSEMBLY)) {
                    return PublicPart.Purpose.ASSEMBLY;
                }
                if (purpose.equals(PublicPart.Purpose.COMPILATION)) {
                    return PublicPart.Purpose.COMPILATION;
                }
                if (purpose.equals(PublicPart.Purpose.INFRASTRUCTURE)) {
                    return PublicPart.Purpose.INFRASTRUCTURE;
                }
            }
        }
        return null;
    }

    public List getAssemblyPathList() {
        return new ArrayList(this.getUsedPathList(PublicPart.Purpose.ASSEMBLY));
    }

    public Compartment getCompartment() {
        Compartment compartment = (Compartment)this.m_configuration.getDevConfObject().getCompartments().get(this.m_compartmentID);
        return compartment;
    }

    public List getCompilationPathList() {
        return new ArrayList(this.getUsedPathList(PublicPart.Purpose.COMPILATION));
    }

    public List getInfrastructurePathList() {
        return this.m_infrastructurePathList;
    }

    void setInfrastructurePathList(List list) {
        this.m_infrastructurePathList = list;
    }

    public String getSDKPath() throws DevConfigException {
        String propName = this.getRequiredSDKProperty();
        String path = this.m_localBuildProperties.getProperty(propName);
        if (path == null) {
            String msg = "Could not find a build property with path for SDK: " + propName;
            throw new DevConfigException(msg);
        }
        return path;
    }

    public String getRequiredSDKProperty() throws DevConfigException {
        BuildSettings settings = new BuildSettings(this.m_configuration);
        String sdkKey = settings.getRequiredSDK();
        String propName = sdkKey + "_HOME";
        return propName;
    }

    public String getSDKLibraryPath() throws DevConfigException {
        BuildSettings settings = new BuildSettings(this.m_configuration);
        Map.Entry entry = settings.getRequiredSDKWithLibrary();
        String propName = (String)entry.getKey() + "_HOME";
        String lib = (String)entry.getValue();
        String path = this.m_localBuildProperties.getProperty(propName);
        if (path == null) {
            String msg = "Could not find a build property with path for SDK: " + propName;
            throw new DevConfigException(msg);
        }
        path = path + File.separator + lib;
        return path;
    }

    private Set getUsedPathList(PublicPart.Purpose purpose) {
        String thisMethod = "getUsedPathList()";
        HashSet<String> pathList = new HashSet<String>();
        List deps = this.m_component.getDependencies();
        if (deps != null) {
            Iterator iter = deps.iterator();
            while (iter.hasNext()) {
                Map pps;
                Dependency dep = (Dependency)iter.next();
                if (!dep.isAtBuildTime() || dep.isForChildrenOnly()) continue;
                DCReference dcRef = dep.getComponent();
                PPReference ppRef = dep.getPublicPartDependency();
                String usedCompartment = this.m_configuration.getCompartmentIDFromDCReference(this.m_compartmentID, dcRef);
                if (usedCompartment == null) continue;
                DCProxy usedProxy = null;
                try {
                    usedProxy = this.m_configuration._getDCProxyLocalOrActive(usedCompartment, dcRef.getVendor(), dcRef.getName());
                }
                catch (DevConfigException e) {
                    LOCATION.traceThrowableT(300, thisMethod, "Could not initialize used DC Proxy for " + dcRef + ". Skipping this dependency.", (Throwable)((Object)e));
                }
                if (usedProxy == null || (pps = usedProxy.getComponent().getPublicParts()) == null) continue;
                if (ppRef != null && ppRef.getName() != null) {
                    PublicPart pp = (PublicPart)pps.get(ppRef.getName());
                    if (pp == null || !pp.getPurpose().equals(purpose)) continue;
                    pathList.add(this.m_layout.getUsedPublicPartRootFolder(this.m_buildVariant, ppRef));
                    continue;
                }
                Iterator ppiter = pps.values().iterator();
                while (ppiter.hasNext()) {
                    PublicPart pp = (PublicPart)ppiter.next();
                    if (pp == null || !pp.getPurpose().equals(purpose)) continue;
                    ppRef = new PPReference(pp.getName(), dcRef);
                    pathList.add(this.m_layout.getUsedPublicPartRootFolder(this.m_buildVariant, ppRef));
                }
            }
        }
        return pathList;
    }

    public ILocalBuildProperties getLocalBuildProperties() {
        return this.m_localBuildProperties;
    }

    public void setLocalBuildProperties(ILocalBuildProperties localBuildProperties) {
        this.m_localBuildProperties = localBuildProperties;
    }

    public boolean isUsedPublicPartForAssembly(PPReference ppRef) {
        return PublicPart.Purpose.ASSEMBLY.equals(this.getUsedPublicPartPurpose(ppRef));
    }

    public boolean isUsedPublicPartForCompilation(PPReference ppRef) {
        return PublicPart.Purpose.COMPILATION.equals(this.getUsedPublicPartPurpose(ppRef));
    }

    public boolean isUsedPublicPartForInfrastructure(PPReference ppRef) {
        return PublicPart.Purpose.INFRASTRUCTURE.equals(this.getUsedPublicPartPurpose(ppRef));
    }

    public String getSourceCodeLocation() {
        String thisMethod = "getSourceCodeLocation()";
        String result = "UNKNOWN";
        try {
            DCProxy proxy = this.m_configuration._getDCProxyLocally(this.m_compartmentID, this.m_component.getVendor(), this.m_component.getName());
            if (proxy.isLocalOnly()) {
                result = DevelopmentComponentInfo.getUserAtHost();
            } else if (proxy.isSynchedAsInactiveSource()) {
                result = this.m_configuration.getWorkspaceURL(this.m_compartmentID, false);
            } else if (proxy.isSynchedAsActiveSource()) {
                result = this.m_configuration.getWorkspaceURL(this.m_compartmentID, true);
            }
        }
        catch (DevConfigException e) {
            LOCATION.catching(thisMethod, (Throwable)((Object)e));
            LOCATION.infoT("failed to get source code location. Dc not available locally: {0}", new Object[]{((Throwable)((Object)e)).getMessage()});
        }
        return result;
    }

    public DevelopmentComponent getReferencedComponent(Dependency dep) {
        String thisMethod = "getReferencedComponent(Dependency dep)";
        DCReference dcRef = dep.getComponent();
        String usedCompartment = this.m_configuration.getCompartmentIDFromDCReference(this.m_compartmentID, dcRef);
        if (usedCompartment == null) {
            return null;
        }
        DCProxy usedProxy = null;
        try {
            usedProxy = this.m_configuration._getDCProxyLocalOrActive(usedCompartment, dcRef.getVendor(), dcRef.getName());
        }
        catch (DevConfigException e) {
            LOCATION.catching(thisMethod, (Throwable)((Object)e));
            LOCATION.infoT(thisMethod, "Could not initialize used DC Proxy for \"{0}\". Skipping this dependency.", new Object[]{dcRef});
            return null;
        }
        return usedProxy.getComponent();
    }

    private static String getUserAtHost() {
        String user = System.getProperty("user.name", "localuser");
        String host = "localhost";
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOCATION.catching("getUserAtHost", (Throwable)e);
        }
        return user + "@" + host;
    }

    public String getDCVariantTempGenFolder() {
        return this.m_tempGenFolder;
    }

    public int getVersion() {
        return 3;
    }

    public String[] getReservedPackageNames() {
        return this.m_layout.getReservedPackageNames();
    }

    public boolean isLocalConfiguration() {
        return this.m_configuration.isLocalConfiguration();
    }

    public boolean isNameReservationCheckRequired() {
        return this.m_configuration.getConfigurationData().getNameServer() != null && this.m_configuration.calculateSyncModeForDC(this.m_compartmentID, this.m_component.getVendor(), this.m_component.getName()) != DCNodeSyncMode.LOCAL_ONLY;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

