/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.cbs.util.Util;
import com.sap.tc.complib.Compartment;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.impl.NameVendorPair;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.File;
import java.util.Map;

public class DevConfFileSystemLayout {
    public static final String DCS_FOLDER_NAME = "DCs";
    public static final String SCS_FOLDER_NAME = "SCs";
    public static final String COMP_ROOT_FOLDER_NAME = "_comp";
    public static final String COMPARTMENTS_FOLDER_NAME = "Compartments";
    public static final String TOP_LEVEL_DCS_FOLDER_NAME = "TopLevelDCs";
    public static final String TOP_LEVE_DC_REF_EXTENSION = ".dcref";
    public static final String TEMP_FOLDER_NAME = "temp";
    public static final String DEVCONF_DEFINITION_FILE = ".confdef";
    static final String SEPARATOR = File.separator;
    static final char SEPARATOR_CHAR = File.separatorChar;
    private static Location thisLocation = Location.getLocation((Class)(class$com$sap$tc$devconf$impl$DevConfFileSystemLayout == null ? (class$com$sap$tc$devconf$impl$DevConfFileSystemLayout = DevConfFileSystemLayout.class$("com.sap.tc.devconf.impl.DevConfFileSystemLayout")) : class$com$sap$tc$devconf$impl$DevConfFileSystemLayout));
    private Category m_Category;
    private DevelopmentConfiguration m_config;
    static /* synthetic */ Class class$com$sap$tc$devconf$impl$DevConfFileSystemLayout;

    DevConfFileSystemLayout(DevelopmentConfiguration config) {
        this.m_config = config;
    }

    public String getAbsoluteSCRoot(String compartmentName) {
        return Util.concatenatePath((String)this.getRootPathForCompartment(compartmentName), (String)this.getRelativeSCRoot(compartmentName), (char)File.separatorChar);
    }

    public String getRelativeSCRoot(String compartmentName) {
        Map compartments = this.m_config.getConfigurationData().getCompartments();
        if (compartments == null) {
            return null;
        }
        Compartment compartment = (Compartment)compartments.get(compartmentName);
        if (compartment == null) {
            return null;
        }
        String scVendor = compartment.getScVendor();
        String scName = compartment.getScName();
        String path = SCS_FOLDER_NAME + SEPARATOR + scVendor + SEPARATOR + Util.replaceSlashWithSeparator((String)scName) + SEPARATOR + COMP_ROOT_FOLDER_NAME + SEPARATOR;
        if (!compartment.IsDefaultCompartment()) {
            path = COMPARTMENTS_FOLDER_NAME + SEPARATOR + compartmentName + SEPARATOR + path;
        }
        return path;
    }

    public String getAbsoluteDCRoot(String compartmentName, String dcVendor, String dcName) {
        return Util.concatenatePath((String)this.getRootPathForCompartment(compartmentName), (String)this.getRelativeDCRoot(compartmentName, dcVendor, dcName), (char)File.separatorChar);
    }

    public String getRelativeDCRoot(String compartmentName, String dcVendor, String dcName) {
        Compartment compartment = this.getCompartment(compartmentName);
        String path = DCS_FOLDER_NAME + SEPARATOR + dcVendor + SEPARATOR + Util.replaceSlashWithSeparator((String)dcName) + SEPARATOR + COMP_ROOT_FOLDER_NAME + SEPARATOR;
        if (!compartment.IsDefaultCompartment()) {
            path = COMPARTMENTS_FOLDER_NAME + SEPARATOR + compartmentName + SEPARATOR + path;
        }
        return path;
    }

    public String getAbsoluteTopLevelDCsRoot(String compartmentName) {
        String s = Util.concatenatePath((String)this.getAbsoluteSCRoot(compartmentName), (String)TOP_LEVEL_DCS_FOLDER_NAME, (char)SEPARATOR_CHAR);
        return s + SEPARATOR;
    }

    public String calculateTopLevelDCRefFileName(String dcVendor, String dcName) {
        return Util.replaceSlashWithBlank((String)(dcVendor + "/" + dcName)) + TOP_LEVE_DC_REF_EXTENSION;
    }

    private Compartment getCompartment(String compartmentName) {
        Map compartments = this.m_config.getConfigurationData().getCompartments();
        if (compartments == null) {
            throw new IllegalStateException("INTERNAL ERROR: configuration \"" + this.m_config.getConfigurationData().getName() + "\" has no compartments");
        }
        Compartment compartment = (Compartment)compartments.get(compartmentName);
        if (compartment == null) {
            throw new IllegalArgumentException("Compartment \"" + compartmentName + "\" does not exist in configuration \"" + this.m_config.getConfigurationData().getName() + "\"");
        }
        return compartment;
    }

    public String getRootPathForCompartment(String compartmentName) {
        String localArchiveRootPath = this.m_config.getLocalArchiveRootFolder();
        Compartment compartment = this.getCompartment(compartmentName);
        if (compartment.hasLocalArchivesOnly()) {
            if (localArchiveRootPath == null) {
                String msg = "INTERNAL ERROR: Global root folder for pre-installed component archives not defined.";
                throw new IllegalStateException(msg);
            }
            String subFolderName = compartment.getLocalArchiveFolder();
            if (subFolderName == null) {
                String msg = "Configuration Error: no  local archive folder name defined for local-only compartment \"" + compartment.getName() + "\"";
                throw new IllegalStateException(msg);
            }
            return Util.concatenatePath((String)localArchiveRootPath, (String)subFolderName, (char)File.separatorChar);
        }
        return this.m_config.getConfigurationRootFolder();
    }

    public static NameVendorPair parseDCRefFilename(String filename) {
        String nameVendorPart;
        int ind;
        int pos;
        NameVendorPair retVal = null;
        if (filename.endsWith(TOP_LEVE_DC_REF_EXTENSION) && (pos = filename.lastIndexOf(TOP_LEVE_DC_REF_EXTENSION)) > 0 && (ind = (nameVendorPart = filename.substring(0, pos)).indexOf(" ")) != -1) {
            String dcVendor = nameVendorPart.substring(0, ind);
            String dcName = nameVendorPart.substring(ind + 1, nameVendorPart.length());
            if ((dcName = dcName.replace(' ', '/')).length() > 0 && dcVendor.length() > 0) {
                retVal = new NameVendorPair(dcVendor, dcName);
            }
        }
        return retVal;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

