/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.devconf.DCNodeSyncMode;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.DevelopmentConfigurationFactory;
import com.sap.tc.devconf.FileNotExistingException;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevConfFileMonitor;
import com.sap.tc.devconf.impl.DCProxy;
import com.sap.tc.devconf.impl.DevelopmentComponentNode;
import com.sap.tc.devconf.impl.DevelopmentComponentRef;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.impl.syncdb.IDCSyncEntry;
import com.sap.tc.devconf.impl.syncdb.SyncMode;
import com.sap.tc.logging.Location;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DevConfFileMonitor
implements IDevConfFileMonitor {
    private static Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$IDevConfFileMonitor == null ? (class$com$sap$tc$devconf$IDevConfFileMonitor = DevConfFileMonitor.class$("com.sap.tc.devconf.IDevConfFileMonitor")) : class$com$sap$tc$devconf$IDevConfFileMonitor));
    public static final int CHANGE_DELETED = 0;
    public static final int CHANGE_MOFIFIED = 1;
    public static final String DCS_PREFIX = "DCs" + File.separator;
    public static final String COMP_FOLDER_SECTION = File.separator + "_comp" + File.separator;
    public static final String DEF_FOLDER = "def" + File.separator;
    public static final char DC_NAME_SEPARATOR = '/';
    private static boolean _disabled;
    public static final List _specialFolders;
    private DevelopmentConfigurationFactory m_factory;
    private DevelopmentComponentRef m_lastDC = null;
    private String m_lastConfigRoot = null;
    private String m_lastDCFolder = null;
    private String m_lastPublicPartName = null;
    private boolean m_lastOneWasDCDef = false;
    private String m_lastPath = null;
    private String m_lastMonitoredFolderPrefix = null;
    private String m_lastIgnoredFolder = null;
    private boolean m_lastDCdirty = false;
    private Mode m_mode = Mode.ALL_WITH_NOTIFY;
    static /* synthetic */ Class class$com$sap$tc$devconf$IDevConfFileMonitor;

    public DevConfFileMonitor(DevelopmentConfigurationFactory factory) {
        this.m_factory = factory;
    }

    public void notifyFileDeleted(String path) {
        if (_disabled) {
            return;
        }
        this.handeFileChange(path, 0);
    }

    public void notifyFileModified(String path) {
        if (_disabled) {
            return;
        }
        this.handeFileChange(path, 1);
    }

    public void resetMonitorCache() {
        this.m_lastDC = null;
        this.m_lastConfigRoot = null;
        this.m_lastDCFolder = null;
        this.m_lastPublicPartName = null;
        this.m_lastOneWasDCDef = false;
        this.m_lastPath = null;
        this.m_lastMonitoredFolderPrefix = null;
        this.m_lastIgnoredFolder = null;
    }

    private void handeFileChange(String path, int changeType) {
        DCSearchResult result;
        if (this.m_mode == Mode.NOTHING) {
            return;
        }
        if (this.m_mode == Mode.ONE_DC_UNTIL_DIRTY_NO_NOTIFY && this.m_lastDCdirty) {
            return;
        }
        if (path == null || path.length() == 0) {
            return;
        }
        if (path.charAt(path.length() - 1) == File.separatorChar) {
            return;
        }
        if (this.m_lastIgnoredFolder != null) {
            if (this.isParentFolder(this.m_lastIgnoredFolder, path)) {
                this.m_lastPath = path;
                return;
            }
            this.m_lastIgnoredFolder = null;
        }
        if (this.m_lastMonitoredFolderPrefix != null) {
            if (path.startsWith(this.m_lastMonitoredFolderPrefix)) {
                result = this.getLastDC();
                if (result != null && result.syncDbEntry != null && result.devconf != null) {
                    if (this.m_lastMonitoredFolderPrefix.endsWith(DEF_FOLDER)) {
                        this.handlePPFiles(result.devconf, path, changeType, this.m_lastMonitoredFolderPrefix);
                    }
                    this.dirtify(result.devconf, result.syncDbEntry);
                    this.m_lastPath = path;
                    return;
                }
            } else {
                this.m_lastMonitoredFolderPrefix = null;
            }
        }
        if ((result = this.findDC(path)) != null && result.syncDbEntry != null && result.devconf != null) {
            if (this.handledDcDefFile(result.devconf, path, changeType) || this.handlePPFiles(result.devconf, path, changeType, null) || this.isBeneathMonitoredFolder(result.devconf, this.m_lastDC, path)) {
                this.dirtify(result.devconf, result.syncDbEntry);
            } else {
                this.m_lastIgnoredFolder = path.substring(0, path.lastIndexOf(File.separatorChar) + 1);
            }
        }
        this.m_lastPath = path;
    }

    private boolean isParentFolder(String folder, String file) {
        int index1 = file.lastIndexOf(File.separatorChar);
        if (index1 == -1) {
            return folder.length() == 0;
        }
        if (folder.length() == 0) {
            return false;
        }
        int index2 = file.indexOf(folder);
        if (index2 == -1) {
            return false;
        }
        return index1 == index2 + folder.length() - 1;
    }

    private DCSearchResult getLastDC() {
        if (this.m_lastDC != null && this.m_lastDCFolder != null && this.m_lastConfigRoot != null) {
            DevelopmentConfiguration conf = (DevelopmentConfiguration)this.m_factory.lookupDevConfByRootPath(this.m_lastConfigRoot);
            IDCSyncEntry entry = null;
            if (conf == null) {
                this.m_lastConfigRoot = null;
            } else {
                entry = conf.getComponentSyncDB().getEntry(this.m_lastDC);
            }
            if (entry != null) {
                return new DCSearchResult(entry, conf);
            }
        }
        this.m_lastPublicPartName = null;
        this.m_lastOneWasDCDef = false;
        this.m_lastDC = null;
        this.m_lastDCFolder = null;
        return null;
    }

    private boolean isBeneathMonitoredFolder(DevelopmentConfiguration conf, DevelopmentComponentRef dc, String path) {
        IDCProxy dcp;
        String thisMethod = "isBeneathMonitoredFolder";
        try {
            dcp = conf.getDCProxyLocally(dc.getCompartment(), dc.getVendor(), dc.getName());
        }
        catch (DevConfigException e) {
            LOCATION.traceThrowableT(300, thisMethod, "could not get DC Proxy for {0}. Cannot determine if file is source file. Skipping file changed event handling for file {1}.", new Object[]{dc.toString(), path}, (Throwable)((Object)e));
            return false;
        }
        DevelopmentComponent comp = dcp.getComponent();
        return this.isBeneathFolderFromList(comp.getPackageFolders(), path) || this.isBeneathFolderFromList(comp.getSourceFolders(), path) || this.isBeneathFolderFromList(_specialFolders, path);
    }

    private boolean isBeneathFolderFromList(List list, String path) {
        if (list != null) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                String name = this.convertDcNameToPathSegment((String)iter.next());
                int firstOccurrenceOfSourceFolderInCompFolder = path.indexOf(name, this.m_lastDCFolder.length());
                if (firstOccurrenceOfSourceFolderInCompFolder != this.m_lastDCFolder.length()) continue;
                this.m_lastMonitoredFolderPrefix = path.substring(0, firstOccurrenceOfSourceFolderInCompFolder + name.length());
                return true;
            }
        }
        return false;
    }

    private String convertDcNameToPathSegment(String folderName) {
        boolean appendSeparartor;
        boolean bl = appendSeparartor = folderName.charAt(folderName.length() - 1) != '/';
        if (File.separatorChar != '/' && folderName.indexOf(47) != -1) {
            folderName = folderName.replace('/', File.separatorChar);
        }
        String result = appendSeparartor ? folderName + File.separator : folderName;
        return result;
    }

    private boolean handledDcDefFile(DevelopmentConfiguration devconf, String path, int changeType) {
        if (this.m_lastPath != null && this.m_lastPath.equals(path) && this.m_lastOneWasDCDef) {
            devconf.handleLocalDCDefFileChanged(this.m_lastDC, changeType, path);
            return true;
        }
        int dcdefPos = path.lastIndexOf(".dcdef");
        if (dcdefPos == path.length() - ".dcdef".length() && dcdefPos == this.m_lastDCFolder.length()) {
            this.m_lastOneWasDCDef = true;
            devconf.handleLocalDCDefFileChanged(this.m_lastDC, changeType, path);
            return true;
        }
        this.m_lastOneWasDCDef = false;
        return false;
    }

    private boolean handlePPFiles(DevelopmentConfiguration devconf, String path, int changeType, String defFolder) {
        if (this.m_lastPath != null && this.m_lastPath.equals(path) && this.m_lastPublicPartName != null) {
            devconf.handleLocalPPFileChanged(this.m_lastDC, this.m_lastPublicPartName, changeType, path);
            return true;
        }
        if (path.endsWith(".pp")) {
            int defFolderEndPos;
            if (defFolder != null) {
                defFolderEndPos = defFolder.length() - 1;
            } else {
                int defFolderPos = path.indexOf(DEF_FOLDER, this.m_lastDCFolder.length());
                if (defFolderPos == -1 || defFolderPos != this.m_lastDCFolder.length()) {
                    return false;
                }
                defFolderEndPos = defFolderPos + DEF_FOLDER.length() - 1;
            }
            int lastSlashPos = path.lastIndexOf(File.separatorChar);
            if (lastSlashPos == -1 && lastSlashPos != defFolderEndPos) {
                return false;
            }
            int suffixPos = path.length() - ".pp".length();
            if (suffixPos > lastSlashPos + 1) {
                this.m_lastPublicPartName = path.substring(lastSlashPos + 1, suffixPos);
                devconf.handleLocalPPFileChanged(this.m_lastDC, this.m_lastPublicPartName, changeType, path);
                this.m_lastMonitoredFolderPrefix = path.substring(0, defFolderEndPos + 1);
                return true;
            }
            return false;
        }
        this.m_lastPublicPartName = null;
        return false;
    }

    private void dirtify(DevelopmentConfiguration devconf, IDCSyncEntry syncDBentry) {
        if (!syncDBentry.isDirty() && (syncDBentry.isLocalOnlySource() || syncDBentry.isSynchedAsSource())) {
            syncDBentry.setDirty(true);
            this.m_lastDCdirty = true;
            devconf.getComponentSyncDB().save();
            if (this.m_mode == Mode.ALL_WITH_NOTIFY) {
                SyncMode mode = syncDBentry.getMode();
                Compartment compartment = devconf.getCompartmentObject(this.m_lastDC.getCompartment());
                boolean inactive = mode == SyncMode.SYNCHED_AS_INACTIVE_SOURCE || mode == SyncMode.LOCAL_ONLY && DCProxy._isLocallyAvailableStateActive(DCNodeSyncMode.fromSyncMode(mode), compartment);
                DevelopmentComponentNode node = new DevelopmentComponentNode(devconf, this.m_lastDC.getCompartment(), this.m_lastDC.getVendor(), this.m_lastDC.getName(), !inactive);
                devconf.notifyDCDirty(node);
            }
        }
    }

    public IDCProxy getLocalDCProxyForFile(File file) throws DevConfigException {
        IDCProxy proxy = null;
        if (!file.exists()) {
            throw new FileNotExistingException("Illegal Argument for getDCFromFile. File does not exist: " + file.getAbsolutePath());
        }
        String path = file.getAbsolutePath();
        DCSearchResult res = this.findDC(path);
        if (res != null && res.devconf != null && this.m_lastDC != null && this.m_lastDC.getCompartment() != null) {
            DevelopmentConfiguration conf = res.devconf;
            proxy = res.devconf.getDCProxyLocally(this.m_lastDC.getCompartment(), this.m_lastDC.getVendor(), this.m_lastDC.getName());
        }
        return proxy;
    }

    private DCSearchResult findDC(String file) {
        DevelopmentConfiguration conf;
        if (this.m_lastDC != null && this.m_lastDCFolder != null && this.m_lastConfigRoot != null && file.startsWith(this.m_lastDCFolder)) {
            conf = (DevelopmentConfiguration)this.m_factory.lookupDevConfByRootPath(this.m_lastConfigRoot);
            IDCSyncEntry entry = null;
            if (conf == null) {
                this.m_lastConfigRoot = null;
            } else {
                entry = conf.getComponentSyncDB().getEntry(this.m_lastDC);
            }
            if (entry != null) {
                return new DCSearchResult(entry, conf);
            }
        }
        this.m_lastPublicPartName = null;
        this.m_lastOneWasDCDef = false;
        this.m_lastDC = null;
        this.m_lastDCFolder = null;
        if (this.m_lastConfigRoot != null && file.startsWith(this.m_lastConfigRoot) && (conf = (DevelopmentConfiguration)this.m_factory.lookupDevConfByRootPath(this.m_lastConfigRoot)) != null) {
            return this.getDCSyncEntry(conf, file);
        }
        conf = (DevelopmentConfiguration)this.m_factory.findConfigInstanceForPath(file);
        if (conf != null) {
            this.m_lastConfigRoot = conf.getConfigurationRootFolder();
            return this.getDCSyncEntry(conf, file);
        }
        this.m_lastConfigRoot = null;
        return null;
    }

    private DCSearchResult getDCSyncEntry(DevelopmentConfiguration conf, String path) {
        int confRootLength = this.m_lastConfigRoot.length();
        if (path.indexOf(DCS_PREFIX, confRootLength) != confRootLength) {
            return null;
        }
        int compFolderPos = path.indexOf(COMP_FOLDER_SECTION);
        if (compFolderPos == -1) {
            return null;
        }
        int startDC = confRootLength + DCS_PREFIX.length();
        String dcPart = path.substring(startDC, compFolderPos);
        int firstSlashPos = dcPart.indexOf(File.separatorChar);
        if (firstSlashPos == -1 || firstSlashPos == dcPart.length() - 1) {
            return null;
        }
        String dcVendor = dcPart.substring(0, firstSlashPos);
        String dcName = File.separatorChar == '/' ? dcPart.substring(firstSlashPos + 1) : dcPart.substring(firstSlashPos + 1).replace(File.separatorChar, '/');
        IDCSyncEntry entry = conf.getComponentSyncDB().getEntry(dcName, dcVendor);
        if (entry != null) {
            int compPartEndPos = compFolderPos + COMP_FOLDER_SECTION.length();
            this.m_lastDCFolder = path.substring(0, compPartEndPos);
            this.m_lastDC = new DevelopmentComponentRef(dcName, dcVendor, conf.getComponentSyncDB().getCompartmentFor(dcName, dcVendor));
        }
        return new DCSearchResult(entry, conf);
    }

    public Mode setMode(Mode mode) {
        Mode oldmode = this.m_mode;
        this.m_lastDCdirty = false;
        this.m_mode = mode;
        return oldmode;
    }

    public static boolean isDisabled() {
        return _disabled;
    }

    public static void setDisabled(boolean disabled) {
        _disabled = disabled;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _specialFolders = new ArrayList();
        String disabledProp = System.getProperty("devconf.FileMonitorOff", "false");
        _disabled = disabledProp.equalsIgnoreCase("true");
        _specialFolders.add("cfg");
        _specialFolders.add("def");
    }

    static class DCSearchResult {
        public IDCSyncEntry syncDbEntry;
        public DevelopmentConfiguration devconf;

        public DCSearchResult(IDCSyncEntry syncDbEntry, DevelopmentConfiguration devconf) {
            this.devconf = devconf;
            this.syncDbEntry = syncDbEntry;
        }
    }

    public static class Mode {
        public static Mode ALL_WITH_NOTIFY = new Mode("ALL_WITH_NOTIFY");
        public static Mode NOTHING = new Mode("NOTHING");
        public static Mode ONE_DC_UNTIL_DIRTY_NO_NOTIFY = new Mode("ONE_DC_UNTIL_DIRTY_NO_NOTIFY");
        private String m_name;

        private Mode(String name) {
            this.m_name = name;
        }

        public String toString() {
            return this.m_name;
        }
    }
}

