/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.cbs.util.Util;
import com.sap.tc.complib.Compartment;
import com.sap.tc.devconf.DCActivityState;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.DevelopmentConfigurationFactory;
import com.sap.tc.devconf.impl.DevelopmentComponentRef;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.impl.PPRef;
import com.sap.tc.devconf.impl.RemoteStateSynchronizer;
import com.sap.tc.devconf.impl.RepositoryLayout;
import com.sap.tc.devconf.impl.syncdb.ComponentSyncDB;
import com.sap.tc.devconf.impl.syncdb.IDCSyncEntry;
import com.sap.tc.devconf.impl.syncdb.SyncMode;
import com.sap.tc.devconf.impl.syncdb.SyncState;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;

public class DcVfsListenerHandler {
    private static Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$impl$DcVfsListenerHandler == null ? (class$com$sap$tc$devconf$impl$DcVfsListenerHandler = DcVfsListenerHandler.class$("com.sap.tc.devconf.impl.DcVfsListenerHandler")) : class$com$sap$tc$devconf$impl$DcVfsListenerHandler));
    private DevelopmentConfiguration m_config;
    private RemoteStateSynchronizer m_synchronizer;
    private DevelopmentConfigurationFactory m_configFactory;
    static /* synthetic */ Class class$com$sap$tc$devconf$impl$DcVfsListenerHandler;

    public DcVfsListenerHandler(DevelopmentConfiguration config) {
        this.m_config = config;
        this.m_synchronizer = new RemoteStateSynchronizer(config);
    }

    public void activityStateChanged(IVfsActivityRecordedFolderItem folderItem, VfsFolderItemActivityState oldState) {
        String thisMethod = "activityStateChanged";
        DevelopmentComponentRef ref = this.getLocalDCFromFolderItem((IVfsFolderItem)folderItem);
        if (ref == null) {
            return;
        }
        if (ref.equals(this.m_config.getComponentInWork())) {
            LOCATION.debugT(thisMethod, "ingnore DC \"{0}\" because it is just being created ", new Object[]{ref.toString()});
            return;
        }
        IDCSyncEntry entry = this.getSyncDBEntry(ref);
        if (entry == null) {
            return;
        }
        DCActivityState oldDCActState = entry.getActivityState();
        SyncMode oldMode = entry.getMode();
        SyncState oldDCSyncState = this.m_config.getSyncState(ref);
        VfsFolderItemLocationState vfsLocState = folderItem.getLocationState();
        VfsFolderItemActivityState currentVfsActState = folderItem.getActivityState();
        if (LOCATION.beLogged(100)) {
            String msg = "DC \"" + ref + "\" state changed \n   DCMode: " + oldMode + " DCState: " + oldDCSyncState + " DCActivity: " + oldDCActState + "\n   current VFS State:  location :" + vfsLocState + " activity state: " + currentVfsActState + "\n   old VFS Activity state:" + oldState;
            LOCATION.debugT(thisMethod, msg);
        }
        if (currentVfsActState == VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE || vfsLocState == VfsFolderItemLocationState.DELETED) {
            LOCATION.infoT(thisMethod, "VFS report dcdef file for \"{0}\" checked out for delete or deleted: NOT IMPLEMENTED YET", new Object[]{ref});
            return;
        }
        if (oldDCActState == DCActivityState.CHECKED_OUT_FOR_CREATE && currentVfsActState != VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE) {
            if (vfsLocState == VfsFolderItemLocationState.LOCAL_ONLY) {
                this.m_synchronizer.creationReverted(ref, entry);
            } else if (vfsLocState == VfsFolderItemLocationState.DELETED) {
                LOCATION.infoT(thisMethod, "Found VFS location state DELETED when dc syncdb thinks it is CHECKED_OUT_FOR_CREATE: NOT IMPLEMENTED");
            } else {
                this.m_synchronizer.creationCheckedIn(ref, entry);
            }
        }
    }

    PPRef getPPFromFolderItem(IVfsFolderItem folderItem) {
        String thisMethod = "getLocalDCFromFolderItem";
        PPRef ppref = null;
        IVfsFile vfsFile = folderItem.asFile();
        if (vfsFile != null) {
            IVfsWorkspace ws;
            RepositoryLayout rl = new RepositoryLayout();
            String path = this.getWSrelativePath(vfsFile);
            if (path != null && (ppref = rl.parsePPName(path)) != null && (ws = vfsFile.getWorkspace()) != null) {
                String compartmentName = null;
                try {
                    Compartment c = this.m_config.getCompartmentByWorkspace(vfsFile.getWorkspace());
                    if (c != null) {
                        compartmentName = c.getName();
                    }
                }
                catch (DevConfigException e) {
                    LOCATION.catching(thisMethod, (Throwable)((Object)e));
                    String msg = " compartment not found for " + ppref.getDcRef().getVendor() + "/" + ppref.getDcRef().getName();
                    LOCATION.infoT(thisMethod, msg);
                }
                if (compartmentName != null) {
                    ppref.getDcRef().setCompartment(compartmentName);
                } else {
                    ppref = null;
                }
            }
        }
        return ppref;
    }

    DevelopmentComponentRef getLocalDCFromFolderItem(IVfsFolderItem folderItem) {
        String thisMethod = "getLocalDCFromFolderItem";
        DevelopmentComponentRef ref = null;
        IVfsFile vfsFile = folderItem.asFile();
        if (vfsFile != null) {
            IVfsWorkspace ws;
            RepositoryLayout rl = new RepositoryLayout();
            String path = this.getWSrelativePath(vfsFile);
            if (path != null && (ref = rl.parseDCName(path)) != null && (ws = vfsFile.getWorkspace()) != null) {
                String compartmentName = null;
                try {
                    Compartment c = this.m_config.getCompartmentByWorkspace(vfsFile.getWorkspace());
                    if (c != null) {
                        compartmentName = c.getName();
                    }
                }
                catch (DevConfigException e) {
                    LOCATION.catching(thisMethod, (Throwable)((Object)e));
                    String msg = " compartment not found for " + ref.getVendor() + "/" + ref.getName();
                    LOCATION.infoT(thisMethod, msg);
                }
                if (compartmentName != null) {
                    ref.setCompartment(compartmentName);
                } else {
                    ref = null;
                }
            }
        }
        return ref;
    }

    IDCSyncEntry getSyncDBEntry(DevelopmentComponentRef dcref) {
        String thisMethod = "getSyncDBEntry()";
        ComponentSyncDB syncdb = this.m_config.getComponentSyncDB();
        IDCSyncEntry entry = syncdb.getEntry(dcref.getCompartment(), dcref.getName(), dcref.getVendor());
        if (entry == null) {
            LOCATION.infoT(thisMethod, "DC \"{0}\" state change reported by VFS, but DC not found in DC syncdb (ingoring it).)", new Object[]{dcref});
        }
        return entry;
    }

    public void locationStateChangedForDC(DevelopmentComponentRef ref, IVfsFolderItem folderItem, VfsFolderItemLocationState oldState) {
        IDCSyncEntry entry = this.getSyncDBEntry(ref);
        String thisMethod = "locationStateChanged()";
        if (entry == null) {
            return;
        }
        if (entry.getActivityState() != DCActivityState.NONE) {
            return;
        }
        VfsFolderItemLocationState vfsLocState = folderItem.getLocationState();
        if (vfsLocState == VfsFolderItemLocationState.DELETED) {
            LOCATION.infoT(thisMethod, "VFS reported dcdef file for \"" + ref + "\" deleted: Handler NOT IMPLEMENTED YET");
            return;
        }
        if (vfsLocState == VfsFolderItemLocationState.SERVER_ONLY) {
            if (entry.isSynchedAsSource()) {
                // empty if block
            }
        } else if (vfsLocState == VfsFolderItemLocationState.LOCAL_ONLY && entry.isSynchedAsSource()) {
            this.m_synchronizer.synchedSourceNowLocalOnly(ref, entry);
        }
    }

    private String getWSrelativePath(IVfsFile vfsFile) {
        String thisMethod = "getWSrelativePath(IVfsFile)";
        String path = vfsFile.getWorkspaceRelativePath();
        if (path != null) {
            return path;
        }
        try {
            String url = vfsFile.getUrl();
            if (url == null) {
                String m = "failed to get URL of file: \"" + vfsFile.getLocalPath() + " (null)";
                LOCATION.infoT(thisMethod, m);
                return null;
            }
            path = this.m_config.getLocationRelativePathByURL(url);
            return path;
        }
        catch (VfsException e) {
            LOCATION.catching(thisMethod, (Throwable)e);
            String m = "failed to get URL of file: \"" + vfsFile.getLocalPath() + "\"" + " caught:\n" + Util.printStackTraceToString((Throwable)e);
            LOCATION.infoT(thisMethod, m);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

