/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.cbs.client.IDCVariantState;
import com.sap.tc.devconf.DCNotFoundException;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.IDCVariantContext;
import com.sap.tc.devconf.impl.DevelopmentComponentRef;

public class DCVariantContext
implements IDCVariantContext {
    private final IDCVariantState m_variantState;
    private final DevelopmentComponentRef m_dcref;

    DCVariantContext(String compartment, IDCVariantState vntState) {
        this.m_variantState = vntState;
        this.m_dcref = new DevelopmentComponentRef(vntState.getDCRef().getName(), vntState.getDCRef().getVendor(), compartment);
    }

    DCVariantContext(DevelopmentComponentRef dcref) {
        this.m_variantState = null;
        this.m_dcref = dcref;
    }

    public String getDCName() {
        return this.m_dcref.getName();
    }

    public String getDCVendor() {
        return this.m_dcref.getVendor();
    }

    public String getCompartment() {
        return this.m_dcref.getCompartment();
    }

    public String getVariantName() {
        return this.m_variantState.getVariantName();
    }

    public boolean exists() {
        return this.m_variantState != null;
    }

    public long getVariantBuildNumber() throws DevConfigException {
        if (this.m_variantState == null) {
            String msg = "DC \"" + this.getDCVendor() + "/" + this.getDCName() + "\" does not exist on CBS in variant \"" + this.getVariantName() + "\" in compartment \"" + this.getCompartment() + "\"";
            throw new DCNotFoundException(msg, new DevelopmentComponentRef(this.getDCName(), this.getDCVendor(), this.getCompartment()), null);
        }
        return this.m_variantState.getVariantBuildNumber();
    }

    public boolean isBroken() throws DevConfigException {
        if (this.m_variantState == null) {
            String msg = "DC \"" + this.getDCVendor() + "/" + this.getDCName() + "\" does not exist on CBS in variant \"" + this.getVariantName() + "\" in compartment \"" + this.getCompartment() + "\"";
            throw new DCNotFoundException(msg, new DevelopmentComponentRef(this.getDCName(), this.getDCVendor(), this.getCompartment()), null);
        }
        return this.m_variantState.isBroken();
    }

    public boolean isDeployable() throws DevConfigException {
        if (this.m_variantState == null) {
            String msg = "DC \"" + this.getDCVendor() + "/" + this.getDCName() + "\" does not exist on CBS in variant \"" + this.getVariantName() + "\" in compartment \"" + this.getCompartment() + "\"";
            throw new DCNotFoundException(msg, new DevelopmentComponentRef(this.getDCName(), this.getDCVendor(), this.getCompartment()), null);
        }
        return this.m_variantState.isDeployable();
    }

    public boolean isDirty() throws DevConfigException {
        if (this.m_variantState == null) {
            String msg = "DC \"" + this.getDCVendor() + "/" + this.getDCName() + "\" does not exist on CBS in variant \"" + this.getVariantName() + "\" in compartment \"" + this.getCompartment() + "\"";
            throw new DCNotFoundException(msg, new DevelopmentComponentRef(this.getDCName(), this.getDCVendor(), this.getCompartment()), null);
        }
        return this.m_variantState.isDirty();
    }

    public IDCVariantState getVariantState() {
        return this.m_variantState;
    }

    public DevelopmentComponentRef getDcref() {
        return this.m_dcref;
    }
}

