/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.cbs.util.Util;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.provider.DCInputProvider;
import com.sap.tc.complib.provider.PPInputProvider;
import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.NoRemoteFolderItemException;
import com.sap.tc.devconf.RemoteResourceNotAFileException;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.impl.PPRepositoryInputProvider;
import com.sap.tc.devconf.impl.RepositoryLayout;
import com.sap.tc.devconf.impl.VFSHandler;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsGenericFolder;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class DCRepositoryInputProvider
implements DCInputProvider {
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$impl$DCRepositoryInputProvider == null ? (class$com$sap$tc$devconf$impl$DCRepositoryInputProvider = DCRepositoryInputProvider.class$("com.sap.tc.devconf.impl.DCRepositoryInputProvider")) : class$com$sap$tc$devconf$impl$DCRepositoryInputProvider));
    private DevelopmentConfiguration m_devConf;
    private IVfsGenericFolder m_wsRootFolder;
    private IVfsFolder m_compRootFolder;
    private IVfsFolder m_defFolder;
    private String m_dcVendor;
    private String m_dcName;
    private boolean m_loadPublicParts = true;
    static /* synthetic */ Class class$com$sap$tc$devconf$impl$DCRepositoryInputProvider;

    private DCRepositoryInputProvider() {
    }

    public DCRepositoryInputProvider(DevelopmentConfiguration devConf, IVfsGenericFolder rootFolder, String dcVendor, String dcName) throws VfsException {
        this.m_devConf = devConf;
        this.m_wsRootFolder = rootFolder;
        this.m_dcVendor = dcVendor;
        this.m_dcName = dcName;
    }

    public void releaseStream(InputStream reader) {
        String thisMethod = "releaseStream";
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                LOCATION.catching(thisMethod, (Throwable)e);
                String msg = "Error closing input  stream for \"" + this.m_dcVendor + "~" + this.m_dcName + "\"(" + e.getMessage() + ").";
                LOCATION.errorT(thisMethod, msg + " Caught:\n" + Util.printStackTraceToString((Throwable)e));
            }
        }
    }

    public String[] getPublicParts(DevelopmentComponent component) {
        return null;
    }

    public String[] getPublicParts() throws ProviderException {
        if (this.m_loadPublicParts) {
            try {
                IVfsFolder defFolder = this.getDefFolder();
                if (defFolder != null) {
                    IVfsFolderItem[] folderChildren = defFolder.getFolderItems();
                    ArrayList<String> ppNames = new ArrayList<String>();
                    if (folderChildren != null) {
                        int length = folderChildren.length;
                        int i = 0;
                        while (i < length) {
                            String name;
                            int pos;
                            IVfsFolderItem item = folderChildren[i];
                            if (this.isPPFile(item) && (pos = (name = item.getName()).lastIndexOf(".pp")) > 0) {
                                name = name.substring(0, pos);
                                ppNames.add(name);
                            }
                            ++i;
                        }
                    }
                    String[] res = new String[ppNames.size()];
                    Iterator it = ((AbstractList)ppNames).iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        res[i] = (String)it.next();
                        ++i;
                    }
                    return res;
                }
                return new String[0];
            }
            catch (VfsException ex) {
                throw new ProviderException("Can't load public parts of component " + this.m_dcVendor + "/" + this.m_dcName + " : " + ex.getMessage(), (Throwable)ex);
            }
            catch (NoRemoteFolderItemException e) {
                String thisMethod = "getPublicParts";
                LOCATION.catching(thisMethod, (Throwable)((Object)e));
                return new String[0];
            }
            catch (DevConfigException ex) {
                throw new ProviderException("Can't load public parts of component " + this.m_dcVendor + "/" + this.m_dcName + " : " + ((Throwable)((Object)ex)).getMessage(), (Throwable)((Object)ex));
            }
        }
        return new String[0];
    }

    public boolean isPPFile(IVfsFolderItem item) {
        IVfsFile vfsFile = item.asFile();
        if (vfsFile == null) {
            return false;
        }
        String name = vfsFile.getName();
        if (!name.endsWith(".pp")) {
            return false;
        }
        return name.length() > ".pp".length();
    }

    public PPInputProvider getPPInputProvider(String publicPartName) throws ProviderException {
        try {
            IVfsFolder folder = this.getDefFolder();
            if (folder != null) {
                RepositoryLayout rLayout = new RepositoryLayout();
                String defFolderURL = Util.concatenatePath((String)this.m_wsRootFolder.getUrl(), (String)rLayout.calculateRemoteDefFolder(this.m_dcVendor, this.m_dcName), (char)'/');
                return new PPRepositoryInputProvider(publicPartName, this.m_devConf, defFolderURL);
            }
            throw new ProviderException("No def folder available for DC.");
        }
        catch (VfsException ex) {
            String msg = "Error getting component data from repository. Could not get read public parts from repository: " + ex.getMessage();
            throw new ProviderException(msg, (Throwable)ex);
        }
        catch (DevConfigException e) {
            String msg = "Error getting component data from repository. Could not get read public parts from repository: " + ((Throwable)((Object)e)).getMessage();
            throw new ProviderException(msg, (Throwable)((Object)e));
        }
    }

    public InputStream getStreamForDC() throws ProviderException {
        String url = null;
        try {
            RepositoryLayout rLayout = new RepositoryLayout();
            String dcdefRemotePath = Util.concatenatePath((String)rLayout.calculateRemoteDCRoot(this.m_dcVendor, this.m_dcName), (String)".dcdef", (char)'/');
            url = Util.concatenatePath((String)this.m_wsRootFolder.getUrl(), (String)dcdefRemotePath, (char)'/');
            return this.vfsHandler().getFileStreamForURL(url);
        }
        catch (VfsException e) {
            throw new ProviderException("DTR Client error when trying to get component definition file from remote server: " + e.getMessage(), (Throwable)e);
        }
        catch (NoRemoteFolderItemException e) {
            throw new ProviderException("Could not get component definition file from remote server. Not found : " + url, (Throwable)((Object)e));
        }
        catch (RemoteResourceNotAFileException e) {
            throw new ProviderException("Could not get component definition file from remote server. Resource is not a file: " + url, (Throwable)((Object)e));
        }
        catch (DevConfigException e) {
            throw new ProviderException("Could not get component definition file from remote server: " + ((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
        }
    }

    public boolean isValid() {
        String thisMethod = "isValid()";
        try {
            return this.getComponentRootFolder() != null && this.vfsHandler().checkFileInVfsFolder((IVfsGenericFolder)this.getComponentRootFolder(), ".dcdef");
        }
        catch (VfsException e) {
            LOCATION.catching(thisMethod, (Throwable)e);
        }
        catch (DevConfigException e) {
            LOCATION.catching(thisMethod, (Throwable)((Object)e));
        }
        return false;
    }

    public void hidePublicParts(boolean doHide) {
        this.m_loadPublicParts = !doHide;
    }

    private IVfsFolder getDefFolder() throws VfsException, DevConfigException {
        if (this.m_defFolder == null) {
            RepositoryLayout rLayout = new RepositoryLayout();
            String defFolderRemotePath = Util.concatenatePath((String)rLayout.calculateRemoteDCRoot(this.m_dcVendor, this.m_dcName), (String)"def", (char)'/');
            this.m_defFolder = this.vfsHandler().getSubFolderFromVfsFolder(this.m_wsRootFolder, defFolderRemotePath);
            return this.m_defFolder;
        }
        return this.m_defFolder;
    }

    private IVfsFolder getComponentRootFolder() throws VfsException, DevConfigException {
        if (this.m_compRootFolder == null) {
            RepositoryLayout rLayout = new RepositoryLayout();
            this.m_compRootFolder = this.vfsHandler().getSubFolderFromVfsFolder(this.m_wsRootFolder, rLayout.calculateRemoteDCRoot(this.m_dcVendor, this.m_dcName));
        }
        return this.m_compRootFolder;
    }

    private VFSHandler vfsHandler() {
        return this.m_devConf.getVFSHandler();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

