/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.buildplugin.api.IDevelopmentComponentInfo;
import com.sap.tc.buildplugin.api.ILocalBuildProperties;
import com.sap.tc.buildtool.BuildToolException;
import com.sap.tc.buildtool.IBuildResult;
import com.sap.tc.buildtool.PluginHandlerFactory;
import com.sap.tc.cbs.client.IDCVariantState;
import com.sap.tc.cbs.client.error.UnknownDCException;
import com.sap.tc.cbs.util.ArchivePacker;
import com.sap.tc.cbs.util.ArchiveUnpacker;
import com.sap.tc.cbs.util.Util;
import com.sap.tc.cbs.util.archives.ContentMD5Computer;
import com.sap.tc.cbs.util.archives.DataBrowser;
import com.sap.tc.cbs.util.archives.DataNotFoundException;
import com.sap.tc.cbs.util.archives.DataProcessor;
import com.sap.tc.cbs.util.archives.IData;
import com.sap.tc.cbs.util.archives.IDataFilter;
import com.sap.tc.cbs.util.archives.IDataProcessor;
import com.sap.tc.cbs.util.archives.PublishedContentMD5Computer;
import com.sap.tc.cbs.util.archives.data.AbstractKey;
import com.sap.tc.cbs.util.archives.data.J2EEFileData;
import com.sap.tc.cbs.util.archives.data.MD5Key;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.ComponentType;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.Dependency;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.EntityReference;
import com.sap.tc.complib.PPReference;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.complib.Repository;
import com.sap.tc.complib.SourceState;
import com.sap.tc.complib.provider.DCInputProvider;
import com.sap.tc.complib.provider.DCOutputProvider;
import com.sap.tc.complib.provider.PPOutputProvider;
import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.complib.validate.InvalidFileFormatException;
import com.sap.tc.complib.xml.XMLException;
import com.sap.tc.devconf.BuildException;
import com.sap.tc.devconf.CheckoutException;
import com.sap.tc.devconf.CreateException;
import com.sap.tc.devconf.DCActivityState;
import com.sap.tc.devconf.DCEventType;
import com.sap.tc.devconf.DCMessageType;
import com.sap.tc.devconf.DCName;
import com.sap.tc.devconf.DCNodeSyncMode;
import com.sap.tc.devconf.DCNodeSyncState;
import com.sap.tc.devconf.DCSerializationSchemaException;
import com.sap.tc.devconf.DCUsageFilter;
import com.sap.tc.devconf.DCValidationException;
import com.sap.tc.devconf.DependencyValidationOption;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.Digraph;
import com.sap.tc.devconf.IDCNodeResult;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDCProxyListener;
import com.sap.tc.devconf.IDCProxyResult;
import com.sap.tc.devconf.IDCVariantContext;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentComponentRef;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.IUsedDCFoundHandler;
import com.sap.tc.devconf.IllegalDependencyException;
import com.sap.tc.devconf.IllegalEntityReferenceException;
import com.sap.tc.devconf.InvalidDefinitionException;
import com.sap.tc.devconf.NoSourceStateException;
import com.sap.tc.devconf.RemovalException;
import com.sap.tc.devconf.RepositoryAccessException;
import com.sap.tc.devconf.SyncException;
import com.sap.tc.devconf.UsedDCSearchInstruction;
import com.sap.tc.devconf.impl.CBSHandler;
import com.sap.tc.devconf.impl.DCDependenciesManager;
import com.sap.tc.devconf.impl.DCDependencyChecker;
import com.sap.tc.devconf.impl.DCFileInputProvider;
import com.sap.tc.devconf.impl.DCFileOutputProvider;
import com.sap.tc.devconf.impl.DCProxyResult;
import com.sap.tc.devconf.impl.DCRepositoryInputProvider;
import com.sap.tc.devconf.impl.DevConfFileMonitor;
import com.sap.tc.devconf.impl.DevConfFileSystemLayout;
import com.sap.tc.devconf.impl.DevelopmentComponentInfo;
import com.sap.tc.devconf.impl.DevelopmentComponentNode;
import com.sap.tc.devconf.impl.DevelopmentComponentRef;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.impl.FileSystemLayout;
import com.sap.tc.devconf.impl.LocalBuildProperties;
import com.sap.tc.devconf.impl.PPFileOutputProvider;
import com.sap.tc.devconf.impl.SourceUnpacker;
import com.sap.tc.devconf.impl.VFSHandler;
import com.sap.tc.devconf.impl.syncdb.ComponentSyncDB;
import com.sap.tc.devconf.impl.syncdb.IDCSyncEntry;
import com.sap.tc.devconf.impl.syncdb.SyncMode;
import com.sap.tc.devconf.impl.syncdb.SyncState;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsGenericFolder;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.config.IMountPoint;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipException;

public class DCProxy
implements IDCProxy {
    static final Location LOCATION = Location.getLocation((String)"com.sap.tc.devconf.impl.DCProxy");
    public static String DC_TYPE_PLUGIN = "Build Plugin";
    public static String DC_TYPE_INFRA = "Build Infrastructure";
    public static String DC_VENDOR_INFR = "sap.com";
    private static long SYNC_SKIPPED = -2L;
    private static final String TEMP_FOLDER_PREFIX = "CBS~";
    private static final String TEMP_FOLDER_SUFFIX = "~zips";
    private static boolean _isUnpackSourcesFromDeployablesEnabled = true;
    private static final String MD5_DIGEST_NAME = "MD5";
    private static final IDataFilter DEFAULT_HASH_FILTER = new IDataFilter(){

        public boolean accept(IData data) throws IOException {
            String name = data.getName().toLowerCase();
            if (!data.isContainer()) {
                if (name.endsWith(".class")) {
                    return true;
                }
                if (name.endsWith(".mf")) {
                    if (name.equals("manifest.mf") || name.equals("meta-inf/manifest.mf")) {
                        return false;
                    }
                    if (name.equals("sap_manifest.mf") || name.equals("meta-inf/sap_manifest.mf")) {
                        return false;
                    }
                    if (name.equals("dc_manifest.mf") || name.equals("meta-inf/dc_manifest.mf")) {
                        return false;
                    }
                }
                if (name.endsWith(".hash")) {
                    return false;
                }
            }
            return true;
        }
    };
    private final DevelopmentConfiguration m_configuration;
    private final Compartment m_compartment;
    private final FileSystemLayout m_fileSystemLayout;
    private final DCDependenciesManager m_dependenciesManager;
    private final String m_dcVendor;
    private final String m_dcName;
    private final String m_compartmentName;
    private final String m_key;
    private boolean m_isActive;
    private DevelopmentComponent m_component;
    private CBSHandler m_archiveLoader = null;
    private static String nl;
    private Set m_listeners = new HashSet();
    private boolean m_invalid = false;
    private boolean m_deleted = false;
    Map m_variantTempGenFolders = new HashMap();
    private boolean m_isLightweight = false;
    private DecimalFormat m_decimalFormatter = null;

    public static boolean isUnpackSourcesFromDeployablesEnabled() {
        return _isUnpackSourcesFromDeployablesEnabled;
    }

    public static DCProxy createDCProxyLocally(DevelopmentConfiguration configuration, String compartmentName, String dcVendor, String dcName) throws DevConfigException {
        DCProxy proxy = new DCProxy(configuration, compartmentName, dcVendor, dcName);
        proxy.initializeAttributesLocally();
        if (proxy.isDCValid()) {
            proxy.ensureCachedCorrectly();
        }
        return proxy;
    }

    public static DCProxy createDCProxyLocalOrActive(DevelopmentConfiguration configuration, String compartmentName, String dcVendor, String dcName) throws DevConfigException {
        DCProxy proxy = new DCProxy(configuration, compartmentName, dcVendor, dcName);
        proxy.initializeAttributesLocalOrActive();
        if (proxy.isDCValid()) {
            proxy.ensureCachedCorrectly();
        }
        return proxy;
    }

    public static DCProxy createDCProxy(DevelopmentConfiguration configuration, String compartmentName, String dcVendor, String dcName, boolean fromActiveWorkspace) throws DevConfigException {
        return new DCProxy(configuration, compartmentName, dcVendor, dcName, fromActiveWorkspace);
    }

    public static DCProxy createDCProxyFromArchive(DevelopmentConfiguration configuration, String compartmentName, String dcVendor, String dcName, InputStream source) throws DevConfigException {
        DCProxy p = new DCProxy(configuration, compartmentName, dcVendor, dcName);
        p.m_isActive = p.isLocalRegardedAsInactive();
        try {
            p.unpackComponentDefinitionArchive(source);
        }
        catch (ZipException e) {
            String msg = "Failed to read component definition from zip stream for " + compartmentName + ":" + dcVendor + "/" + dcName;
            throw new DevConfigException(msg + " (" + e.getMessage() + ")");
        }
        catch (IOException e) {
            String msg = "Failed to read component definition from zip stream for " + dcName + ":" + dcVendor + "/" + dcName;
            throw new DevConfigException(msg + " (" + e.getMessage() + ")");
        }
        p.initializeAttributesLocally();
        if (p.isDCValid()) {
            p.ensureCachedCorrectly();
        }
        return p;
    }

    public static DCProxy createDCProxy(DevelopmentConfiguration configuration, String compartmentName, String dcVendor, String dcName, boolean isActive, DevelopmentComponent component) throws DevConfigException {
        return new DCProxy(configuration, compartmentName, dcVendor, dcName, isActive, component);
    }

    public static DCProxy createLightweightDCProxy(DevelopmentConfiguration configuration, String compartmentName, String dcVendor, String dcName) {
        DCProxy p = new DCProxy(configuration, compartmentName, dcVendor, dcName);
        p.m_isLightweight = true;
        return p;
    }

    private DCProxy(DevelopmentConfiguration configuration, String compartmentName, String dcVendor, String dcName) {
        this.m_configuration = configuration;
        this.m_compartment = this.m_configuration.getCompartmentObject(compartmentName);
        this.m_compartmentName = this.m_compartment.getName();
        this.m_dcVendor = dcVendor;
        this.m_dcName = dcName;
        this.m_key = this.getKey(this.m_compartmentName, this.m_dcVendor, this.m_dcName);
        this.m_fileSystemLayout = new FileSystemLayout(this.m_configuration, this.m_compartmentName, this.m_dcVendor, this.m_dcName);
        this.m_dependenciesManager = new DCDependenciesManager(this.m_configuration);
    }

    private DCProxy(DevelopmentConfiguration configuration, String compartmentName, String dcVendor, String dcName, boolean fromActiveWorkspace) throws DevConfigException {
        this.m_configuration = configuration;
        this.m_compartment = this.m_configuration.getCompartmentObject(compartmentName);
        this.m_compartmentName = this.m_compartment.getName();
        this.m_isActive = fromActiveWorkspace;
        this.m_dcVendor = dcVendor;
        this.m_dcName = dcName;
        this.m_key = this.getKey(this.m_compartmentName, this.m_dcVendor, this.m_dcName);
        this.m_fileSystemLayout = new FileSystemLayout(this.m_configuration, this.m_compartmentName, this.m_dcVendor, this.m_dcName);
        this.m_dependenciesManager = new DCDependenciesManager(this.m_configuration);
        this.initializeAttributesActiveOrInactive();
        if (this.isDCValid()) {
            this.ensureCachedCorrectly();
        }
    }

    private DCProxy(DevelopmentConfiguration configuration, String compartmentName, String dcVendor, String dcName, boolean fromActiveWorkspace, DevelopmentComponent component) throws DevConfigException {
        this.m_configuration = configuration;
        this.m_compartment = this.m_configuration.getCompartmentObject(compartmentName);
        this.m_compartmentName = this.m_compartment.getName();
        this.m_isActive = fromActiveWorkspace;
        this.m_dcVendor = dcVendor;
        this.m_dcName = dcName;
        this.m_key = this.getKey(this.m_compartmentName, this.m_dcVendor, this.m_dcName);
        this.m_fileSystemLayout = new FileSystemLayout(this.m_configuration, this.m_compartmentName, this.m_dcVendor, this.m_dcName);
        this.m_dependenciesManager = new DCDependenciesManager(this.m_configuration);
        this.m_component = component;
        if (this.isDCValid()) {
            this.ensureCachedCorrectly();
        }
    }

    private void ensureCachedCorrectly() {
        if (!this.m_isLightweight) {
            this.m_configuration.getDcProxyCache().put(this);
        }
    }

    public void changeParent(String parentVendor, String parentName, IVfsActivity activity) throws SyncException, CheckoutException {
        this.assertValidInstance();
        if (this.isAvailableAsModifiableSource()) {
            String message = "Internal Error: Not yet implemented: changeParent()";
            throw new SyncException(message, null);
        }
        String message = "Component \"" + this.m_dcVendor + "/" + this.m_dcName + "\" is not available locally as modifiable source code.";
        throw new CheckoutException(message, null, 3);
    }

    public void syncAsArchives(String buildVariant, boolean forcedSync) throws SyncException {
        this.syncAsArchives(buildVariant, forcedSync, null);
    }

    void syncAsArchives(IDCVariantState vntState, boolean forcedSync) throws SyncException {
        this.syncAsArchives(vntState.getVariantName(), forcedSync, vntState);
    }

    void syncAsArchives(String buildVariant, boolean forcedSync, IDCVariantState vntState) throws SyncException {
        String thisMethod = "syncAsArchives(String, boolean)";
        this.assertValidInstance();
        LOCATION.debugT(thisMethod, "buildVariant: {0},  refreshAll:{1}", new Object[]{buildVariant, new Boolean(forcedSync)});
        if (this.m_configuration.isInOfflineMode()) {
            String m = "Synching  is not allowed in offline mode.";
            throw new SyncException(m, null, 22);
        }
        if (this.m_configuration.getBuildServer() == null) {
            String message = "Cannot sync archives of " + this.m_dcVendor + "/" + this.m_dcName + ". No build server specified in configuration " + this.m_configuration.getDevConfObject().getName();
            throw new SyncException(message, null, 9);
        }
        if (this.isLocalOnly()) {
            String m = "Synching as archives is not allowed. Component is local only.";
            throw new SyncException(m, null, 23, this.m_compartmentName, this.m_dcName, this.m_dcVendor);
        }
        if (this.isSynchedAsSource()) {
            String m = "Synching as archives is not allowed. Component is synched as source.";
            throw new SyncException(m, null, 23, this.m_compartmentName, this.m_dcName, this.m_dcVendor);
        }
        try {
            this.syncArchives(buildVariant, forcedSync, vntState);
        }
        catch (SyncException s) {
            throw s;
        }
        catch (Exception e) {
            String m = "Unknown error while syncing component: " + e.getMessage();
            throw new SyncException(m, e, 0, this.m_compartmentName, this.m_dcName, this.m_dcVendor);
        }
    }

    public void syncAsSources(boolean fromInactive, boolean forcedSync) throws SyncException {
        this.assertValidInstance();
        String thisMethod = "syncAsSources";
        ComponentSyncDB syncdb = this.m_configuration.getComponentSyncDB();
        LOCATION.debugT(thisMethod, "forDevelopment: {0}, refreshAll: {1}", new Object[]{new Boolean(fromInactive), new Boolean(forcedSync)});
        if (this.m_configuration.isInOfflineMode()) {
            String m = "Synching  is not allowed in offline mode.";
            throw new SyncException(m, null, 22);
        }
        if (this.isLocalOnly()) {
            String m = "Synching is not allowed. Component is local only(" + this + ")";
            throw new SyncException(m, null, 23, this.m_compartmentName, this.m_dcName, this.m_dcVendor);
        }
        if (this.isSynchedAsArchives()) {
            String m = "Synching as source is not allowed. Component is synched as archives(" + this + ")";
            throw new SyncException(m, null, 23, this.m_compartmentName, this.m_dcName, this.m_dcVendor);
        }
        if (fromInactive && this.isSynchedAsActiveSource()) {
            String m = "Synching as inactive source is not allowed. Component is synched as active source(" + this + ")";
            throw new SyncException(m, null, 23, this.m_compartmentName, this.m_dcName, this.m_dcVendor);
        }
        if (!fromInactive && this.isSynchedAsInactiveSource()) {
            String m = "Synching as active source is not allowed. Component is already synched as inactive source. (" + this + ")";
            throw new SyncException(m, null, 23, this.m_compartmentName, this.m_dcName, this.m_dcVendor);
        }
        if (this.isSynchedAsSource()) {
            this.resync(forcedSync);
            return;
        }
        boolean wasDirty = this._isDirty();
        DevConfFileMonitor.Mode oldMonitorMode = this.m_configuration.setFileMonitorMode(DevConfFileMonitor.Mode.NOTHING);
        try {
            this.syncSources(fromInactive, forcedSync);
            Object var8_12 = null;
            this.m_configuration.setFileMonitorMode(oldMonitorMode);
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            this.m_configuration.setFileMonitorMode(oldMonitorMode);
            throw throwable;
        }
        IDCSyncEntry syncEntry = syncdb.getEntry(this.m_compartment, this.m_component);
        if (syncEntry == null) {
            syncEntry = syncdb.createEntry(this.m_compartment, this.m_component);
        }
        this.setSyncedAsSource(syncEntry, fromInactive, wasDirty);
    }

    public void createMountPoint(boolean forDevelopment) throws SyncException {
        this.assertValidInstance();
        String thisMethod = "createMountPoint(boolean)";
        LOCATION.debugT(thisMethod, "forDevelopment: {0}", new Object[]{new Boolean(forDevelopment)});
        SourceState sourceState = this.m_configuration.getSourceState(this.m_compartmentName);
        if (sourceState == null) {
            String msg = "No source state configured for compartment of " + this;
            throw new SyncException(msg);
        }
        Repository reposInfo = sourceState.getRepository();
        if (reposInfo == null) {
            String msg = "No repository configured for compartment of " + this;
            throw new SyncException(msg);
        }
        if (this.isAvailableLocally()) {
            if (this.isSynchedAsSource()) {
                if (forDevelopment && this.isSynchedAsInactiveSource()) {
                    return;
                }
                if (!forDevelopment && this.isSynchedAsActiveSource()) {
                    return;
                }
                String msg = "Development component already synced from another workspace.";
                throw new SyncException(msg);
            }
            if (this.isLocalOnly()) {
                String msg = "Development component is not in repository";
                throw new SyncException(msg);
            }
            String msg = "Development component is currently synched as archives";
            throw new SyncException(msg);
        }
        if (this._getVFSHandler().findOrCreateRepositoryServer(reposInfo) == null) {
            throw new SyncException("cannot find or create repository server", null, -1, this.m_compartmentName, this.m_dcName, this.m_dcVendor);
        }
        if (!this.m_configuration.findOrCreateMountPointForDC(this.m_compartmentName, this.m_dcVendor, this.m_dcName, forDevelopment, false)) {
            throw new SyncException("cannot find or create mount point", null, -1, this.m_compartmentName, this.m_dcName, this.m_dcVendor);
        }
    }

    public void removeMountPoint() throws SyncException {
        this.assertValidInstance();
        if (this.isAvailableLocally() && !this.isSynchedAsArchives()) {
            return;
        }
        this._removeMountPoint(true);
    }

    private void syncSources(boolean forDevelopment, boolean forcedSync) throws SyncException {
        String configRootDir = this.m_configuration.getConfigurationRootFolder();
        try {
            String localDCroot = this.m_configuration.getDevConfFSL().getRelativeDCRoot(this.m_compartmentName, this.m_dcVendor, this.m_dcName);
            String localDCpath = configRootDir + localDCroot;
            SourceState sourceState = this.m_configuration.getSourceState(this.m_compartmentName);
            if (sourceState == null) {
                throw new SyncException("no source state available for component", null, 6, this.m_compartmentName, this.m_dcName, this.m_dcVendor);
            }
            Repository reposInfo = sourceState.getRepository();
            if (this._getVFSHandler().findOrCreateRepositoryServer(reposInfo) == null) {
                throw new SyncException("cannot find or create repository server", null, -1, this.m_compartmentName, this.m_dcName, this.m_dcVendor);
            }
            if (!this.m_configuration.findOrCreateMountPointForDC(this.m_compartmentName, this.m_dcVendor, this.m_dcName, forDevelopment, false)) {
                throw new SyncException("cannot  find or create mount point", null, -1, this.m_compartmentName, this.m_dcName, this.m_dcVendor);
            }
            this._getVFSHandler().syncLocalPath(localDCpath, forcedSync);
            DCFileInputProvider dcInputProvider = new DCFileInputProvider(this.m_configuration, this.m_compartmentName, this.m_dcVendor, this.m_dcName);
            this.m_component = ComponentFactory.initialize((DCInputProvider)dcInputProvider);
            this.m_component.initializePublicParts((DCInputProvider)dcInputProvider);
            this.m_isLightweight = false;
        }
        catch (SyncException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SyncException("I/O error when reading component definition: " + e.getMessage(), e, 4, this.m_compartmentName, this.m_dcName, this.m_dcVendor);
        }
        catch (XMLException e) {
            throw new SyncException("XML parsing error when reading component definition: " + e.getMessage(), e, 3, this.m_compartmentName, this.m_dcName, this.m_dcVendor);
        }
        catch (ProviderException e) {
            throw new SyncException("Error with input stream provider when reading component definition: " + e.getMessage(), e, 5, this.m_compartmentName, this.m_dcName, this.m_dcVendor);
        }
        catch (Exception e) {
            throw new SyncException("Unknown error while snycing component: " + e.getMessage(), e, 0, this.m_compartmentName, this.m_dcName, this.m_dcVendor);
        }
    }

    public void syncUsedComponents(String buildVariant, boolean syncForce) throws SyncException {
        Set<DCName> dcnames;
        String thisMethod = "syncUsedComponents(String,boolean)";
        this.assertValidInstance();
        LOCATION.debugT(thisMethod, " this DC:  {0} buildVariant:  {1} refresh all: {2} ", new Object[]{this, buildVariant, new Boolean(syncForce)});
        if (this.m_configuration.isInOfflineMode()) {
            String m = "Synching  is not allowed in offline mode.";
            throw new SyncException(m, null, 22);
        }
        HashMap dcsToBeSynchedAsArchives = new HashMap();
        if (buildVariant == null) {
            try {
                buildVariant = this.m_configuration.getDefaultBuildVariant(this.getCompartmentName());
            }
            catch (DevConfigException e) {
                String msg = "Cannot sync used components. No build variant specified and no default build variant set.";
                throw new SyncException(msg, (Throwable)((Object)e));
            }
        }
        this.syncUsedComponentsHelper(buildVariant, dcsToBeSynchedAsArchives);
        this.syncBuildPluginAndDependencies(buildVariant, dcsToBeSynchedAsArchives);
        HashMap dcNamesByCompartment = new HashMap();
        Iterator iter = dcsToBeSynchedAsArchives.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            IDevelopmentComponentNode node = (IDevelopmentComponentNode)entry.getKey();
            String bv = (String)entry.getValue();
            String compartmentName = node.getCompartmentName();
            HashMap nodesByVariantForCompartmentMap = (HashMap)dcNamesByCompartment.get(compartmentName);
            if (nodesByVariantForCompartmentMap == null) {
                nodesByVariantForCompartmentMap = new HashMap();
                dcNamesByCompartment.put(compartmentName, nodesByVariantForCompartmentMap);
            }
            if ((dcnames = (HashSet)nodesByVariantForCompartmentMap.get(bv)) == null) {
                dcnames = new HashSet();
                nodesByVariantForCompartmentMap.put(bv, dcnames);
            }
            DCName dcName = new DCName(node.getName(), node.getVendor());
            dcnames.add(dcName);
        }
        Iterator iterCompartment = dcNamesByCompartment.keySet().iterator();
        while (iterCompartment.hasNext()) {
            String compartmentName = (String)iterCompartment.next();
            HashMap nodesByVariantForCompartmentMap = (HashMap)dcNamesByCompartment.get(compartmentName);
            if (nodesByVariantForCompartmentMap == null) continue;
            Iterator iternodebyVnt = nodesByVariantForCompartmentMap.keySet().iterator();
            while (iternodebyVnt.hasNext()) {
                String buildVariantName = (String)iternodebyVnt.next();
                dcnames = (Set)nodesByVariantForCompartmentMap.get(buildVariantName);
                if (dcnames == null) continue;
                DCName[] nameArray = dcnames.toArray(new DCName[dcnames.size()]);
                try {
                    Set contexts = this.m_configuration.getDCVariantContexts(compartmentName, buildVariantName, nameArray);
                    Iterator iterCtx = contexts.iterator();
                    while (iterCtx.hasNext()) {
                        IDCVariantContext variantContext = (IDCVariantContext)iterCtx.next();
                        if (variantContext.exists()) {
                            this.m_configuration.syncAsArchives(variantContext, syncForce);
                            continue;
                        }
                        DevelopmentComponentNode node = new DevelopmentComponentNode(this.m_configuration, compartmentName, variantContext.getDCVendor(), variantContext.getDCName(), true);
                        String msg = "Sync used Dcs: Could not find component on build server : " + node;
                        LOCATION.infoT(thisMethod, msg);
                        this.notifyUsedDCSyncWarning(this.toNode(), buildVariant, msg);
                    }
                }
                catch (Exception e) {
                    String msg = "Sync used Dcs: Failed to sync used archives from compartment : " + compartmentName;
                    LOCATION.infoT(thisMethod, msg);
                    this.notifyUsedDCSyncWarning(this.toNode(), buildVariant, msg);
                }
            }
        }
    }

    private Map syncUsedComponentsHelper(String buildVariant, Map dcsTobeSynchedArsArchives) throws SyncException {
        String thisMethod = "syncUsedComponentsHelper()";
        final HashSet<IDevelopmentComponentNode> startDCs = new HashSet<IDevelopmentComponentNode>();
        IDevelopmentComponentNode thisNode = this.toNode();
        startDCs.add(thisNode);
        Set usedDCs = null;
        try {
            usedDCs = this.m_configuration.listUsedDCs(startDCs, new IUsedDCFoundHandler(){

                public boolean onUsedDCError(Exception exception, IDevelopmentComponentNode referncingNode, Dependency dependency) {
                    String methodString = "syncUsedComponentsHelper():IUsedDCFoundHandler#onUsedDCError";
                    String msg = "Error during synchronizing of used components: " + exception.getMessage();
                    LOCATION.debugT(methodString, msg);
                    DCProxy.this.notifyUsedDCSyncWarning(referncingNode, "", msg);
                    return true;
                }

                public boolean onUsedDCError(Exception exception, IDevelopmentComponentNode referncingNode, PPReference reference) {
                    String methodString = "syncUsedComponentsHelper():IUsedDCFoundHandler#onUsedDCError(Exception,IDevelopmentComponentNode,PPReference)";
                    String msg = "Error during synchronizing of used components: " + exception.getMessage();
                    LOCATION.debugT(methodString, msg);
                    DCProxy.this.notifyUsedDCSyncWarning(referncingNode, "", msg);
                    return true;
                }

                public boolean onUsedDCError(Exception exception, IDevelopmentComponentNode problemDC) {
                    String methodString = "syncUsedComponentsHelper():IUsedDCFoundHandler#onUsedDCError(Exception,IDevelopmentComponentNode)";
                    String msg = "Error during synchronizing of used components: " + exception.getMessage();
                    LOCATION.debugT(methodString, msg);
                    DCProxy.this.notifyUsedDCSyncWarning(problemDC, "", msg);
                    return true;
                }

                public UsedDCSearchInstruction atComponentNode(IDevelopmentComponentNode foundDC, IDevelopmentComponentNode usingDC) {
                    UsedDCSearchInstruction result;
                    if (startDCs.contains(foundDC)) {
                        DCUsageFilter filter = new DCUsageFilter(true, true, true, true, true);
                        result = new UsedDCSearchInstruction(filter, false);
                    } else {
                        result = null;
                    }
                    return result;
                }
            });
        }
        catch (DevConfigException e1) {
            String msg = "Error during synchronizing of used components: " + ((Throwable)((Object)e1)).getMessage();
            LOCATION.traceThrowableT(300, "syncUsedComponentsHelper()", msg, (Throwable)((Object)e1));
            this.notifyUsedDCSyncFailed(msg, this.m_isActive);
        }
        if (usedDCs != null) {
            Iterator iter = usedDCs.iterator();
            while (iter.hasNext()) {
                String msg;
                IDevelopmentComponentNode dcnode = (IDevelopmentComponentNode)iter.next();
                if (dcnode.isSynchedAsSource()) {
                    LOCATION.debugT("syncUsedComponentsHelper()", "component is already synched as source. skipping it.");
                    continue;
                }
                if (dcnode.isLocalOnly()) {
                    LOCATION.debugT("syncUsedComponentsHelper()", "component is local only. skipping it.");
                    continue;
                }
                String usedBuildVariant = this.m_configuration.getUsedBuildVariant(this.m_compartmentName, dcnode.getCompartmentName(), buildVariant);
                if (usedBuildVariant == null) {
                    msg = "Synchronize used components: Skipped " + dcnode + ". Cannot determine mapped build varinat for variant " + buildVariant;
                    LOCATION.debugT("syncUsedComponentsHelper()", msg);
                    this.notifyUsedDCSyncWarning(dcnode, "", msg);
                    continue;
                }
                if (!this.m_configuration.isWithBuildServer()) {
                    msg = "Synchronize used components: Skipped " + dcnode + ". No build server configured. Sources must be synched manually.";
                    LOCATION.debugT("syncUsedComponentsHelper()", msg);
                    this.notifyUsedDCSyncWarning(dcnode, "", msg);
                    continue;
                }
                dcsTobeSynchedArsArchives.put(dcnode, usedBuildVariant);
            }
        }
        return dcsTobeSynchedArsArchives;
    }

    public void resync(boolean forceSync) throws SyncException {
        this.assertValidInstance();
        this._resync(forceSync);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean _resync(boolean syncForce) throws SyncException {
        ComponentSyncDB syncdb = this.m_configuration.getComponentSyncDB();
        IDCSyncEntry syncDBEntry = syncdb.getEntry(this.m_compartment.getName(), this.m_dcName, this.m_dcVendor);
        if (!this.isSynchedAsSource()) {
            if (!this.isSynchedAsArchives()) return true;
            this.resyncArchives(syncDBEntry, syncForce);
            return true;
        }
        boolean wasDirty = syncDBEntry.isDirty();
        DevConfFileMonitor.Mode oldMode = this.m_configuration.setFileMonitorMode(DevConfFileMonitor.Mode.ONE_DC_UNTIL_DIRTY_NO_NOTIFY);
        try {
            this._getVFSHandler().syncLocalPath(this.m_fileSystemLayout.getRootFolder(), syncForce);
            File dcdef = new File(this.m_fileSystemLayout.getComponentDefinitionFile());
            if (!dcdef.exists()) {
                this.notifyUnsynchedAfterDTRDeletion();
                this.unsync();
                boolean bl = false;
                Object var12_9 = null;
                this.m_configuration.setFileMonitorMode(oldMode);
                return bl;
            }
            try {
                this.m_component = this.readComponentDefinition();
                this.m_isLightweight = false;
            }
            catch (ProviderException e) {
                String message = "refreshing dc definition failed. ";
                throw new SyncException(message + e.getMessage());
            }
            catch (XMLException e) {
                String message = "refreshing dc definition failed. ";
                throw new SyncException(message + e.getMessage());
            }
            catch (IOException e) {
                String message = "refreshing dc definition failed. ";
                throw new SyncException(message + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            this.m_configuration.setFileMonitorMode(oldMode);
            throw throwable;
        }
        Object var12_10 = null;
        this.m_configuration.setFileMonitorMode(oldMode);
        this.ensureCachedCorrectly();
        if (wasDirty) return true;
        if (!syncDBEntry.isDirty()) return true;
        this.m_configuration.notifyDCDirty(this);
        return true;
    }

    public void unsync() throws SyncException {
        this.unsync(true);
    }

    public void unsync(boolean removeMountPoint) throws SyncException {
        this.assertValidInstance();
        String thisMethod = "unsync(removeMountPoint)";
        boolean active = true;
        boolean activeSet = false;
        try {
            if (!this._isSynched()) {
                return;
            }
            IDevelopmentComponentNode[] usingDCs = this.m_isLightweight ? new DevelopmentComponentNode[]{} : this.m_dependenciesManager.listLocalBuildTimeUsers(this, true);
            ComponentSyncDB syncdb = this.m_configuration.getComponentSyncDB();
            IDCSyncEntry syncDBEntry = syncdb.getEntry(this.m_compartmentName, this.m_dcName, this.m_dcVendor);
            boolean isLocalOnlySource = false;
            boolean wasDirty = syncDBEntry.isDirty();
            if (this.isSynchedAsSource()) {
                block21: {
                    IMountPoint mp = this.m_configuration.getMountPointForDC(this.m_compartmentName, this.m_dcVendor, this.m_dcName);
                    if (mp != null) {
                        DevConfFileMonitor.Mode oldMode = this.m_configuration.setFileMonitorMode(DevConfFileMonitor.Mode.NOTHING);
                        try {
                            isLocalOnlySource = this.doUnsyncSources();
                            if (removeMountPoint) {
                                try {
                                    this.m_configuration.removeMountPoint(mp);
                                }
                                catch (SyncException e) {
                                    LOCATION.catching(thisMethod, (Throwable)((Object)e));
                                    LOCATION.infoT(thisMethod, "caught exception when trying to remove mountpoint , not throwing it again " + ((Throwable)((Object)e)).getMessage());
                                }
                            }
                            Object var14_17 = null;
                            this.m_configuration.setFileMonitorMode(oldMode);
                        }
                        catch (Throwable throwable) {
                            Object var14_18 = null;
                            this.m_configuration.setFileMonitorMode(oldMode);
                            throw throwable;
                        }
                        {
                            break block21;
                        }
                    }
                    LOCATION.debugT(thisMethod, "no mountpoint for DC {0}, skipping DTR unsync", new Object[]{this});
                }
                this._cleanBuildResults(null);
            } else if (this.isSynchedAsArchives()) {
                Util.deleteDirRecursively((File)new File(this.m_fileSystemLayout.getDefFolder()));
                File dcdef = new File(this.m_fileSystemLayout.getComponentDefinitionFile());
                dcdef.delete();
                Iterator variantIterator = syncDBEntry.getVariantNames().iterator();
                while (variantIterator.hasNext()) {
                    String variant = (String)variantIterator.next();
                    if (!syncDBEntry.isSynchedAsArchives(variant)) continue;
                    Util.deleteDirRecursively((File)new File(this.m_fileSystemLayout.getVariantRootFolder(variant)));
                }
            }
            DCNodeSyncMode oldmode = this._getDCSyncMode();
            DCNodeSyncState oldState = this._getDCSyncState();
            DCActivityState oldActState = this._getDCActivityState();
            Set dirtyDcSet = null;
            try {
                dirtyDcSet = this.m_configuration.markDCsDirty(usingDCs, false, true);
            }
            catch (DevConfigException e1) {
                LOCATION.catching(thisMethod, (Throwable)((Object)e1));
                String m = "Failed to mark using DCs as dirty while unsyncing \"" + this + "\"" + ((Throwable)((Object)e1)).getMessage();
                this.m_configuration.sendDCMessage(this, "", DCMessageType.WARNING, DCEventType.ARCHIVE_SYNCED, m, true);
                LOCATION.infoT(thisMethod, m + nl + "    Caught DevConfigException. Send message to listener and ignore the exception.");
            }
            if (isLocalOnlySource && oldActState == DCActivityState.CHECKED_OUT_FOR_CREATE) {
                syncDBEntry.setMode(SyncMode.LOCAL_ONLY);
                syncDBEntry.setState(SyncState._getLocalSourceSyncState());
                syncDBEntry.setActivityState(DCActivityState.NONE);
                syncdb.save();
                this.ensureCachedCorrectly();
                active = DCProxy._isLocallyAvailableStateActive(this.getDCSyncMode(), this.m_compartment);
                activeSet = true;
                this.m_configuration.notifyDCActivityStateChanged(this.m_compartmentName, this.m_dcVendor, this.m_dcName, oldActState, DCActivityState.NONE, active);
            } else {
                syncdb.removeEntry(this.m_compartmentName, this.m_dcName, this.m_dcVendor);
                this.m_configuration.markDCasClean(this, false, false);
                syncdb.save();
                this.ensureCachedCorrectly();
            }
            if (!activeSet) {
                active = oldmode == DCNodeSyncMode.SYNCHED_AS_ACTIVE_SOURCE || oldmode == DCNodeSyncMode.SYNCHED_AS_ARCHIVE;
            }
            this.m_configuration.notifyDCSyncModeChanged(this.m_compartmentName, this.m_dcVendor, this.m_dcName, oldmode, this._getDCSyncMode(), active);
            this.m_configuration.notifyDCSyncStateChanged(this.m_compartmentName, this.m_dcVendor, this.m_dcName, oldState, this._getDCSyncState(), active);
            this.m_configuration.notifyDCChanged(this.m_compartmentName, this.m_dcVendor, this.m_dcName, active);
            if (dirtyDcSet != null) {
                this.m_configuration.notifyDCsDirty(dirtyDcSet);
            }
            if (wasDirty && !this._isDirty()) {
                this.m_configuration.notifyDCClean(this);
            }
        }
        catch (SyncException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Unkown error during unsync: " + e.getMessage();
            throw new SyncException(msg, e, 0);
        }
    }

    private boolean _isDirty() {
        return this.m_configuration.isDCDirty(this.m_compartmentName, this.m_dcVendor, this.m_dcName);
    }

    public DCActivityState getDCActivityState() {
        this.assertValidInstance();
        return this._getDCActivityState();
    }

    public DCNodeSyncState getDCSyncState() {
        this.assertValidInstance();
        return this._getDCSyncState();
    }

    public DCNodeSyncMode getDCSyncMode() {
        this.assertValidInstance();
        return this._getDCSyncMode();
    }

    private DCNodeSyncState _getDCSyncState() {
        return this.m_configuration.calculateSyncStateForDC(this.m_compartmentName, this.m_dcVendor, this.m_dcName);
    }

    private DCActivityState _getDCActivityState() {
        return this.m_configuration.getActivityStateForDC(this.m_compartmentName, this.m_dcVendor, this.m_dcName);
    }

    private DCNodeSyncMode _getDCSyncMode() {
        return this.m_configuration.calculateSyncModeForDC(this.m_compartmentName, this.m_dcVendor, this.m_dcName);
    }

    public IBuildResult make(String buildVariant, String target, ILocalBuildProperties localBuildProperties, boolean validateOnlyAtBuildTime) throws BuildException {
        DependencyValidationOption validateOption = validateOnlyAtBuildTime ? DependencyValidationOption.ONLY_AT_BUILD_TIME : DependencyValidationOption.ALL;
        return this.make(buildVariant, target, localBuildProperties, validateOption, false);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IBuildResult make(String buildVariant, String target, ILocalBuildProperties localBuildProperties, DependencyValidationOption dependencyValidationOption, boolean ignoreBrokenUsedDCs) throws BuildException {
        thisMethod = "make(String, String,boolean)";
        try {
            block43: {
                DCProxy.LOCATION.entering(thisMethod);
                DCProxy.LOCATION.debugT(thisMethod, "this: {0}, buildVariant: {1}, target : {2}, dependencyValidationOption {3}", new Object[]{this, buildVariant, target, dependencyValidationOption});
                buildSucceeded = false;
                try {
                    startTime = System.currentTimeMillis();
                    this.assertValidInstance();
                    result = null;
                    if (!this.isSynchedAsSource() && !this.isLocalOnlySource()) {
                        this.notifyBuildFailed(buildVariant, "The component " + this + "is not available as source code.");
                        throw new BuildException("Must be available as source", null, 1);
                    }
                    dcInfo = new DevelopmentComponentInfo(this.m_configuration, this.m_compartmentName, this.m_component, buildVariant);
                    this.setVariantTempGenFolder(buildVariant, dcInfo.getDCVariantTempGenFolder());
                    this._cleanBuildResults(buildVariant);
                    this.createGenFolders(buildVariant);
                    this.checkMakeDependencies(buildVariant, ignoreBrokenUsedDCs, dependencyValidationOption);
                    try {
                        this.checkParentHierachy(true);
                    }
                    catch (SyncException e) {
                        msg = "Error when trying to check DC parent hierarchy for cycles.";
                        this.notifyBuildFailed(buildVariant, msg + "(" + e.getMessage() + ")");
                        msg = msg + " Component: " + this;
                        throw new BuildException(msg, (Throwable)e, 11);
                    }
                    catch (DCValidationException e) {
                        msg = "Component validation failed. Cycle found in parent hierarchy.";
                        this.notifyBuildFailed(buildVariant, msg);
                        msg = msg + " Component " + this;
                        throw new BuildException(msg, null, 10);
                    }
                    if (dependencyValidationOption != DependencyValidationOption.NOTHING) {
                        try {
                            validateOnlyAtBuildTime = dependencyValidationOption == DependencyValidationOption.ONLY_AT_BUILD_TIME;
                            invalidDeps = this._listInvalidDependencies(false, validateOnlyAtBuildTime, false);
                            if (!invalidDeps.isEmpty()) {
                                invalidDepsIter = invalidDeps.values().iterator();
                                problems = "";
                                while (true) {
                                    if (!invalidDepsIter.hasNext()) {
                                        msg = "Invalid dependencies were found:" + problems;
                                        this.notifyBuildFailed(buildVariant, msg);
                                        throw new BuildException(msg, null, 9);
                                    }
                                    e = (IllegalDependencyException)invalidDepsIter.next();
                                    problems = problems + DCProxy.nl + "   " + e.getMessage();
                                }
                            }
                        }
                        catch (SyncException e) {
                            msg = "Could not validate dependencies: " + e.getMessage();
                            this.notifyBuildFailed(buildVariant, msg);
                            throw new BuildException(msg, (Throwable)e, 2);
                        }
                    }
                    invalidEntityRefs = null;
                    try {
                        invalidEntityRefs = this.listInvalidEntityRefs();
                    }
                    catch (SyncException e) {
                        msg = "Could not validate entity references: " + e.getMessage();
                        this.notifyBuildFailed(buildVariant, msg);
                        throw new BuildException(msg, (Throwable)e, 3);
                    }
                    if (!invalidEntityRefs.isEmpty()) {
                        problems = "";
                        invalidRefsIter = invalidEntityRefs.iterator();
                        while (true) {
                            if (!invalidRefsIter.hasNext()) {
                                msg = "Invalid entity references found: " + problems;
                                this.notifyBuildFailed(buildVariant, msg);
                                throw new BuildException(msg, null, 13);
                            }
                            e = (IllegalEntityReferenceException)invalidRefsIter.next();
                            this.getDependencyChecker().notifyRefCheckFailed(this, e.getMessage(), buildVariant);
                            problems = problems + DCProxy.nl + "   " + e.getMessage();
                        }
                    }
                    dcInfo.setInfrastructurePathList(this.getInfrastructureComponentPathList(buildVariant));
                    if (localBuildProperties == null) {
                        lbp = new LocalBuildProperties();
                        lbp.setBuildLocation(this.m_configuration.getDevConfObject().getLocation());
                        localBuildProperties = lbp;
                    }
                    dcInfo.setLocalBuildProperties(localBuildProperties);
                    pluginRef = this.m_component.getBuildPlugin();
                    if (pluginRef == null) {
                        this.notifyBuildFailed(buildVariant, "Build failed: No build plugin reference found in component definition");
                        throw new BuildException("No build plugin defined.", null, 14);
                    }
                    pluginRoot = new File(dcInfo.getUsedPublicPartGenFolder(pluginRef));
                    if (!pluginRoot.exists()) {
                        this.notifyBuildFailed(buildVariant, "Build failed because of internal error: No build plugin found");
                        throw new BuildException("No build plugin found", null, 5);
                    }
                    try {
                        pluginHandler = PluginHandlerFactory.getInstance().getPluginHandlerInstance((IDevelopmentComponentInfo)dcInfo, dcInfo.getUsedPublicPartGenFolder(pluginRef), target, true, true, this.m_configuration.getJarHandler());
                        if (pluginHandler == null) {
                            this.notifyBuildFailed(buildVariant, "Build failed because of internal error: could not initialize build plugin handler");
                            throw new BuildException("Error initializing build plugin", null, 6);
                        }
                        try {
                            this.notifyBuildStart(buildVariant);
                            result = pluginHandler.execute();
                            endTime = System.currentTimeMillis();
                            DCProxy.LOCATION.debugT(thisMethod, "build plugin execution finished");
                            switch (result.getResultCode()) {
                                case 2: {
                                    DCProxy.LOCATION.debugT(thisMethod, "Build plugin result code: build failed with error");
                                    this.notifyBuildFailed(buildVariant, result.getResultMessage());
                                    break;
                                }
                                case 3: {
                                    DCProxy.LOCATION.debugT(thisMethod, "Build plugin result code: build failed with system error");
                                    this.notifyBuildFailed(buildVariant, result.getResultMessage());
                                    break;
                                }
                                case 0: {
                                    DCProxy.LOCATION.debugT(thisMethod, "Build plugin result code: build OK");
                                    this.notifyBuildSuccess(buildVariant, endTime - startTime);
                                    buildSucceeded = true;
                                    break;
                                }
                                case 1: {
                                    DCProxy.LOCATION.debugT(thisMethod, "Build plugin result code: build finished with warning");
                                    this.notifyBuildWarning(buildVariant, result.getResultMessage(), endTime - startTime);
                                    buildSucceeded = true;
                                    break;
                                }
                                default: {
                                    DCProxy.LOCATION.infoT(thisMethod, "Build plugin reported unexpected result code: " + result.getResultCode());
                                    break;
                                }
                            }
                        }
                        catch (Exception e) {
                            DCProxy.LOCATION.traceThrowableT(300, "Build failed in configuration {0} for DC {1} in variant {2}. Unexpected exception thrown by plugin handler/build plugins.", new Object[]{this.m_configuration.getName(), this, buildVariant}, (Throwable)e);
                            this.notifyBuildFailed(buildVariant, "Build failed because of internal error: Caught Exception: " + DCProxy.nl + Util.printStackTraceToString((Throwable)e));
                            throw new BuildException("Error thrown by build-plugin handler: " + e.getMessage(), e, 0);
                        }
                    }
                    catch (BuildToolException e) {
                        this.notifyBuildFailed(buildVariant, "Build failed because of internal error: Caught BuildToolException: " + e.getMessage());
                        throw new BuildException("Exeption during execution of build plugin", e, 7);
                    }
                    var14_24 = result;
                    var19_32 = null;
                }
                catch (Throwable var18_46) {
                    var19_33 = null;
                    try {
                        DCProxy.LOCATION.debugT(thisMethod, "Starting broken and dirty status handling");
                        brokenFlagUpdated = false;
                        dirtyFlagReset = false;
                        dirtyFlagReset = this.m_configuration.markDCasClean(this, false, false);
                        brokenFlagUpdated = this.m_configuration.setDCBrokenFlag(buildSucceeded == false, this, false);
                        buildStatusChangedDcSet = this.markAtBuildTimeUsingDCsDirty(false, false);
                        if (buildStatusChangedDcSet != null && !buildStatusChangedDcSet.isEmpty() || dirtyFlagReset || brokenFlagUpdated) {
                            this.m_configuration.getComponentSyncDB().save();
                        }
                        if (brokenFlagUpdated || dirtyFlagReset) {
                            buildStatusChangedDcSet.add(this._toNode());
                        }
                        if (buildStatusChangedDcSet != null && !buildStatusChangedDcSet.isEmpty()) {
                            this.m_configuration.notifyDCsBuildStatusChanged(buildStatusChangedDcSet);
                        }
                        DCProxy.LOCATION.debugT(thisMethod, "Finished broken and dirty status handling");
                        throw var18_46;
                    }
                    catch (DevConfigException e1) {
                        DCProxy.LOCATION.catching(thisMethod, (Throwable)e1);
                        m = "Failed to update dirty status of Dcs while building DC \"" + this + "\"" + e1.getMessage();
                        this.m_configuration.sendDCMessage(this, "", DCMessageType.WARNING, DCEventType.ARCHIVE_SYNCED, m, true);
                        DCProxy.LOCATION.infoT(thisMethod, "{0}{1}   Caught DevConfigException: {2}. Send message to listener and ignore the exception.", new Object[]{m, DCProxy.nl, e1.getMessage()});
                    }
                    throw var18_46;
                }
                ** try [egrp 7[TRYBLOCK] [7 : 1338->1493)] { 
lbl170:
                // 1 sources

                DCProxy.LOCATION.debugT(thisMethod, "Starting broken and dirty status handling");
                brokenFlagUpdated = false;
                dirtyFlagReset = false;
                dirtyFlagReset = this.m_configuration.markDCasClean(this, false, false);
                brokenFlagUpdated = this.m_configuration.setDCBrokenFlag(buildSucceeded == false, this, false);
                buildStatusChangedDcSet = this.markAtBuildTimeUsingDCsDirty(false, false);
                if (buildStatusChangedDcSet != null && !buildStatusChangedDcSet.isEmpty() || dirtyFlagReset || brokenFlagUpdated) {
                    this.m_configuration.getComponentSyncDB().save();
                }
                if (brokenFlagUpdated || dirtyFlagReset) {
                    buildStatusChangedDcSet.add(this._toNode());
                }
                if (buildStatusChangedDcSet != null && !buildStatusChangedDcSet.isEmpty()) {
                    this.m_configuration.notifyDCsBuildStatusChanged(buildStatusChangedDcSet);
                }
                DCProxy.LOCATION.debugT(thisMethod, "Finished broken and dirty status handling");
                break block43;
lbl187:
                // 1 sources

                catch (DevConfigException e1) {
                    DCProxy.LOCATION.catching(thisMethod, (Throwable)e1);
                    m = "Failed to update dirty status of Dcs while building DC \"" + this + "\"" + e1.getMessage();
                    this.m_configuration.sendDCMessage(this, "", DCMessageType.WARNING, DCEventType.ARCHIVE_SYNCED, m, true);
                    DCProxy.LOCATION.infoT(thisMethod, "{0}{1}   Caught DevConfigException: {2}. Send message to listener and ignore the exception.", new Object[]{m, DCProxy.nl, e1.getMessage()});
                }
            }
            var24_44 = null;
        }
        catch (Throwable var23_47) {
            var24_45 = null;
            DCProxy.LOCATION.exiting(thisMethod);
            throw var23_47;
        }
        DCProxy.LOCATION.exiting(thisMethod);
        return var14_24;
    }

    public IBuildResult makeRecursively(String buildVariant, String target, ILocalBuildProperties localBuildProperties, boolean rebuildAll) throws BuildException {
        String thisMethod = "makeRecursively(String, String,boolean)";
        this.assertValidInstance();
        LOCATION.debugT(thisMethod, "buildVariant: {0}, target : {1}, rebuildAll : {2} ", new Object[]{buildVariant, target, new Boolean(rebuildAll)});
        LOCATION.debugT(thisMethod, " recursively making component: " + this);
        IBuildResult result = null;
        Iterator it = this._listDCsForRecursiveMake(buildVariant, true).iterator();
        this.notifyRecursiveBuildStart(buildVariant);
        while (it.hasNext()) {
            DCProxy dc = (DCProxy)it.next();
            result = dc.make(buildVariant, target, localBuildProperties);
            if (result.getResultCode() == 2) {
                String message = "ERROR in recursive make. Build failed for component " + dc;
                this.notifyRecursiveBuildFailed(buildVariant);
                throw new BuildException(message);
            }
            if (result.getResultCode() != 3) continue;
            String message = "SYSTEM ERROR in recursive make. Build failed for component " + dc;
            this.notifyRecursiveBuildFailed(buildVariant);
            throw new BuildException(message);
        }
        this.notifyRecursiveBuildSuccess(buildVariant);
        return result;
    }

    public IBuildResult makeFile(String buildVariant, String target, ILocalBuildProperties localBuildProperties, String filePath) throws BuildException {
        this.assertValidInstance();
        return null;
    }

    public void packComponentInterfaceArchive(String buildVariant, OutputStream destination) throws IOException, ZipException, FileNotFoundException {
        this.assertValidInstance();
        ArchivePacker packer = new ArchivePacker();
        File dcda = new File(this.m_fileSystemLayout.getRootFolder(), ".dcda");
        packer.openArchive(destination, this.m_fileSystemLayout.getRootFolder());
        packer.setCompressionLevel(-1);
        packer.setCompressionMethod(8);
        String[] paths = new String[]{".dcdef"};
        packer.add(paths, false);
        this.packComponentDefinitionArchive(new FileOutputStream(dcda));
        paths[0] = dcda.getName();
        packer.add(paths, false);
        dcda.delete();
        if (this.m_component.getPublicParts() != null) {
            Iterator iter = this.m_component.getPublicParts().values().iterator();
            while (iter.hasNext()) {
                PublicPart pp = (PublicPart)iter.next();
                File ppa = new File(this.m_fileSystemLayout.getRootFolder(), pp.getName() + ".ppa");
                this.packPublicPartArchive(pp.getName(), buildVariant, new FileOutputStream(ppa));
                paths[0] = ppa.getName();
                packer.add(paths, false);
                ppa.delete();
            }
        }
        packer.closeArchive();
    }

    public void packComponentDefinitionArchive(OutputStream destination) throws IOException, ZipException, FileNotFoundException {
        ArchivePacker packer = new ArchivePacker();
        this.assertValidInstance();
        packer.openArchive(destination, this.m_fileSystemLayout.getRootFolder());
        packer.setCompressionLevel(-1);
        packer.setCompressionMethod(8);
        String[] paths = new String[]{".dcdef"};
        packer.add(paths, false);
        if (new File(this.m_fileSystemLayout.getDefFolder()).exists()) {
            paths[0] = "def";
            packer.add(paths, true);
        }
        packer.closeArchive();
    }

    public void packPublicPartArchive(String ppName, String buildVariant, OutputStream destination) throws IOException, ZipException, FileNotFoundException {
        this.packPublicPartArchive(ppName, buildVariant, destination, false);
    }

    public String packPublicPartArchive(String ppName, String buildVariant, OutputStream destination, boolean includeHash) throws IOException, ZipException, FileNotFoundException {
        this.assertValidInstance();
        String ppRoot = this.m_fileSystemLayout.getPublicPartRootFolder(buildVariant, ppName);
        String hash = null;
        if (includeHash) {
            try {
                byte[] contHash = new ContentMD5Computer().compute(new File(ppRoot));
                hash = Encoder.toHexString((byte[])contHash);
                new File(ppRoot + hash + ".HASH").createNewFile();
                PublicPart pp = (PublicPart)this.m_component.getPublicParts().get(ppName);
                if (pp.getPurpose() == PublicPart.Purpose.COMPILATION) {
                    byte[] pubContHash = new PublishedContentMD5Computer().compute(new File(ppRoot));
                    hash = Encoder.toHexString((byte[])pubContHash);
                    new File(ppRoot + hash + ".HASHP").createNewFile();
                }
            }
            catch (NoSuchAlgorithmException e) {
                LOCATION.catching((Throwable)e);
            }
            catch (IOException e) {
                LOCATION.catching((Throwable)e);
            }
            catch (InterruptedException e) {
                LOCATION.traceThrowableT(100, "packPublicPartArchive", (Throwable)e);
                throw new InterruptedIOException();
            }
        }
        ArchivePacker packer = new ArchivePacker();
        packer.openArchive(destination, ppRoot);
        packer.setCompressionLevel(-1);
        packer.setCompressionMethod(8);
        packer.addAll(true);
        if (packer.getPackedFiles() == 0) {
            packer.addDummyEntry(".cbs");
        }
        packer.closeArchive();
        return hash;
    }

    private String calculateHash(String ppRoot, boolean filteredMD5) throws NoSuchAlgorithmException, DataNotFoundException, IOException, InterruptedException {
        J2EEFileData data = new J2EEFileData(new File(ppRoot));
        MD5Key key = new MD5Key(MessageDigest.getInstance(MD5_DIGEST_NAME), null, filteredMD5);
        DataProcessor proc = new DataProcessor((AbstractKey)key);
        IDataFilter filter = DEFAULT_HASH_FILTER;
        proc.addFilter(filter, (short)2);
        DataBrowser.calculateContentKey((IData)data, (IDataProcessor)proc);
        return Encoder.toHexString((byte[])key.getBytes());
    }

    public boolean packRuntimeArchive(String buildVariant, OutputStream destination) throws IOException, ZipException, FileNotFoundException {
        this.assertValidInstance();
        File file = new File(this.m_fileSystemLayout.getDeployRootFolder(buildVariant));
        if (file.exists()) {
            File[] files = file.listFiles();
            if (files != null && files.length != 0) {
                Util.writeFileToStream((File)files[0], (OutputStream)destination);
                return true;
            }
            return false;
        }
        return false;
    }

    public void packLogFiles(String buildVariant, OutputStream destination) throws IOException, ZipException, FileNotFoundException {
        this.assertValidInstance();
        ArchivePacker packer = new ArchivePacker();
        packer.openArchive(destination, this.m_fileSystemLayout.getVariantRootFolder(buildVariant) + "logs");
        packer.setCompressionLevel(-1);
        packer.setCompressionMethod(8);
        packer.addAll(true);
        packer.closeArchive();
    }

    public void unpackComponentDefinitionArchive(InputStream source) throws IOException, ZipException {
        ArchiveUnpacker unpacker = new ArchiveUnpacker();
        this.assertValidInstance();
        try {
            unpacker.openArchive(source);
            unpacker.unpack(this.m_fileSystemLayout.getRootFolder());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            unpacker.closeArchive();
            throw throwable;
        }
        unpacker.closeArchive();
    }

    public void unpackPublicPartArchive(String ppName, String buildVariant, InputStream source) throws IOException, ZipException {
        ArchiveUnpacker unpacker = new ArchiveUnpacker();
        this.assertValidInstance();
        try {
            unpacker.openArchive(source);
            unpacker.unpack(this.m_fileSystemLayout.getPublicPartRootFolder(buildVariant, ppName));
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            unpacker.closeArchive();
            throw throwable;
        }
        unpacker.closeArchive();
    }

    public void unpackRuntimeArchive(String buildVariant, InputStream source) throws IOException, ZipException {
        boolean parentCreated;
        String thisMethod = "unpackRuntimeArchive()";
        this.assertValidInstance();
        File target = new File(this.m_fileSystemLayout.getDefaultSDAFileName(buildVariant));
        File parentFolder = target.getParentFile();
        if (parentFolder != null && !parentFolder.exists() && !(parentCreated = parentFolder.mkdirs())) {
            String m = "Could not create parent folders for archive " + target.getAbsolutePath();
            throw new IOException(m);
        }
        Util.writeStreamToFile((InputStream)source, (File)target);
        if (DCProxy.isUnpackSourcesFromDeployablesEnabled()) {
            try {
                File[] srcFile = this.unpackSourcesFromArchive(buildVariant, target);
                int i = 0;
                while (i < srcFile.length) {
                    File file = srcFile[i];
                    this.notifyDCASourceUnpacked(buildVariant, file);
                    LOCATION.debugT(thisMethod, "unpacked source archive {0}", new Object[]{file});
                    ++i;
                }
            }
            catch (IOException e) {
                LOCATION.catching(thisMethod, (Throwable)e);
                String m = "Error while scanning runtime archive for zipped source code. Archive: \"" + target + "\" Error: \"" + e.getMessage() + "\"";
                LOCATION.infoT(thisMethod, m);
                this.notifyDCASourceUnpackFailed(buildVariant, m + nl + Util.printStackTraceToString((Throwable)e));
            }
        }
    }

    private File[] unpackSourcesFromArchive(String buildVariant, File archiveFile) throws IOException {
        SourceUnpacker unpacker = this.m_configuration.getSourceUnpacker();
        File targetFolder = new File(this.m_fileSystemLayout.getVariantSourceFolder(buildVariant));
        return unpacker.unzipSourceArchives(archiveFile, targetFolder);
    }

    public void remove(IVfsActivity activity) throws RemovalException {
        this.assertValidInstance();
        if (this.isLocalOnly()) {
            String msg = "Remote deletion of component is not possible. This component only exists locally.";
            throw new RemovalException(msg, null, 7);
        }
        if (!this.m_compartment.isModificationAllowed()) {
            String msg = this.toString() + " is not modifyable in this configuration.";
            throw new RemovalException(msg, null, 8);
        }
        if (this.isSynchedAsArchives()) {
            String msg = this.toString() + " is synched as archives. Delete is not possible in this state.";
            throw new RemovalException(msg, null, 9);
        }
        if (this.isSynchedAsSource() && !this._isSynchedAsModifiableSource()) {
            String msg = this.toString() + " is synched as non-modifyable source code. Delete is not possible in this state.";
            throw new RemovalException(msg, null, 10);
        }
        if (!this._isSynched() || this.isSynchedAsModifiableSource()) {
            throw new IllegalStateException("INTERNAL ERROR: Deletion of non-local DCs is not implemented yet.");
        }
    }

    public void removeLocalDC(boolean deleteFiles) throws RemovalException, DevConfigException {
        File folder;
        String thisMethod = "removeLocalDC()";
        LOCATION.infoT(thisMethod, "component:" + this.toString());
        this.assertValidInstance();
        if (!this.isLocalOnly()) {
            String msg = "The component cannot be deleted locally because it does not have 'LocalOnly' status";
            throw new RemovalException(msg, null, 4);
        }
        List children = this.m_component.getEnclosedComponents();
        if (children != null && children.size() > 0) {
            String msg = "The component cannot be deleted. It still has inner components.";
            throw new RemovalException(msg, null, 6);
        }
        DCReference parentRef = this.m_component.getEnclosingComponent();
        DCProxy parentProxy = null;
        boolean ignoreParent = false;
        if (parentRef != null) {
            try {
                parentProxy = this.m_configuration._getDCProxyLocally(this.m_compartmentName, parentRef.getVendor(), parentRef.getName());
            }
            catch (DevConfigException e) {
                String msg = "Cannot delete local component. Cannot find local parent component " + parentRef + ": " + ((Throwable)((Object)e)).getMessage();
                throw new RemovalException(msg, (Throwable)((Object)e), 5);
            }
            List parentsKnownChildren = parentProxy.getComponent().getEnclosedComponents();
            ignoreParent = true;
            if (parentsKnownChildren != null) {
                Iterator it = parentsKnownChildren.iterator();
                while (it.hasNext()) {
                    DCReference childRef = (DCReference)it.next();
                    if (!childRef.getName().equals(this.m_dcName) || !childRef.getVendor().equals(this.m_dcVendor)) continue;
                    String alias = childRef.getSCAlias();
                    if (alias == null) {
                        ignoreParent = false;
                        break;
                    }
                    String childCompartment = this.m_configuration.getCompartmentForSCAlias(parentProxy.getCompartmentName(), alias);
                    if (!this.m_compartmentName.equals(childCompartment)) continue;
                    ignoreParent = false;
                    break;
                }
            }
            if (!ignoreParent && !parentProxy.isLocalOnlySource()) {
                String msg = "Cannot delete local component. Parent component does not have local-only status";
                throw new RemovalException(msg, null, 1);
            }
        }
        IDevelopmentComponentNode[] usingDCs = this.m_dependenciesManager.listLocalBuildTimeUsers(this, true);
        if (deleteFiles) {
            folder = new File(this.m_fileSystemLayout.getRootFolder());
            LOCATION.debugT(thisMethod, "deleting recursively folder: " + folder.getPath());
            Util.deleteDirRecursively((File)folder);
        } else {
            folder = new File(this.m_fileSystemLayout.getDefFolder());
            LOCATION.debugT(thisMethod, "deleting recursively DC def folder: " + folder.getPath());
            Util.deleteDirRecursively((File)folder);
            File dcdef = new File(this.m_fileSystemLayout.getComponentDefinitionFile());
            dcdef.delete();
        }
        this._cleanBuildResults(null);
        Set dirtyDcSet = null;
        try {
            dirtyDcSet = this.m_configuration.markDCsDirty(usingDCs, false, false);
        }
        catch (DevConfigException e1) {
            LOCATION.catching(thisMethod, (Throwable)((Object)e1));
            String m = "Failed to mark using DCs as dirty while deleting \"" + this + "\"" + ((Throwable)((Object)e1)).getMessage();
            this.m_configuration.sendDCMessage(this, "", DCMessageType.WARNING, DCEventType.ARCHIVE_SYNCED, m, true);
            LOCATION.infoT(thisMethod, "{0}{1}    Caught DevConfigException. Send message to listener and ignore it : {2}", new Object[]{m, nl, ((Throwable)((Object)e1)).getMessage()});
        }
        if (!ignoreParent && parentProxy != null) {
            parentProxy.removeChildDC(this.m_dcVendor, this.m_dcName);
            parentProxy._serializeDefinition();
        } else {
            this.m_configuration.removeTopLevelComponentEntry(this.m_compartmentName, this.m_dcVendor, this.m_dcName);
        }
        ComponentSyncDB syncdb = this.m_configuration.getComponentSyncDB();
        syncdb.removeEntry(this.m_compartment, this.m_component);
        LOCATION.debugT(thisMethod, "removed entry from DC syncdb");
        syncdb.save();
        this.m_deleted = true;
        boolean active = DCProxy._isLocallyAvailableStateActive(DCNodeSyncMode.LOCAL_ONLY, this.m_compartment);
        boolean invalidate = false;
        this.m_configuration.getDcProxyCache().remove(this.m_compartmentName, this.m_dcVendor, this.m_dcName, !active, invalidate);
        this.notifyDCDeleted();
        DevelopmentComponentNode node = this._toNode();
        this.m_configuration.notifyDCClean(node);
        if (dirtyDcSet != null) {
            this.m_configuration.notifyDCsDirty(dirtyDcSet);
        }
    }

    void notifyDCDeleted() {
        if (!this.isValidInstance()) {
            return;
        }
        this.m_invalid = true;
        Iterator iter = this.m_listeners.iterator();
        while (iter.hasNext()) {
            IDCProxyListener listener = (IDCProxyListener)iter.next();
            listener.onDCDeleted(this.m_configuration, this.m_compartmentName, this.m_dcVendor, this.m_dcName, !this.m_isActive);
        }
        this.m_configuration.notifyDCdeleted(this.m_compartmentName, this.m_dcVendor, this.m_dcName, !this.m_isActive);
    }

    public void renameComponent(String newName) {
        this.assertValidInstance();
        LOCATION.infoT("renameComponent", "***** NOT IMPLEMENTED YET ******");
    }

    public DevelopmentComponent getComponent() {
        this.assertValidInstance();
        return this.m_component;
    }

    public Compartment getCompartment() {
        return this.m_compartment;
    }

    public Map getBuildVariants() {
        this.assertValidInstance();
        return this.m_compartment.getBuildVariants();
    }

    public void _cleanBuildResults(String buildVariant) {
        this.assertValidInstance();
        String thisMethod = "cleanBuildResults(String)";
        LOCATION.debugT(thisMethod, "cleaning build results of variant {0} of {1}", new Object[]{buildVariant, this});
        if (buildVariant != null) {
            this.cleanBuildResultsOfVariant(buildVariant);
        } else {
            Map variants = this.m_compartment.getBuildVariants();
            if (variants != null) {
                Set variantNames = variants.keySet();
                Iterator it = variantNames.iterator();
                while (it.hasNext()) {
                    String variantName = (String)it.next();
                    this.cleanBuildResultsOfVariant(variantName);
                }
            }
        }
    }

    private List _listDCsForRecursiveMake(String buildVariant, boolean sendBuildFailedMessages) throws BuildException {
        List sortedDclist;
        String thisMethod = "listDCsForRecursiveMake()";
        Digraph graph = new Digraph();
        graph.addNode(this);
        TreeSet visitedArchiveDCs = new TreeSet();
        TreeSet vistedMakeDCs = new TreeSet();
        LOCATION.debugT(thisMethod, "determining build order");
        this.constructAtBuildTimeUsageGraph(graph, vistedMakeDCs, visitedArchiveDCs, buildVariant, sendBuildFailedMessages);
        try {
            sortedDclist = graph.order();
        }
        catch (IllegalStateException e) {
            String message = "Recursive build is impossible. " + e.getMessage();
            if (sendBuildFailedMessages) {
                this.notifyBuildFailed(buildVariant, message);
            }
            throw new BuildException(message, e, 8);
        }
        return sortedDclist;
    }

    public String getName() {
        return this.m_dcName;
    }

    public String getVendor() {
        return this.m_dcVendor;
    }

    public String getRootFolder() {
        return this.m_fileSystemLayout.getRootFolder();
    }

    public String getDefinitionPath() {
        return this.m_fileSystemLayout.getComponentDefinitionFile();
    }

    public String getPPDefinitionPath(String ppName) {
        return this.m_fileSystemLayout.getPublicPartDefinitionFile(ppName);
    }

    public void addToSourceControl(IVfsActivity activity) throws CheckoutException, SyncException, CreateException {
        this.assertValidInstance();
        String thisMethod = "addToSourceControl(IVFsActivity)";
        HashSet addedItems = new HashSet();
        boolean succesfullyFinished = false;
        LOCATION.debugT(thisMethod, "activity: {0}", new Object[]{activity});
        if (this.m_configuration.isLocalConfiguration()) {
            throw new SyncException("Cannot add to source control in a local-only configuration.", null, 32);
        }
        if (this.m_configuration.isInOfflineMode()) {
            String msg = "Cannot add to source control when in offline mode";
            throw new SyncException(msg, null, 22);
        }
        if (!this.isLocalOnly()) {
            String msg = "A component with the same name is already under source control.";
            throw new CreateException(msg, null, 1);
        }
        if (!this.m_compartment.isModificationAllowed()) {
            String msg = "Cannot add to source control, compartment \"" + this.m_compartmentName + "\" is not modifiable";
            throw new CreateException(msg, null, 6);
        }
        VFSHandler vfsHandler = this._getVFSHandler();
        DevConfFileMonitor.Mode oldMode = this.m_configuration.setFileMonitorMode(DevConfFileMonitor.Mode.ONE_DC_UNTIL_DIRTY_NO_NOTIFY);
        try {
            boolean useInactive;
            boolean wasDirty = this._isDirty();
            DCReference parentRef = this.m_component.getEnclosingComponent();
            if (parentRef == null) {
                this.assertSCFolderEnabled();
            }
            if (!this.m_configuration.findOrCreateMountPointForDC(this.m_compartmentName, this.m_dcVendor, this.m_dcName, useInactive = this.m_compartment.hasInactiveSourceState(), true)) {
                throw new SyncException("Cannot add \"" + this + "\" to source control. cannot find or create DTR mount point", null, -1, this.m_compartmentName, this.m_dcName, this.m_dcVendor);
            }
            String localDCpath = this.m_fileSystemLayout.getRootFolder();
            vfsHandler.syncLocalPath(localDCpath);
            String[] paths = this.m_fileSystemLayout.getDefaultFolders();
            vfsHandler.addNewFilesToActivity(activity, paths, addedItems);
            paths = new String[]{this.m_fileSystemLayout.getComponentDefinitionFile()};
            vfsHandler.addNewFilesToActivity(activity, paths, addedItems);
            if (parentRef == null) {
                this.m_configuration.addTopLevelComponentEntry(this.m_compartmentName, this.m_dcVendor, this.m_dcName, activity, addedItems);
            }
            try {
                this.m_configuration.getVFSHandler().saveConfigurationSettings();
            }
            catch (IOException e) {
                throw new CreateException("Error updating repository client definition: " + e.getMessage(), e, 4);
            }
            if (this.m_component.getPublicParts() != null) {
                Iterator iter = this.m_component.getPublicParts().values().iterator();
                while (iter.hasNext()) {
                    PublicPart pp = (PublicPart)iter.next();
                    this._addPublicPartToSourceControl(pp.getName(), activity, addedItems);
                }
            }
            IDCSyncEntry entry = this.m_configuration.getComponentSyncDB().getEntry(this.m_compartmentName, this.m_dcName, this.m_dcVendor);
            DCActivityState oldState = DCActivityState.NONE;
            DCActivityState newState = DCActivityState.CHECKED_OUT_FOR_CREATE;
            entry.setActivityState(newState);
            this.setSyncedAsSource(entry, useInactive, wasDirty);
            succesfullyFinished = true;
            this.m_configuration.notifyDCActivityStateChanged(this.m_compartmentName, this.m_dcVendor, this.m_dcName, oldState, newState, !useInactive);
            Object var16_19 = null;
            this.m_configuration.setFileMonitorMode(oldMode);
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            this.m_configuration.setFileMonitorMode(oldMode);
            if (!succesfullyFinished) {
                try {
                    vfsHandler.revertFilesFromActivity(addedItems);
                }
                catch (VfsException e) {
                    LOCATION.traceThrowableT(300, thisMethod, "Caught VFS Exception during cleanup, ignoring it", (Throwable)e);
                }
            }
            throw throwable;
        }
        if (!succesfullyFinished) {
            try {
                vfsHandler.revertFilesFromActivity(addedItems);
            }
            catch (VfsException e) {
                LOCATION.traceThrowableT(300, thisMethod, "Caught VFS Exception during cleanup, ignoring it", (Throwable)e);
            }
        }
    }

    private void assertSCFolderEnabled() throws SyncException {
        if (this.m_configuration.isDTRAccessDisabledForSC(this.m_compartment)) {
            String m = "Access to SC Folder in DTR was disabled (authorization problem)";
            throw new SyncException(m, null, 403);
        }
    }

    public void checkoutDefinition(IVfsActivity activity) throws CheckoutException {
        this.checkoutDefinition(activity, null);
    }

    public boolean checkoutDefinition(IVfsActivity activity, Set addedItems) throws CheckoutException {
        String[] filePaths;
        this.assertValidInstance();
        boolean checkedOutByUs = false;
        String thisMethod = "checkoutDefinition(IVFsActivity)";
        LOCATION.debugT(thisMethod, "activity: {0}", new Object[]{activity});
        if (this.isSynchedAsModifiableSource()) {
            filePaths = new String[]{this.m_fileSystemLayout.getComponentDefinitionFile()};
            if (addedItems == null) {
                addedItems = new HashSet();
            }
        } else {
            throw new CheckoutException("Cannot checkout DC definition. Component not available as modiffiable source code. Current component sync mode: " + this.getDCSyncMode(), null, 3);
        }
        int itemsBefore = addedItems.size();
        this._getVFSHandler().checkoutFiles(activity, filePaths, addedItems);
        checkedOutByUs = addedItems.size() > itemsBefore;
        return checkedOutByUs;
    }

    public void checkoutPPDefinition(String ppName, IVfsActivity activity) throws CheckoutException {
        this.assertValidInstance();
        String thisMethod = "checkoutPPDefinition(String, IVfsActivity)";
        LOCATION.debugT(thisMethod, "ppNname: {0}, activity: {1}", new Object[]{ppName, activity});
        if (!this.isSynchedAsModifiableSource()) {
            throw new CheckoutException("Cannot checkout public part definition. Component not available as modiffiable source code. Current component sync mode: " + this.getDCSyncMode(), null, 3);
        }
        String[] filePaths = new String[]{this.m_fileSystemLayout.getPublicPartDefinitionFile(ppName)};
        this._getVFSHandler().checkoutFiles(activity, filePaths, null);
    }

    public void addPublicPartToSourceControl(String ppName, IVfsActivity activity) throws SyncException {
        this.assertValidInstance();
        String thisMethod = "addPublicPartToSourceControl(String, IVfsActivity)";
        LOCATION.debugT(thisMethod, "ppName: {0}, activity: {1}", new Object[]{ppName, activity});
        HashSet addedItems = new HashSet();
        this._addPublicPartToSourceControl(ppName, activity, addedItems);
    }

    public void _addPublicPartToSourceControl(String ppName, IVfsActivity activity, Set addedItems) throws SyncException {
        if (!this.isAvailableAsModifiableSource()) {
            String m = "Cannot add public part to DTR. The component must be either local or synched as source.";
            throw new SyncException(m, null, 6);
        }
        String[] paths = new String[]{this.m_fileSystemLayout.getPublicPartDefinitionFile(ppName)};
        this._getVFSHandler().addNewFilesToActivity(activity, paths, addedItems);
    }

    public void serializeDefinition() throws DevConfigException {
        this._serializeDefinition();
        this.m_configuration.markDCasDirty(this, true, true);
        this.markUsingDCsDirty(true, true);
    }

    public void _serializeDefinition() throws DevConfigException {
        this.assertValidInstance();
        if (this.isAvailableAsModifiableSource()) {
            DCFileOutputProvider provider = new DCFileOutputProvider(this.m_configuration, this.m_compartmentName, this.m_dcVendor, this.m_dcName);
            try {
                ComponentFactory.serialize((DevelopmentComponent)this.m_component, (DCOutputProvider)provider);
            }
            catch (Exception e) {
                String m = "Saving DC \"" + this + "\" failed. :" + e.getMessage();
                throw new DevConfigException(m, e);
            }
        } else {
            String m = "Cannot save DC \"" + this + "\". Component not synched as modifiable source. Sync mode:" + this.getDCSyncMode() + " sync state: " + this.getDCSyncState();
            throw new DevConfigException(m, null);
        }
    }

    public void serializePPDefinition(String ppName, String schemaVersion) throws DevConfigException {
        this._serializePPDefinition(ppName, schemaVersion);
    }

    public void serializePPDefinition(String ppName) throws DevConfigException {
        this._serializePPDefinition(ppName, null);
    }

    public void _serializePPDefinition(String ppName, String schemaVersion) throws DevConfigException {
        String thisMethod = "serializePPDefinition(String)";
        this.assertValidInstance();
        LOCATION.debugT(thisMethod, "ppName: {0}", new Object[]{ppName});
        if (this.isAvailableAsModifiableSource()) {
            PPFileOutputProvider provider = new PPFileOutputProvider(this.m_configuration, ppName, new FileSystemLayout(this.m_configuration, this.m_compartmentName, this.m_dcVendor, this.m_dcName));
            Map ppMap = this.m_component.getPublicParts();
            if (ppMap == null) {
                throw new DevConfigException("cannot serialize public part named \"" + ppName + "\". Component \"" + this + "\" has no public parts.");
            }
            PublicPart ppart = (PublicPart)ppMap.get(ppName);
            if (ppart == null) {
                throw new DevConfigException("cannot serialize public part named \"" + ppName + "\". Component \"" + this + "\" has no such public part.");
            }
            try {
                if (schemaVersion == null) {
                    ppart.serialize((PPOutputProvider)provider);
                } else {
                    ppart.serialize((PPOutputProvider)provider, schemaVersion);
                }
                this.m_configuration.markDCasDirty(this, true, true);
            }
            catch (DevConfigException e) {
                throw new DevConfigException("Error when trying to save public part " + ppName + ": " + ((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
            }
            catch (IOException e) {
                throw new DevConfigException("I/O Error when trying to save public part " + ppName + ": " + e.getMessage(), e);
            }
            catch (ProviderException e) {
                Throwable innerException = e.getCause();
                if (innerException instanceof InvalidFileFormatException) {
                    throw new DCSerializationSchemaException("File Format Error when trying to save public part " + ppName + "of " + this + " : " + e.getMessage(), e, schemaVersion);
                }
                throw new DevConfigException("Error when trying to save public part " + ppName + ": " + e.getMessage(), e);
            }
        } else {
            String m = "Cannot save public part " + ppName + "\" of DC " + this + "\". Component not synched as modifiable source. Sync mode:" + this.getDCSyncMode() + " sync state: " + this.getDCSyncState();
            throw new DevConfigException(m, null);
        }
        this.markUsingDCsDirty(ppName, true, true);
    }

    public void reloadDefinition() throws DevConfigException, RepositoryAccessException, InvalidDefinitionException {
        this._reloadDefinition(false);
    }

    public void _reloadDefinition(boolean sendNotifications) throws DevConfigException, RepositoryAccessException, InvalidDefinitionException {
        this.assertValidInstance();
        if (this._getDCSyncMode() == DCNodeSyncMode.NOT_SYNCHED) {
            IVfsWorkspace ws = this.m_configuration.getWorkspaceFromCompartmentID(this.m_compartmentName, this.m_isActive);
            IVfsGenericFolder folder = null;
            if (ws != null) {
                folder = ws.asGenericFolder();
            }
            if (folder != null) {
                try {
                    DCRepositoryInputProvider provider = new DCRepositoryInputProvider(this.m_configuration, folder, this.m_dcVendor, this.m_dcName);
                    try {
                        this.m_component = ComponentFactory.initialize((DCInputProvider)provider);
                    }
                    catch (XMLException e) {
                        throw new InvalidDefinitionException("Reloading DC definition failed with XML error: " + e.getMessage(), e);
                    }
                    catch (IOException e) {
                        throw new RepositoryAccessException("Reloading DC definition failed: " + e.getMessage(), e);
                    }
                    catch (ProviderException e) {
                        throw new DevConfigException("Reloading DC definition failed: " + e.getMessage(), e);
                    }
                }
                catch (VfsException e) {
                    throw new RepositoryAccessException("Reloading DC definition failed. DTR client error: " + e.getMessage(), e);
                }
            }
        } else {
            DCFileInputProvider dcInputProvider = new DCFileInputProvider(this.m_configuration, this.m_compartmentName, this.m_dcVendor, this.m_dcName);
            try {
                Map ppMap;
                Map oldPPMap = null;
                if (this.m_component != null) {
                    oldPPMap = this.m_component.getPublicParts();
                }
                this.m_component = ComponentFactory.initialize((DCInputProvider)dcInputProvider, (boolean)false);
                if (oldPPMap != null && this.m_component != null && (ppMap = this.m_component.getPublicParts()) == null) {
                    ppMap = this.m_component.emptyPublicParts();
                    ppMap.putAll(oldPPMap);
                }
            }
            catch (XMLException e) {
                throw new InvalidDefinitionException("XML Error occured when loading component definition: " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new DevConfigException("I/O Error occured when loading component definition: " + e.getMessage(), e);
            }
            catch (ProviderException e) {
                throw new DevConfigException("Error occured when loading component definition: " + e.getMessage(), e);
            }
        }
        if (sendNotifications) {
            this.m_configuration.notifyDCChanged(this.m_compartmentName, this.m_dcVendor, this.m_dcName, this.m_isActive);
        }
    }

    public void reloadPPDefinition(String ppName) throws DevConfigException, RepositoryAccessException {
        String thisMethod = "reloadPPDefinition(String)";
        LOCATION.debugT(thisMethod, "this: {0} ppName: {1}", new Object[]{this, ppName});
        if (this.getDCSyncMode() == DCNodeSyncMode.NOT_SYNCHED) {
            throw new DevConfigException("Cannot reloaf definition of public part of DC " + this + " from file. DC not available locally. DC Sync Mode: " + this.getDCSyncMode());
        }
        DCFileInputProvider dcInputProvider = new DCFileInputProvider(this.m_configuration, this.m_compartmentName, this.m_dcVendor, this.m_dcName);
        try {
            this.m_component.initializePublicParts((DCInputProvider)dcInputProvider);
        }
        catch (IOException e) {
            throw new DevConfigException("IO Error occured. Failed to reload definition of public part " + ppName + " of component " + this + ": " + e.getMessage(), e);
        }
        catch (XMLException e) {
            throw new DevConfigException("XML Error occured. Failed to reload definition of public part " + ppName + " of component " + this + ": " + e.getMessage(), e);
        }
        catch (ProviderException e) {
            throw new DevConfigException("Failed to reload definition of public part " + ppName + " of component " + this + ": " + e.getMessage(), e);
        }
    }

    public void _reloadPPDefinition(String ppName, boolean sendNotifications) throws DevConfigException, RepositoryAccessException {
        String thisMethod = "reloadPPDefinition(String)";
        this.assertValidInstance();
        if (this._getDCSyncMode() == DCNodeSyncMode.NOT_SYNCHED) {
            LOCATION.infoT(thisMethod, "Ingnoring request to reload definition of public part {0} of DC {1}: DC is not synched", new Object[]{ppName, this});
        } else {
            DCFileInputProvider dcInputProvider = new DCFileInputProvider(this.m_configuration, this.m_compartmentName, this.m_dcVendor, this.m_dcName);
            try {
                this.m_component.initializePublicPart(ppName, (DCInputProvider)dcInputProvider);
                if (sendNotifications) {
                    this.m_configuration.notifyDCChanged(this.m_compartmentName, this.m_dcVendor, this.m_dcName, this.m_isActive);
                }
            }
            catch (IOException e) {
                throw new DevConfigException("IO Error loading definition of public part " + ppName + " of DC " + this + " : " + e.getMessage(), e);
            }
            catch (XMLException e) {
                throw new DevConfigException("XML Error loading definition of public part " + ppName + " of DC " + this + " : " + e.getMessage(), e);
            }
            catch (ProviderException e) {
                throw new DevConfigException("Error loading definition of public part " + ppName + " of DC " + this + " : " + e.getMessage(), e);
            }
        }
    }

    FileSystemLayout getFileSystemLayout() {
        return this.m_fileSystemLayout;
    }

    public int compareTo(Object o) {
        int result;
        if (o instanceof DCProxy) {
            DCProxy p = (DCProxy)o;
            result = this.getKey().compareTo(p.getKey());
        } else {
            result = -1;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DCProxy) {
            DCProxy p = (DCProxy)obj;
            return this.getKey().equals(p.getKey());
        }
        return false;
    }

    public List getUsedCompilationPathList(String buildVariant) {
        this.assertValidInstance();
        DevelopmentComponentInfo dcInfo = new DevelopmentComponentInfo(this.m_configuration, this.m_compartmentName, this.m_component, buildVariant);
        return dcInfo.getCompilationPathList();
    }

    public String toString() {
        return this.getVendor() + "/" + this.getName() + "(" + this.m_compartmentName + ")";
    }

    public boolean _isSynchedAsModifiableSource() {
        return this.isSynchedAsInactiveSource() || this.isSynchedAsActiveSource() && this.m_compartment.isModificationAllowed() && this.m_compartment.getSourceState().isLocationChangeable();
    }

    public boolean isSynchedAsModifiableSource() {
        return this._isSynchedAsModifiableSource();
    }

    public boolean isAvailableAsModifiableSource() {
        return this._isSynchedAsModifiableSource() || this.isLocalOnlySource();
    }

    public boolean isSynched() {
        return this._isSynched();
    }

    private void cleanBuildResultsOfVariant(String buildVariant) {
        File vntTempFolderFile;
        File vntGenFolder = new File(this.m_fileSystemLayout.getVariantRootFolder(buildVariant));
        if (vntGenFolder.exists()) {
            Util.deleteDirRecursively((File)vntGenFolder);
        }
        if ((vntTempFolderFile = this.getVariantTempGenFolder(buildVariant)).exists()) {
            LOCATION.debugT("cleanBuildResultsOfVariant", "deleting temporary gen folder {0} for DC {1} in variant {2}", new Object[]{vntTempFolderFile.getAbsolutePath(), this.toString(), buildVariant});
            Util.deleteDirRecursively((File)vntTempFolderFile);
        }
    }

    private File getVariantTempGenFolder(String buildVariant) {
        File folder = (File)this.m_variantTempGenFolders.get(buildVariant);
        if (folder == null) {
            folder = new File(this.m_fileSystemLayout.getTempVariantGenFolder(buildVariant));
            this.m_variantTempGenFolders.put(buildVariant, folder);
        }
        return folder;
    }

    private void setVariantTempGenFolder(String buildVariant, String folderPath) {
        this.m_variantTempGenFolders.put(buildVariant, new File(folderPath));
    }

    void addChildDC(String dcVendor, String dcName) {
        String thisMethod = "addChildDC";
        if (this.m_component != null) {
            List children = this.m_component.getEnclosedComponents();
            if (children == null) {
                children = this.m_component.emptyEnclosedComponents();
            }
            DCReference dcref = new DCReference(dcName, dcVendor);
            boolean found = false;
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                DCReference child = (DCReference)iter.next();
                found = child.equals((Object)dcref);
                if (found) break;
            }
            if (found) {
                LOCATION.debugT(thisMethod, "attempt to add child twice, ignoring it. parent " + this + ", child: " + dcref);
            } else {
                children.add(dcref);
            }
        }
    }

    void removeChildDC(String dcVendor, String dcName) {
        List children;
        if (this.m_component != null && (children = this.m_component.getEnclosedComponents()) != null) {
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                DCReference dcRef = (DCReference)iter.next();
                if (!dcRef.getName().equals(dcName) || !dcRef.getVendor().equals(dcVendor)) continue;
                iter.remove();
                break;
            }
        }
    }

    public boolean isAvailableLocally() {
        return this._getDCSyncMode() != DCNodeSyncMode.NOT_SYNCHED;
    }

    boolean _isSynched() {
        DCNodeSyncMode mode = this._getDCSyncMode();
        return mode != DCNodeSyncMode.NOT_SYNCHED && mode != DCNodeSyncMode.LOCAL_ONLY;
    }

    public boolean isSynchedAsSource() {
        return this.isSynchedAsInactiveSource() || this.isSynchedAsActiveSource();
    }

    public boolean isSynchedAsActiveSource() {
        return this._getDCSyncMode() == DCNodeSyncMode.SYNCHED_AS_ACTIVE_SOURCE;
    }

    public boolean isSynchedAsInactiveSource() {
        return this._getDCSyncMode() == DCNodeSyncMode.SYNCHED_AS_INACTIVE_SOURCE;
    }

    public boolean isSynchedAsArchives() {
        return this._getDCSyncMode() == DCNodeSyncMode.SYNCHED_AS_ARCHIVE;
    }

    public boolean isLocalOnly() {
        return this._getDCSyncMode() == DCNodeSyncMode.LOCAL_ONLY;
    }

    public boolean isLocalOnlySource() {
        return this._getDCSyncMode() == DCNodeSyncMode.LOCAL_ONLY && this._getDCSyncState() != DCNodeSyncState.INSTALLED;
    }

    public boolean isLocalOnlyArchive() {
        return this._getDCSyncMode() == DCNodeSyncMode.LOCAL_ONLY && this._getDCSyncState() == DCNodeSyncState.INSTALLED;
    }

    private void setSyncedAsSource(IDCSyncEntry syncEntry, boolean inactive, boolean wasDirty) {
        DCNodeSyncMode oldmode = this._getDCSyncMode();
        DCNodeSyncState oldState = this._getDCSyncState();
        if (inactive) {
            syncEntry.setMode(SyncMode.SYNCHED_AS_INACTIVE_SOURCE);
        } else {
            syncEntry.setMode(SyncMode.SYNCHED_AS_ACTIVE_SOURCE);
        }
        syncEntry.setState(SyncState.UPTODATE);
        if (oldmode == DCNodeSyncMode.NOT_SYNCHED) {
            syncEntry.setDirty(true);
        }
        this.m_configuration.getComponentSyncDB().save();
        this.ensureCachedCorrectly();
        if (!wasDirty && syncEntry.isDirty()) {
            this.m_configuration.notifyDCDirty(this);
        }
        this.m_configuration.notifyDCSyncModeChanged(this.m_compartmentName, this.m_dcVendor, this.m_dcName, oldmode, this._getDCSyncMode(), !inactive);
        this.m_configuration.notifyDCSyncStateChanged(this.m_compartmentName, this.m_dcVendor, this.m_dcName, oldState, this._getDCSyncState(), !inactive);
        this.m_configuration.notifyDCChanged(this.m_compartmentName, this.m_dcVendor, this.m_dcName, !inactive);
    }

    public boolean isAnythingCheckedOut() throws VfsException {
        this.assertValidInstance();
        String thisMethod = "isAnythingCheckedOut()";
        String localdcroot = this.m_fileSystemLayout.getRootFolder();
        LOCATION.debugT(thisMethod, "local DC root: " + localdcroot);
        return this._getVFSHandler().isSomethingCheckedOutUnderLocalPath(localdcroot);
    }

    void initializeAttributesActiveOrInactive() throws DevConfigException {
        String thisMethod = "initializeAttributes()";
        LOCATION.debugT(thisMethod, "try to get definition of component " + this.m_dcVendor + ":" + this.m_dcName + " compartment:" + this.m_compartmentName + " sync mode " + this._getDCSyncMode());
        if (this.isThisStateAvailableLocally()) {
            LOCATION.debugT(thisMethod, "component data are available locally. Try to read component data from local file.");
            this.initializeFromLocalFiles();
        } else {
            if (this.m_configuration.isLocalConfiguration()) {
                this.m_component = null;
                String msg = "Requested DC data not available locally in " + (this.m_isActive ? "active" : "inactive") + " state. Cannot read it remotely because this is a local-only configuration. DC is :" + this.m_compartmentName + ":" + this.m_dcVendor + "/" + this.m_dcName;
                LOCATION.debugT(thisMethod, msg);
                SyncException e = new SyncException(msg, null, 32, this.m_compartmentName, this.m_dcName, this.m_dcVendor);
                throw new DevConfigException(msg, (Throwable)((Object)e));
            }
            if (this.m_configuration.isInOfflineMode()) {
                this.m_component = null;
                String msg = "Requested DC data not available locally in " + (this.m_isActive ? "active" : "inactive") + " state. Cannot read it remotely because in offline-mode. DC is :" + this.m_compartmentName + ":" + this.m_dcVendor + "/" + this.m_dcName;
                LOCATION.debugT(thisMethod, msg);
                SyncException e = new SyncException(msg, null, 22, this.m_compartmentName, this.m_dcName, this.m_dcVendor);
                throw new DevConfigException(msg, (Throwable)((Object)e));
            }
            LOCATION.debugT(thisMethod, "component not synched in " + (this.m_isActive ? "active" : "inactive") + " state. try to get DC data from remote server.");
            this.initializeFromRemoteServer();
        }
    }

    void initializeAttributesLocally() throws DevConfigException {
        String thisMethod = "initializeAttributes()";
        LOCATION.debugT(thisMethod, "try to get definition of component " + this.m_dcVendor + ":" + this.m_dcName + " compartment:" + this.m_compartmentName + " sync mode " + this._getDCSyncMode());
        DCNodeSyncMode mode = this._getDCSyncMode();
        if (mode == DCNodeSyncMode.NOT_SYNCHED) {
            this.m_component = null;
            String msg = "Cannot create local DCProxy for DC that is neither synched nor local-only :" + this.m_compartmentName + ":" + this.m_dcVendor + "/" + this.m_dcName;
            throw new DevConfigException(msg);
        }
        this.m_isActive = DCProxy._isLocallyAvailableStateActive(mode, this.m_compartment);
        LOCATION.debugT(thisMethod, "component is available locally. Try to read component data from local file.");
        this.initializeFromLocalFiles();
    }

    public static boolean _isLocallyAvailableStateActive(DCNodeSyncMode mode, Compartment compartment) {
        if (mode == DCNodeSyncMode.SYNCHED_AS_ACTIVE_SOURCE) {
            return true;
        }
        if (mode == DCNodeSyncMode.SYNCHED_AS_INACTIVE_SOURCE) {
            return false;
        }
        if (mode == DCNodeSyncMode.SYNCHED_AS_ARCHIVE) {
            return true;
        }
        if (mode == DCNodeSyncMode.LOCAL_ONLY) {
            return !compartment.hasInactiveSourceState();
        }
        String msg = "Internal error: called _isLocallyAvailableStateActive() for unsynched DC (syncMode = " + mode + ")";
        IllegalStateException ex = new IllegalStateException(msg);
        LOCATION.throwing("_isLocallyAvailableStateActive", (Throwable)ex);
        throw ex;
    }

    void initializeAttributesLocalOrActive() throws DevConfigException {
        String thisMethod = "initializeAttributesLocalOrActive()";
        try {
            this.initializeAttributesLocally();
        }
        catch (DevConfigException e) {
            if (this.m_configuration.isInOfflineMode()) {
                throw e;
            }
            LOCATION.traceThrowableT(300, thisMethod, "component not synched. try to get active DC data from remote server.", (Throwable)((Object)e));
            this.m_isActive = true;
            this.initializeFromRemoteServer();
        }
    }

    void initializeFromRemoteServer() throws DevConfigException {
        String thisMethod = "initializeFromRemoteServer()";
        LOCATION.debugT(thisMethod, "component not available locally . try to get data from remote server.");
        if (this.canInitializeFromBuildServer()) {
            LOCATION.debugT(thisMethod, "try reading from build server.");
            this.m_component = this.m_configuration.initializeDCFromBuildServer(this.m_compartmentName, this.m_dcVendor, this.m_dcName);
        } else {
            LOCATION.debugT(thisMethod, "try to read DC data from repository.");
            if (this.m_compartment.getSourceState() == null) {
                String message = "Failed to read DC Data from repository: component " + this + " has no source state in configuration " + this.m_configuration.getName();
                this.m_component = null;
                throw new NoSourceStateException(message, this.m_compartment.getName());
            }
            try {
                IVfsWorkspace ws = this.m_configuration.getWorkspaceFromCompartmentID(this.m_compartmentName, this.m_isActive);
                IVfsGenericFolder folder = null;
                if (ws == null) {
                    String msg = "Could not get DTR workspace object for compartment " + this.m_compartmentName + " in state " + (this.m_isActive ? "active" : "inactive");
                    throw new DevConfigException(msg);
                }
                LOCATION.debugT(thisMethod, "try to get definition of component " + this.m_dcVendor + ":" + this.m_dcName + " from repository workspace " + ws.getName());
                folder = ws.asGenericFolder();
                if (folder == null) {
                    this.m_component = null;
                    String msg = "DTR client error. Cannot get generic folder for workspace " + ws.getAbsoluteRemotePath() + ". Failed to read component definition from DTR for " + this.m_compartmentName + ":" + this.m_dcVendor + "/" + this.m_dcName + ".";
                    LOCATION.debugT(thisMethod, msg);
                    throw new DevConfigException(msg);
                }
                DCRepositoryInputProvider provider = new DCRepositoryInputProvider(this.m_configuration, folder, this.m_dcVendor, this.m_dcName);
                this.m_component = ComponentFactory.initialize((DCInputProvider)provider, (boolean)true);
            }
            catch (VfsException e) {
                this.m_component = null;
                String msg = "DTR client Error: " + e.getMessage() + ". Failed to read component definition from DTR for " + this.m_compartmentName + ":" + this.m_dcVendor + "/" + this.m_dcName + ".";
                throw new DevConfigException(msg, e);
            }
            catch (IOException e) {
                this.m_component = null;
                String msg = "IO Error: " + e.getMessage() + ". Failed to read component definition from DTR for " + this.m_compartmentName + ":" + this.m_dcVendor + "/" + this.m_dcName + ". ";
                throw new DevConfigException(msg, e);
            }
            catch (XMLException e) {
                this.m_component = null;
                String msg = "XML error:" + e.getMessage() + ". Failed to read component definition from DTR for " + this.m_compartmentName + ":" + this.m_dcVendor + "/" + this.m_dcName + ". ";
                throw new DevConfigException(msg, e);
            }
            catch (ProviderException e) {
                this.m_component = null;
                String msg = "Component definition read error " + e.getMessage() + ". Failed to read component from DTR for " + this.m_compartmentName + ":" + this.m_dcVendor + "/" + this.m_dcName + ". ";
                throw new DevConfigException(msg, e);
            }
            catch (RepositoryAccessException e) {
                this.m_component = null;
                String msg = "Component definition read error " + ((Throwable)((Object)e)).getMessage() + ". Failed to read component from DTR for " + this.m_compartmentName + ":" + this.m_dcVendor + "/" + this.m_dcName + ". ";
                throw new DevConfigException(msg, (Throwable)((Object)e));
            }
        }
        if (this.m_component == null) {
            String msg = "Internal Error: component data not initialized after reading remotely. DC: " + this.m_compartmentName + ":" + this.m_dcVendor + "/" + this.m_dcName;
            throw new DevConfigException(msg);
        }
    }

    private boolean canInitializeFromBuildServer() {
        return this.m_isActive && !this.m_compartment.isLocal() && this.m_configuration.isWithBuildServer() && !this.m_compartment.hasSourceState();
    }

    void initializeFromLocalFiles() throws DevConfigException {
        DCFileInputProvider dcInputProvider = new DCFileInputProvider(this.m_configuration, this.m_compartmentName, this.m_dcVendor, this.m_dcName);
        this.m_component = null;
        try {
            this.m_component = ComponentFactory.initialize((DCInputProvider)dcInputProvider);
            this.m_component.initializePublicParts((DCInputProvider)dcInputProvider);
        }
        catch (ProviderException e) {
            String msg = "Failed to read component definition from local file " + this.m_compartmentName + ":" + this.m_dcVendor + "/" + this.m_dcName + " : " + e.getMessage();
            throw new DevConfigException(msg + " (" + e.getMessage() + ")", e);
        }
        catch (IOException e) {
            String msg = "I/O Error: Failed to read component definition from local file " + this.m_compartmentName + ":" + this.m_dcVendor + "/" + this.m_dcName + " : " + e.getMessage();
            throw new DevConfigException(msg + " (" + e.getMessage() + ")", e);
        }
        catch (XMLException e) {
            String msg = "XML error: Failed to read component definition from local file " + this.m_compartmentName + ":" + this.m_dcVendor + "/" + this.m_dcName + " : " + e.getMessage();
            throw new DevConfigException(msg + " (" + e.getMessage() + ")", e);
        }
    }

    void checkMakeDependency(String usingCompartment, DCReference dcRef, PPReference ppRef, String usingVariant, boolean ignoreBrokenUsedDCs) throws BuildException {
        String thisMethod = "checkMakeDependency()";
        LOCATION.debugT(thisMethod, "usingCompartment: {0}, dcRef: {1}, ppRef: {2}, usingVariant: {3} ignoreBrokenUsedDCs:{4}", new Object[]{usingCompartment, dcRef, ppRef, usingVariant, new Boolean(ignoreBrokenUsedDCs)});
        if (dcRef != null) {
            String ppName;
            String usedCompartment = this.m_configuration.getCompartmentIDFromDCReference(usingCompartment, dcRef);
            if (usedCompartment == null) {
                String message = "Used component not found: " + dcRef.getVendor() + "/" + dcRef.getName();
                this.notifyBuildFailed(usingVariant, message);
                throw new BuildException(message + ". DC not found in DC syncdb", null, 2);
            }
            IDCSyncEntry syncDBEntry = this.m_configuration.getComponentSyncDB().getEntry(usedCompartment, dcRef.getName(), dcRef.getVendor());
            if (syncDBEntry == null || !syncDBEntry.isLocallyAvailable()) {
                String message = "Used component not available locally: " + dcRef.getVendor() + "/" + dcRef.getName() + "( " + usedCompartment + ")";
                this.notifyBuildFailed(usingVariant, message);
                throw new BuildException(message, null, 2);
            }
            if (syncDBEntry.isLocallyAvailableAsSource() && syncDBEntry.isBroken()) {
                if (!ignoreBrokenUsedDCs) {
                    String message = "Cannot build because used component is broken: " + dcRef.getVendor() + "/" + dcRef.getName() + "( " + usedCompartment + ")";
                    this.notifyBuildFailed(usingVariant, message);
                    throw new BuildException(message, null, 13);
                }
                String message = "Ingored broken used DC : " + dcRef.getVendor() + "/" + dcRef.getName() + "( " + usedCompartment + ")";
                LOCATION.infoT(thisMethod, "Ignored broken DC used DC in build for {}/{}({}) : {}", new Object[]{this.m_dcVendor, this.m_dcName, this.m_compartment.getName(), message});
            }
            if (syncDBEntry.isSynchedAsArchives()) {
                String usedVariant = this.m_configuration.getUsedBuildVariant(usingCompartment, usedCompartment, usingVariant);
                if (usedVariant == null) {
                    try {
                        if (!this.m_configuration.isUsing(usingCompartment, usedCompartment)) {
                            String notification = "Illegal component usage: compartment \"" + usingCompartment + "\" does not use compartment \"" + usedCompartment + "\" of used DC \"" + dcRef.getVendor() + "/" + dcRef.getName() + "\"";
                            this.notifyBuildFailed(usingVariant, notification);
                            String m = notification + "; using DC: " + this;
                            throw new BuildException(m, null, 2);
                        }
                    }
                    catch (DevConfigException e) {
                        LOCATION.traceThrowableT(300, thisMethod, "could not determine why variant mapping was not found: " + ((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
                    }
                    String nofification = "No build variant maping found for component \"" + dcRef.getVendor() + "/" + dcRef.getName() + "\"";
                    this.notifyBuildFailed(usingVariant, nofification);
                    String m = "Failed to get used component. No build variant maping found for component " + dcRef.getVendor() + "/" + dcRef.getName() + " used by " + this + ", using variant is \"" + usingVariant + "\"";
                    throw new BuildException(m, null, 2);
                }
                if (!syncDBEntry.isAvailable(usedVariant)) {
                    String msg = "Used component not available " + dcRef + " in variant " + usedVariant;
                    this.notifyBuildFailed(usingVariant, msg);
                    throw new BuildException(msg, null, 3);
                }
            }
            DCProxy usedProxy = null;
            try {
                usedProxy = this.m_configuration._getDCProxyLocally(usedCompartment, dcRef.getVendor(), dcRef.getName());
            }
            catch (DevConfigException e) {
                String msg = "Used component not available (" + dcRef.getVendor() + "/" + dcRef.getName() + ")";
                this.notifyBuildFailed(usingVariant, msg);
                throw new BuildException(msg, null, 2);
            }
            LOCATION.debugT(thisMethod, "used DC is completely available locally. Check if public part exists");
            String string = ppName = ppRef != null ? ppRef.getName() : null;
            if (ppName != null) {
                try {
                    usedProxy.assertPPExists(ppName);
                }
                catch (SyncException e) {
                    String msg = "Could not find used public part \"" + ppName + "\" of  " + usedProxy.toString() + " : " + ((Throwable)((Object)e)).getMessage();
                    this.notifyBuildFailed(usingVariant, msg);
                    throw new BuildException(msg, (Throwable)((Object)e), 3);
                }
            }
        }
    }

    void checkMakeDependencies(String buildVariant, boolean ignoreBrokenUsedDCs, DependencyValidationOption dependencyValidationOption) throws BuildException {
        String thisMethod = "checkMakeDependencies";
        PPReference pluginRef = this.m_component.getBuildPlugin();
        if (pluginRef == null) {
            String msg = "Build failed: No build plugin reference found in component definition";
            this.notifyBuildFailed(buildVariant, msg);
            throw new BuildException(msg, null, 14);
        }
        LOCATION.debugT(thisMethod, "Check if build plugin \"{0}\" (variant \"{1}\") and its dependencies are available locally", new Object[]{pluginRef.getComponent(), buildVariant});
        this.checkMakeDependency(this.m_compartmentName, pluginRef.getComponent(), pluginRef, buildVariant, ignoreBrokenUsedDCs);
        LOCATION.debugT(thisMethod, "Check if used components are available locally");
        List deps = this.m_component.getDependencies();
        if (deps != null) {
            Iterator iter = deps.iterator();
            while (iter.hasNext()) {
                Dependency dep = (Dependency)iter.next();
                DCReference dcRef = dep.getComponent();
                PPReference ppRef = dep.getPublicPartDependency();
                LOCATION.debugT(thisMethod, "Check if used component \"{0}\" is available in build variant \"{1}\"", new Object[]{dcRef, buildVariant});
                if (dep.isForChildrenOnly()) continue;
                if (dep.isAtBuildTime()) {
                    this.checkMakeDependency(this.m_compartmentName, dcRef, ppRef, buildVariant, ignoreBrokenUsedDCs);
                    continue;
                }
                if (dep.isAtRunTime()) {
                    this.checkMakeDependency(this.m_compartmentName, dcRef, ppRef, buildVariant, true);
                    continue;
                }
                if (dependencyValidationOption == DependencyValidationOption.NOTHING || dependencyValidationOption == DependencyValidationOption.ONLY_AT_BUILD_TIME) {
                    LOCATION.debugT(thisMethod, "Skipping availability check for dependency from {0} to {1} because check is restricted (Check {2})", new Object[]{this, dep, dependencyValidationOption});
                    continue;
                }
                this.checkMakeDependency(this.m_compartmentName, dcRef, ppRef, buildVariant, true);
            }
        }
    }

    private List getInfrastructureComponentPathList(String buildVariant) throws BuildException {
        ArrayList pathList = new ArrayList();
        HashSet coveredPPs = new HashSet();
        HashSet coveredDCs = new HashSet();
        PPReference pluginRef = this.m_component.getBuildPlugin();
        if (pluginRef != null) {
            this.addUsedInfrastructureDCorPPToList(pathList, coveredDCs, coveredPPs, this.m_compartmentName, pluginRef.getComponent(), pluginRef, buildVariant);
            this.addUsedPluginDependencies(pathList, coveredDCs, coveredPPs, this.m_compartmentName, pluginRef, buildVariant);
        }
        return pathList;
    }

    private void addUsedPluginDependencies(List pathList, Set coveredDCs, Set coveredPPs, String usingCompartment, PPReference ppRef, String usingVariant) throws BuildException {
        String thisMethod = "addUsedPluginDependencies()";
        String pluginCompartment = this.m_configuration.getCompartmentIDFromDCReference(usingCompartment, ppRef.getComponent());
        DCProxy usedPluginProxy = null;
        try {
            usedPluginProxy = this.m_configuration._getDCProxyLocalOrActive(pluginCompartment, ppRef.getComponent().getVendor(), ppRef.getComponent().getName());
        }
        catch (DevConfigException e) {
            LOCATION.traceThrowableT(300, thisMethod, "Could not initialize used plugin DCProxy, skipping this plugin dependency: " + ((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
        }
        if (usedPluginProxy != null) {
            String usedVariant = this.m_configuration.getUsedBuildVariant(usingCompartment, pluginCompartment, usingVariant);
            if (usedVariant == null) {
                String nofification = "Used component not found: " + usedPluginProxy;
                this.notifyBuildFailed(usingVariant, nofification);
                String m = "FAILED to get used component. No build variant maping found for component " + usedPluginProxy + " used by " + this + ", using variant is \"" + usingVariant + "\"";
                throw new BuildException(m, null, 2);
            }
            this.addPluginDependenciesToList(pathList, coveredDCs, coveredPPs, pluginCompartment, usedPluginProxy.getComponent(), usedVariant);
        }
    }

    private void addPluginDependenciesToList(List pathList, Set coveredDCs, Set coveredPPs, String usingCompartment, DevelopmentComponent component, String usingVariant) throws BuildException {
        List deps = component.getDependencies();
        if (deps != null) {
            Iterator iter = deps.iterator();
            while (iter.hasNext()) {
                Dependency dep = (Dependency)iter.next();
                if (!dep.isAtRunTime() || dep.isForChildrenOnly()) continue;
                DCReference dcRef = dep.getComponent();
                PPReference ppRef = dep.getPublicPartDependency();
                this.addUsedInfrastructureDCorPPToList(pathList, coveredDCs, coveredPPs, usingCompartment, dcRef, ppRef, usingVariant);
            }
        }
    }

    private void syncBuildPluginAndDependencies(final String buildVariant, Map dcsToBeSynchedAsArchives) throws SyncException {
        IDevelopmentComponentNode bpNode;
        String thisMethod = "syncBuildPluginAndDependencies(String,boolean )";
        final HashSet<IDevelopmentComponentNode> startDCs = new HashSet<IDevelopmentComponentNode>();
        try {
            bpNode = this.toNode().getBuildPlugin();
        }
        catch (DevConfigException e) {
            String msg = ((Throwable)((Object)e)).getMessage();
            LOCATION.traceThrowableT(300, "syncBuildPluginAndDependencies(String,boolean )", msg, (Throwable)((Object)e));
            LOCATION.debugT("Could not find the build plugin for DC " + this + " skipping sync of build plugin and dependencies.");
            return;
        }
        if (bpNode == null) {
            LOCATION.debugT("Not build plugin defined for DC " + this + " skipping sync of build plugin and dependencies.");
            return;
        }
        final HashMap syncCandidates = new HashMap();
        startDCs.add(bpNode);
        try {
            this.m_configuration.listUsedDCs(startDCs, new IUsedDCFoundHandler(){

                public boolean onUsedDCError(Exception exception, IDevelopmentComponentNode referncingNode, Dependency dependency) {
                    String methodString = "syncBuildPluginAndDependencies(String,boolean ):IUsedDCFoundHandler#onUsedDCError";
                    String msg = "Error during synchronizing of used components: " + exception.getMessage();
                    LOCATION.debugT(methodString, msg);
                    DCProxy.this.notifyUsedDCSyncWarning(referncingNode, "", msg);
                    return true;
                }

                public boolean onUsedDCError(Exception exception, IDevelopmentComponentNode referncingNode, PPReference reference) {
                    String methodString = "syncBuildPluginAndDependencies(String,boolean ):IUsedDCFoundHandler#onUsedDCError(Exception,IDevelopmentComponentNode,PPReference)";
                    String msg = "Error during synchronizing of used components: " + exception.getMessage();
                    LOCATION.debugT(methodString, msg);
                    DCProxy.this.notifyUsedDCSyncWarning(referncingNode, "", msg);
                    return true;
                }

                public boolean onUsedDCError(Exception exception, IDevelopmentComponentNode problemDC) {
                    String methodString = "syncBuildPluginAndDependencies(String,boolean ):IUsedDCFoundHandler#onUsedDCError(Exception,IDevelopmentComponentNode)";
                    String msg = "Error during synchronizing of used components: " + exception.getMessage();
                    LOCATION.debugT(methodString, msg);
                    DCProxy.this.notifyUsedDCSyncWarning(problemDC, "", msg);
                    return true;
                }

                public UsedDCSearchInstruction atComponentNode(IDevelopmentComponentNode foundDC, IDevelopmentComponentNode usingDC) {
                    UsedDCSearchInstruction result;
                    if (foundDC.isSynchedAsSource() || foundDC.isLocalOnly()) {
                        result = null;
                    } else if (startDCs.contains(foundDC)) {
                        String usedVariant = DCProxy.this.m_configuration.getUsedBuildVariant(DCProxy.this.m_compartmentName, foundDC.getCompartmentName(), buildVariant);
                        if (usedVariant == null) {
                            String msg = "Could not determine mapped build variant of DC " + foundDC + ". used by " + this + ", using variant " + buildVariant + " Skipping this dependency.";
                            LOCATION.debugT("syncBuildPluginAndDependencies(String,boolean )", msg);
                            DCProxy.this.notifyUsedDCSyncWarning(foundDC, "", msg);
                            result = null;
                        } else {
                            syncCandidates.put(foundDC, usedVariant);
                            DCUsageFilter filter = new DCUsageFilter(true, false, false, false, false);
                            result = new UsedDCSearchInstruction(filter, false);
                        }
                    } else if (usingDC == null) {
                        String msg = "Internal error while determining used DCs. Found " + foundDC + " but no using DC passed as argument!";
                        LOCATION.infoT("syncBuildPluginAndDependencies(String,boolean )", msg);
                        DCProxy.this.notifyUsedDCSyncError(foundDC, "", msg);
                        result = null;
                    } else {
                        String usingVariant = (String)syncCandidates.get(usingDC);
                        if (usingVariant == null) {
                            String msg = "Internal error: Could not determine using build variant for usage of DC " + foundDC + " by " + usingDC;
                            LOCATION.debugT("syncBuildPluginAndDependencies(String,boolean )", msg);
                            DCProxy.this.notifyUsedDCSyncError(foundDC, "", msg);
                            result = null;
                        } else {
                            String usedVariant = DCProxy.this.m_configuration.getUsedBuildVariant(usingDC.getCompartmentName(), foundDC.getCompartmentName(), usingVariant);
                            if (usedVariant == null) {
                                String msg = "Could not determine mapped build variant of DC " + foundDC + " used by " + usingDC + ", using variant " + usingVariant + " Skipping this dependency.";
                                LOCATION.debugT("syncBuildPluginAndDependencies(String,boolean )", msg);
                                DCProxy.this.notifyUsedDCSyncError(foundDC, "", msg);
                                result = null;
                            } else {
                                DCUsageFilter filter = new DCUsageFilter(true, false, false, false, false);
                                result = new UsedDCSearchInstruction(filter, false);
                                syncCandidates.put(foundDC, usedVariant);
                            }
                        }
                    }
                    return result;
                }
            });
        }
        catch (DevConfigException e1) {
            String msg = "Error during synchronizing of used components: " + ((Throwable)((Object)e1)).getMessage();
            LOCATION.traceThrowableT(300, "syncBuildPluginAndDependencies(String,boolean )", msg, (Throwable)((Object)e1));
            this.notifyUsedDCSyncFailed(msg, this.m_isActive);
        }
        Iterator iter = syncCandidates.keySet().iterator();
        while (iter.hasNext()) {
            IDevelopmentComponentNode dcnode = (IDevelopmentComponentNode)iter.next();
            String bv = (String)syncCandidates.get(dcnode);
            if (dcnode.isSynchedAsSource() || dcnode.isLocalOnly()) continue;
            if (!this.m_configuration.isWithBuildServer()) {
                String msg = "Synchronize used components: Skipped " + dcnode + ". No build server configured. Sources must be synched manually.";
                LOCATION.debugT("syncBuildPluginAndDependencies(String,boolean )", msg);
                this.notifyUsedDCSyncWarning(dcnode, "", msg);
                continue;
            }
            dcsToBeSynchedAsArchives.put(dcnode, bv);
        }
    }

    private void addUsedInfrastructureDCorPPToList(List pathList, Set coveredDCs, Set coveredPPs, String usingCompartment, DCReference dcRef, PPReference ppRef, String usingVariant) throws BuildException {
        String thisMethod = "addUsedDCorPPToList(...)";
        if (dcRef != null) {
            String usedCompartment = this.m_configuration.getCompartmentIDFromDCReference(usingCompartment, dcRef);
            if (usedCompartment == null) {
                throw new BuildException("Used component " + dcRef.getName() + "(SC " + dcRef.getSCAlias() + ") not available", null, 2);
            }
            if (!this.m_configuration.isDCAvailableLocally(usedCompartment, dcRef.getVendor(), dcRef.getName())) {
                throw new BuildException("Used component " + dcRef.getName() + "(SC " + dcRef.getSCAlias() + ") not available", null, 2);
            }
            DCProxy usedProxy = null;
            try {
                usedProxy = this.m_configuration._getDCProxyLocalOrActive(usedCompartment, dcRef.getVendor(), dcRef.getName());
            }
            catch (DevConfigException e) {
                LOCATION.traceThrowableT(300, thisMethod, "Could not initialize used DCProxy, skipping this dependency.", (Throwable)((Object)e));
            }
            if (usedProxy != null) {
                Map pps = usedProxy.getComponent().getPublicParts();
                if (pps != null) {
                    if (ppRef != null && ppRef.getName() != null) {
                        PublicPart pp = (PublicPart)pps.get(ppRef.getName());
                        if (pp == null) {
                            throw new BuildException("Used publuc part not available", null, 3);
                        }
                        if (!coveredPPs.contains(pp) && pp.getPurpose().equals(PublicPart.Purpose.INFRASTRUCTURE)) {
                            coveredPPs.add(pp);
                            FileSystemLayout layout = new FileSystemLayout(this.m_configuration, usingCompartment, dcRef.getVendor(), dcRef.getName());
                            pathList.add(layout.getUsedPublicPartRootFolder(usingVariant, ppRef));
                        }
                    } else {
                        Iterator iter = pps.values().iterator();
                        while (iter.hasNext()) {
                            PublicPart pp = (PublicPart)iter.next();
                            if (pp == null || coveredPPs.contains(pp) || !pp.getPurpose().equals(PublicPart.Purpose.INFRASTRUCTURE)) continue;
                            coveredPPs.add(pp);
                            ppRef = new PPReference(pp.getName(), dcRef);
                            FileSystemLayout layout = new FileSystemLayout(this.m_configuration, usingCompartment, dcRef.getVendor(), dcRef.getName());
                            pathList.add(layout.getUsedPublicPartRootFolder(usingVariant, ppRef));
                        }
                    }
                } else if (pps == null && ppRef != null && ppRef.getName() != null) {
                    throw new BuildException("Used public part not available", null, 3);
                }
                if (!coveredDCs.contains(usedProxy)) {
                    coveredDCs.add(usedProxy);
                    List deps = usedProxy.getComponent().getDependencies();
                    if (deps != null) {
                        Iterator iter = deps.iterator();
                        while (iter.hasNext()) {
                            Dependency dep = (Dependency)iter.next();
                            if (!dep.isAtRunTime() || dep.isForChildrenOnly()) continue;
                            DCReference dcReference = dep.getComponent();
                            PPReference ppReference = dep.getPublicPartDependency();
                            this.addUsedInfrastructureDCorPPToList(pathList, coveredDCs, coveredPPs, usingCompartment, dcReference, ppReference, usingVariant);
                        }
                    }
                }
            }
        }
    }

    private void createGenFolders(String buildVariant) throws BuildException {
        File vntTempFolderFile;
        File root = new File(this.m_fileSystemLayout.getVariantRootFolder(buildVariant));
        if (!root.exists() && !root.mkdirs()) {
            String m = "Create build folders failed. Could not create gen root folder: " + root.getAbsolutePath();
            throw new BuildException(m, null, 12);
        }
        if (this.m_component.getPublicParts() != null) {
            Iterator iter = this.m_component.getPublicParts().values().iterator();
            while (iter.hasNext()) {
                PublicPart pp = (PublicPart)iter.next();
                File ppRoot = new File(this.m_fileSystemLayout.getPublicPartRootFolder(buildVariant, pp.getName()));
                if (ppRoot.exists() || ppRoot.mkdirs()) continue;
                String m = "Create build folders failed. Could not create gen folder: " + ppRoot.getAbsolutePath() + " for public part " + pp.getName();
                throw new BuildException(m, null, 12);
            }
        }
        if (!(vntTempFolderFile = this.getVariantTempGenFolder(buildVariant)).exists()) {
            if (!vntTempFolderFile.mkdirs()) {
                String m = "Create build folders failed. Could not temp gen folder: " + vntTempFolderFile.getAbsolutePath() + " for build variant " + buildVariant;
                throw new BuildException(m, null, 12);
            }
            LOCATION.debugT("createGenFolders", "successfully created temporary gen folder {0} for DC {1} in variant {2}", new Object[]{vntTempFolderFile.getAbsolutePath(), this.toString(), buildVariant});
        }
    }

    private void syncArchives(String buildVariant, boolean syncForce, IDCVariantState vntState) throws SyncException {
        String thisMethod = "syncArchives(String ,boolean )";
        long newBuildNumber = this.loadCompleteDC(buildVariant, syncForce, vntState);
        if (newBuildNumber == SYNC_SKIPPED) {
            return;
        }
        try {
            this.m_component = this.readComponentDefinition();
            this.m_isLightweight = false;
        }
        catch (IOException e) {
            String msg = "I/O error after archive download (" + e.getMessage() + "). Could not read definition of " + this;
            this.notifyDCDASyncFailed(buildVariant, "IO Error");
            this.removeAllFilesAndSetUnsynched();
            throw new SyncException(msg, e, 4);
        }
        catch (XMLException e) {
            String msg = "XML parser error after archive download (" + e.getMessage() + "). Could not read definition of " + this;
            this.removeAllFilesAndSetUnsynched();
            throw new SyncException(msg, e, 4);
        }
        catch (ProviderException e) {
            String msg = "Read error after archive download (" + e.getMessage() + "). Could not read definition of " + this;
            this.removeAllFilesAndSetUnsynched();
            throw new SyncException(msg, e, 4);
        }
        ComponentSyncDB syncdb = this.m_configuration.getComponentSyncDB();
        IDCSyncEntry syncEntry = syncdb.getEntry(this.m_compartment, this.m_component);
        if (syncEntry == null) {
            syncEntry = syncdb.createEntry(this.m_compartment, this.m_component);
        }
        DCNodeSyncMode oldmode = this._getDCSyncMode();
        DCNodeSyncState oldState = this._getDCSyncState();
        SyncMode newMode = SyncMode.SYNCHED_AS_ARCHIVE;
        SyncState newState = SyncState.UPTODATE;
        syncEntry.setState(buildVariant, newState);
        syncEntry.setMode(newMode);
        syncEntry.setBuildNumber(buildVariant, newBuildNumber);
        Set dirtifiedDcSet = new HashSet();
        try {
            dirtifiedDcSet = this.markUsingDCsDirty(false, false);
        }
        catch (DevConfigException e) {
            String m = "Failed to mark using DCs as dirty after syncing \"" + this + "\"" + ((Throwable)((Object)e)).getMessage();
            this.m_configuration.sendDCMessage(this, buildVariant, DCMessageType.WARNING, DCEventType.ARCHIVE_SYNCED, m, true);
            LOCATION.traceThrowableT(300, thisMethod, "Caught DevConfigException when trying to mark using Dcs dirty after archive sync. Send message to listener and ignore the exception.", (Throwable)((Object)e));
        }
        syncdb.save();
        this.ensureCachedCorrectly();
        this.m_configuration.notifyDCSyncModeChanged(this.m_compartmentName, this.m_dcVendor, this.m_dcName, oldmode, this._getDCSyncMode(), true);
        this.m_configuration.notifyDCSyncStateChanged(this.m_compartmentName, this.m_dcVendor, this.m_dcName, oldState, this._getDCSyncState(buildVariant), true);
        this.m_configuration.notifyDCChanged(this.m_compartmentName, this.m_dcVendor, this.m_dcName, true);
        this.m_configuration.notifyDCsDirty(dirtifiedDcSet);
    }

    private DCNodeSyncState _getDCSyncState(String buildVariant) {
        return this.m_configuration.calculateSyncStateForDC(this.m_compartmentName, this.m_dcVendor, this.m_dcName, buildVariant);
    }

    private void removeAllFilesAndSetUnsynched() {
        Util.deleteDirRecursively((File)new File(this.m_fileSystemLayout.getRootFolder()));
        IDCSyncEntry entry = this.m_configuration.getComponentSyncDB().getEntry(this.m_compartmentName, this.m_dcName, this.m_dcVendor);
        if (entry != null) {
            SyncMode oldMode = entry.getMode();
            SyncState oldState = this.m_configuration.getComponentSyncDB().getSyncState(this.m_compartmentName, this.m_dcVendor, this.m_dcName);
            this.m_configuration.getComponentSyncDB().removeEntry(this.m_compartmentName, this.m_dcName, this.m_dcVendor);
            SyncMode newMode = SyncMode.NOT_SYNCHED;
            SyncState newState = SyncState.UNKNOWN;
            this.m_configuration.getComponentSyncDB().save();
            boolean affectsActiveState = true;
            this.m_configuration.notifyDCSyncStateChanged(this.m_compartmentName, this.m_dcVendor, this.m_dcName, oldState, newState, affectsActiveState);
            this.m_configuration.notifyDCSyncModeChanged(this.m_compartmentName, this.m_dcVendor, this.m_dcName, oldMode, newMode, affectsActiveState);
            this.m_configuration.notifyDCChanged(this.m_compartmentName, this.m_dcVendor, this.m_dcName, affectsActiveState);
        }
    }

    private DevelopmentComponent readComponentDefinition() throws ProviderException, XMLException, IOException {
        DCFileInputProvider dcInputProvider = new DCFileInputProvider(this.m_configuration, this.m_compartmentName, this.m_dcVendor, this.m_dcName);
        DevelopmentComponent dc = ComponentFactory.initialize((DCInputProvider)dcInputProvider);
        dc.initializePublicParts((DCInputProvider)dcInputProvider);
        return dc;
    }

    private boolean doUnsyncSources() throws SyncException {
        VFSHandler vfsHandler;
        boolean isTopLevel = this.m_component != null ? this.m_component.getEnclosingComponent() == null : true;
        boolean isLocalOnly = false;
        if (this._isSynchedAsModifiableSource()) {
            if (this._getDCActivityState() == DCActivityState.CHECKED_OUT_FOR_CREATE) {
                String msg = "Cannot unsync component. The component itself is checked out for create.";
                throw new SyncException(msg, null, 7);
            }
            if (this._getDCActivityState() == DCActivityState.CHECKED_OUT_FOR_DELETE) {
                String msg = "Cannot unsync component. The component itself is checked out for delete.";
                throw new SyncException(msg, null, 7);
            }
            try {
                if (this.isAnythingCheckedOut()) {
                    String msg = "Cannot unsync component. There are files checked out.";
                    throw new SyncException(msg, null, 7);
                }
            }
            catch (VfsException e) {
                String msg = "Cannot determine whether files are checked out (VfsException : " + e.getMessage() + ")";
                throw new SyncException(msg, e);
            }
        }
        if (!(isLocalOnly = (vfsHandler = this._getVFSHandler()).isItemLocalOnly(this.getDefinitionPath()))) {
            vfsHandler.removeLocalPath(this.m_fileSystemLayout.getRootFolder());
        }
        if (isTopLevel) {
            DevConfFileSystemLayout devconfFSL = this.m_configuration.getDevConfFSL();
            String folderSCs = devconfFSL.getAbsoluteTopLevelDCsRoot(this.m_compartmentName);
            String dcRefFile = folderSCs + devconfFSL.calculateTopLevelDCRefFileName(this.m_dcVendor, this.m_dcName);
            vfsHandler.removeLocalPath(dcRefFile);
        }
        return isLocalOnly;
    }

    private void resyncArchives(IDCSyncEntry syncDBEntry, boolean refreshAll) throws SyncException {
        Iterator variantIterator = syncDBEntry.getVariantNames().iterator();
        while (variantIterator.hasNext()) {
            String variant = (String)variantIterator.next();
            this.syncArchives(variant, refreshAll, null);
        }
    }

    private void constructAtBuildTimeUsageGraph(Digraph graph, Set visitedMakeDCs, Set visitedArchiveDCs, String buildVariant, boolean sendBuildFailedMessages) throws BuildException {
        String thisMethod = "buildUsageGraph()";
        visitedMakeDCs.add(this.getKey());
        List dependencies = this.m_component.getDependencies();
        if (dependencies == null) {
            return;
        }
        Iterator it = dependencies.iterator();
        TreeSet<String> alreadyFoundDcRefs = new TreeSet<String>();
        while (it.hasNext()) {
            String m;
            Dependency dep = (Dependency)it.next();
            if (!dep.isAtBuildTime()) continue;
            if (dep.getComponent() == null) {
                m = "Invalid used component found (dependency does not point to any DC). Used by " + this;
                if (sendBuildFailedMessages) {
                    this.notifyBuildFailed(buildVariant, m);
                }
                throw new BuildException(m, null, 9, this.getVendor(), this.getName(), null);
            }
            if (dep.getComponent().getVendor() == null) {
                m = "Invalid used component found (dependency does not specify a vendor). Used by " + this;
                if (sendBuildFailedMessages) {
                    this.notifyBuildFailed(buildVariant, m);
                }
                throw new BuildException(m, null, 9, this.getVendor(), this.getName(), null);
            }
            if (dep.getComponent().getName() == null) {
                m = "Invalid used component found (dependency does not specify a component name). Used by " + this;
                if (sendBuildFailedMessages) {
                    this.notifyBuildFailed(buildVariant, m);
                }
                throw new BuildException(m, null, 9, this.getVendor(), this.getName(), null);
            }
            DCReference ref = dep.getComponent();
            String usedCompartment = this.m_configuration.getCompartmentIDFromDCReference(this.m_compartmentName, ref);
            if (usedCompartment == null) {
                String m2 = "Used component not found :  " + ref.getVendor() + "/" + ref.getName() + ", used by " + this;
                if (sendBuildFailedMessages) {
                    this.notifyBuildFailed(buildVariant, m2);
                }
                throw new BuildException(m2, null, 2, ref.getVendor(), ref.getName(), null);
            }
            String usedDCkey = this.getKey(usedCompartment, ref.getVendor(), ref.getName());
            String usedComponentMessageString = ref.getVendor() + "/" + ref.getName() + " in compartment '" + usedCompartment + "'";
            if (alreadyFoundDcRefs.contains(usedDCkey)) continue;
            alreadyFoundDcRefs.add(usedDCkey);
            if (visitedMakeDCs.contains(usedDCkey)) {
                DCProxy usedDCProxy = null;
                try {
                    usedDCProxy = this.m_configuration._getDCProxyLocally(usedCompartment, ref.getVendor(), ref.getName());
                }
                catch (DevConfigException e) {
                    String m3 = "InternalError: could not initialize DCProxy for used DC " + ref.getVendor() + "/" + ref.getName() + " used by " + this;
                    if (sendBuildFailedMessages) {
                        this.notifyBuildFailed(buildVariant, m3);
                    }
                    throw new BuildException(m3, (Throwable)((Object)e), 2, ref.getVendor(), ref.getName(), null);
                }
                graph.addArc(this, usedDCProxy);
                LOCATION.debugT(thisMethod, "added usage arrow [{0}] ---> [{1}]", new Object[]{this, usedDCProxy});
                continue;
            }
            if (visitedArchiveDCs.contains(usedDCkey)) continue;
            int availability = this.m_configuration.getLocalAvailability(usedCompartment, ref.getVendor(), ref.getName());
            if (availability == DevelopmentConfiguration.DC_NOT_AVAILABLE_LOCALLY) {
                String msg = "used component " + usedComponentMessageString + " is not synced used. " + " (used by : " + this + ")";
                if (sendBuildFailedMessages) {
                    this.notifyBuildFailed(buildVariant, msg);
                }
                throw new BuildException(msg, null, 2);
            }
            if (availability == DevelopmentConfiguration.DC_AVAILABLE_AS_ARCHIVES) {
                visitedArchiveDCs.add(usedDCkey);
                continue;
            }
            DCProxy usedDCproxy = null;
            try {
                usedDCproxy = this.m_configuration._getDCProxyLocalOrActive(usedCompartment, ref.getVendor(), ref.getName());
            }
            catch (DevConfigException e) {
                String msg = "cannot get DCProxy for  used component " + usedComponentMessageString + ". " + " (used by: " + this + ")";
                if (sendBuildFailedMessages) {
                    this.notifyBuildFailed(buildVariant, msg);
                }
                throw new BuildException(msg, (Throwable)((Object)e), 2);
            }
            graph.addArc(this, usedDCproxy);
            LOCATION.debugT(thisMethod, "added usage arrow [" + this + "] ---> [" + usedDCproxy + "]");
            usedDCproxy.constructAtBuildTimeUsageGraph(graph, visitedMakeDCs, visitedArchiveDCs, buildVariant, sendBuildFailedMessages);
        }
    }

    private String getKey() {
        return this.m_key;
    }

    private String getKey(String compartment, String vendor, String name) {
        return compartment + "#" + vendor + "#" + name;
    }

    void syncArchivesFromCBSorDTR(String buildVariant, boolean refreshAll) throws SyncException {
        boolean withCBS;
        boolean bl = withCBS = this.m_configuration.getBuildServer() != null;
        if (!withCBS) {
            LOCATION.debugT("syncArchivesFromCBSorDTR", "No build server specified in configuration, looking for archives in DTR");
            this.syncArchivesFromRepository(refreshAll);
        } else {
            this.syncAsArchives(buildVariant, refreshAll);
        }
    }

    private void syncArchivesFromRepository(boolean refreshAll) throws SyncException {
        String thisMethod = "syncArchivesFromRepository";
        if (this.isSynchedAsArchives()) {
            String msg = "Cannot resync archives for " + this + ". No build server specified in configuration.";
            throw new SyncException(msg, null, 11, this.m_compartmentName, this.getName(), this.getVendor());
        }
        if (this._isSynched() && !this.isSynchedAsActiveSource()) {
            String msg = "cannot sync archives  from active workspace, already synched in mode " + this._getDCSyncMode() + ". Skipping " + this;
            LOCATION.infoT(thisMethod, msg);
            return;
        }
        if (!this.getComponent().isExternal()) {
            String msg = "cannot sync archives from active workspace, component is not of type external. Skipping " + this;
            LOCATION.infoT(thisMethod, msg);
            return;
        }
        if (!this.getCompartment().hasSourceState()) {
            String msg = "cannot sync archives from active workspace. Compartment has no workspace assigned.";
            throw new SyncException(msg, null, 11, this.m_compartmentName, this.getName(), this.getVendor());
        }
        this.syncAsSources(false, refreshAll);
    }

    boolean isDCValid() {
        return this.m_component != null && this.m_dcVendor.equals(this.m_component.getVendor()) && this.m_dcName.equals(this.m_component.getName());
    }

    void assertIsValid() throws DevConfigException {
        if (!this.m_invalid) {
            return;
        }
        String message = "Invalid state detected: ";
        DevConfigException e = null;
        if (this.m_component == null) {
            message = message + " Component data are not intialized (null).";
            e = new DevConfigException(message);
        }
        if (this.m_dcVendor.equals(this.m_component.getVendor())) {
            message = message + " vendor name " + this.m_dcVendor + " of DCProxy is not equal to vendor name in definition file.";
            e = new DevConfigException(message);
        }
        if (this.m_dcName.equals(this.m_component.getName())) {
            message = message + " DC name " + this.m_dcVendor + " of DCProxy is not equal to DC name in definition file.";
            e = new DevConfigException(message);
        }
        if (e != null) {
            throw e;
        }
    }

    String getPPKey(String ppName) {
        return this.m_compartmentName + "#" + this.m_dcVendor + "#" + this.m_dcName + "#" + ppName;
    }

    private void _removeMountPoint(boolean unsyncBeforeRemove) throws SyncException {
        String compartmentName = this.m_compartmentName;
        IMountPoint mp = this.m_configuration.getMountPointForDC(compartmentName, this.m_dcVendor, this.m_dcName);
        if (mp != null) {
            String localDCpath = this.m_configuration.getDevConfFSL().getAbsoluteDCRoot(compartmentName, this.m_dcVendor, this.m_dcName);
            if (unsyncBeforeRemove) {
                this._getVFSHandler().removeLocalPath(localDCpath);
            }
            this.m_configuration.removeMountPoint(mp);
        }
    }

    public IVfsFile getComponentDefinitionVfsFile() throws VfsException {
        this.assertValidInstance();
        String dcdefFile = this.m_fileSystemLayout.getComponentDefinitionFile();
        IVfsFolderItem item = this._getVFSHandler().getFolderItemForLocalPath(dcdefFile);
        return item == null ? null : item.asFile();
    }

    public String getSDKPath(String buildVariant, ILocalBuildProperties localBuildProperties) throws SyncException {
        this.assertValidInstance();
        try {
            if (localBuildProperties == null) {
                localBuildProperties = new LocalBuildProperties();
            }
            DevelopmentComponentInfo dcInfo = new DevelopmentComponentInfo(this.m_configuration, this.m_compartmentName, this.m_component, buildVariant);
            dcInfo.setLocalBuildProperties(localBuildProperties);
            return dcInfo.getSDKPath();
        }
        catch (DevConfigException e) {
            throw new SyncException("Could not determine SDK Path for make of component " + this, (Throwable)((Object)e));
        }
    }

    public String getRequiredSDKProperty(String buildVariant) throws SyncException {
        this.assertValidInstance();
        try {
            DevelopmentComponentInfo dcInfo = new DevelopmentComponentInfo(this.m_configuration, this.m_compartmentName, this.m_component, buildVariant);
            return dcInfo.getRequiredSDKProperty();
        }
        catch (DevConfigException e) {
            throw new SyncException("Could not determine required SDK Property for make of component " + this, (Throwable)((Object)e));
        }
    }

    private DCProxy getParentLocallyOrActive() throws SyncException {
        DCReference parentRef = this.m_component.getEnclosingComponent();
        if (parentRef == null) {
            return null;
        }
        DCProxy proxy = null;
        try {
            proxy = this.m_configuration._getDCProxyLocalOrActive(this.m_compartmentName, parentRef.getVendor(), parentRef.getName());
        }
        catch (DevConfigException e) {
            String msg = "Could not find parent component \"" + parentRef.getVendor() + "/" + parentRef.getName() + "\" of " + this;
            throw new SyncException(msg, (Throwable)((Object)e), 14);
        }
        return proxy;
    }

    String getUsedCompartmentName(DCReference dcRef) throws SyncException {
        String usedCompartment = this.m_configuration.findCompartmentIDFromDCReference(this.m_compartmentName, dcRef);
        if (usedCompartment == null) {
            String msg = "Could not find compartment of used component " + dcRef.getVendor() + "/" + dcRef.getName() + " in configuration " + this.m_configuration.getConfigurationData().getName();
            throw new SyncException(msg, null, 11, null, dcRef.getVendor(), dcRef.getName());
        }
        return usedCompartment;
    }

    private String getUsedCompartmentName(PPReference ppRef) throws SyncException {
        return this.getUsedCompartmentName(ppRef.getComponent());
    }

    public boolean isBuildPlugin() {
        ComponentType type = this.m_component.getComponentType();
        if (type == null) {
            return false;
        }
        String typeName = type.getType();
        return DC_VENDOR_INFR.equals(type.getVendor()) && DC_TYPE_PLUGIN.equals(typeName);
    }

    public boolean isInfrastructureLibrary() {
        ComponentType type = this.m_component.getComponentType();
        if (type == null) {
            return false;
        }
        String typeName = type.getType();
        return DC_VENDOR_INFR.equals(type.getVendor()) && DC_TYPE_INFRA.equals(typeName);
    }

    public boolean isInfrastructureComponent() {
        ComponentType type = this.m_component.getComponentType();
        if (type == null) {
            return false;
        }
        String typeName = type.getType();
        return DC_VENDOR_INFR.equals(type.getVendor()) && (DC_TYPE_PLUGIN.equals(typeName) || DC_TYPE_INFRA.equals(typeName));
    }

    private CBSHandler getArchiveLoader() throws DevConfigException {
        if (this.m_archiveLoader == null) {
            this.m_archiveLoader = new CBSHandler(this);
        }
        return this.m_archiveLoader;
    }

    private void assertPPExists(String ppName) throws SyncException {
        Map pps = this.getComponent().getPublicParts();
        if (pps == null || pps.get(ppName) == null) {
            String message = "Used public part not available";
            throw new SyncException(message, null, 12, this.m_compartmentName, this.m_dcName, this.m_dcVendor, ppName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long loadCompleteDC(String buildVariant, boolean syncForce, IDCVariantState vntState) throws SyncException {
        long buildnumber;
        CBSHandler loader;
        try {
            loader = this.getArchiveLoader();
        }
        catch (DevConfigException ex) {
            throw new SyncException("Could not load DC archives from build server: " + ((Throwable)((Object)ex)).getMessage(), (Throwable)((Object)ex), 43);
        }
        String thisMethod = "loadCompleteDC()";
        IDCVariantState variantState = vntState == null ? loader.loadDCVariantState(buildVariant) : vntState;
        if (!syncForce) {
            long currentBuildNumberOnServer = variantState.getVariantBuildNumber();
            ComponentSyncDB syncdb = this.m_configuration.getComponentSyncDB();
            IDCSyncEntry syncEntry = syncdb.getEntry(this.getCompartmentName(), this.getName(), this.getVendor());
            if (syncEntry != null && syncEntry.getMode() == SyncMode.SYNCHED_AS_ARCHIVE && syncEntry.isVariantUpToDate(buildVariant, currentBuildNumberOnServer)) {
                LOCATION.debugT(thisMethod, "Already up-to-date. skipped synching archives for {0}", new Object[]{this});
                this.notifyArchiveSyncSkipped(buildVariant);
                return SYNC_SKIPPED;
            }
        }
        LOCATION.debugT(thisMethod, "downloading archives for {0}", new Object[]{this});
        File downloadFolder = null;
        try {
            try {
                block21: {
                    FileInputStream stream;
                    downloadFolder = Util.createTempFolder((String)TEMP_FOLDER_PREFIX, (String)TEMP_FOLDER_SUFFIX);
                    LOCATION.debugT(thisMethod, "created temp folder {0}", new Object[]{downloadFolder.getAbsolutePath()});
                    LOCATION.debugT(thisMethod, "getting component description archive");
                    CBSHandler.IDownloadResult loaderResult = loader.downloadDCDescriptionArchive(downloadFolder, buildVariant);
                    File dcdaFile = loaderResult.getFile();
                    this.notifyDCDASynced(buildVariant);
                    buildnumber = loaderResult.getBuildNumber();
                    HashMap<String, File> ppAFiles = new HashMap<String, File>();
                    String[] ppNames = variantState.getPublicParts();
                    if (ppNames == null) {
                        LOCATION.debugT(thisMethod, "found no public parts on CBS (via DCVariantState)");
                    } else {
                        int numberPPs = ppNames.length;
                        LOCATION.debugT(thisMethod, "found {0} public parts on CBS", new Object[]{Integer.toString(numberPPs)});
                        int i = 0;
                        while (i < numberPPs) {
                            String ppName = ppNames[i];
                            LOCATION.debugT(thisMethod, "found public part \"{0}\"", new Object[]{ppName});
                            loaderResult = loader.downloadPPArchive(downloadFolder, buildVariant, ppName);
                            File ppAFile = loaderResult.getFile();
                            this.notifyPublicPartSynced(buildVariant, ppName);
                            buildnumber = buildnumber > loaderResult.getBuildNumber() ? buildnumber : loaderResult.getBuildNumber();
                            ppAFiles.put(ppName, ppAFile);
                            ++i;
                        }
                    }
                    File dcaFile = null;
                    if (!variantState.isDeployable()) {
                        LOCATION.debugT(thisMethod, "not trying to get DCA. DC is not deployable.");
                    } else {
                        LOCATION.debugT(thisMethod, "getting DCA (deployables)");
                        loaderResult = loader.downloadDCArchive(downloadFolder, buildVariant);
                        this.notifyDCASynced(buildVariant);
                        buildnumber = buildnumber > loaderResult.getBuildNumber() ? buildnumber : loaderResult.getBuildNumber();
                        dcaFile = loaderResult.getFile();
                    }
                    LOCATION.debugT(thisMethod, "deleting current DC data");
                    Util.deleteDirRecursively((File)new File(this.m_fileSystemLayout.getDefFolder()));
                    Util.deleteDirRecursively((File)new File(this.m_fileSystemLayout.getVariantRootFolder(buildVariant)));
                    LOCATION.debugT(thisMethod, "unpack DCDA (meta data)");
                    this.unpackComponentDefinitionArchive(new FileInputStream(dcdaFile));
                    Iterator iterPPNames = ppAFiles.keySet().iterator();
                    while (true) {
                        if (!iterPPNames.hasNext()) {
                            if (variantState.isDeployable()) {
                                LOCATION.debugT(thisMethod, "unpack DCA (deployables)");
                                stream = new FileInputStream(dcaFile);
                                try {
                                    this.unpackRuntimeArchive(buildVariant, stream);
                                    Object var19_26 = null;
                                    break;
                                }
                                catch (Throwable throwable) {
                                    Object var19_27 = null;
                                    ((InputStream)stream).close();
                                    throw throwable;
                                }
                            }
                            break block21;
                        }
                        String pp = (String)iterPPNames.next();
                        LOCATION.debugT(thisMethod, "unpack public part \"{0}\"", new Object[]{pp});
                        File ppFile = (File)ppAFiles.get(pp);
                        LOCATION.debugT(thisMethod, "unpacking PPA from {0}", new Object[]{ppFile.getAbsolutePath()});
                        this.unpackPublicPartArchive(pp, buildVariant, new FileInputStream(ppFile));
                    }
                    ((InputStream)stream).close();
                }
                Object var21_29 = null;
                if (downloadFolder == null) return buildnumber;
            }
            catch (UnknownDCException e) {
                this.notifyDCDASyncFailed(buildVariant, "Component does not exist on the build server.");
                String msg = "Archive download Failed for " + this.m_compartment + "~" + this.m_dcVendor + "~" + this.m_dcName + " in variant " + buildVariant + "." + " The component does not exist on the buildserver";
                throw new SyncException(msg, e, 404);
            }
            catch (ZipException e) {
                String msg = "Error unzipping archives for component " + this.m_compartment + "~" + this.m_dcVendor + "~" + this.m_dcName + " in variant " + buildVariant + "." + e.getMessage();
                throw new SyncException(msg, e, 28);
            }
            catch (IOException e) {
                String msg = "Could not get component " + this.m_compartment + "~" + this.m_dcVendor + "~" + this.m_dcName + " in variant " + buildVariant + " from build server. " + e.getMessage();
                throw new SyncException(msg, e, 28);
            }
        }
        catch (Throwable throwable) {
            Object var21_30 = null;
            if (downloadFolder == null) throw throwable;
            LOCATION.debugT(thisMethod, "deleting temp folder {0}", new Object[]{downloadFolder.getAbsolutePath()});
            Util.deleteDirRecursively((File)downloadFolder);
            if (!downloadFolder.exists()) throw throwable;
            LOCATION.infoT(thisMethod, "Failed to delete temp folder {0}", new Object[]{downloadFolder.getAbsolutePath()});
            throw throwable;
        }
        LOCATION.debugT(thisMethod, "deleting temp folder {0}", new Object[]{downloadFolder.getAbsolutePath()});
        Util.deleteDirRecursively((File)downloadFolder);
        if (!downloadFolder.exists()) return buildnumber;
        LOCATION.infoT(thisMethod, "Failed to delete temp folder {0}", new Object[]{downloadFolder.getAbsolutePath()});
        return buildnumber;
    }

    private void notifyUnsynchedAfterDTRDeletion() {
        String text = "Found DC definition was deleted on the server. Removing DC \"" + this + "\" from client ";
        this.m_configuration.sendDCMessage(this, null, DCMessageType.INFO, DCEventType.SOURCE_SYNCED, text, this.m_isActive);
    }

    private void notifyUsedDCSyncFailed(String text, boolean active) {
        this.m_configuration.sendDCMessage(this, null, DCMessageType.ERROR, DCEventType.SYNCED_USED, text, active);
    }

    private void notifyUsedDCSyncWarning(IDevelopmentComponentNode node, String buildVariant, String text) {
        this.m_configuration.sendDCMessage(node, buildVariant, DCMessageType.WARNING, DCEventType.SYNCED_USED, text);
    }

    private void notifyUsedDCSyncError(IDevelopmentComponentNode node, String buildVariant, String text) {
        this.m_configuration.sendDCMessage(node, buildVariant, DCMessageType.ERROR, DCEventType.SYNCED_USED, text);
    }

    private void notifyDCDASynced(String buildVariant) {
        String text = "synched DCD archive for " + this + " in variant \"" + buildVariant + "\"";
        this.m_configuration.sendDCMessage(this, buildVariant, DCMessageType.INFO, DCEventType.ARCHIVE_SYNCED, text, true);
    }

    private void notifyArchiveSyncSkipped(String buildVariant) {
        String text = "Already up to date. skipped syncing " + this + " in variant \"" + buildVariant + "\"";
        this.m_configuration.sendDCMessage(this, buildVariant, DCMessageType.INFO, DCEventType.ARCHIVE_SYNCED, text, true);
    }

    private void notifyDCDASyncFailed(String buildVariant, String errMsg) {
        String text = "ERROR: synching DCDA archive failed for " + this + " in variant \"" + buildVariant + "\" :" + errMsg;
        this.m_configuration.sendDCMessage(this, buildVariant, DCMessageType.ERROR, DCEventType.ARCHIVE_SYNCED, text, true);
    }

    private void notifyDCASynced(String buildVariant) {
        String text = "synched runtime archive for " + this + " in variant \"" + buildVariant + "\"";
        this.m_configuration.sendDCMessage(this, buildVariant, DCMessageType.INFO, DCEventType.ARCHIVE_SYNCED, text, true);
    }

    private void notifyDCASourceUnpacked(String buildVariant, File f) {
        String text = "extracted " + f.getAbsolutePath() + " for " + this + " in variant \"" + buildVariant + "\"";
        this.m_configuration.sendDCMessage(this, buildVariant, DCMessageType.INFO, DCEventType.ARCHIVE_SYNCED, text, true);
    }

    private void notifyDCASourceUnpackFailed(String buildVariant, String errMsg) {
        String text = "ERROR while trying to unpack sources from runtime archive of " + this + " in variant \"" + buildVariant + "\"" + nl + errMsg;
        this.m_configuration.sendDCMessage(this, buildVariant, DCMessageType.INFO, DCEventType.ARCHIVE_SYNCED, text, true);
    }

    private void notifyPublicPartSynced(String buildVariant, String ppName) {
        String text = "synched archive for public part \"" + ppName + "\" of \"" + this + " in variant \"" + buildVariant + "\"";
        this.m_configuration.sendDCMessage(this, buildVariant, DCMessageType.INFO, DCEventType.ARCHIVE_SYNCED, text, true);
    }

    private void notifyRecursiveBuildStart(String buildVariant) {
        String text = "starting recursive build for  " + this + " in variant \"" + buildVariant + "\"";
        this.m_configuration.sendDCMessage(this, buildVariant, DCMessageType.INFO, DCEventType.BUILD_STARTED, text, this.m_isActive);
    }

    private void notifyRecursiveBuildSuccess(String buildVariant) {
        String text = "successfully finished recursive build for  " + this + " in variant \"" + buildVariant + "\"";
        this.m_configuration.sendDCMessage(this, buildVariant, DCMessageType.INFO, DCEventType.BUILD_FINISHED, text, this.m_isActive);
    }

    private void notifyBuildStart(String buildVariant) {
        String text = "starting build for  " + this + " in variant \"" + buildVariant + "\"";
        this.m_configuration.sendDCMessage(this, buildVariant, DCMessageType.INFO, DCEventType.BUILD_STARTED, text, this.m_isActive);
    }

    private void notifyBuildFailed(String buildVariant, String errMsg) {
        String text = "Build failed for " + this + " in variant \"" + buildVariant + "\": " + errMsg;
        this.m_configuration.sendDCMessage(this, buildVariant, DCMessageType.ERROR, DCEventType.BUILD_FINISHED, text, this.m_isActive);
    }

    private void notifyRecursiveBuildFailed(String buildVariant) {
        String text = "Build failed for  " + this + " in variant \"" + buildVariant;
        this.m_configuration.sendDCMessage(this, buildVariant, DCMessageType.ERROR, DCEventType.BUILD_FINISHED, text, this.m_isActive);
    }

    private void notifyBuildWarning(String buildVariant, String buildMsg) {
        String text = "built with warnings " + this + " in variant \"" + buildVariant + "\" :" + buildMsg;
        this.m_configuration.sendDCMessage(this, buildVariant, DCMessageType.WARNING, DCEventType.BUILD_FINISHED, text, this.m_isActive);
    }

    private void notifyBuildWarning(String buildVariant, String buildMsg, long milliseconds) {
        String text = "built with warnings " + this + " in variant \"" + buildVariant + "\" (" + this.getDecimalFormatter().format((double)milliseconds / 1000.0) + " sec) :" + buildMsg;
        this.m_configuration.sendDCMessage(this, buildVariant, DCMessageType.WARNING, DCEventType.BUILD_FINISHED, text, this.m_isActive);
    }

    private void notifyBuildSuccess(String buildVariant, long milliseconds) {
        String text = "successfully built " + this + " in variant \"" + buildVariant + "\" (" + this.getDecimalFormatter().format((double)milliseconds / 1000.0) + " sec)";
        this.m_configuration.sendDCMessage(this, buildVariant, DCMessageType.INFO, DCEventType.BUILD_FINISHED, text, this.m_isActive);
    }

    private DecimalFormat getDecimalFormatter() {
        if (this.m_decimalFormatter == null) {
            this.m_decimalFormatter = new DecimalFormat("0.000");
            DecimalFormatSymbols s = this.m_decimalFormatter.getDecimalFormatSymbols();
            s.setDecimalSeparator('.');
            s.setGroupingSeparator(',');
            this.m_decimalFormatter.setDecimalFormatSymbols(s);
        }
        return this.m_decimalFormatter;
    }

    public void checkReferenceAllowed(PPReference ppRef) throws SyncException, IllegalDependencyException {
        this.assertValidInstance();
        this.assertValidReference(ppRef);
        boolean checkACLs = true;
        this.getDependencyChecker().checkReferenceAllowed(this, ppRef.getComponent(), ppRef.getName(), this.getUsedCompartmentName(ppRef), true, checkACLs);
    }

    public void checkReferenceAllowed(PPReference ppRef, boolean fullCheckRequired) throws SyncException, IllegalDependencyException {
        this.assertValidInstance();
        this.assertValidReference(ppRef);
        boolean checkACLs = true;
        this.getDependencyChecker().checkReferenceAllowed(this, ppRef.getComponent(), ppRef.getName(), this.getUsedCompartmentName(ppRef), fullCheckRequired, checkACLs);
    }

    public void checkReferenceAllowed(DCReference dcRef, boolean fullCheckRequired) throws SyncException, IllegalDependencyException {
        this.assertValidInstance();
        this.assertValidReference(dcRef);
        boolean checkACLs = true;
        this.getDependencyChecker().checkReferenceAllowed(this, dcRef, null, this.getUsedCompartmentName(dcRef), fullCheckRequired, checkACLs);
    }

    public void checkReferenceAllowed(DCReference dcRef) throws SyncException, IllegalDependencyException {
        this.checkReferenceAllowed(dcRef, true);
    }

    public void checkReferenceAllowed(String compartment, DCReference dcRef, boolean fullCheckRequired) throws SyncException, IllegalDependencyException, IllegalArgumentException {
        this.assertValidInstance();
        this.assertValidReference(dcRef);
        boolean checkACLs = true;
        this.getDependencyChecker().checkReferenceAllowed(this, dcRef, null, compartment, fullCheckRequired, checkACLs);
    }

    public void checkReferenceAllowed(String compartment, DCReference dcRef) throws SyncException, IllegalDependencyException, IllegalArgumentException {
        this.checkReferenceAllowed(compartment, dcRef, true);
    }

    public void checkReferenceAllowed(String compartment, PPReference ppRef, boolean fullCheckRequired) throws SyncException, IllegalDependencyException {
        this.assertValidInstance();
        this.assertValidReference(ppRef);
        boolean checkACLs = true;
        this.getDependencyChecker().checkReferenceAllowed(this, ppRef.getComponent(), ppRef.getName(), compartment, fullCheckRequired, checkACLs);
    }

    public void checkReferenceAllowed(String compartment, PPReference ppRef) throws SyncException, IllegalDependencyException {
        this.checkReferenceAllowed(compartment, ppRef, true);
    }

    public boolean isReferenceAllowed(DCReference dcRef) throws SyncException {
        return this.isReferenceAllowed(dcRef, this.getUsedCompartmentName(dcRef));
    }

    public boolean isReferenceAllowed(DCReference dcRef, String usedCompartment) throws SyncException {
        this.assertValidInstance();
        try {
            boolean checkACLs = true;
            this.getDependencyChecker().checkReferenceAllowed(this, dcRef, null, usedCompartment, true, checkACLs);
            return true;
        }
        catch (IllegalDependencyException e) {
            LOCATION.catching("isReferenceAllowed", (Throwable)((Object)e));
            return false;
        }
    }

    public boolean isReferenceAllowed(PPReference ppRef) throws SyncException {
        return this.isReferenceAllowed(ppRef, this.getUsedCompartmentName(ppRef));
    }

    public boolean isReferenceAllowed(PPReference ppRef, String usedCompartment) throws SyncException {
        boolean result;
        this.assertValidInstance();
        try {
            boolean checkACLs = true;
            this.getDependencyChecker().checkReferenceAllowed(this, ppRef.getComponent(), ppRef.getName(), usedCompartment, true, checkACLs);
            result = true;
        }
        catch (IllegalDependencyException e) {
            String thisMethod = "isReferenceAllowed";
            LOCATION.catching(thisMethod, (Throwable)((Object)e));
            result = false;
        }
        return result;
    }

    public void validateDependencies(boolean fullCheckRequired) throws SyncException, IllegalDependencyException {
        this.validateDependencies(fullCheckRequired, true);
    }

    public void checkBuildPluginReferenceAllowed(boolean fullCheckRequired) throws SyncException, IllegalDependencyException {
        this.assertValidInstance();
        this._checkBuildPluginReferenceAllowed(this.m_component.getBuildPlugin(), fullCheckRequired);
    }

    private void _checkBuildPluginReferenceAllowed(PPReference ppRef, boolean fullCheckRequired) throws SyncException, IllegalDependencyException {
        this.assertValidReference(ppRef);
        this.getDependencyChecker().checkBuildPluginAllowed(this, ppRef, this.getUsedCompartmentName(ppRef), fullCheckRequired);
    }

    public boolean isValidInstance() {
        return !this.m_invalid;
    }

    public void registerListener(IDCProxyListener listener) {
        this.assertValidInstance();
        this.m_listeners.add(listener);
    }

    public void unregisterListener(IDCProxyListener listener) {
        this.m_listeners.remove(listener);
    }

    private Map _listInvalidDependencies(boolean fullParentCheckRequired, boolean validateOnlyAtBuildTime, boolean checkACLsOnlyForBuildTime) throws SyncException {
        List dependencies;
        String thisMethod = "_listInvalidDependencies";
        this.assertValidInstance();
        HashMap<Dependency, IllegalDependencyException> invalidDeps = new HashMap<Dependency, IllegalDependencyException>();
        PPReference bpRef = this.m_component.getBuildPlugin();
        if (bpRef != null) {
            try {
                this.assertValidReference(bpRef);
                LOCATION.debugT(thisMethod, "Validating build plugin reference.");
                this._checkBuildPluginReferenceAllowed(bpRef, fullParentCheckRequired);
            }
            catch (IllegalDependencyException e) {
                LOCATION.debugT(thisMethod, "Found illegal build plugin reference: " + ((Throwable)((Object)e)).getMessage());
                Dependency dep = ComponentFactory.createDependency();
                dep.setPublicPartDependency(bpRef);
                invalidDeps.put(dep, e);
            }
        }
        if ((dependencies = this.m_component.getDependencies()) != null) {
            Iterator depIter = dependencies.iterator();
            while (depIter.hasNext()) {
                boolean checkACLs;
                Dependency dep = (Dependency)depIter.next();
                if (validateOnlyAtBuildTime && !dep.isAtBuildTime()) {
                    LOCATION.debugT(thisMethod, "Skipping dependency {0} because only at-build-time should be validated.", new Object[]{dep});
                    continue;
                }
                boolean bl = checkACLs = !checkACLsOnlyForBuildTime || dep.isAtBuildTime();
                if (LOCATION.beDebug()) {
                    LOCATION.debugT(thisMethod, "Validating dependency {0}. Checking ACLs: {1}", new Object[]{dep, new Boolean(checkACLs)});
                }
                try {
                    if (dep.getPublicPart() == null) {
                        DCReference dcRef = dep.getComponent();
                        this.assertValidReference(dcRef);
                        this.getDependencyChecker().checkReferenceAllowed(this, dcRef, null, this.getUsedCompartmentName(dcRef), fullParentCheckRequired, checkACLs);
                        continue;
                    }
                    PPReference ppRef = dep.getPublicPartDependency();
                    this.assertValidInstance();
                    this.assertValidReference(ppRef);
                    this.getDependencyChecker().checkReferenceAllowed(this, ppRef.getComponent(), ppRef.getName(), this.getUsedCompartmentName(ppRef), fullParentCheckRequired, checkACLs);
                }
                catch (IllegalDependencyException e) {
                    LOCATION.debugT(thisMethod, "Found invalid dependency: " + ((Throwable)((Object)e)).getMessage());
                    invalidDeps.put(dep, e);
                }
            }
        }
        return invalidDeps;
    }

    private Set listInvalidEntityRefs() throws SyncException {
        String thisMethod = "listInvalidEntityRefs";
        HashSet<IllegalEntityReferenceException> invalidRefExceptions = new HashSet<IllegalEntityReferenceException>();
        Map pps = this.m_component.getPublicParts();
        if (pps != null) {
            Iterator iter = pps.values().iterator();
            while (iter.hasNext()) {
                PublicPart referencingPP = (PublicPart)iter.next();
                List eRefs = referencingPP.getImportedEntities();
                if (eRefs == null) continue;
                Iterator iterEntity = eRefs.iterator();
                while (iterEntity.hasNext()) {
                    IllegalEntityReferenceException e;
                    PublicPart referencedPP;
                    EntityReference eRef = (EntityReference)iterEntity.next();
                    String nameOfReferencedPublicPart = eRef.getPublicPart();
                    DCReference dcFromEntityRef = eRef.getComponent();
                    if (!this.isPublicPartUsed(dcFromEntityRef, nameOfReferencedPublicPart)) {
                        IllegalEntityReferenceException e2 = IllegalEntityReferenceException.createForNotUsed(null, new DevelopmentComponentRef(this), referencingPP.getName(), dcFromEntityRef, nameOfReferencedPublicPart, referencingPP.getPurpose().toString());
                        LOCATION.debugT(thisMethod, "adding execption to result exceptionset: {0}", new Object[]{((Throwable)((Object)e2)).getMessage()});
                        invalidRefExceptions.add(e2);
                        continue;
                    }
                    IDCProxy referencedDC = this.m_configuration.getUsedDCProxy(this.getCompartmentName(), dcFromEntityRef);
                    Map ppsOfReferncedDC = referencedDC.getComponent().getPublicParts();
                    PublicPart publicPart = referencedPP = ppsOfReferncedDC == null ? null : (PublicPart)ppsOfReferncedDC.get(nameOfReferencedPublicPart);
                    if (referencedPP == null) {
                        e = IllegalEntityReferenceException.createForNotFound(null, new DevelopmentComponentRef(this), referencingPP.getName(), dcFromEntityRef, nameOfReferencedPublicPart, referencingPP.getPurpose().toString());
                        LOCATION.debugT(thisMethod, "adding execption to result exceptionset: {0}", new Object[]{((Throwable)((Object)e)).getMessage()});
                        invalidRefExceptions.add(e);
                        continue;
                    }
                    if (referencedPP.getPurpose().equals(referencingPP.getPurpose())) continue;
                    e = IllegalEntityReferenceException.createForDifferntPurposes(null, new DevelopmentComponentRef(this), referencingPP.getName(), dcFromEntityRef, nameOfReferencedPublicPart, referencingPP.getPurpose().toString(), referencedPP.getPurpose().toString());
                    LOCATION.debugT(thisMethod, "adding execption to result exceptionset: {0}", new Object[]{((Throwable)((Object)e)).getMessage()});
                    invalidRefExceptions.add(e);
                }
            }
        }
        return invalidRefExceptions;
    }

    private boolean isPublicPartUsed(DCReference dcRef, String ppName) {
        List deps = this.m_component.getDependencies();
        if (deps != null) {
            Iterator iterDeps = deps.iterator();
            while (iterDeps.hasNext()) {
                String usedPP;
                Dependency dep = (Dependency)iterDeps.next();
                if (dep == null || !dep.isAtBuildTime() || !dep.getComponent().equals((Object)dcRef) || (usedPP = dep.getPublicPart()) != null && !usedPP.equals(ppName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkParentHierachy(boolean ignoreParentMissing) throws DCValidationException, SyncException {
        String thisMethod = "checkParentHierachy()";
        HashSet<DCProxy> visitedDCs = new HashSet<DCProxy>();
        for (DCProxy nextDC = this; nextDC != null; nextDC = nextDC.getParentLocallyOrActive()) {
            visitedDCs.add(nextDC);
            try {
                continue;
            }
            catch (SyncException e) {
                LOCATION.traceThrowableT(300, thisMethod, "Could not get parent of {0}", new Object[]{nextDC}, (Throwable)((Object)e));
                if (ignoreParentMissing) {
                    return false;
                }
                throw e;
            }
        }
        return true;
    }

    public void assertNotDeleted(String errorMessage) throws SyncException {
        if (this._getDCActivityState() == DCActivityState.CHECKED_OUT_FOR_DELETE) {
            throw new SyncException(errorMessage + "(checked out for delete)", null, 34);
        }
        if (this.isDeletedInRepository()) {
            throw new SyncException(errorMessage + "(deleted on server)", null, 34);
        }
    }

    private boolean isDeletedInRepository() throws SyncException {
        if (this._getDCActivityState() == DCActivityState.CHECKED_OUT_FOR_CREATE) {
            return false;
        }
        return this._getVFSHandler().isItemDeletedOnServer(this.getDefinitionPath());
    }

    public boolean isRepresentingActiveState() {
        return this.m_isActive;
    }

    public void invalidate() {
        String thisMethod = "invalidate()";
        this.assertValidInstance();
        this.m_invalid = true;
        LOCATION.debugT(thisMethod, "Invalidating proxy {0}", new Object[]{this});
        Iterator iter = this.m_listeners.iterator();
        while (iter.hasNext()) {
            IDCProxyListener listener = (IDCProxyListener)iter.next();
            listener.onDCInvalid(this, this.m_configuration, this.m_compartmentName, this.m_dcVendor, this.m_dcName, !this.m_isActive);
        }
        this.m_listeners.clear();
    }

    void assertValidInstance() throws IllegalStateException {
        if (this.m_invalid) {
            String m = "Internal error: Attempt to use invalidated DC Proxy " + this;
            IllegalStateException e = new IllegalStateException(m);
            LOCATION.throwing("checkValid", (Throwable)e);
            throw e;
        }
    }

    private VFSHandler _getVFSHandler() {
        return this.m_configuration.getVFSHandler();
    }

    public boolean isDeleted() {
        return this.m_deleted;
    }

    public boolean isLocalRegardedAsInactive() {
        return this.m_compartment.hasInactiveSourceState();
    }

    public boolean isThisStateAvailableLocally() {
        return this.isThisStateAvailableLocally(this._getDCSyncMode());
    }

    private boolean isThisStateAvailableLocally(DCNodeSyncMode mode) {
        if (mode == DCNodeSyncMode.NOT_SYNCHED) {
            return false;
        }
        return mode == DCNodeSyncMode.LOCAL_ONLY || this.m_isActive && mode == DCNodeSyncMode.SYNCHED_AS_ACTIVE_SOURCE || this.m_isActive && mode == DCNodeSyncMode.SYNCHED_AS_ARCHIVE || !this.m_isActive && mode == DCNodeSyncMode.SYNCHED_AS_INACTIVE_SOURCE;
    }

    public boolean isAvailableLocallyAsSource() {
        DCNodeSyncMode mode = this.getDCSyncMode();
        DCNodeSyncState state = this.getDCSyncState();
        boolean localOnlySource = mode == DCNodeSyncMode.LOCAL_ONLY && state != DCNodeSyncState.INSTALLED;
        boolean synchedAsSource = mode == DCNodeSyncMode.SYNCHED_AS_ACTIVE_SOURCE || mode == DCNodeSyncMode.SYNCHED_AS_INACTIVE_SOURCE;
        return localOnlySource || synchedAsSource;
    }

    public IDevelopmentConfiguration getDevelopmentConfiguration() {
        return this.getConfiguration();
    }

    public DevelopmentConfiguration getConfiguration() {
        return this.m_configuration;
    }

    public Map listInvalidDependencies(boolean fullCheckRequired) throws SyncException {
        return this.listInvalidDependencies(fullCheckRequired, true);
    }

    public IBuildResult make(String buildVariant, String target, ILocalBuildProperties localBuildProperties, DependencyValidationOption dependencyValidationOption) throws BuildException {
        return this.make(buildVariant, target, localBuildProperties, dependencyValidationOption, false);
    }

    public IBuildResult make(String buildVariant, String target, ILocalBuildProperties localBuildProperties) throws BuildException {
        return this.make(buildVariant, target, localBuildProperties, DependencyValidationOption.ALL, false);
    }

    public IDCProxy[] listDCProxiesForRecursiveMake() throws BuildException {
        this.assertValidInstance();
        List list = this._listDCsForRecursiveMake("", false);
        IDCProxy[] array = new IDCProxy[list.size()];
        Iterator it = list.iterator();
        int i = 0;
        while (it.hasNext()) {
            DCProxy dc = (DCProxy)it.next();
            array[i] = dc;
            ++i;
        }
        return array;
    }

    public IDCProxy[] listDCProxiesOfUsedDCs(boolean ignoreErrors) throws SyncException {
        return this.m_dependenciesManager.listDCProxiesOfUsedDCs(this, ignoreErrors);
    }

    public IDevelopmentComponentRef[] listLocalAtBuildTimeUsersRecursively(boolean ignoreErrors) throws DevConfigException, SyncException {
        return this.m_dependenciesManager.listBuildTimeUsersRecursively(this, ignoreErrors);
    }

    public Set markUsingDCsDirty(String ppName, boolean doSave, boolean doNotify) throws DevConfigException {
        DCUsageFilter filter = new DCUsageFilter(true, true, true, true, true);
        return this.markUsingDCsDirty(ppName, filter, doSave, doNotify);
    }

    public Set markUsingDCsDirty(boolean doSave, boolean doNotify) throws DevConfigException {
        DCUsageFilter filter = new DCUsageFilter(true, true, true, true, true);
        return this.markUsingDCsDirty(filter, doSave, doNotify);
    }

    private Set markAtBuildTimeUsingDCsDirty(boolean doSave, boolean doNotify) throws DevConfigException {
        DCUsageFilter filter = new DCUsageFilter(false, true, false, false, false);
        return this.markUsingDCsDirty(filter, doSave, doNotify);
    }

    private Set markUsingDCsDirty(DCUsageFilter usageFilter, boolean doSave, boolean doNotify) throws DevConfigException {
        return this.markUsingDCsDirty(null, usageFilter, doSave, doNotify);
    }

    private Set markUsingDCsDirty(String ppName, DCUsageFilter usageFilter, boolean doSave, boolean doNotify) throws DevConfigException {
        IDevelopmentComponentNode[] users = this.m_dependenciesManager.listLocalUsers(this, ppName, usageFilter, true);
        Set result = users != null && users.length > 0 ? this.m_configuration.markDCsDirty(users, doSave, doNotify) : new HashSet();
        return result;
    }

    public IDCProxy[] getRecursivelyAllDirtyUsedDCs() throws BuildException {
        this.assertValidInstance();
        List list = this._listDCsForRecursiveMake("", false);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            DCProxy dc = (DCProxy)it.next();
            if (dc._isDirty()) continue;
            it.remove();
        }
        IDCProxy[] array = new IDCProxy[list.size()];
        return list.toArray(array);
    }

    public boolean isDirty() {
        this.assertValidInstance();
        return this._isDirty();
    }

    private void assertValidReference(PPReference ppRef) throws IllegalDependencyException {
        if (ppRef.getComponent() == null) {
            throw new IllegalDependencyException(IllegalDependencyException.DependencyRule.RULE_NO_DCREF, null, new DevelopmentComponentRef(this), ppRef.getComponent());
        }
        this.assertValidReference(ppRef.getComponent());
        if (ppRef.getName() == null || ppRef.getName().length() == 0) {
            throw new IllegalDependencyException(IllegalDependencyException.DependencyRule.RULE_NO_PP_NAME, null, new DevelopmentComponentRef(this), ppRef.getComponent());
        }
    }

    private void assertValidReference(DCReference dcRef) throws IllegalDependencyException {
        if (dcRef.getName() == null || dcRef.getName().length() == 0) {
            throw new IllegalDependencyException(IllegalDependencyException.DependencyRule.RULE_NO_DC_NAME, null, new DevelopmentComponentRef(this), dcRef);
        }
        if (dcRef.getVendor() == null || dcRef.getVendor().length() == 0) {
            throw new IllegalDependencyException(IllegalDependencyException.DependencyRule.RULE_NO_DC_VENDOR, null, new DevelopmentComponentRef(this), dcRef);
        }
    }

    public void cleanBuildResults(String buildVariant) {
        this._cleanBuildResults(buildVariant);
        try {
            this.markAtBuildTimeUsingDCsDirty(true, true);
        }
        catch (DevConfigException e) {
            String m = "Failed to mark using DCs as dirty after cleaning build results of \"" + this + "\"" + ((Throwable)((Object)e)).getMessage();
            this.m_configuration.sendDCMessage(this, "", DCMessageType.WARNING, DCEventType.ARCHIVE_SYNCED, m, true);
            LOCATION.traceThrowableT(300, "markUsingDCsDirty", "Caught DevConfigException. Send message to listener and ignore the exception.", (Throwable)((Object)e));
        }
    }

    public boolean isAvailableLocallyAsArchives() {
        return this.isLocalOnlyArchive() || this.isSynchedAsArchives();
    }

    public IDCProxyResult listUsedDCs(DCUsageFilter filter, boolean searchRemoteInactive) {
        ArrayList exceptions = new ArrayList();
        Set usedDCs = this.m_dependenciesManager.listDirectlyUsedDCProxies(this, filter, searchRemoteInactive, exceptions);
        return new DCProxyResult(usedDCs, exceptions);
    }

    public IDCProxyResult listUsedInfrastructureDCs() {
        ArrayList exceptions = new ArrayList();
        Set usedDCs = this.m_dependenciesManager.listInfrastructureDependenciesProxies(this, exceptions);
        return new DCProxyResult(usedDCs, exceptions);
    }

    public IDCProxyResult listUsedDCs(DCUsageFilter filter) {
        return this.listUsedDCs(filter, false);
    }

    public IDCProxyResult listDCsForSynchAsArchives() {
        ArrayList exceptions = new ArrayList();
        Set usedDCs = this.m_dependenciesManager.listDCsForSynchAsArchives(this, exceptions);
        return new DCProxyResult(usedDCs, exceptions);
    }

    public IDevelopmentComponentNode toNode() {
        return this._toNode();
    }

    public DevelopmentComponentNode _toNode() {
        return new DevelopmentComponentNode(this);
    }

    DevelopmentConfiguration _getDevelopmentConfiguration() {
        return this.m_configuration;
    }

    public int hashCode() {
        return this.m_key.hashCode();
    }

    public String getCompartmentName() {
        return this.m_compartmentName;
    }

    private DCDependencyChecker getDependencyChecker() {
        return this.m_configuration.getDependencyChecker();
    }

    public IDCNodeResult listLocalAtBuildTimeUsers() {
        return this.m_dependenciesManager.listLocalAtBuildTimeUsers(this);
    }

    public boolean isBroken() {
        return this.m_configuration.isDCBroken(this.m_compartment.getName(), this.m_dcVendor, this.m_dcName);
    }

    public Map listInvalidDependencies(boolean fullCheckRequired, boolean checkACLsOnlyForBuildTimeDependencies) throws SyncException {
        return this._listInvalidDependencies(fullCheckRequired, false, checkACLsOnlyForBuildTimeDependencies);
    }

    public void validateDependencies(boolean fullCheckRequired, boolean checkACLsOnlyForBuildTimeDependencies) throws SyncException, IllegalDependencyException {
        this.assertValidInstance();
        this._checkBuildPluginReferenceAllowed(this.m_component.getBuildPlugin(), fullCheckRequired);
        List dependencies = this.m_component.getDependencies();
        if (dependencies != null) {
            Iterator depIter = dependencies.iterator();
            while (depIter.hasNext()) {
                boolean checkACL;
                Dependency dep = (Dependency)depIter.next();
                boolean bl = checkACL = !checkACLsOnlyForBuildTimeDependencies || dep.isAtBuildTime();
                if (dep.getPublicPart() == null) {
                    DCReference dcRef = dep.getComponent();
                    this.assertValidReference(dcRef);
                    this.getDependencyChecker().checkReferenceAllowed(this, dcRef, null, this.getUsedCompartmentName(dcRef), fullCheckRequired, checkACL);
                    continue;
                }
                PPReference ppRef = dep.getPublicPartDependency();
                this.assertValidReference(ppRef);
                this.getDependencyChecker().checkReferenceAllowed(this, ppRef.getComponent(), ppRef.getName(), this.getUsedCompartmentName(ppRef), fullCheckRequired, checkACL);
            }
        }
    }

    static {
        String s = System.getProperty("devconf.UnpackSources", "false");
        if (s != null) {
            _isUnpackSourcesFromDeployablesEnabled = s.trim().equalsIgnoreCase("false");
        }
        nl = System.getProperty("line.separator");
    }
}

