/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.complib.provider.DCOutputProvider;
import com.sap.tc.complib.provider.PPOutputProvider;
import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.impl.FileSystemLayout;
import com.sap.tc.devconf.impl.PPFileOutputProvider;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class DCFileOutputProvider
implements DCOutputProvider {
    private static Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$impl$DCFileOutputProvider == null ? (class$com$sap$tc$devconf$impl$DCFileOutputProvider = DCFileOutputProvider.class$("com.sap.tc.devconf.impl.DCFileOutputProvider")) : class$com$sap$tc$devconf$impl$DCFileOutputProvider));
    private DevelopmentConfiguration m_devConf;
    private String m_compartmentID;
    private String m_dcVendor;
    private String m_dcName;
    private FileSystemLayout m_fsLayout;
    static /* synthetic */ Class class$com$sap$tc$devconf$impl$DCFileOutputProvider;

    private DCFileOutputProvider() {
    }

    public DCFileOutputProvider(DevelopmentConfiguration devConf, String compartmentID, String dcVendor, String dcName) {
        this.m_devConf = devConf;
        this.m_compartmentID = compartmentID;
        this.m_dcVendor = dcVendor;
        this.m_dcName = dcName;
        this.m_fsLayout = new FileSystemLayout(devConf, compartmentID, dcVendor, dcName);
    }

    public void releaseStream(OutputStream writer) {
        try {
            writer.close();
        }
        catch (IOException e) {
            LOCATION.catching("releaseStream", (Throwable)e);
        }
    }

    public OutputStream getStreamForDC() throws ProviderException {
        File file = new File(this.m_fsLayout.getComponentDefinitionFile());
        return this.getStream(file);
    }

    public PPOutputProvider getPPOutputProvider(String publicPartName) {
        return new PPFileOutputProvider(this.m_devConf, publicPartName, this.m_fsLayout);
    }

    private OutputStream getStream(File file) throws ProviderException {
        FileOutputStream writer;
        try {
            file.createNewFile();
            writer = new FileOutputStream(file);
        }
        catch (FileNotFoundException ex) {
            String m = "Could not open output stream for writing. File not found: " + file.getAbsolutePath() + " (" + ex.getMessage() + ").";
            throw new ProviderException(m, (Throwable)ex);
        }
        catch (IOException ex) {
            String m = "Could not open file for writing: " + file.getAbsolutePath() + " (" + ex.getMessage() + ").";
            throw new ProviderException(m, (Throwable)ex);
        }
        return writer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

