/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.provider.DCInputProvider;
import com.sap.tc.complib.provider.PPInputProvider;
import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.impl.FileSystemLayout;
import com.sap.tc.devconf.impl.PPFileInputProvider;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;

class DCFileInputProvider
implements DCInputProvider {
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$impl$DCFileInputProvider == null ? (class$com$sap$tc$devconf$impl$DCFileInputProvider = DCFileInputProvider.class$("com.sap.tc.devconf.impl.DCFileInputProvider")) : class$com$sap$tc$devconf$impl$DCFileInputProvider));
    private DevelopmentConfiguration m_devConf;
    private String m_compartmentID;
    private String m_dcVendor;
    private String m_dcName;
    private FileSystemLayout m_fsLayout;
    private boolean m_loadPublicParts = true;
    private boolean m_loadPPEntities = true;
    static /* synthetic */ Class class$com$sap$tc$devconf$impl$DCFileInputProvider;

    private DCFileInputProvider() {
    }

    public DCFileInputProvider(DevelopmentConfiguration devConf, String compartmentID, String dcVendor, String dcName) {
        this.m_devConf = devConf;
        this.m_compartmentID = compartmentID;
        this.m_dcVendor = dcVendor;
        this.m_dcName = dcName;
        this.m_fsLayout = new FileSystemLayout(devConf, compartmentID, dcVendor, dcName);
    }

    public void releaseStream(InputStream reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                LOCATION.catching("releaseStream", (Throwable)e);
            }
        }
    }

    public String[] getPublicParts(DevelopmentComponent component) {
        return null;
    }

    public String[] getPublicParts() throws ProviderException {
        if (this.m_loadPublicParts) {
            String path = this.m_fsLayout.getDefFolder();
            File defdir = new File(path);
            if (defdir.exists()) {
                String[] files = defdir.list(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.endsWith(".pp");
                    }
                });
                int length = files == null ? 0 : files.length;
                String[] res = new String[length];
                int i = 0;
                while (i < length) {
                    int n = files[i].lastIndexOf(".");
                    res[i] = files[i].substring(0, n);
                    ++i;
                }
                return res;
            }
            return new String[0];
        }
        return new String[0];
    }

    public InputStream getStreamForDC() throws ProviderException {
        String thisMethod = "getStreamForDC()";
        File file = new File(this.m_fsLayout.getComponentDefinitionFile());
        if (file.exists()) {
            return this.getStream(file);
        }
        String m = "Cannot read component definition. File does not exist: " + file.getAbsolutePath();
        throw new ProviderException(m);
    }

    public PPInputProvider getPPInputProvider(String publicPartName) {
        return new PPFileInputProvider(this.m_devConf, publicPartName, this.m_fsLayout);
    }

    public void hidePublicParts(boolean doHide) {
        this.m_loadPublicParts = !doHide;
    }

    public void hidePPEntities(boolean doHide) {
        this.m_loadPPEntities = !doHide;
    }

    private InputStream getStream(File file) throws ProviderException {
        FileInputStream reader = null;
        if (file.exists()) {
            try {
                reader = new FileInputStream(file);
            }
            catch (FileNotFoundException ex) {
                String m = "Error reading component definition file: " + file.getAbsolutePath() + " : " + ex.getMessage();
                throw new ProviderException(m, (Throwable)ex);
            }
        }
        return reader;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

