/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.cbs.util.Util;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.ComponentReference;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.PPReference;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.complib.SCReference;
import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.devconf.DCEventType;
import com.sap.tc.devconf.DCMessageType;
import com.sap.tc.devconf.DCValidationException;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.IllegalDependencyException;
import com.sap.tc.devconf.NoRemoteFolderItemException;
import com.sap.tc.devconf.SyncException;
import com.sap.tc.devconf.impl.DCProxy;
import com.sap.tc.devconf.impl.DevelopmentComponentRef;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.logging.Location;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DCDependencyChecker {
    public static final String NAME_WILDCARD = "*";
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$impl$DCDependencyChecker == null ? (class$com$sap$tc$devconf$impl$DCDependencyChecker = DCDependencyChecker.class$("com.sap.tc.devconf.impl.DCDependencyChecker")) : class$com$sap$tc$devconf$impl$DCDependencyChecker));
    private static final String NL = System.getProperty("line.separator");
    static /* synthetic */ Class class$com$sap$tc$devconf$impl$DCDependencyChecker;

    void checkReferenceAllowed(DCProxy usingDC, DCReference usedDCref, String ppName, String usedCompartment, boolean fullCheckRequired, boolean checkACLs) throws SyncException, IllegalDependencyException {
        this._checkReferenceAllowed(usingDC, usedDCref, ppName, usedCompartment, fullCheckRequired, false, checkACLs);
    }

    private void _checkReferenceAllowed(DCProxy usingDC, DCReference usedDCref, String ppName, String usedCompartment, boolean fullCheckRequired, boolean isBuildPluginReference, boolean checkACLs) throws SyncException, IllegalDependencyException {
        ArrayListResult ancestorLine;
        try {
            ancestorLine = this.getAncestorLine(usingDC, false);
        }
        catch (DCValidationException e) {
            throw new SyncException(((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e), 33);
        }
        if (!ancestorLine.exceptions.isEmpty()) {
            Exception e = (Exception)ancestorLine.exceptions.iterator().next();
            if (fullCheckRequired) {
                if (e instanceof SyncException) {
                    throw (SyncException)((Object)e);
                }
                throw new SyncException("could not check if reference is allowed: " + e.getMessage(), e, 14);
            }
            this.notifyRefCheckOmittedAncestor(usingDC, usedDCref.toString(), e.getMessage());
        }
        this._checkReferenceAllowed(usingDC, usedDCref, ppName, usedCompartment, ancestorLine.list, isBuildPluginReference, checkACLs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void _checkReferenceAllowed(DCProxy usingDC, DCReference usedDCref, String ppName, String usedCompartment, ArrayList ancestorLine, boolean isBuildPluginReference, boolean checkACLs) throws SyncException, IllegalDependencyException {
        DCProxy usedProxy;
        String thisMethod = "checkReferenceAllowed(PPReference,String)";
        if (usedDCref == null) {
            String m = "internal Error: Cannot check if reference is allowed: Illegal public part reference ( DCReference is null)";
            SyncException e = new SyncException(m, null, 11);
            LOCATION.throwing(thisMethod, (Throwable)((Object)e));
            throw e;
        }
        if (usedCompartment == null) {
            usedCompartment = usingDC.getUsedCompartmentName(usedDCref);
        }
        try {
            usedProxy = usingDC.getConfiguration()._getDCProxyLocalOrActive(usedCompartment, usedDCref.getVendor(), usedDCref.getName());
        }
        catch (DevConfigException e) {
            Throwable innerInnerException;
            Throwable innerException = e.getCause();
            if (innerException instanceof ProviderException && (innerInnerException = ((ProviderException)innerException).getCause()) instanceof NoRemoteFolderItemException) {
                String msg = "\"" + usedDCref.getVendor() + "/" + usedDCref.getName() + "\" is not synched and no active version exists on the server.";
                throw new SyncException(msg, (Throwable)((Object)e), 11, usedCompartment, usedDCref.getVendor(), usedDCref.getName());
            }
            String msg = "Cannot validate dependency: " + ((Throwable)((Object)e)).getMessage();
            throw new SyncException(msg, (Throwable)((Object)e), 11, usedCompartment, usedDCref.getVendor(), usedDCref.getName());
        }
        if (usingDC.equals(usedProxy)) {
            IllegalDependencyException e = new IllegalDependencyException(IllegalDependencyException.DependencyRule.RULE_SELF, null, new DevelopmentComponentRef(usingDC), usedDCref, ppName);
            this.notifyRefCheckFailed(usingDC, ((Throwable)((Object)e)).getMessage());
            LOCATION.throwing(thisMethod, (Throwable)((Object)e));
            throw e;
        }
        if (ancestorLine.contains(usedProxy)) {
            IllegalDependencyException e = new IllegalDependencyException(IllegalDependencyException.DependencyRule.RULE_ANCESTOR, null, new DevelopmentComponentRef(usingDC), usedDCref, ppName);
            LOCATION.throwing(thisMethod, (Throwable)((Object)e));
            this.notifyRefCheckFailed(usingDC, ((Throwable)((Object)e)).getMessage());
            throw e;
        }
        DCReference usedParentRef = usedProxy.getComponent().getEnclosingComponent();
        if (usedParentRef == null) {
            this.checkReferenceAllowedByDC(usingDC, ppName, usedProxy, usedDCref, ancestorLine, isBuildPluginReference, checkACLs);
            return;
        }
        if (usedParentRef.getVendor().equals(usingDC.getVendor()) && usedParentRef.getName().equals(usingDC.getName()) && usedCompartment.equals(usingDC.getCompartmentName())) {
            this.checkReferenceAllowedByDC(usingDC, ppName, usedProxy, usedDCref, ancestorLine, isBuildPluginReference, checkACLs);
            return;
        }
        if (this.isContained(ancestorLine, usedCompartment, usedParentRef.getVendor(), usedParentRef.getName())) {
            this.checkReferenceAllowedByDC(usingDC, ppName, usedProxy, usedDCref, ancestorLine, isBuildPluginReference, checkACLs);
            return;
        }
        DCReference parentRef = usingDC.getComponent().getEnclosingComponent();
        if (ancestorLine.size() == 1 && parentRef != null && usedCompartment.equals(usingDC.getCompartmentName()) && usedParentRef.getVendor().equals(parentRef.getVendor()) && usedParentRef.getName().equals(parentRef.getName())) {
            LOCATION.debugT(thisMethod, "Found that {0} and {1} are children of same parent {2}", new Object[]{usingDC, usedProxy, parentRef});
            return;
        }
        LOCATION.debugT(thisMethod, "Found that {0} and {1} are not siblings", new Object[]{usingDC, usedProxy});
        IllegalDependencyException e = new IllegalDependencyException(IllegalDependencyException.DependencyRule.RULE_TO_INNER_DC, null, new DevelopmentComponentRef(usingDC), usedDCref, ppName);
        this.notifyRefCheckFailed(usingDC, ((Throwable)((Object)e)).getMessage());
        LOCATION.throwing(thisMethod, (Throwable)((Object)e));
        throw e;
    }

    private void checkReferenceAllowedByDC(DCProxy usingDC, String ppName, DCProxy usedProxy, DCReference usedDCref, ArrayList ancestorLine, boolean isBuildPluginReference, boolean checkACLs) throws SyncException, IllegalDependencyException {
        String thisMethod = "checkReferenceAllowedByDC";
        String usedCompartment = usedProxy.getCompartmentName();
        if (!this.checkSCUsage(usingDC, usedCompartment)) {
            IllegalDependencyException e = new IllegalDependencyException(IllegalDependencyException.DependencyRule.RULE_COMPARTMENT, null, new DevelopmentComponentRef(usingDC), usedDCref, ppName);
            this.notifyRefCheckFailed(usingDC, ((Throwable)((Object)e)).getMessage());
            throw e;
        }
        if (!this.isComponentTypeCompatible(usingDC, usedProxy, isBuildPluginReference)) {
            IllegalDependencyException e = new IllegalDependencyException(IllegalDependencyException.DependencyRule.RULE_INFRASTRUCTURE, null, new DevelopmentComponentRef(usingDC), usedDCref, ppName);
            this.notifyRefCheckFailed(usingDC, ((Throwable)((Object)e)).getMessage());
            throw e;
        }
        if (checkACLs) {
            if (ppName != null) {
                this.checkGrantsForUsedPublicPart(ancestorLine, usedProxy, ppName);
            } else {
                this.checkGrantsForUsedDC(ancestorLine, usedProxy);
            }
        } else {
            LOCATION.debugT(thisMethod, "Skipping ACL check for usage from {0} to {1}. Not requested by caller.", new Object[]{usingDC, usedProxy});
        }
    }

    private boolean isContained(ArrayList proxyList, String compartment, String vendor, String name) {
        boolean contained = false;
        Iterator it = ((AbstractList)proxyList).iterator();
        while (it.hasNext() && !contained) {
            DCProxy p = (DCProxy)it.next();
            boolean bl = contained = p.getCompartment().getName().equals(compartment) && p.getVendor().equals(vendor) && p.getName().equals(name);
        }
        return contained;
    }

    void checkGrantsForUsedDC(ArrayList usingDCandAncestors, DCProxy usedProxy) throws SyncException, IllegalDependencyException {
        String thisMethod = "checkGrantsForUsedDC";
        if (usingDCandAncestors.isEmpty()) {
            IllegalStateException ex = new IllegalStateException("Internal Error in check if refernce is allowed. CheckGrantsForUsedPublicPart() called with empty list!");
            LOCATION.throwing(thisMethod, (Throwable)ex);
            throw ex;
        }
        DevelopmentComponent usedDC = usedProxy.getComponent();
        boolean dcHasGrants = usedDC.getGrants() != null && !usedDC.getGrants().isEmpty();
        Map pps = usedProxy.getComponent().getPublicParts();
        HashSet<String> ppsThatNeedGrant = new HashSet<String>();
        if (pps != null) {
            Iterator ppNamesIter = pps.keySet().iterator();
            while (ppNamesIter.hasNext()) {
                String ppName = (String)ppNamesIter.next();
                PublicPart pp = (PublicPart)pps.get(ppName);
                List grants = pp.getGrants();
                if (grants == null || grants.isEmpty()) continue;
                ppsThatNeedGrant.add(ppName);
            }
        }
        if (!ppsThatNeedGrant.isEmpty() || dcHasGrants) {
            boolean allGrantsFound = false;
            boolean dcAllowed = false;
            int i = usingDCandAncestors.size() - 1;
            while (i > -1 && !allGrantsFound) {
                DCProxy usingProxy = (DCProxy)usingDCandAncestors.get(i);
                if (!dcAllowed) {
                    dcAllowed = this.checkGrants(usingProxy, usedDC.getGrants());
                }
                Iterator ppThatNeedGrantIterator = ppsThatNeedGrant.iterator();
                while (ppThatNeedGrantIterator.hasNext()) {
                    String ppName = (String)ppThatNeedGrantIterator.next();
                    PublicPart usedPP = (PublicPart)pps.get(ppName);
                    if (!this.checkGrants(usingProxy, usedPP.getGrants())) continue;
                    ppThatNeedGrantIterator.remove();
                }
                allGrantsFound = dcAllowed && ppsThatNeedGrant.isEmpty();
                --i;
            }
            if (!allGrantsFound) {
                DCProxy usingDC = (DCProxy)usingDCandAncestors.get(0);
                IllegalDependencyException e = new IllegalDependencyException(IllegalDependencyException.DependencyRule.RULE_ACCESS_LIST, null, new DevelopmentComponentRef(usingDC), new DCReference(usedProxy.getName(), usedProxy.getVendor()), null);
                this.notifyRefCheckFailed(usingDC, ((Throwable)((Object)e)).getMessage());
                throw e;
            }
        }
    }

    void checkGrantsForUsedPublicPart(ArrayList usingDCandAncestors, DCProxy usedProxy, String ppName) throws SyncException, IllegalDependencyException {
        String thisMethod = "checkGrantsForUsedPublicPart";
        if (usingDCandAncestors.isEmpty()) {
            IllegalStateException ex = new IllegalStateException("Internal Error in check if refernce is allowed. CheckGrantsForUsedPublicPart() called with empty list!");
            LOCATION.throwing(thisMethod, (Throwable)ex);
            throw ex;
        }
        Map pps = usedProxy.getComponent().getPublicParts();
        String usedDCName = usedProxy.getComponent().getName();
        String usedDCVendor = usedProxy.getComponent().getVendor();
        if (pps == null) {
            String msg = "Public part \"" + ppName + "\" not found. Component \"" + usedProxy + "\"does not seem to have any public parts.";
            SyncException e = new SyncException(msg, null, 12, usedProxy.getCompartmentName(), usedDCVendor, usedDCName, ppName);
            LOCATION.errorT(thisMethod, "Throw SyncException: " + Util.printStackTraceToString((Throwable)((Object)e)));
            throw e;
        }
        if (pps.get(ppName) == null) {
            String msg = "Public part not found. Component " + usedProxy + " does not seem to have a public part named " + ppName;
            SyncException e = new SyncException(msg, null, 12, usedProxy.getCompartmentName(), usedDCVendor, usedDCName, ppName);
            LOCATION.errorT(thisMethod, "Throw SyncException: " + Util.printStackTraceToString((Throwable)((Object)e)));
            throw e;
        }
        PublicPart usedPP = (PublicPart)pps.get(ppName);
        DevelopmentComponent usedDC = usedProxy.getComponent();
        boolean ppHasGrants = usedPP.getGrants() != null && !usedPP.getGrants().isEmpty();
        boolean dcHasGrants = usedDC.getGrants() != null && !usedDC.getGrants().isEmpty();
        boolean allowed = false;
        if (ppHasGrants || dcHasGrants) {
            int i = usingDCandAncestors.size() - 1;
            while (i > -1 && !allowed) {
                DCProxy usingProxy = (DCProxy)usingDCandAncestors.get(i);
                LOCATION.debugT(thisMethod, "Checking ACL for usage of public part {0} of DC {1} by DC {2}", new Object[]{usedPP.getName(), usedProxy, usingProxy});
                boolean ppAllowed = this.checkGrants(usingProxy, usedPP.getGrants());
                boolean dcAllowed = this.checkGrants(usingProxy, usedDC.getGrants());
                allowed = ppAllowed && dcAllowed;
                --i;
            }
            if (!allowed) {
                DCProxy usingDC = (DCProxy)usingDCandAncestors.get(0);
                IllegalDependencyException e = new IllegalDependencyException(IllegalDependencyException.DependencyRule.RULE_ACCESS_LIST, null, new DevelopmentComponentRef(usingDC), new DCReference(usedDCName, usedDCVendor), ppName);
                LOCATION.throwing(thisMethod, (Throwable)((Object)e));
                this.notifyRefCheckFailed(usingDC, ((Throwable)((Object)e)).getMessage());
                throw e;
            }
            LOCATION.debugT(thisMethod, "Checking ACL for usage of public part {0} of DC {1} sucessful", new Object[]{usedPP.getName(), usedProxy});
        }
    }

    private boolean checkGrants(DCProxy usingProxy, List grants) {
        if (grants == null) {
            return true;
        }
        if (grants.size() == 0) {
            return true;
        }
        int i = 0;
        while (i < grants.size()) {
            ComponentReference ref = (ComponentReference)grants.get(i);
            String name = ref.getName();
            String vendor = ref.getVendor();
            boolean isWildcardName = NAME_WILDCARD.equals(name);
            if (ref instanceof DCReference ? (isWildcardName || name.equals(usingProxy.getName())) && vendor.equals(usingProxy.getVendor()) : ref instanceof SCReference && (isWildcardName || name.equals(usingProxy.getCompartment().getScName())) && vendor.equals(usingProxy.getCompartment().getScVendor())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean checkSCUsage(DCProxy usingProxy, String usedCompartment) {
        if (!usedCompartment.equals(usingProxy.getCompartmentName())) {
            Set usedCompartments = usingProxy.getCompartment().getUsedCompartments();
            if (usedCompartments != null && !usedCompartments.isEmpty()) {
                return usedCompartments.contains(usedCompartment);
            }
            return false;
        }
        return true;
    }

    private boolean isComponentTypeCompatible(DCProxy usingProxy, DCProxy usedProxy, boolean isBuildPluginReference) {
        String thisMethod = "isComponentTypeCompatible";
        if (!(usingProxy.isInfrastructureComponent() || !usedProxy.isInfrastructureComponent() || isBuildPluginReference && usedProxy.isBuildPlugin())) {
            LOCATION.debugT(thisMethod, "DC \"{0}\" is not an infrastructure DC but uses infrastructure DC \"{1}\"", new Object[]{usingProxy, usedProxy});
            return false;
        }
        return true;
    }

    void notifyRefCheckOmittedNoParent(DCProxy usingDC, String usedDC, String parent) {
        String text = "Ommitted check if refernce to \"{1}\" is allowed from \"{0}\" by parent references. Data for parent \"{2}\" not available.";
        usingDC.getConfiguration().sendDCMessage(usingDC, "", DCMessageType.WARNING, DCEventType.ARCHIVE_SYNCED, MessageFormat.format(text, usedDC, usingDC.getName(), parent), usingDC.isRepresentingActiveState());
    }

    void notifyRefCheckFailed(DCProxy usingDC, String text, String buildVariant) {
        usingDC.getConfiguration().sendDCMessage(usingDC, buildVariant, DCMessageType.WARNING, DCEventType.CHECK_REFERENCE, text, usingDC.isRepresentingActiveState());
    }

    void notifyRefCheckFailed(DCProxy usingDC, String text) {
        this.notifyRefCheckFailed(usingDC, text, "");
    }

    void notifyRefCheckOmittedAncestor(DCProxy usingDC, String usedDC, String problemText) {
        String text = "Ommitted check for reference from \"{0}\" to \"{1}\" based on data of ancestors. Reason: {2}";
        usingDC.getConfiguration().sendDCMessage(usingDC, "", DCMessageType.WARNING, DCEventType.CHECK_REFERENCE, MessageFormat.format(text, usingDC.toString(), usedDC, problemText), usingDC.isRepresentingActiveState());
    }

    ArrayListResult getAncestorLine(DCProxy startDC, boolean searchRemoteInactive) throws DCValidationException {
        String thisMethod = "getAncestors";
        ArrayListResult result = new ArrayListResult();
        result.list.add(startDC);
        Compartment compartment = startDC.getCompartment();
        String compartmentName = compartment.getName();
        boolean hasInactive = compartment.hasInactiveSourceState();
        DevelopmentConfiguration config = startDC.getConfiguration();
        DCReference parentRef = startDC.getComponent().getEnclosingComponent();
        while (parentRef != null) {
            DCProxy parentProxy;
            block10: {
                DevConfigException outerException2;
                block9: {
                    try {
                        parentProxy = config._getDCProxyLocalOrActive(compartmentName, parentRef.getVendor(), parentRef.getName());
                    }
                    catch (DevConfigException outerException2) {
                        LOCATION.catching(thisMethod, (Throwable)((Object)outerException2));
                        if (!searchRemoteInactive || !hasInactive) break block9;
                        try {
                            parentProxy = config._getDCProxy(compartmentName, parentRef.getVendor(), parentRef.getName(), false);
                            if (result.list.contains(parentProxy)) {
                                String m = "Found a cycle in the component's parent hierarchy. DC " + parentProxy + "appears twice.";
                                if (LOCATION.beLogged(300)) {
                                    String hierarchy = "   Parent hierarchy of: " + startDC + ": " + NL;
                                    Iterator it = ((AbstractList)result.list).iterator();
                                    while (it.hasNext()) {
                                        DCProxy dc = (DCProxy)it.next();
                                        hierarchy = hierarchy + "      -" + dc;
                                    }
                                    hierarchy = hierarchy + "      -" + parentProxy;
                                    LOCATION.infoT(thisMethod, hierarchy);
                                }
                                throw new DCValidationException(m, null, new DevelopmentComponentRef(startDC), 0);
                            }
                            break block10;
                        }
                        catch (DevConfigException innerException) {
                            LOCATION.catching(thisMethod, (Throwable)((Object)innerException));
                            result.exceptions.add(innerException);
                            parentProxy = null;
                        }
                    }
                    break block10;
                }
                result.exceptions.add(outerException2);
                parentProxy = null;
            }
            if (parentProxy == null) {
                parentRef = null;
                continue;
            }
            result.list.add(parentProxy);
            parentRef = parentProxy.getComponent().getEnclosingComponent();
        }
        return result;
    }

    void checkBuildPluginAllowed(DCProxy usingDC, PPReference ppRef, String usedCompartmentName, boolean fullCheckRequired) throws SyncException, IllegalDependencyException {
        boolean checkACLS = true;
        boolean isBuildPluginReference = true;
        this._checkReferenceAllowed(usingDC, ppRef.getComponent(), ppRef.getName(), usedCompartmentName, fullCheckRequired, isBuildPluginReference, checkACLS);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ArrayListResult {
        public ArrayList list = new ArrayList();
        public Collection exceptions = new ArrayList();
    }
}

