/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.ConfigurationException;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.Dependency;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.PPReference;
import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.complib.xml.XMLException;
import com.sap.tc.devconf.DCEventType;
import com.sap.tc.devconf.DCMessageType;
import com.sap.tc.devconf.DCNodeSyncMode;
import com.sap.tc.devconf.DCUsageFilter;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.Digraph;
import com.sap.tc.devconf.IDCNodeResult;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentComponentRef;
import com.sap.tc.devconf.IUsedDCFoundHandler;
import com.sap.tc.devconf.InvalidDefinitionException;
import com.sap.tc.devconf.RepositoryAccessException;
import com.sap.tc.devconf.SyncException;
import com.sap.tc.devconf.UsedDCSearchInstruction;
import com.sap.tc.devconf.impl.CompartmentFinder;
import com.sap.tc.devconf.impl.DCNodeResult;
import com.sap.tc.devconf.impl.DCProxy;
import com.sap.tc.devconf.impl.DTRClientErrorMapper;
import com.sap.tc.devconf.impl.DevelopmentComponentNode;
import com.sap.tc.devconf.impl.DevelopmentComponentRef;
import com.sap.tc.devconf.impl.DevelopmentComponentStateRef;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.impl.syncdb.IDCSyncEntry;
import com.sap.tc.devconf.impl.syncdb.SyncMode;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.exceptions.ClientLibraryException;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DCDependenciesManager {
    public Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$impl$DCDependenciesManager == null ? (class$com$sap$tc$devconf$impl$DCDependenciesManager = DCDependenciesManager.class$("com.sap.tc.devconf.impl.DCDependenciesManager")) : class$com$sap$tc$devconf$impl$DCDependenciesManager));
    private DevelopmentConfiguration m_config;
    static /* synthetic */ Class class$com$sap$tc$devconf$impl$DCDependenciesManager;

    public DCDependenciesManager(DevelopmentConfiguration conf) {
        this.m_config = conf;
    }

    public IDCProxy[] getBuildOrderOfDCsAvailableAsSource(boolean ignoreErrors) throws SyncException, DevConfigException {
        IDCProxy[] array;
        List orderedList = this._computeBuildOrderOfDCsAvailableAsSource(ignoreErrors);
        if (orderedList == null) {
            array = new IDCProxy[]{};
        } else {
            array = new IDCProxy[orderedList.size()];
            int i = 0;
            Iterator iter = orderedList.iterator();
            while (iter.hasNext()) {
                IDCProxy p = (IDCProxy)iter.next();
                array[i++] = p;
            }
        }
        return array;
    }

    public IDCNodeResult listLocalAtBuildTimeUsers(DCProxy proxy) {
        try {
            Set usingDCs;
            ArrayList exceptions = new ArrayList();
            if (proxy.isInfrastructureComponent()) {
                usingDCs = this.listLocalBuildInfrastructureDCUsers(proxy, true, exceptions);
            } else {
                DCUsageFilter usageFilter = new DCUsageFilter(false, true, false, false, false);
                usingDCs = this._listLocalUsers(proxy, null, usageFilter, true, exceptions);
            }
            return new DCNodeResult(usingDCs, exceptions);
        }
        catch (DevConfigException e) {
            String method = "listLocalAtBuildTimeUsers";
            String m = "Internal error: Caught unexpected DevConfigException although 'ignore errors' was set : " + ((Throwable)((Object)e)).getMessage();
            IllegalStateException ex = new IllegalStateException(m);
            this.LOCATION.throwing(method, (Throwable)ex);
            throw ex;
        }
    }

    public DevelopmentComponentNode[] listLocalBuildTimeUsers(DCProxy inputDC, boolean ignoreErrors) throws DevConfigException {
        DCUsageFilter usageFilter = new DCUsageFilter(false, true, false, false, false);
        return this.listLocalUsers(inputDC, usageFilter, ignoreErrors);
    }

    public DevelopmentComponentNode[] listLocalUsers(DCProxy inputDC, DCUsageFilter usageFilter, boolean ignoreErrors) throws DevConfigException {
        return this.listLocalUsers(inputDC, null, usageFilter, ignoreErrors);
    }

    public DevelopmentComponentNode[] listLocalUsers(DCProxy inputDC, String ppName, DCUsageFilter usageFilter, boolean ignoreErrors) throws DevConfigException {
        ArrayList exceptions = new ArrayList();
        Set usingDCs = inputDC.isInfrastructureComponent() ? this.listLocalBuildInfrastructureDCUsers(inputDC, ignoreErrors, exceptions) : this._listLocalUsers(inputDC, ppName, usageFilter, ignoreErrors, exceptions);
        DevelopmentComponentNode[] returnArray = new DevelopmentComponentNode[usingDCs.size()];
        return usingDCs.toArray(returnArray);
    }

    private Set listLocalBuildInfrastructureDCUsers(DCProxy inputDC, boolean ignoreErrors, ArrayList exceptions) throws DevConfigException {
        Set users;
        if (!inputDC.isInfrastructureComponent()) {
            throw new DevConfigException("internal error: listLocalBuildInfrastructureDCUsers called for non-infrastructure DC " + inputDC);
        }
        if (inputDC.isBuildPlugin()) {
            users = this.listLocalBuildPluginUsers(inputDC, exceptions, ignoreErrors);
        } else {
            users = new HashSet();
            HashSet usingBuildplugins = new HashSet();
            HashSet visitedProxies = new HashSet();
            this.listUsingBuildPlugins(inputDC, usingBuildplugins, visitedProxies, exceptions, ignoreErrors);
            Iterator bpIter = usingBuildplugins.iterator();
            while (bpIter.hasNext()) {
                DCProxy bp = (DCProxy)bpIter.next();
                users.addAll(this.listLocalBuildPluginUsers(bp, exceptions, ignoreErrors));
            }
        }
        return users;
    }

    private void listUsingBuildPlugins(DCProxy inputDC, Set buildPlugins, Set visitedDCProxies, List exceptions, boolean ignoreErrors) throws DevConfigException {
        String theInputDCName = inputDC.getName();
        String theInputDCVendor = inputDC.getVendor();
        boolean isInputDCInDefaultCompartment = inputDC.getCompartment().IsDefaultCompartment();
        try {
            Set proxies = this.m_config.getLocalDCProxies(false, false, true);
            Iterator iterDcProxies = proxies.iterator();
            HashSet<DCProxy> usersOfThisOne = new HashSet<DCProxy>();
            block4: while (iterDcProxies.hasNext()) {
                List deps;
                DCProxy proxy = (DCProxy)iterDcProxies.next();
                if (visitedDCProxies.contains(proxy) || !proxy.isAvailableLocallyAsArchives() || !proxy.isInfrastructureComponent() || (deps = proxy.getComponent().getDependencies()) == null) continue;
                Iterator iteratorDependencies = deps.iterator();
                while (iteratorDependencies.hasNext()) {
                    Dependency dep = (Dependency)iteratorDependencies.next();
                    if (!dep.isAtRunTime() || dep.isForChildrenOnly()) continue;
                    String usedName = dep.getComponent().getName();
                    String usedVendor = dep.getComponent().getVendor();
                    if (!theInputDCName.equalsIgnoreCase(usedName) || !theInputDCVendor.equalsIgnoreCase(usedVendor)) continue;
                    String scAlias = dep.getComponent().getSCAlias();
                    if (scAlias == null) {
                        if (!isInputDCInDefaultCompartment) continue;
                        if (proxy.isBuildPlugin()) {
                            buildPlugins.add(proxy);
                            continue block4;
                        }
                        usersOfThisOne.add(proxy);
                        continue block4;
                    }
                    Compartment aliasedCompartment = null;
                    try {
                        aliasedCompartment = this.m_config.getConfigurationData().getCompartmentByAlias(proxy.getCompartmentName(), scAlias);
                        if (!inputDC.getCompartment().getName().equalsIgnoreCase(aliasedCompartment.getName())) continue;
                        if (proxy.isBuildPlugin()) {
                            buildPlugins.add(proxy);
                            continue block4;
                        }
                        usersOfThisOne.add(proxy);
                        continue block4;
                    }
                    catch (ConfigurationException e) {
                        String method = "listUsingBuildPlugins";
                        this.LOCATION.catching(method, (Throwable)e);
                        String m = "Cannot determine using components. Inconsistent development configuration: " + e.getMessage();
                        DevConfigException ex = new DevConfigException(m, e);
                        if (!ignoreErrors) {
                            throw ex;
                        }
                        exceptions.add(ex);
                    }
                }
            }
            Iterator usersIterator = usersOfThisOne.iterator();
            while (usersIterator.hasNext()) {
                DCProxy proxy = (DCProxy)usersIterator.next();
                visitedDCProxies.add(proxy);
                this.listUsingBuildPlugins(proxy, buildPlugins, visitedDCProxies, exceptions, ignoreErrors);
            }
        }
        catch (DevConfigException e) {
            String method = "listUsingBuildPlugins";
            this.LOCATION.catching(method, (Throwable)((Object)e));
            if (ignoreErrors) {
                exceptions.add(e);
            }
            throw e;
        }
    }

    private Set listLocalBuildPluginUsers(DCProxy inputDC, List exceptions, boolean ignoreErrors) throws DevConfigException {
        HashSet<DevelopmentComponentNode> users = new HashSet<DevelopmentComponentNode>();
        try {
            Set proxies = this.m_config.getLocalDCProxies(false, true, false);
            Iterator iterDcProxies = proxies.iterator();
            while (iterDcProxies.hasNext()) {
                DCReference dcref;
                PPReference buildPluginRef;
                DCProxy proxy = (DCProxy)iterDcProxies.next();
                if (!proxy.isAvailableLocallyAsSource() || (buildPluginRef = proxy.getComponent().getBuildPlugin()) == null || (dcref = buildPluginRef.getComponent()) == null || !inputDC.getName().equals(dcref.getName()) || !inputDC.getVendor().equals(dcref.getVendor())) continue;
                users.add(proxy._toNode());
            }
        }
        catch (DevConfigException e) {
            String method = "listLocalBuildPluginUsers";
            this.LOCATION.catching(method, (Throwable)((Object)e));
            if (ignoreErrors) {
                exceptions.add(e);
            }
            throw e;
        }
        return users;
    }

    private Set _listLocalUsers(DCProxy inputDC, String ppName, DCUsageFilter usageFilter, boolean ignoreErrors, Collection exceptions) throws DevConfigException {
        String thisMethod = "listBuildTimeUsers";
        HashSet<IDevelopmentComponentNode> usingDCs = new HashSet<IDevelopmentComponentNode>();
        List dcnodes = this.m_config.getDevelopmentComponentNodes();
        Iterator iterDcNodes = dcnodes.iterator();
        String theInputDCName = inputDC.getName();
        String theInputDCVendor = inputDC.getVendor();
        boolean isInputDCInDefaultCompartment = inputDC.getCompartment().IsDefaultCompartment();
        block5: while (iterDcNodes.hasNext()) {
            IDevelopmentComponentNode node = (IDevelopmentComponentNode)iterDcNodes.next();
            if (!node.isAvailableAsSource()) continue;
            List deps = null;
            try {
                deps = node.getDevelopmentComponent(false).getDependencies();
            }
            catch (RepositoryAccessException e) {
                String m = "Failed to determine build dependencies. Unexpected RepositoryAccessException caught for locally available DC: " + ((Throwable)((Object)e)).getMessage();
                this.LOCATION.traceThrowableT(300, thisMethod, m, (Throwable)((Object)e));
                if (!ignoreErrors) {
                    throw new DevConfigException(m, (Throwable)((Object)e));
                }
                exceptions.add(e);
            }
            catch (InvalidDefinitionException e) {
                String m = "Failed to determine build dependencies. Could not read definition of component  " + node + " : " + ((Throwable)((Object)e)).getMessage();
                this.LOCATION.traceThrowableT(300, thisMethod, m, (Throwable)((Object)e));
                if (!ignoreErrors) {
                    throw new DevConfigException(m, (Throwable)((Object)e));
                }
                exceptions.add(e);
            }
            if (deps == null || deps.size() <= 0) continue;
            Iterator depsIter = deps.iterator();
            while (depsIter.hasNext()) {
                String dependencyPP;
                Dependency dep = (Dependency)depsIter.next();
                if (!usageFilter.isMatchingOne(dep)) continue;
                String usedName = dep.getComponent().getName();
                String usedVendor = dep.getComponent().getVendor();
                if (ppName != null && (dependencyPP = dep.getPublicPart()) != null && !dependencyPP.equals(ppName) || !theInputDCName.equalsIgnoreCase(usedName) || !theInputDCVendor.equalsIgnoreCase(usedVendor)) continue;
                String scAlias = dep.getComponent().getSCAlias();
                if (scAlias == null) {
                    if (!isInputDCInDefaultCompartment) continue;
                    usingDCs.add(node);
                    continue block5;
                }
                Compartment aliasedCompartment = null;
                try {
                    aliasedCompartment = this.m_config.getConfigurationData().getCompartmentByAlias(node.getCompartmentName(), scAlias);
                    if (!inputDC.getCompartment().getName().equalsIgnoreCase(aliasedCompartment.getName())) continue;
                    usingDCs.add(node);
                    continue block5;
                }
                catch (ConfigurationException e) {
                    this.LOCATION.catching(thisMethod, (Throwable)e);
                    String m = "Cannot determine using components. Inconsistent development configuration: " + e.getMessage();
                    DevConfigException ex = new DevConfigException(m, e);
                    if (ignoreErrors) {
                        exceptions.add(ex);
                        continue;
                    }
                    throw ex;
                }
            }
        }
        return usingDCs;
    }

    public IDevelopmentComponentRef[] listBuildTimeUsersRecursively(DCProxy theUsedDC, boolean ignoreErrors) throws DevConfigException, SyncException {
        List orderedList;
        String thisMethod = "listBuildDependenciesRecursively";
        if (!theUsedDC.isThisStateAvailableLocally()) {
            String m = "Illegal Argument for recursive dependecy calculation: DC Proxy does not represent a locally available state of the DC. " + theUsedDC;
            throw new DevConfigException(m);
        }
        Digraph graph = new Digraph();
        List dcnodes = this.m_config.getDevelopmentComponentNodes();
        Iterator iterDcNodes = dcnodes.iterator();
        while (iterDcNodes.hasNext()) {
            DevelopmentComponentNode node = (DevelopmentComponentNode)iterDcNodes.next();
            if (!node.isAvailableAsSource()) continue;
            DCProxy proxy = null;
            try {
                proxy = this.m_config._getDCProxyLocally(node.getCompartmentName(), node.getVendor(), node.getName());
                graph.addNode(proxy);
                List deps = proxy.getComponent().getDependencies();
                if (deps == null || deps.size() <= 0) continue;
                HashSet<DCProxy> usedDCs = new HashSet<DCProxy>();
                Iterator depsIter = deps.iterator();
                while (depsIter.hasNext()) {
                    DCProxy usedDCproxy;
                    Dependency dep = (Dependency)depsIter.next();
                    if (!dep.isAtBuildTime() || dep.isForChildrenOnly()) continue;
                    String usedCompartment = this.m_config.getCompartmentIDFromDCReference(proxy.getCompartment().getName(), dep.getComponent());
                    if (usedCompartment == null) {
                        String m;
                        if (ignoreErrors) {
                            m = "Compute DC build order: skipping DC that could not be loaded: " + dep.getComponent();
                            this.LOCATION.infoT(thisMethod, m);
                            this.m_config.sendDCMessage(node, "", DCMessageType.WARNING, DCEventType.GENERIC_DC_EVENT, "Compute DC build order: could not load used DC: " + dep.getComponent() + ". skipping it");
                            continue;
                        }
                        m = "Could not determine compartment of DC " + dep.getComponent() + " , which is used by DC " + proxy;
                        this.m_config.sendDCMessage(node, "", DCMessageType.WARNING, DCEventType.GENERIC_DC_EVENT, "Abort computing DC build order, Could not determine compartment of DC: " + dep.getComponent());
                        throw new SyncException(m, null, 11, " unkown Compartment", dep.getComponent().getVendor(), dep.getComponent().getName());
                    }
                    try {
                        usedDCproxy = this.m_config._getDCProxyLocally(usedCompartment, dep.getComponent().getVendor(), dep.getComponent().getName());
                    }
                    catch (DevConfigException e) {
                        this.LOCATION.catching(thisMethod, (Throwable)((Object)e));
                        if (ignoreErrors) {
                            String m = "Compute DC build order: skipping DC that could not be loaded (no DCproxy): " + dep.getComponent();
                            this.LOCATION.infoT(thisMethod, m + ": " + ((Throwable)((Object)e)).getMessage());
                            this.m_config.sendDCMessage(node, "", DCMessageType.WARNING, DCEventType.GENERIC_DC_EVENT, "Compute DC build order: could not load used DC (no DCproxy): " + dep.getComponent() + ". skipping it");
                            continue;
                        }
                        throw e;
                    }
                    if (!usedDCproxy.isAvailableLocallyAsSource()) continue;
                    usedDCs.add(usedDCproxy);
                }
                graph.addArcs(proxy, usedDCs);
            }
            catch (DevConfigException e) {
                String m;
                if (ignoreErrors) {
                    m = "listBuildDependenciesRecursively: skipping DC that could not be loaded: " + node;
                    this.LOCATION.traceThrowableT(300, thisMethod, m, (Throwable)((Object)e));
                    this.m_config.sendDCMessage(node, "", DCMessageType.WARNING, DCEventType.GENERIC_DC_EVENT, m);
                    continue;
                }
                m = "Abort computing recursive DC dependencies, cannot load DC: " + node;
                this.m_config.sendDCMessage(node, "", DCMessageType.WARNING, DCEventType.GENERIC_DC_EVENT, m);
                throw e;
            }
        }
        Digraph buildGraph = graph.getBackwardsReachableSubgraph(theUsedDC);
        try {
            orderedList = buildGraph.order();
        }
        catch (IllegalStateException e) {
            String message = "Cycle detected in DC dependencies. Cannot determine build sequence. " + e.getMessage();
            throw new DevConfigException(message, e);
        }
        IDevelopmentComponentRef[] returnArray = new IDevelopmentComponentRef[orderedList.size()];
        Iterator buildlistIter = orderedList.iterator();
        int i = 0;
        while (buildlistIter.hasNext()) {
            DCProxy p = (DCProxy)buildlistIter.next();
            returnArray[i++] = new DevelopmentComponentRef(p);
        }
        return returnArray;
    }

    private List _computeBuildOrderOfDCsAvailableAsSource(boolean ignoreErrors) throws DevConfigException, SyncException {
        List dcnodes = this.m_config.getDevelopmentComponentNodes();
        if (dcnodes.isEmpty()) {
            return new ArrayList();
        }
        return this._computeBuildOrderOfDCs(dcnodes, ignoreErrors);
    }

    List _computeBuildOrderOfDCs(List dcnodes, boolean ignoreErrors) throws DevConfigException, SyncException {
        return this._computeBuildOrderOfDCs(dcnodes, ignoreErrors, new ArrayList());
    }

    List _computeBuildOrderOfDCs(Collection dcnodes, Collection exceptions) throws DevConfigException {
        try {
            return this._computeBuildOrderOfDCs(dcnodes, true, exceptions);
        }
        catch (SyncException e) {
            String m = "Internal Error: Caught SyncException while 'ignoreErrors' was set!";
            IllegalStateException ex = new IllegalStateException(m + ": " + ((Throwable)((Object)e)).getMessage());
            this.LOCATION.throwing("_computeBuildOrderOfDCs", (Throwable)ex);
            throw ex;
        }
    }

    List _computeBuildOrderOfDCs(Collection dcnodes, boolean ignoreErrors, Collection exceptions) throws DevConfigException, SyncException {
        List sortedDclist;
        String thisMethod = "_computeBuildOrderOfDCs()";
        Digraph graph = new Digraph();
        Iterator iter = dcnodes.iterator();
        while (iter.hasNext()) {
            DevelopmentComponentNode node = (DevelopmentComponentNode)iter.next();
            if (!node.isAvailableAsSource()) continue;
            DCProxy proxy = null;
            try {
                proxy = this.m_config._getDCProxyLocally(node.getCompartmentName(), node.getVendor(), node.getName());
            }
            catch (DevConfigException e) {
                String m;
                this.LOCATION.catching(thisMethod, (Throwable)((Object)e));
                if (ignoreErrors) {
                    exceptions.add(e);
                    m = "Compute DC build order: skipping DC that could not be loaded: " + node + ". Exception: " + ((Throwable)((Object)e)).getMessage();
                    this.LOCATION.debugT(thisMethod, m);
                    this.m_config.sendDCMessage(node, "", DCMessageType.WARNING, DCEventType.GENERIC_DC_EVENT, m);
                    continue;
                }
                m = "Abort computing DC build order, cannot load DC: " + node;
                this.m_config.sendDCMessage(node, "", DCMessageType.WARNING, DCEventType.GENERIC_DC_EVENT, m);
                throw e;
            }
            graph.addNode(proxy);
            List deps = proxy.getComponent().getDependencies();
            HashSet<DCProxy> targetNodes = new HashSet<DCProxy>();
            if (deps == null) continue;
            Iterator iterDeps = deps.iterator();
            while (iterDeps.hasNext()) {
                Dependency dep = (Dependency)iterDeps.next();
                if (!dep.isAtBuildTime() || dep.isForChildrenOnly()) continue;
                String usedCompartment = this.m_config.getCompartmentIDFromDCReference(proxy.getCompartment().getName(), dep.getComponent());
                if (usedCompartment == null) {
                    String m = "Used DC not available locally. used DC " + dep.getComponent() + " , used by DC " + proxy;
                    SyncException e = new SyncException(m, null, 11, "Unkown Compartment", dep.getComponent().getVendor(), dep.getComponent().getName());
                    if (ignoreErrors) {
                        exceptions.add(e);
                        this.LOCATION.traceThrowableT(300, thisMethod, m, (Throwable)((Object)e));
                        this.m_config.sendDCMessage(node, "", DCMessageType.WARNING, DCEventType.GENERIC_DC_EVENT, "Compute DC build order: could not load used DC: " + dep.getComponent() + ". skipping it");
                        continue;
                    }
                    this.m_config.sendDCMessage(node, "", DCMessageType.WARNING, DCEventType.GENERIC_DC_EVENT, "Abort computing DC build order, cannot load used DC: " + dep.getComponent());
                    throw e;
                }
                DCProxy usedDCproxy = this.m_config._getDCProxyLocally(usedCompartment, dep.getComponent().getVendor(), dep.getComponent().getName());
                if (!usedDCproxy.isAvailableLocallyAsSource()) continue;
                targetNodes.add(usedDCproxy);
            }
            graph.addArcs(proxy, targetNodes);
        }
        try {
            sortedDclist = graph.order();
        }
        catch (IllegalStateException e) {
            String message = "Full build impossible due to cyclic DC usages. " + e.getMessage();
            throw new DevConfigException(message, e);
        }
        return sortedDclist;
    }

    List orderLocalDCsByDependencies(Collection dcnodes, boolean ignoreErrors, Collection exceptions, DCUsageFilter usageFilter) throws DevConfigException {
        List sortedDclist;
        String thisMethod = "_orderLocalDCsByDependencies()";
        Digraph graph = new Digraph();
        Iterator iter = dcnodes.iterator();
        while (iter.hasNext()) {
            DevelopmentComponentNode node = (DevelopmentComponentNode)iter.next();
            if (!node.isSynched() && !node.isLocalOnly()) {
                String msg = "Cannot compute odering of local DCs: non-local DC passed: " + node;
                DevConfigException e = new DevConfigException(msg);
                this.LOCATION.traceThrowableT(300, thisMethod, "{0}. Skipping this node", new Object[]{msg}, (Throwable)((Object)e));
                if (ignoreErrors) {
                    exceptions.add(e);
                    continue;
                }
                throw e;
            }
            DCProxy proxy = null;
            try {
                proxy = (DCProxy)node.getDCProxy();
            }
            catch (DevConfigException e) {
                String m;
                this.LOCATION.catching(thisMethod, (Throwable)((Object)e));
                if (ignoreErrors) {
                    exceptions.add(e);
                    m = "Compute DC order: skipping DC that could not be loaded: " + node + " : " + ((Throwable)((Object)e)).getMessage();
                    this.LOCATION.debugT(thisMethod, m);
                    this.m_config.sendDCMessage(node, "", DCMessageType.WARNING, DCEventType.GENERIC_DC_EVENT, m);
                    continue;
                }
                m = "Abort computing DC order, cannot load DC: " + node;
                this.m_config.sendDCMessage(node, "", DCMessageType.WARNING, DCEventType.GENERIC_DC_EVENT, m);
                throw e;
            }
            graph.addNode(proxy);
            List deps = proxy.getComponent().getDependencies();
            HashSet<DCProxy> targetNodes = new HashSet<DCProxy>();
            if (deps == null) continue;
            Iterator iterDeps = deps.iterator();
            while (iterDeps.hasNext()) {
                Dependency dep = (Dependency)iterDeps.next();
                if (!usageFilter.isMatchingOne(dep)) continue;
                String usedCompartment = this.m_config.getCompartmentIDFromDCReference(proxy.getCompartment().getName(), dep.getComponent());
                if (usedCompartment == null) {
                    if (ignoreErrors) {
                        this.LOCATION.infoT(thisMethod, "cannot determine SC compartment of used DC. used DC {0} , used by DC {1}", new Object[]{dep.getComponent(), proxy});
                        continue;
                    }
                    String m = "Abort computing DC order, cannot determine compartment of used DC: " + dep.getComponent();
                    throw new DevConfigException(m);
                }
                boolean skip = true;
                Iterator paticipatingDCs = dcnodes.iterator();
                while (paticipatingDCs.hasNext()) {
                    IDevelopmentComponentNode n = (IDevelopmentComponentNode)paticipatingDCs.next();
                    if (!n.getName().equals(dep.getComponent().getName()) || !n.getVendor().equals(dep.getComponent().getVendor()) || !n.getCompartmentName().equals(usedCompartment)) continue;
                    skip = false;
                    break;
                }
                if (skip) continue;
                try {
                    DCProxy usedDCproxy = this.m_config._getDCProxyLocally(usedCompartment, dep.getComponent().getVendor(), dep.getComponent().getName());
                    targetNodes.add(usedDCproxy);
                }
                catch (DevConfigException e) {
                    String m;
                    this.LOCATION.catching(thisMethod, (Throwable)((Object)e));
                    if (ignoreErrors) {
                        exceptions.add(e);
                        m = "Compute DC order: skipping DC that could not be loaded: " + dep.getComponent().getVendor() + "/" + dep.getComponent().getName() + " : " + ((Throwable)((Object)e)).getMessage();
                        this.LOCATION.debugT(thisMethod, m);
                        this.m_config.sendDCMessage(node, "", DCMessageType.WARNING, DCEventType.GENERIC_DC_EVENT, m);
                        continue;
                    }
                    m = "Abort computing DC order, cannot load DC: " + node;
                    throw e;
                }
            }
            graph.addArcs(proxy, targetNodes);
        }
        try {
            sortedDclist = graph.order();
        }
        catch (IllegalStateException e) {
            String message = "Full build impossible due to cyclic DC usages. " + e.getMessage();
            throw new DevConfigException(message, e);
        }
        ArrayList<DevelopmentComponentNode> resultList = new ArrayList<DevelopmentComponentNode>(sortedDclist.size());
        Iterator it = sortedDclist.iterator();
        while (it.hasNext()) {
            DCProxy dcp = (DCProxy)it.next();
            resultList.add(dcp._toNode());
        }
        return resultList;
    }

    public List _computeBuildOrderOfDCs(IDevelopmentComponentRef[] dcrefs, boolean ignoreErrors) throws DevConfigException, SyncException {
        ArrayList<DevelopmentComponentNode> list = new ArrayList<DevelopmentComponentNode>(dcrefs.length);
        int i = 0;
        while (i < dcrefs.length) {
            IDevelopmentComponentRef ref = dcrefs[i];
            IDCSyncEntry entry = this.m_config.getComponentSyncDB().getEntry(ref);
            if (entry != null && entry.isLocallyAvailableAsSource()) {
                boolean inactive = entry.getMode() == SyncMode.SYNCHED_AS_INACTIVE_SOURCE || entry.getMode() == SyncMode.LOCAL_ONLY && DCProxy._isLocallyAvailableStateActive(DCNodeSyncMode.fromSyncMode(SyncMode.LOCAL_ONLY), this.m_config.getCompartmentObject(ref.getCompartment()));
                DevelopmentComponentNode node = new DevelopmentComponentNode(this.m_config, ref.getCompartment(), ref.getName(), ref.getVendor(), !inactive);
                list.add(node);
            }
            ++i;
        }
        return this._computeBuildOrderOfDCs(list, ignoreErrors);
    }

    public Set listDirectlyUsedDCProxies(IDCProxy usingDC, DCUsageFilter filter, boolean searchRemoteInactive, List exceptions) {
        DevelopmentComponent dc = usingDC.getComponent();
        HashSet<IDCProxy> result = new HashSet<IDCProxy>();
        List deps = dc.getDependencies();
        if (deps != null) {
            Iterator iterDeps = deps.iterator();
            while (iterDeps.hasNext()) {
                Dependency dep = (Dependency)iterDeps.next();
                if (!filter.isMatchingOne(dep)) continue;
                IDCProxy usedProxy = null;
                try {
                    usedProxy = this.m_config.getUsedDCProxy(usingDC.getCompartment().getName(), dep.getComponent(), searchRemoteInactive);
                    result.add(usedProxy);
                }
                catch (SyncException e) {
                    exceptions.add(e);
                }
            }
        }
        return result;
    }

    public Set listDirectlyUsedDCNodes(DevelopmentComponentNode usingDC, DCUsageFilter filter, boolean searchRemoteInactive, List exceptions) throws RepositoryAccessException, InvalidDefinitionException {
        HashSet<DevelopmentComponentNode> result = new HashSet<DevelopmentComponentNode>();
        DevelopmentComponent dc = usingDC.getDevelopmentComponent(false);
        List deps = dc.getDependencies();
        if (deps != null) {
            Iterator iterDeps = deps.iterator();
            while (iterDeps.hasNext()) {
                Dependency dep = (Dependency)iterDeps.next();
                if (!filter.isMatchingOne(dep)) continue;
                DevelopmentComponentNode usedDC = null;
                try {
                    usedDC = this.m_config.getUsedDCNode(usingDC.getCompartment().getName(), dep.getComponent(), searchRemoteInactive);
                    result.add(usedDC);
                }
                catch (SyncException e) {
                    exceptions.add(e);
                }
            }
        }
        return result;
    }

    public Set listInfrastructureDependenciesProxies(IDCProxy usingDCProxy, List exceptions) {
        HashSet collectedDCs = new HashSet();
        PPReference pluginRef = usingDCProxy.getComponent().getBuildPlugin();
        if (pluginRef != null) {
            this.listPluginDependencyProxies(collectedDCs, usingDCProxy.getName(), pluginRef.getComponent(), pluginRef, exceptions);
        }
        return collectedDCs;
    }

    public Set listInfrastructureDependenciesNodes(DevelopmentComponentNode usingDC, List exceptions) throws SyncException, InvalidDefinitionException {
        try {
            HashSet<DevelopmentComponentNode> collectedDCs = new HashSet<DevelopmentComponentNode>();
            PPReference pluginPPRef = usingDC.getDevelopmentComponent(false).getBuildPlugin();
            if (pluginPPRef != null) {
                DCReference pluginDCRef = pluginPPRef.getComponent();
                CompartmentFinder dcStateFinder = new CompartmentFinder(this.m_config);
                DevelopmentComponentNode pluginNode = this.getUsedDCNode(dcStateFinder, usingDC.getCompartmentName(), pluginDCRef, false);
                collectedDCs.add(pluginNode);
                this.listUsedNodes(dcStateFinder, pluginNode, new DCUsageFilter(true, false, false, false, false), collectedDCs, exceptions, false);
            }
            return collectedDCs;
        }
        catch (RepositoryAccessException e) {
            Throwable ex = e.getCause();
            if (ex != null) {
                if (ex instanceof SyncException) {
                    throw (SyncException)((Object)ex);
                }
                if (ex instanceof XMLException) {
                    throw new SyncException(((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e), 3);
                }
                if (ex instanceof IOException) {
                    throw new SyncException(((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e), 4);
                }
                if (ex instanceof ProviderException) {
                    throw new SyncException(((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e), 5);
                }
                if (ex instanceof VfsException) {
                    throw DTRClientErrorMapper.toSyncException(((Throwable)((Object)e)).getMessage(), (ClientLibraryException)((VfsException)ex));
                }
                if (ex instanceof DevConfigException) {
                    throw new SyncException(((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e), 25);
                }
            }
            throw new SyncException(((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e), 0);
        }
    }

    public DCNodeResult listRecursivelyUsedDCNodes(IDevelopmentComponentNode[] usingDCs, DCUsageFilter filter, boolean searchRemoteInactive) {
        ArrayList exceptions = new ArrayList();
        HashSet<IDevelopmentComponentNode> collectedDCs = new HashSet<IDevelopmentComponentNode>();
        CompartmentFinder compartmentFinder = new CompartmentFinder(this.m_config);
        int i = 0;
        while (i < usingDCs.length) {
            collectedDCs.add(usingDCs[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < usingDCs.length) {
            this.listUsedNodes(compartmentFinder, usingDCs[i2], filter, collectedDCs, exceptions, searchRemoteInactive);
            ++i2;
        }
        Iterator iter = collectedDCs.iterator();
        int i3 = 0;
        while (i3 < usingDCs.length) {
            collectedDCs.remove(usingDCs[i3]);
            ++i3;
        }
        return new DCNodeResult(collectedDCs, exceptions);
    }

    public DCNodeResult listRecursivelyAtRuntimeUsedDCNodes(IDevelopmentComponentNode usingDC, boolean searchRemoteInactive) {
        ArrayList exceptions = new ArrayList();
        HashSet<IDevelopmentComponentNode> collectedDCs = new HashSet<IDevelopmentComponentNode>();
        collectedDCs.add(usingDC);
        this.listUsedNodes(new CompartmentFinder(this.m_config), usingDC, new DCUsageFilter(true, false, false, false, false), collectedDCs, exceptions, searchRemoteInactive);
        collectedDCs.remove(usingDC);
        return new DCNodeResult(collectedDCs, exceptions);
    }

    private void listUsedNodes(CompartmentFinder dcStateFinder, IDevelopmentComponentNode usingDC, DCUsageFilter filter, Set visitedDCs, List exceptions, boolean searchRemoteInactive) {
        String thisMethod = "listUsedNodes()";
        try {
            List deps = usingDC.getDevelopmentComponent(false).getDependencies();
            if (deps != null) {
                Iterator iter = deps.iterator();
                while (iter.hasNext()) {
                    Dependency dep = (Dependency)iter.next();
                    if (!filter.isMatchingOne(dep)) continue;
                    DCReference dcReference = dep.getComponent();
                    PPReference ppReference = dep.getPublicPartDependency();
                    DevelopmentComponentNode usedNode = this.getUsedDCNode(dcStateFinder, usingDC.getCompartmentName(), dcReference, searchRemoteInactive);
                    if (visitedDCs.contains(usedNode)) continue;
                    visitedDCs.add(usedNode);
                    this.listUsedNodes(dcStateFinder, usedNode, filter, visitedDCs, exceptions, searchRemoteInactive);
                }
            }
        }
        catch (SyncException e) {
            exceptions.add(e);
        }
        catch (RepositoryAccessException e) {
            exceptions.add(e);
        }
        catch (InvalidDefinitionException e) {
            exceptions.add(e);
        }
    }

    private void listPluginDependencyProxies(Set coveredDCs, String usingCompartment, DCReference dcRef, PPReference ppRef, List exceptions) {
        String thisMethod = "listPluginDependency()";
        this.LOCATION.debugT(thisMethod, "this DC: {0}dependency public part: {1}dependency DC vendor: {2}dependency DC Name: {3}dependency SCAlias: {4}", new Object[]{this, ppRef == null ? null : ppRef.getName(), dcRef.getVendor(), dcRef.getName(), dcRef.getSCAlias()});
        this.LOCATION.debugT("getting DC proxy for plugin dependency");
        try {
            DCProxy usedProxy = (DCProxy)this.m_config.getUsedDCProxy(usingCompartment, dcRef);
            if (coveredDCs.contains(usedProxy)) {
                return;
            }
            coveredDCs.add(usedProxy);
            List deps = usedProxy.getComponent().getDependencies();
            if (deps != null) {
                Iterator iter = deps.iterator();
                while (iter.hasNext()) {
                    Dependency dep = (Dependency)iter.next();
                    if (!dep.isAtRunTime() || dep.isForChildrenOnly()) continue;
                    DCReference dcReference = dep.getComponent();
                    PPReference ppReference = dep.getPublicPartDependency();
                    this.listPluginDependencyProxies(coveredDCs, usedProxy.getCompartment().getName(), dcReference, ppReference, exceptions);
                }
            }
        }
        catch (SyncException e) {
            exceptions.add(e);
        }
    }

    private void listPluginDependencyProxies(Set coveredDCs, String usingCompartment, DCReference dcRef, PPReference ppRef) throws SyncException {
        String thisMethod = "listPluginDependency()";
        this.LOCATION.debugT(thisMethod, "this DC: {0}dependency public part: {1}dependency DC vendor: {2}dependency DC Name: {3}dependency SCAlias: {4}", new Object[]{this, ppRef == null ? null : ppRef.getName(), dcRef.getVendor(), dcRef.getName(), dcRef.getSCAlias()});
        this.LOCATION.debugT("getting DC proxy for plugin dependency");
        DCProxy usedProxy = (DCProxy)this.m_config.getUsedDCProxy(usingCompartment, dcRef);
        if (coveredDCs.contains(usedProxy)) {
            return;
        }
        coveredDCs.add(usedProxy);
        List deps = usedProxy.getComponent().getDependencies();
        if (deps != null) {
            Iterator iter = deps.iterator();
            while (iter.hasNext()) {
                Dependency dep = (Dependency)iter.next();
                if (!dep.isAtRunTime() || dep.isForChildrenOnly()) continue;
                DCReference dcReference = dep.getComponent();
                PPReference ppReference = dep.getPublicPartDependency();
                this.listPluginDependencyProxies(coveredDCs, usedProxy.getCompartment().getName(), dcReference, ppReference);
            }
        }
    }

    public IDCProxy[] listDCProxiesOfUsedDCs(IDCProxy usingDC, boolean ignoreErrors) throws SyncException {
        String thisMethod = "listDCProxiesOfUsedDCs";
        HashSet<DCProxy> collectedDCs = new HashSet<DCProxy>();
        PPReference pluginRef = usingDC.getComponent().getBuildPlugin();
        this.listPluginDependencyProxies(collectedDCs, usingDC.getCompartment().getName(), pluginRef.getComponent(), pluginRef);
        List list = usingDC.getComponent().getDependencies();
        if (list != null) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Dependency dep = (Dependency)iter.next();
                if (!dep.isAtDesignTime() && !dep.isAtBuildTime() || dep.isForChildrenOnly()) continue;
                String usingCompartment = usingDC.getCompartment().getName();
                DCReference dcRef = dep.getComponent();
                try {
                    DCProxy usedProxy = null;
                    usedProxy = (DCProxy)this.m_config.getUsedDCProxy(usingCompartment, dcRef);
                    collectedDCs.add(usedProxy);
                }
                catch (SyncException e) {
                    if (!ignoreErrors) {
                        throw e;
                    }
                    String m = "Skip dependency from " + this + "to " + dcRef + ". could not get DC proxy";
                    this.LOCATION.traceThrowableT(300, thisMethod, m, (Throwable)((Object)e));
                }
            }
        }
        IDCProxy[] array = collectedDCs.toArray(new IDCProxy[collectedDCs.size()]);
        return array;
    }

    public Set listDCsForSynchAsArchives(DCProxy proxy, List exceptions) {
        Set infrastructureDCs = this.listInfrastructureDependenciesProxies(proxy, exceptions);
        Set usedDCs = this.listDirectlyUsedDCProxies(proxy, new DCUsageFilter(false, true, false, false, false), false, exceptions);
        Iterator iterUsedDcs = usedDCs.iterator();
        while (iterUsedDcs.hasNext()) {
            DCProxy p = (DCProxy)iterUsedDcs.next();
            if (!p.isAvailableLocally() || p.isSynchedAsArchives()) continue;
            iterUsedDcs.remove();
        }
        usedDCs.addAll(infrastructureDCs);
        return usedDCs;
    }

    public IDevelopmentComponentNode getBuildPlugin(DevelopmentComponentNode node) throws DevConfigException {
        try {
            DevelopmentConfiguration conf = node._getConfiguration();
            DevelopmentComponent dc = node.getDevelopmentComponent(false);
            PPReference bpPPRef = dc.getBuildPlugin();
            if (bpPPRef == null) {
                return null;
            }
            DCReference bpDCRef = bpPPRef.getComponent();
            if (bpDCRef == null) {
                return null;
            }
            DevelopmentComponentStateRef state = conf.findDCState(node.getCompartmentName(), bpDCRef, false);
            if (state == null) {
                throw new DevConfigException("Cannot find build plugin \"" + bpDCRef + "\" for DC \"" + node + "\"");
            }
            return new DevelopmentComponentNode(conf, state.getCompartment(), state.getVendor(), state.getName(), state.isActive());
        }
        catch (RepositoryAccessException e) {
            throw new DevConfigException("Cannot get build plugin for DC \"" + node + "\" in configuration \"" + this.m_config.getName() + "\" : " + ((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
        }
        catch (InvalidDefinitionException e) {
            throw new DevConfigException("Cannot get build plugin for DC \"" + node + "\" in configuration \"" + this.m_config.getName() + "\" : " + ((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
        }
        catch (SyncException e) {
            throw new DevConfigException("Cannot find build plugin for DC \"" + node + "\" in configuration \"" + this.m_config.getName() + "\" : " + ((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
        }
    }

    public DevelopmentComponentNode getUsedDCNode(CompartmentFinder dcStateFinder, String referencingCompartment, DCReference dcref, boolean searchRemoteInactive) throws SyncException {
        String thisMethod = "getUsedDCNode()";
        String dcName = dcref.getName();
        String dcVendor = dcref.getVendor();
        DevelopmentComponentStateRef ref = dcStateFinder.findDCState(referencingCompartment, dcref, searchRemoteInactive);
        if (ref == null) {
            String message = "Cannot find compartment of used component: " + dcVendor + ":" + dcName;
            throw new SyncException(message, null, 11, "<UNKNOWN>", dcName, dcVendor);
        }
        DevelopmentComponentNode node = new DevelopmentComponentNode(this.m_config, ref.getCompartment(), dcVendor, dcName, ref.isActive());
        return node;
    }

    public Set listUsedNodes(Set startDCs, IUsedDCFoundHandler foundDCHandler) throws DevConfigException {
        HashSet<IDevelopmentComponentNode> usedDCNodes = new HashSet<IDevelopmentComponentNode>();
        HashSet errorDCRefs = new HashSet();
        Iterator iter = startDCs.iterator();
        while (iter.hasNext()) {
            IDevelopmentComponentNode node = (IDevelopmentComponentNode)iter.next();
            if (usedDCNodes.contains(node)) continue;
            usedDCNodes.add(node);
            UsedDCSearchInstruction searchInstruction = foundDCHandler.atComponentNode(node, null);
            if (searchInstruction == null) continue;
            this._listUsedNodes(node, searchInstruction, foundDCHandler, usedDCNodes, errorDCRefs);
        }
        usedDCNodes.removeAll(startDCs);
        return usedDCNodes;
    }

    private void _listUsedNodes(IDevelopmentComponentNode usingDC, UsedDCSearchInstruction searchInstruction, IUsedDCFoundHandler foundDCHandler, Set usedDCNodes, Set errorDCRefs) throws DevConfigException {
        DevelopmentComponent dc;
        String thisMethod = "_listUsedNodes";
        try {
            dc = usingDC.getDevelopmentComponent(false);
        }
        catch (RepositoryAccessException e) {
            String msg = "Could not get development component of node " + usingDC + " : " + ((Throwable)((Object)e)).getMessage();
            this.LOCATION.traceThrowableT(100, thisMethod, msg, (Throwable)((Object)e));
            if (!foundDCHandler.onUsedDCError((Exception)((Object)e), usingDC)) {
                throw new DevConfigException(msg, (Throwable)((Object)e));
            }
            return;
        }
        catch (InvalidDefinitionException e) {
            String msg = "Could not read development component definition for node " + usingDC + " : " + ((Throwable)((Object)e)).getMessage();
            this.LOCATION.traceThrowableT(100, thisMethod, msg, (Throwable)((Object)e));
            if (!foundDCHandler.onUsedDCError((Exception)((Object)e), usingDC)) {
                throw new DevConfigException(msg, (Throwable)((Object)e));
            }
            return;
        }
        List deps = dc.getDependencies();
        if (deps != null) {
            Iterator iterDeps = deps.iterator();
            block5: while (iterDeps.hasNext()) {
                Dependency dep = (Dependency)iterDeps.next();
                if (!searchInstruction.getFilter().isMatchingOne(dep)) {
                    this.LOCATION.debugT(thisMethod, "Skipping " + dep.getComponent() + ". Already visited");
                    continue;
                }
                DevelopmentComponentNode usedDC = null;
                DCReference ref = dep.getComponent();
                if (ref.getSCAlias() == null) {
                    if (errorDCRefs.contains(ref)) {
                        this.LOCATION.debugT(thisMethod, "Skipping " + ref + ". Found in list of unreolvable dependencies");
                        continue;
                    }
                    Iterator iter = usedDCNodes.iterator();
                    while (iter.hasNext()) {
                        IDevelopmentComponentNode node = (IDevelopmentComponentNode)iter.next();
                        if (!node.getName().equals(ref.getName()) || !node.getVendor().equals(ref.getVendor())) continue;
                        this.LOCATION.debugT(thisMethod, "Skipping " + ref + ". Already visited");
                        continue block5;
                    }
                }
                try {
                    usedDC = this.m_config.getUsedDCNode(usingDC.getCompartment().getName(), ref, searchInstruction.isSearchRemoteInactive());
                }
                catch (SyncException e) {
                    if (ref.getSCAlias() == null) {
                        errorDCRefs.add(ref);
                    }
                    String msg = "Could not get used component " + dep + " of component " + usedDC;
                    this.LOCATION.traceThrowableT(100, thisMethod, msg, (Throwable)((Object)e));
                    if (foundDCHandler.onUsedDCError((Exception)((Object)e), usingDC, dep)) continue;
                    throw new DevConfigException(msg, (Throwable)((Object)e));
                }
                if (usedDCNodes.contains(usedDC)) continue;
                usedDCNodes.add(usedDC);
                UsedDCSearchInstruction instruction = foundDCHandler.atComponentNode(usedDC, usingDC);
                if (instruction == null) continue;
                this._listUsedNodes(usedDC, instruction, foundDCHandler, usedDCNodes, errorDCRefs);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

