/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.cbs.util.Util;
import com.sap.tc.complib.provider.DCInputProvider;
import com.sap.tc.complib.provider.PPInputProvider;
import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.SyncException;
import com.sap.tc.devconf.impl.CBSHandler;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.impl.FileSystemLayout;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;

public class DCArchivePoolInputProvider
implements DCInputProvider {
    private static Location LOCATION = Location.getLocation((String)"com.sap.tc.devconf.impl.DCArchivePoolInputProvider");
    private String m_dcName;
    private String m_dcVendor;
    private String m_compartment;
    private String m_variant;
    private DevelopmentConfiguration m_configuration;
    private File m_tempFolder = null;
    private ArchivePPInputProvider m_ppInputProvider = null;
    boolean m_open = false;

    public DCArchivePoolInputProvider(DevelopmentConfiguration configuration, String compartmentName, String dcVendor, String dcName, String buildVariant) {
        this.m_dcName = dcName;
        this.m_dcVendor = dcVendor;
        this.m_compartment = compartmentName;
        this.m_configuration = configuration;
        this.m_variant = buildVariant;
    }

    private DCArchivePoolInputProvider() {
    }

    public InputStream getStreamForDC() throws ProviderException {
        String thisMethod = "getStreamForDC()";
        this.assertOpen(false, thisMethod);
        String TEMP_FOLDER_PREFIX = "dcdef_";
        FileInputStream stream = null;
        String name = Util.replaceSlash((String)this.m_dcName);
        String vendor = Util.replaceSlash((String)this.m_dcVendor);
        this.m_tempFolder = new File(this.m_configuration.getConfigurationRootFolder() + FileSystemLayout.SEPARATOR + "temp" + FileSystemLayout.SEPARATOR + "dcdef_" + vendor + "_" + name + "_" + this.getUniqueTimeStamp());
        if (!this.m_tempFolder.mkdirs()) {
            throw new ProviderException("Cannot create temporary file: ");
        }
        try {
            if (LOCATION.beLogged(100)) {
                LOCATION.debugT(thisMethod, "loading CDA for " + this.m_dcVendor + "/" + this.m_dcName + " in compartment " + this.m_compartment + " of configuration " + this.m_configuration.getDevConfObject().getName());
            }
            CBSHandler loader = new CBSHandler(this.m_configuration, this.m_compartment, this.m_dcVendor, this.m_dcName);
            loader.loadComponentDescriptor(this.m_tempFolder.getAbsolutePath(), this.m_variant);
            LOCATION.debugT(thisMethod, "loaded CDA to temp folder {0}", new Object[]{this.m_tempFolder.getPath()});
            stream = new FileInputStream(new File(this.m_tempFolder.getAbsolutePath() + FileSystemLayout.SEPARATOR + ".dcdef"));
            this.m_open = true;
        }
        catch (SyncException ex) {
            String message = "Cannot read DC descriptor from build server: " + this.m_compartment + ":" + this.m_dcVendor + "/" + this.m_dcName + " : " + ((Throwable)((Object)ex)).getMessage();
            switch (ex.getErrorCode()) {
                case 24: {
                    message = message + " " + ((Throwable)((Object)ex)).getMessage();
                    break;
                }
                case 16: {
                    message = message + " " + ((Throwable)((Object)ex)).getMessage();
                    break;
                }
            }
            Util.deleteDirRecursively((File)this.m_tempFolder);
            throw new ProviderException(message, (Throwable)((Object)ex));
        }
        catch (IOException ex) {
            String message = "Cannot get component descriptor from server: " + ex.getMessage();
            Util.deleteDirRecursively((File)this.m_tempFolder);
            throw new ProviderException(message);
        }
        catch (DevConfigException ex) {
            String message = "Cannot get component descriptor from server: " + ((Throwable)((Object)ex)).getMessage();
            Util.deleteDirRecursively((File)this.m_tempFolder);
            throw new ProviderException(message);
        }
        return stream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void releaseStream(InputStream stream) {
        String thisMethod = "releaseStream(InputStream)";
        if (stream == null) {
            String m = "releaseStream()called with null stream.Ignoring this call.";
            Exception ex = new Exception();
            m = m + "\n" + Util.printStackTraceToString((Throwable)ex);
            LOCATION.infoT(thisMethod, m);
            return;
        }
        if (!this.m_open) {
            String m = "releaseStream()called while not open. Ignoring this call.";
            Exception ex = new Exception();
            m = m + "\n" + Util.printStackTraceToString((Throwable)ex);
            LOCATION.infoT(thisMethod, m);
            return;
        }
        try {
            try {
                stream.close();
            }
            catch (IOException ex) {
                LOCATION.traceThrowableT(300, thisMethod, "closing archive input stream failed", (Throwable)ex);
                Object var6_9 = null;
                this.m_open = false;
                Util.deleteDirRecursively((File)this.m_tempFolder);
                if (!LOCATION.beDebug()) return;
                LOCATION.infoT(thisMethod, "deleted temp folder " + this.m_tempFolder.getPath());
                return;
            }
            Object var6_8 = null;
            this.m_open = false;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            this.m_open = false;
            Util.deleteDirRecursively((File)this.m_tempFolder);
            if (!LOCATION.beDebug()) throw throwable;
            LOCATION.infoT(thisMethod, "deleted temp folder " + this.m_tempFolder.getPath());
            throw throwable;
        }
        Util.deleteDirRecursively((File)this.m_tempFolder);
        if (!LOCATION.beDebug()) return;
        LOCATION.infoT(thisMethod, "deleted temp folder " + this.m_tempFolder.getPath());
    }

    public String[] getPublicParts() throws ProviderException {
        String thisMethod = "getPublicParts()";
        this.assertOpen(true, thisMethod);
        String path = this.m_tempFolder.getAbsolutePath() + FileSystemLayout.SEPARATOR + "def";
        File defdir = new File(path);
        if (defdir.exists()) {
            String[] files = defdir.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".pp");
                }
            });
            String[] res = new String[files.length];
            int i = 0;
            while (i < files.length) {
                int n = files[i].lastIndexOf(".");
                res[i] = files[i].substring(0, n);
                ++i;
            }
            return res;
        }
        return new String[0];
    }

    public PPInputProvider getPPInputProvider(String publicPartName) {
        String thisMethod = "getPPInputProvider(String)";
        this.assertOpen(true, thisMethod);
        this.m_ppInputProvider = new ArchivePPInputProvider(this, this.m_tempFolder.getAbsolutePath(), publicPartName);
        return this.m_ppInputProvider;
    }

    boolean isOpen() {
        return this.m_open;
    }

    private void assertOpen(boolean open, String method) {
        if (!this.m_open && open) {
            String logMessage = "DC Input provider assertion failed. The archive stream is not open.";
            IllegalStateException ex = new IllegalStateException(logMessage);
            LOCATION.throwing(method, (Throwable)ex);
            throw ex;
        }
        if (this.m_open && !open) {
            String logMessage = "Operation 'open 'not allowed on stream. The archive stream is already open";
            IllegalStateException e = new IllegalStateException(logMessage);
            throw e;
        }
    }

    synchronized long getUniqueTimeStamp() {
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            LOCATION.catching("getUniqueTimeStamp", (Throwable)e);
        }
        return System.currentTimeMillis();
    }

    static class ArchivePPInputProvider
    implements PPInputProvider {
        DCArchivePoolInputProvider m_parent;
        String m_ppName;
        String m_rootFolder;

        private ArchivePPInputProvider() {
        }

        protected ArchivePPInputProvider(DCArchivePoolInputProvider parent, String rootFolder, String ppName) {
            this.m_parent = parent;
            this.m_rootFolder = rootFolder;
            this.m_ppName = ppName;
        }

        public InputStream getStreamForPublicPart() throws ProviderException {
            FileInputStream stream = null;
            String filename = this.m_rootFolder + FileSystemLayout.SEPARATOR + FileSystemLayout.getPublicPartDefFileRelative(this.m_ppName);
            try {
                File f = new File(filename);
                stream = new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                String message = "cannot open public part input Stream on " + filename + " : " + e.getMessage();
                throw new ProviderException(message);
            }
            return stream;
        }

        public void releaseStream(InputStream stream) {
            try {
                stream.close();
            }
            catch (IOException ex) {
                String thisMethod = "releaseStream";
                LOCATION.traceThrowableT(300, thisMethod, "closing stream failed.", (Throwable)ex);
            }
        }
    }
}

