/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.cbs.client.CBSFactory;
import com.sap.tc.cbs.client.HTTPConnectionSettings;
import com.sap.tc.cbs.client.IBuildSpace;
import com.sap.tc.cbs.client.error.AuthorizationException;
import com.sap.tc.cbs.client.error.CommunicationException;
import com.sap.tc.cbs.client.error.InternalServerException;
import com.sap.tc.cbs.client.error.UnknownBuildSpaceException;
import com.sap.tc.cbs.util.Util;
import com.sap.tc.complib.DevelopmentConfiguration;
import com.sap.tc.complib.Repository;
import com.sap.tc.complib.SourceState;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.IConnectionContext;
import com.sap.tc.devconf.SyncException;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.ConnectionPool;
import com.tssap.dtr.client.lib.protocol.Connection;
import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.IConnection;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.requests.http.OptionsRequest;
import com.tssap.dtr.client.lib.protocol.session.Certificates;
import com.tssap.dtr.client.lib.protocol.session.SessionContext;
import com.tssap.dtr.client.lib.protocol.templates.ConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.templates.InvalidTemplateIDException;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.IBuildServer;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;
import com.tssap.dtr.client.lib.vfs.config.IRepositoryServer;
import com.tssap.dtr.client.lib.vfs.config.IServer;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import com.tssap.dtr.client.lib.vfs.fileservice.LocalFileService;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Iterator;

public class ConfigUtils {
    private static Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$impl$ConfigUtils == null ? (class$com$sap$tc$devconf$impl$ConfigUtils = ConfigUtils.class$("com.sap.tc.devconf.impl.ConfigUtils")) : class$com$sap$tc$devconf$impl$ConfigUtils));
    static /* synthetic */ Class class$com$sap$tc$devconf$impl$ConfigUtils;

    public com.sap.tc.cbs.client.IBuildServer getBuildServerProxy(IClient vfsClient, String buildServerURL, IConnectionContext connectionContext) throws DevConfigException {
        String thisMethod = "getBuildServerProxy(DevelopmentConfiguration,Category)";
        IBuildServer vfsBuildServer = null;
        if (vfsClient != null) {
            vfsBuildServer = vfsClient.getLogicalSystem().getBuildServer(buildServerURL);
        }
        if (vfsBuildServer == null) {
            String msg = "Cannot get build server connection parameters from DTR configuration. using default settings";
            LOCATION.infoT(thisMethod, msg);
            return this.getBuildServerProxy(buildServerURL, connectionContext);
        }
        return this.getBuildServerProxy(vfsBuildServer, connectionContext);
    }

    public IBuildServer getVFSBuildServer(IClient vfsClient, String buildServerURL) throws DevConfigException {
        IBuildServer vfsBuildServer = null;
        if (vfsClient != null) {
            vfsBuildServer = vfsClient.getLogicalSystem().getBuildServer(buildServerURL);
        }
        return vfsBuildServer;
    }

    public com.sap.tc.cbs.client.IBuildServer getBuildServerProxy(IBuildServer vfsBuildServer, IConnectionContext connectionContext) throws DevConfigException {
        String thisMethod = "getBuildServerProxy(DevelopmentConfiguration,Category)";
        CBSFactory cbsFactory = new CBSFactory();
        try {
            return cbsFactory.getBuildServer(this.getConnectionTemplate((IServer)vfsBuildServer, connectionContext));
        }
        catch (CommunicationException e) {
            String msg = "Failed to initialize build server proxy: " + e.getMessage();
            LOCATION.errorT(thisMethod, msg + " caused by:\n" + Util.printStackTraceToString((Throwable)e));
            throw new DevConfigException(msg, e);
        }
    }

    public com.sap.tc.cbs.client.IBuildServer getBuildServerProxy(String buildServerURL, IConnectionContext connectionContext) throws DevConfigException {
        String thisMethod = "getBuildServerProxy(DevelopmentConfiguration,Category)";
        CBSFactory cbsFactory = new CBSFactory();
        try {
            HTTPConnectionSettings connSettings = new HTTPConnectionSettings(buildServerURL, connectionContext.getUserName(), connectionContext.getPassword());
            this.setKeyStores(connSettings.getSessionContext(), connectionContext);
            return cbsFactory.getBuildServer((IConnectionTemplate)connSettings);
        }
        catch (CommunicationException e) {
            String msg = "Failed to initialize build server proxy: " + e.getMessage();
            throw new DevConfigException(msg, e);
        }
        catch (MalformedURLException e) {
            String msg = "Failed to initialize build server proxy. Invalid URL: " + e.getMessage();
            throw new DevConfigException(msg, e);
        }
        catch (KeyStoreException e) {
            String msg = "Failed to initialize build server proxy. Invalid KeyStore: " + e.getMessage();
            throw new DevConfigException(msg, e);
        }
    }

    public IConnectionTemplate getConnectionTemplate(IServer server) throws DevConfigException {
        try {
            return ConnectionPool.getTemplateProvider().getConnectionTemplate(server.getConnectionTemplateId());
        }
        catch (InvalidTemplateIDException e) {
            String msg = "Cannot get connection template for server " + server.getUrl() + " : " + e.getMessage();
            throw new DevConfigException(msg, e);
        }
    }

    public IConnectionTemplate getConnectionTemplate(IServer server, IConnectionContext connectionContext) throws DevConfigException {
        String thisMethod = "getConnectionTemplate";
        IConnectionTemplate connTemplate = null;
        try {
            connTemplate = ConnectionPool.getTemplateProvider().getConnectionTemplate(server.getConnectionTemplateId());
        }
        catch (InvalidTemplateIDException e) {
            String msg = "Cannot get connection template for server " + server.getUrl() + " : " + e.getMessage();
            throw new DevConfigException(msg, e);
        }
        if (connectionContext == null) {
            return connTemplate;
        }
        ConnectionTemplate clonedConnTemplate = null;
        try {
            ISessionContext currentSessionContext = connTemplate.getSessionContext();
            String user = connectionContext.getUserName();
            String password = connectionContext.getPassword();
            KeyStore newClientCerts = connectionContext.getClientCertsKeystore();
            KeyStore newServerCerts = connectionContext.getServerCertsKeystore();
            if (user.equals(currentSessionContext.getUser()) && password.equals(currentSessionContext.getPassword())) {
                Certificates currentCerts = currentSessionContext.certificates();
                if (currentCerts == null) {
                    if (newServerCerts == null && newClientCerts == null) {
                        return connTemplate;
                    }
                } else {
                    boolean sameServerCerts;
                    boolean bl = currentCerts.getServerCertificates() == null ? newServerCerts == null : (sameServerCerts = currentCerts.getServerCertificates().equals(newServerCerts));
                    if (sameServerCerts) {
                        boolean sameClientCerts;
                        boolean bl2 = currentCerts.getClientCertificates() == null ? newClientCerts == null : (sameClientCerts = currentCerts.getClientCertificates().equals(newClientCerts));
                        if (sameClientCerts) {
                            return connTemplate;
                        }
                    }
                }
            }
            clonedConnTemplate = new ConnectionTemplate(connTemplate);
            SessionContext newSessionContext = new SessionContext(user, password);
            this.setCredentials((ISessionContext)newSessionContext, connectionContext);
            clonedConnTemplate.setSessionContext((ISessionContext)newSessionContext);
        }
        catch (KeyStoreException e) {
            throw new DevConfigException("Could not set connection settings for " + server.getUrl() + ". Error: " + e.getMessage(), e);
        }
        return clonedConnTemplate;
    }

    public IConnectionTemplate getConnectionTemplate(String serverURL, IConnectionContext connectionContext) throws MalformedURLException, KeyStoreException {
        ConnectionTemplate template = new ConnectionTemplate(serverURL);
        SessionContext sessionContext = new SessionContext(connectionContext.getUserName(), connectionContext.getPassword());
        this.setKeyStores((ISessionContext)sessionContext, connectionContext);
        template.setSessionContext((ISessionContext)sessionContext);
        return template;
    }

    public static IConfiguration getConfiguration(File f) {
        LocalFileService lfs = new LocalFileService();
        IVirtualFile vf = lfs.constructFile(f.getAbsolutePath());
        if (vf == null) {
            return null;
        }
        return Configuration.getConfiguration((IVirtualFile)vf);
    }

    public static IConfiguration getConfiguration(String vfsRootFolder) {
        if (vfsRootFolder == null || vfsRootFolder.length() == 0) {
            return Configuration.getConfiguration();
        }
        File f2 = new File(vfsRootFolder);
        return ConfigUtils.getConfiguration(f2);
    }

    public static IClient findClient(IConfiguration vfsConf, String rootFolder) {
        if (vfsConf != null) {
            Iterator iter = vfsConf.clients();
            while (iter.hasNext()) {
                IClient client = (IClient)iter.next();
                String clientRoot = client.getAbsoluteLocalRoot();
                if (!clientRoot.equals(rootFolder)) continue;
                return client;
            }
        }
        return null;
    }

    public IBuildSpace getBuildSpace(DevelopmentConfiguration devconf, IConnectionContext connectionContext, String configRootDir, String dtrConfFolder) throws DevConfigException {
        String buildServerURL = devconf.getBuildServer();
        if (buildServerURL == null) {
            String msg = "Cannot ping build space. No build server is defined in the development configuration " + devconf.getName();
            throw new DevConfigException(msg);
        }
        IConfiguration dtrconf = ConfigUtils.getConfiguration(dtrConfFolder);
        IClient dtrclient = null;
        if (dtrconf != null) {
            dtrclient = ConfigUtils.findClient(dtrconf, configRootDir);
        }
        com.sap.tc.cbs.client.IBuildServer buildServer = this.getBuildServerProxy(dtrclient, buildServerURL, connectionContext);
        try {
            return buildServer.getBuildSpace(devconf.getName());
        }
        catch (IllegalStateException e) {
            throw new DevConfigException("could not get CBS build space proxy: " + e.getMessage(), e);
        }
    }

    public int pingBuildSpace(IBuildSpace bs) throws DevConfigException {
        try {
            bs.ping();
            return 0;
        }
        catch (AuthorizationException e) {
            LOCATION.catching("pingBuildSpace", (Throwable)e);
            return 1;
        }
        catch (InternalServerException e) {
            LOCATION.catching("pingBuildSpace", (Throwable)e);
            return 2;
        }
        catch (UnknownBuildSpaceException e) {
            LOCATION.catching("pingBuildSpace", (Throwable)e);
            return 3;
        }
        catch (CommunicationException e) {
            LOCATION.catching("pingBuildSpace", (Throwable)e);
            return 2;
        }
    }

    public int pingPath(String pingPath, IConnectionTemplate connectionTemplate) {
        int retCode;
        OptionsRequest optionsRequest;
        String thisMethod = "pingPath(String,IConnectionTemplate)";
        String fullURL = connectionTemplate.getUrl();
        if (pingPath != null) {
            optionsRequest = new OptionsRequest(pingPath);
            fullURL = Util.concatenatePath((String)fullURL, (String)pingPath, (char)'/');
        } else {
            optionsRequest = new OptionsRequest("");
        }
        Connection connection = new Connection(connectionTemplate);
        try {
            IResponse optionsResponse = optionsRequest.perform((IConnection)connection, true);
            int status = optionsResponse.getStatus();
            switch (status) {
                case 200: {
                    retCode = 0;
                    break;
                }
                case 401: {
                    LOCATION.infoT(thisMethod, "ping for URL {0} failed with status: {0}.", new Object[]{fullURL, new Integer(status)});
                    retCode = 1;
                    break;
                }
                default: {
                    LOCATION.infoT(thisMethod, "ping for URL " + fullURL + " failed with status: " + status);
                    retCode = 2;
                    break;
                }
            }
        }
        catch (IOException e) {
            LOCATION.catching(thisMethod, (Throwable)e);
            LOCATION.infoT(thisMethod, "ping for URL " + fullURL + " failed with exception :\n" + Util.printStackTraceToString((Throwable)e));
            retCode = 2;
        }
        catch (HTTPException e) {
            LOCATION.catching(thisMethod, (Throwable)e);
            LOCATION.infoT(thisMethod, "ping for URL " + fullURL + " failed with exception :\n" + Util.printStackTraceToString((Throwable)e));
            retCode = 2;
        }
        return retCode;
    }

    public int pingPath(String serverURL, String pingPath, int maxRepeats, int millisToWaitForResponse, IConnectionContext connectionContext) {
        int retCode;
        String thisMethod = "pingPath(String,String,int,int,String,String)";
        IConnectionTemplate connectionTemplate = null;
        try {
            connectionTemplate = this.getConnectionTemplate(serverURL, connectionContext);
        }
        catch (MalformedURLException e) {
            LOCATION.catching(thisMethod, (Throwable)e);
            LOCATION.infoT(thisMethod, "the specified URL is not valid: " + serverURL + ". \n" + Util.printStackTraceToString((Throwable)e));
            return 2;
        }
        catch (KeyStoreException e) {
            LOCATION.catching(thisMethod, (Throwable)e);
            LOCATION.infoT(thisMethod, "cannot ping path " + pingPath + " on server " + serverURL + " : \n" + Util.printStackTraceToString((Throwable)e));
            return 2;
        }
        String requestPath = connectionTemplate.getBasePath();
        if (pingPath != null) {
            requestPath = Util.concatenatePath((String)requestPath, (String)pingPath, (char)'/');
        }
        String fullURL = Util.concatenatePath((String)serverURL, (String)requestPath, (char)'/');
        OptionsRequest optionsRequest = new OptionsRequest(requestPath);
        Connection connection = new Connection(connectionTemplate);
        connection.setSocketConnectTimeout(millisToWaitForResponse);
        connection.setSocketReadTimeout(millisToWaitForResponse);
        connection.setRequestRepetitions(maxRepeats, true);
        try {
            IResponse optionsResponse = optionsRequest.perform((IConnection)connection, true);
            int status = optionsResponse.getStatus();
            switch (status) {
                case 200: {
                    retCode = 0;
                    break;
                }
                case 401: {
                    LOCATION.infoT(thisMethod, "ping for URL " + fullURL + " failed with status: " + status);
                    retCode = 1;
                    break;
                }
                default: {
                    LOCATION.infoT(thisMethod, "ping for URL " + fullURL + " failed with status: " + status);
                    retCode = 2;
                    break;
                }
            }
        }
        catch (IOException e) {
            LOCATION.catching(thisMethod, (Throwable)e);
            LOCATION.traceThrowableT(300, thisMethod, "ping for URL {0} failed with exception:", new Object[]{fullURL}, (Throwable)e);
            retCode = 2;
        }
        catch (HTTPException e) {
            LOCATION.catching(thisMethod, (Throwable)e);
            LOCATION.traceThrowableT(300, thisMethod, "ping for URL {0} failed with exception:", new Object[]{fullURL}, (Throwable)e);
            retCode = 2;
        }
        return retCode;
    }

    public IRepositoryServer findOrCreateRepositoryServer(IConfiguration conf, IClient client, Repository repository, IConnectionContext connectionContext) throws SyncException {
        String url = repository.getURL();
        IRepositoryServer server = client.getLogicalSystem().getRepositoryServer(url);
        String methodStr = "findOrCreateRepositoryServer(Repository)";
        LOCATION.infoT(methodStr, "Create settings for VFS configuration, server ID: {0}", new Object[]{url});
        try {
            if (server == null) {
                server = client.getLogicalSystem().addRepositoryServer(url, connectionContext.getUserName(), connectionContext.getPassword());
                conf.saveAll();
            }
        }
        catch (MalformedURLException e) {
            throw new SyncException("Adding repository server entry failed. Invalid URL: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SyncException("Adding repository server entry failed with IO error: " + e.getMessage(), e);
        }
        return server;
    }

    void setCredentials(ISessionContext sessionContext, IConnectionContext connectionContext) throws KeyStoreException {
        sessionContext.setUser(connectionContext.getUserName());
        sessionContext.setPassword(connectionContext.getPassword());
        this.setKeyStores(sessionContext, connectionContext);
    }

    void setKeyStores(ISessionContext sessionContext, IConnectionContext connectionContext) throws KeyStoreException {
        Certificates certs = sessionContext.certificates();
        if (connectionContext.getServerCertsKeystore() != null) {
            certs.setServerCertificates(connectionContext.getServerCertsKeystore());
            certs.setAuthenticateThem(true);
        }
        if (connectionContext.getClientCertsKeystore() != null) {
            certs.setClientCertificates(connectionContext.getClientCertsKeystore(), connectionContext.getPassword());
            certs.setAuthenticateMe(true);
        }
    }

    public static String getLocation(SourceState srcState) {
        return ConfigUtils.assureTrailingSlash(srcState.getLocation());
    }

    public static String getInactiveLocation(SourceState srcState) {
        return ConfigUtils.assureTrailingSlash(srcState.getInactiveLocation());
    }

    public static String assureTrailingSlash(String string) {
        if (string != null && string.charAt(string.length() - 1) != '/') {
            return string + "/";
        }
        return string;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

