/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.devconf.ICompartmentNode;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.ISoftwareComponentNode;
import com.sap.tc.devconf.InvalidDefinitionException;
import com.sap.tc.devconf.RepositoryAccessException;
import com.sap.tc.devconf.impl.IComponentNodeHandler;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ComponentTreeVisitor {
    private static Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$impl$ComponentTreeVisitor == null ? (class$com$sap$tc$devconf$impl$ComponentTreeVisitor = ComponentTreeVisitor.class$("com.sap.tc.devconf.impl.ComponentTreeVisitor")) : class$com$sap$tc$devconf$impl$ComponentTreeVisitor));
    private IDevelopmentConfiguration m_config;
    private ISoftwareComponentNode m_snode;
    static /* synthetic */ Class class$com$sap$tc$devconf$impl$ComponentTreeVisitor;

    public ComponentTreeVisitor(IDevelopmentConfiguration config, String compartment, boolean useInactive) {
        this.m_config = config;
        List list = config.getCompartmentNodes();
        ICompartmentNode comp = null;
        int i = 0;
        while (i < list.size()) {
            comp = (ICompartmentNode)list.get(i);
            String name = comp.getCompartment().getName();
            if (name.equals(compartment)) break;
            ++i;
        }
        if (comp == null) {
            throw new IllegalArgumentException("cannot find compartment " + compartment);
        }
        this.m_snode = useInactive ? comp.getInactiveSCNode() : comp.getActiveSCNode();
        if (this.m_snode == null) {
            throw new IllegalArgumentException("cannot find requested software state (scnode ==null)");
        }
    }

    public Collection visitComponentTree(IComponentNodeHandler nodeHandler) throws RepositoryAccessException {
        ArrayList exceptions = new ArrayList();
        this.visitChildren(this.m_snode.getChildren(), nodeHandler, exceptions);
        return exceptions;
    }

    protected void visitChildren(List dcNodes, IComponentNodeHandler nodeHandler, Collection exceptions) {
        if (dcNodes == null) {
            return;
        }
        int j = 0;
        while (j < dcNodes.size()) {
            IDevelopmentComponentNode dnode = (IDevelopmentComponentNode)dcNodes.get(j);
            try {
                nodeHandler.handleComponent(dnode);
            }
            catch (Exception e) {
                LOCATION.traceThrowableT(300, "visitChildren", "Caught exception in node handler:", (Throwable)e);
                exceptions.add(e);
            }
            try {
                this.visitChildren(dnode.getChildren(), nodeHandler, exceptions);
            }
            catch (RepositoryAccessException e) {
                LOCATION.traceThrowableT(300, "visitChildren", "Error accessing remote server when trying to get child nodes of \"{0}\":", new Object[]{dnode}, (Throwable)((Object)e));
                exceptions.add(e);
            }
            catch (InvalidDefinitionException e) {
                LOCATION.traceThrowableT(300, "visitChildren", "Could not get child nodes of \"{0}\":", new Object[]{dnode}, (Throwable)((Object)e));
                exceptions.add(e);
            }
            ++j;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

