/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.cbs.util.Util;
import com.sap.tc.complib.Compartment;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.RepositoryAccessException;
import com.sap.tc.devconf.impl.ArchivePackerNodeHandler;
import com.sap.tc.devconf.impl.ComponentTreeVisitor;
import com.sap.tc.devconf.impl.SyncSourceNodeHandler;
import com.sap.tc.logging.Location;
import java.io.File;
import java.util.Collection;
import java.util.Map;

public class CompartmentPacker {
    private static final Location LOCATION = Location.getLocation((String)(class$com$sap$tc$devconf$impl$CompartmentPacker == null ? (class$com$sap$tc$devconf$impl$CompartmentPacker = CompartmentPacker.class$("com.sap.tc.devconf.impl.CompartmentPacker")) : class$com$sap$tc$devconf$impl$CompartmentPacker).getName());
    private IDevelopmentConfiguration m_config;
    static /* synthetic */ Class class$com$sap$tc$devconf$impl$CompartmentPacker;

    public CompartmentPacker(IDevelopmentConfiguration config) {
        this.m_config = config;
    }

    public Collection pack(String compartmentName, String buildVariant, String targetFolder, boolean inactive, boolean sync) throws DevConfigException, RepositoryAccessException {
        if (sync) {
            this.assertSourceState(compartmentName, inactive);
        }
        this.assertVariant(compartmentName, buildVariant);
        String fullPath = Util.concatenatePath((String)targetFolder, (String)compartmentName, (char)File.separatorChar);
        fullPath = fullPath + File.separator + buildVariant;
        File targetFolderFile = new File(fullPath);
        if (targetFolderFile.exists()) {
            Util.deleteDirRecursively((File)targetFolderFile);
        }
        targetFolderFile.mkdirs();
        ComponentTreeVisitor treeVistor = new ComponentTreeVisitor(this.m_config, compartmentName, inactive);
        ArchivePackerNodeHandler handler = new ArchivePackerNodeHandler(buildVariant, targetFolderFile, sync, inactive);
        return treeVistor.visitComponentTree(handler);
    }

    public Collection syncSource(String compartmentName, boolean inactive) throws DevConfigException, RepositoryAccessException {
        this.assertSourceState(compartmentName, inactive);
        ComponentTreeVisitor treeVistor = new ComponentTreeVisitor(this.m_config, compartmentName, inactive);
        SyncSourceNodeHandler handler = new SyncSourceNodeHandler(inactive);
        return treeVistor.visitComponentTree(handler);
    }

    public void assertSourceState(String compartmentName, boolean inactive) throws DevConfigException {
        String thisMethod = "assertSourceState";
        Map compartments = this.m_config.getConfigurationData().getCompartments();
        Compartment compObj = (Compartment)compartments.get(compartmentName);
        if (compObj == null) {
            String msg = "cannot sync sources. Compartment " + compartmentName + " not existing.";
            DevConfigException ex = new DevConfigException(msg);
            LOCATION.errorT(thisMethod, msg);
            throw ex;
        }
        if (!compObj.hasSourceState()) {
            String msg = "cannot sync sources. Compartment has no source state configured.";
            LOCATION.errorT(thisMethod, msg);
            throw new DevConfigException(msg);
        }
        if (!compObj.hasInactiveSourceState() && inactive) {
            String msg = "cannot sync inactive sources. Compartment has no inactive source state in compartment " + compartmentName;
            LOCATION.errorT(thisMethod, msg);
            throw new DevConfigException(msg);
        }
    }

    public void assertVariant(String compartmentName, String variant) throws DevConfigException {
        String thisMethod = "assertVariant";
        Map compartments = this.m_config.getConfigurationData().getCompartments();
        Compartment compObj = (Compartment)compartments.get(compartmentName);
        if (compObj == null) {
            String msg = "Compartment " + compartmentName + "not existing.";
            LOCATION.errorT(thisMethod, msg);
            throw new DevConfigException(msg);
        }
        Map variantMap = compObj.getBuildVariants();
        if (variantMap == null || !variantMap.containsKey(variant)) {
            String msg = "Variant " + variant + " not existing for compartment " + compartmentName;
            LOCATION.errorT(thisMethod, msg);
            throw new DevConfigException(msg);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

