/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.cbs.util.Util;
import com.sap.tc.complib.Compartment;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.ICompartmentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.ISoftwareComponentNode;
import com.sap.tc.devconf.SyncException;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.impl.SoftwareComponentNode;
import com.sap.tc.logging.Location;
import java.util.List;

class CompartmentNode
implements ICompartmentNode {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$impl$CompartmentNode == null ? (class$com$sap$tc$devconf$impl$CompartmentNode = CompartmentNode.class$("com.sap.tc.devconf.impl.CompartmentNode")) : class$com$sap$tc$devconf$impl$CompartmentNode));
    private DevelopmentConfiguration m_devConf;
    private Compartment m_compartmentObj;
    private ISoftwareComponentNode m_activeSCNode = null;
    private ISoftwareComponentNode m_inactiveSCNode = null;
    static /* synthetic */ Class class$com$sap$tc$devconf$impl$CompartmentNode;

    private CompartmentNode() {
    }

    public CompartmentNode(DevelopmentConfiguration devConf, Compartment compartmentObj) {
        this.m_compartmentObj = compartmentObj;
        this.m_devConf = devConf;
    }

    public Compartment getCompartment() {
        return this.m_compartmentObj;
    }

    public String getSCVendor() {
        return this.m_compartmentObj.getScVendor();
    }

    public String getSCName() {
        return this.m_compartmentObj.getScName();
    }

    public ISoftwareComponentNode getActiveSCNode() {
        String thisMethod = "getActiveSCNode";
        if (this.m_activeSCNode == null) {
            try {
                this.m_activeSCNode = new SoftwareComponentNode(this.m_devConf, this.m_compartmentObj, true);
            }
            catch (DevConfigException e) {
                LOCATION.catching(thisMethod, (Throwable)((Object)e));
                LOCATION.errorT(thisMethod, "Failed to get active DC node. caught exception. (Not throwing it again). Exception: \n " + Util.printStackTraceToString((Throwable)((Object)e)));
                this.m_activeSCNode = null;
            }
        }
        return this.m_activeSCNode;
    }

    public ISoftwareComponentNode getInactiveSCNode() {
        String thisMethod = "getInactiveSCNode()";
        if (this.m_inactiveSCNode == null) {
            if (!this.m_compartmentObj.hasInactiveSourceState()) {
                LOCATION.infoT(thisMethod, "compartment " + this.m_compartmentObj.getName() + " has no inactive source state. returning null");
            } else {
                try {
                    this.m_inactiveSCNode = new SoftwareComponentNode(this.m_devConf, this.m_compartmentObj, false);
                }
                catch (DevConfigException e) {
                    LOCATION.catching(thisMethod, (Throwable)((Object)e));
                    LOCATION.errorT(thisMethod, "Failed to get inactive DC node. caught exception. (Not throwing it again). Exception: \n " + Util.printStackTraceToString((Throwable)((Object)e)));
                    this.m_activeSCNode = null;
                }
            }
        }
        return this.m_inactiveSCNode;
    }

    public boolean modificationAllowed() {
        return this.m_compartmentObj.isModificationAllowed();
    }

    public void refreshArchiveSyncState(String buildVariant) throws SyncException {
        this.m_devConf.refreshArchiveSyncState(this.m_compartmentObj, buildVariant);
    }

    public List listOutdatedSynchedArchives(String buildVariant) throws SyncException {
        return this.m_devConf.listOutdatedSynchedArchives(this.m_compartmentObj, buildVariant);
    }

    public IDevelopmentConfiguration getConfiguration() {
        return this.m_devConf;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

