/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.complib.DCReference;
import com.sap.tc.devconf.SyncException;
import com.sap.tc.devconf.impl.DevelopmentComponentStateRef;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import java.util.HashMap;
import java.util.Map;

public class CompartmentFinder {
    private DevelopmentConfiguration m_config;
    private Map m_map = new HashMap();

    public CompartmentFinder(DevelopmentConfiguration config) {
        this.m_config = config;
    }

    DevelopmentComponentStateRef findDCState(String usingCompartment, DCReference dcRef, boolean searchRemoteInactiveState) throws SyncException {
        Key key = new Key(usingCompartment, dcRef);
        DevelopmentComponentStateRef dcState = (DevelopmentComponentStateRef)this.m_map.get(key);
        if (dcState == null && (dcState = this.m_config.findDCState(usingCompartment, dcRef, searchRemoteInactiveState)) != null) {
            this.m_map.put(key, dcState);
        }
        return dcState;
    }

    private static class Key {
        public final String _usingCompartment;
        public final DCReference _dcRef;

        public Key(String usingCompartmentName, DCReference dcReference) {
            this._usingCompartment = usingCompartmentName;
            this._dcRef = dcReference;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            boolean bl;
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key key = (Key)obj;
            if (this._usingCompartment == null) {
                if (key._usingCompartment != null) return false;
                bl = true;
            } else {
                bl = this._usingCompartment.equals(key._usingCompartment);
            }
            if (!bl) return false;
            if (this._dcRef == null) {
                if (key._dcRef != null) return false;
                return true;
            }
            boolean bl2 = this._dcRef.equals((Object)key._dcRef);
            if (!bl2) return false;
            return true;
        }

        public int hashCode() {
            int result = 17;
            result = this._usingCompartment != null ? 37 * result + this._usingCompartment.hashCode() : result;
            result = this._dcRef != null ? 37 * result + this._dcRef.hashCode() : result;
            return result;
        }
    }
}

