/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.cbs.client.CBSFactory;
import com.sap.tc.cbs.client.IArchiveResult;
import com.sap.tc.cbs.client.IBuildSpace;
import com.sap.tc.cbs.client.IDCRef;
import com.sap.tc.cbs.client.IDCVariantState;
import com.sap.tc.cbs.client.error.AuthorizationException;
import com.sap.tc.cbs.client.error.CBSServerException;
import com.sap.tc.cbs.client.error.CommunicationException;
import com.sap.tc.cbs.client.error.DCInconsistentException;
import com.sap.tc.cbs.client.error.InternalServerException;
import com.sap.tc.cbs.client.error.UnknownBuildSpaceException;
import com.sap.tc.cbs.client.error.UnknownCompartmentException;
import com.sap.tc.cbs.client.error.UnknownDCException;
import com.sap.tc.cbs.client.error.UnknownPublicPartException;
import com.sap.tc.cbs.client.error.UnknownVariantException;
import com.sap.tc.cbs.util.ArchiveUnpacker;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.SyncException;
import com.sap.tc.devconf.impl.DCProxy;
import com.sap.tc.devconf.impl.DevelopmentComponentNode;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.impl.FileSystemLayout;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CBSHandler {
    private String m_dcName;
    private String m_dcVendor;
    private String m_compartment;
    private FileSystemLayout m_fs;
    private ArchiveUnpacker m_unpacker;
    private IBuildSpace m_buildSpace;
    private CBSFactory m_cbsFactory;
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$impl$CBSHandler == null ? (class$com$sap$tc$devconf$impl$CBSHandler = CBSHandler.class$("com.sap.tc.devconf.impl.CBSHandler")) : class$com$sap$tc$devconf$impl$CBSHandler));
    private static final String TEMP_DCDA_NAME = "dcda.zip";
    private static final String PPA_SUFFIX = "~ppa.zip";
    private static final String TEMP_DCA_NAME = "dca.zip";
    static /* synthetic */ Class class$com$sap$tc$devconf$impl$CBSHandler;

    private CBSHandler() {
    }

    public CBSHandler(DCProxy component) throws DevConfigException {
        this.m_dcName = component.getName();
        this.m_dcVendor = component.getVendor();
        this.m_compartment = component.getCompartment().getName();
        this.m_fs = component.getFileSystemLayout();
        this.m_unpacker = new ArchiveUnpacker();
        this.m_buildSpace = component.getConfiguration()._getBuildSpaceProxy();
    }

    public CBSHandler(DevelopmentConfiguration configuration, String compartmentName, String dcVendor, String dcName) throws DevConfigException {
        this.m_dcName = dcName;
        this.m_dcVendor = dcVendor;
        this.m_compartment = compartmentName;
        this.m_fs = new FileSystemLayout(configuration, compartmentName, dcVendor, dcName);
        this.m_unpacker = new ArchiveUnpacker();
        this.m_buildSpace = configuration._getBuildSpaceProxy();
    }

    public CBSHandler(DevelopmentConfiguration configuration, DevelopmentComponentNode node) throws DevConfigException {
        this.m_dcName = node.getName();
        this.m_dcVendor = node.getVendor();
        this.m_compartment = node.getCompartmentName();
        this.m_fs = new FileSystemLayout(configuration, this.m_compartment, this.m_dcVendor, this.m_dcName);
        this.m_unpacker = new ArchiveUnpacker();
        this.m_buildSpace = configuration._getBuildSpaceProxy();
    }

    public long getServerBuildNumber(String buildVariant) throws SyncException {
        long buildNumber;
        String msg = "Cannot get version info from build server. ";
        try {
            buildNumber = this.m_buildSpace.getLatestBuildNumber(this.m_compartment, this.m_dcVendor, this.m_dcName, buildVariant);
        }
        catch (CBSServerException e) {
            throw CBSHandler.asSyncException(e, msg);
        }
        catch (CommunicationException e) {
            throw CBSHandler.asSyncException(e, msg);
        }
        return buildNumber;
    }

    public long loadAndUnpackPublicPart(String ppName, String buildVariant) throws SyncException {
        IArchiveResult res;
        String thisMethod = "loadPublicPart()";
        try {
            String targetFolder = this.m_fs.getPublicPartRootFolder(buildVariant, ppName);
            LOCATION.debugT(thisMethod, "download archive to " + targetFolder);
            res = this.m_buildSpace.getPublicPartArchive(this.m_compartment, this.m_dcVendor, this.m_dcName, ppName, buildVariant, targetFolder);
            LOCATION.debugT(thisMethod, "download sucessful");
        }
        catch (CBSServerException e) {
            String msg = "Failed to sync public part archive.";
            throw CBSHandler.asSyncException(e, msg);
        }
        catch (CommunicationException e) {
            String msg = "Failed to sync public part archive.";
            throw CBSHandler.asSyncException(e, msg);
        }
        return res.getBuildNumber();
    }

    public long loadComponentDescriptor(String buildVariant) throws SyncException {
        return this.loadComponentDescriptor(this.m_fs.getRootFolder(), buildVariant);
    }

    public long loadComponentDescriptor(String targetFolder, String buildVariant) throws SyncException {
        IArchiveResult res;
        String thisMethod = "loadComponentDescriptor()";
        try {
            LOCATION.debugT(thisMethod, "download archive to " + targetFolder);
            res = this.m_buildSpace.getDCDescriptionArchive(this.m_compartment, this.m_dcVendor, this.m_dcName, buildVariant, targetFolder);
            LOCATION.debugT(thisMethod, "download sucessful");
        }
        catch (CBSServerException e) {
            String msg = "Cannot sync archive. " + e.getMessage();
            throw CBSHandler.asSyncException(e, msg);
        }
        catch (CommunicationException e) {
            String msg = "Cannot sync archive. " + e.getMessage();
            throw CBSHandler.asSyncException(e, msg);
        }
        return res.getBuildNumber();
    }

    public long loadAndUnpackRuntimeArchive(String buildVariant) throws SyncException {
        IArchiveResult res;
        String thisMethod = "loadRuntimeArchive(String)";
        String targetFileName = this.m_fs.getDefaultSDAFileName(buildVariant);
        try {
            LOCATION.debugT(thisMethod, "download archive to " + targetFileName);
            res = this.m_buildSpace.getDCArchive(this.m_compartment, this.m_dcVendor, this.m_dcName, buildVariant, (OutputStream)new FileOutputStream(targetFileName));
            LOCATION.debugT(thisMethod, "download sucessful");
        }
        catch (CBSServerException e) {
            String msg = "Cannot sync archive. " + e.getMessage();
            throw CBSHandler.asSyncException(e, msg);
        }
        catch (CommunicationException e) {
            String msg = "Cannot sync archive. " + e.getMessage();
            throw CBSHandler.asSyncException(e, msg);
        }
        catch (FileNotFoundException e) {
            String msg = "Cannot write file " + targetFileName + " : " + e.getMessage();
            throw new SyncException(msg, e, 28);
        }
        return res.getBuildNumber();
    }

    public IDownloadResult downloadDCDescriptionArchive(File folder, String buildVariant) throws SyncException, UnknownDCException {
        String thisMethod = "downloadDCDescriptionArchive";
        try {
            File zipFile = new File(folder.getCanonicalPath() + File.separator + TEMP_DCDA_NAME);
            FileOutputStream ostream = new FileOutputStream(zipFile);
            LOCATION.debugT(thisMethod, "download DCD archive to " + zipFile.getAbsolutePath());
            long beginTime = System.currentTimeMillis();
            IArchiveResult res = this.m_buildSpace.getDCDescriptionArchive(this.m_compartment, this.m_dcVendor, this.m_dcName, buildVariant, (OutputStream)ostream);
            ostream.close();
            long responseTime = System.currentTimeMillis() - beginTime;
            LOCATION.debugT(thisMethod, zipFile.getAbsolutePath() + " successful: " + res.getLength() + " bytes in " + responseTime + " ms");
            return new DownloadResult(res, zipFile);
        }
        catch (UnknownDCException e) {
            LOCATION.infoT(thisMethod, "Archive download failed. DC no longer exists on CBS: " + this.m_compartment + "~" + this.m_dcVendor + "/" + this.m_dcName);
            throw e;
        }
        catch (DCInconsistentException e) {
            String errMsg = "No DCDA found for component \"" + this.m_compartment + "~" + this.m_dcVendor + "~" + this.m_dcName + "\" in variant \"" + buildVariant + "\".";
            throw CBSHandler.asSyncException((CBSServerException)((Object)e), errMsg);
        }
        catch (CBSServerException e) {
            String errMsg = "CBS download failed for component \"" + this.m_compartment + "~" + this.m_dcVendor + "/" + this.m_dcName + "\" in variant \"" + buildVariant + "\". ";
            throw CBSHandler.asSyncException(e, errMsg);
        }
        catch (CommunicationException e) {
            String errMsg = "CBS download failed for component \"" + this.m_compartment + "~" + this.m_dcVendor + "/" + this.m_dcName + "\" in variant \"" + buildVariant + "\". ";
            throw CBSHandler.asSyncException(e, errMsg);
        }
        catch (IOException e) {
            String errMsg = "CBS download failed for component \"" + this.m_compartment + "~" + this.m_dcVendor + "/" + this.m_dcName + "\" in variant \"" + buildVariant + "\" : " + e.getMessage();
            throw new SyncException(errMsg, e, 28, this.m_compartment, this.m_dcName, this.m_dcVendor);
        }
    }

    public IDownloadResult downloadDCArchive(File folder, String buildVariant) throws SyncException {
        String thisMethod = "downloadDCArchive";
        try {
            File zipFile = new File(folder.getCanonicalPath() + File.separator + TEMP_DCA_NAME);
            FileOutputStream ostream = new FileOutputStream(zipFile);
            LOCATION.debugT(thisMethod, "download DC archive to " + zipFile.getAbsolutePath());
            long beginTime = System.currentTimeMillis();
            IArchiveResult res = this.m_buildSpace.getDCArchive(this.m_compartment, this.m_dcVendor, this.m_dcName, buildVariant, (OutputStream)ostream);
            ostream.close();
            long responseTime = System.currentTimeMillis() - beginTime;
            LOCATION.debugT(thisMethod, zipFile.getAbsolutePath() + " successful: " + res.getLength() + " bytes in " + responseTime + " ms");
            return new DownloadResult(res, zipFile);
        }
        catch (CommunicationException e) {
            String errMsg = "CBS download failed for component \"" + this.m_compartment + "~" + this.m_dcVendor + "/" + this.m_dcName + "\" in variant \"" + buildVariant + "\". ";
            throw CBSHandler.asSyncException(e, errMsg);
        }
        catch (CBSServerException e) {
            String errMsg = "CBS download failed for component \"" + this.m_compartment + "~" + this.m_dcVendor + "/" + this.m_dcName + "\" in variant \"" + buildVariant + "\". ";
            throw CBSHandler.asSyncException(e, errMsg);
        }
        catch (IOException e) {
            String errMsg = "CBS download failed for component \"" + this.m_compartment + "~" + this.m_dcVendor + "/" + this.m_dcName + "\" in variant \"" + buildVariant + "\":" + e.getMessage();
            throw new SyncException(errMsg, e, 28, this.m_compartment, this.m_dcName, this.m_dcVendor);
        }
    }

    public IDownloadResult downloadPPArchive(File folder, String buildVariant, String ppName) throws SyncException {
        String thisMethod = "downloadPPArchive";
        try {
            LOCATION.debugT(thisMethod, "downloading public part \"" + ppName + "\"");
            File zipFile = new File(folder.getCanonicalPath() + File.separator + ppName + PPA_SUFFIX);
            FileOutputStream ostream = new FileOutputStream(zipFile);
            LOCATION.debugT(thisMethod, "download archive to " + zipFile.getAbsolutePath());
            long beginTime = System.currentTimeMillis();
            IArchiveResult res = this.m_buildSpace.getPublicPartArchive(this.m_compartment, this.m_dcVendor, this.m_dcName, ppName, buildVariant, (OutputStream)ostream);
            ostream.close();
            long responseTime = System.currentTimeMillis() - beginTime;
            LOCATION.debugT(thisMethod, zipFile.getAbsolutePath() + " successful: " + responseTime + " ms");
            return new DownloadResult(res, zipFile);
        }
        catch (CBSServerException e) {
            String errMsg = "CBS download failed for public part \"" + ppName + "\" of component \"" + this.m_compartment + "~" + this.m_dcVendor + "~" + this.m_dcName + "\" in variant \"" + buildVariant + "\".";
            throw CBSHandler.asSyncException(e, errMsg);
        }
        catch (IOException e) {
            String errMsg = "CBS download failed for public part \"" + ppName + "\" of component \"" + this.m_compartment + "~" + this.m_dcVendor + "~" + this.m_dcName + "\" in variant \"" + buildVariant + "\" :" + e.getMessage();
            throw new SyncException(errMsg, e, 28, this.m_compartment, this.m_dcName, this.m_dcVendor);
        }
        catch (CommunicationException e) {
            String errMsg = "CBS download failed for public part \"" + ppName + "\" of component \"" + this.m_compartment + "~" + this.m_dcVendor + "~" + this.m_dcName + "\" in variant \"" + buildVariant + "\".";
            throw CBSHandler.asSyncException(e, errMsg);
        }
    }

    public IDCVariantState loadDCVariantState(String buildVariant) throws SyncException {
        String errMsg = "Could not load component " + this.m_compartment + "~" + this.m_dcVendor + "~" + this.m_dcName + " in variant " + buildVariant + " from build server. ";
        IDCRef dcref = this.getCBSFactory().createComponentRef(this.m_dcVendor, this.m_dcName);
        IDCRef[] dcrefs = new IDCRef[]{dcref};
        try {
            IDCVariantState[] variantStates = this.m_buildSpace.listDCVariantStates(this.m_compartment, buildVariant, dcrefs);
            IDCVariantState dcVntState = null;
            if (variantStates.length > 0) {
                dcVntState = variantStates[0];
            }
            if (dcVntState == null) {
                errMsg = errMsg + "The component is not available on the build server in this variant.";
                throw new SyncException(errMsg, null, 27);
            }
            if (!dcref.equals(dcVntState.getDCRef())) {
                errMsg = errMsg + "Internal error: CBS returned state of wrong component. (" + dcVntState.getDCRef() + ")";
                throw new SyncException(errMsg, null, 16);
            }
            return dcVntState;
        }
        catch (CBSServerException e) {
            throw CBSHandler.asSyncException(e, errMsg);
        }
        catch (CommunicationException e) {
            throw CBSHandler.asSyncException(e, errMsg);
        }
    }

    private CBSFactory getCBSFactory() {
        if (this.m_cbsFactory == null) {
            this.m_cbsFactory = new CBSFactory();
        }
        return this.m_cbsFactory;
    }

    public static SyncException asSyncException(CBSServerException e, String errMsg, String buildSpace) {
        if (errMsg == null) {
            errMsg = "";
        }
        if (errMsg.length() > 0) {
            errMsg = errMsg + " ";
        }
        if (e instanceof UnknownBuildSpaceException) {
            errMsg = errMsg + "Build space \"" + buildSpace + "\" does not esxist on the server:" + e.getMessage();
            return new SyncException(errMsg, e, 9);
        }
        return CBSHandler.asSyncException(e, errMsg);
    }

    public static SyncException asSyncException(CBSServerException e, String errMsg) {
        if (errMsg == null) {
            errMsg = "";
        }
        if (errMsg.length() > 0) {
            errMsg = errMsg + " ";
        }
        if (e instanceof UnknownCompartmentException) {
            errMsg = errMsg + e.getMessage();
            return new SyncException(errMsg, e, 25);
        }
        if (e instanceof UnknownDCException) {
            errMsg = errMsg + e.getMessage();
            return new SyncException(errMsg, e, 25);
        }
        if (e instanceof UnknownVariantException) {
            errMsg = errMsg + e.getMessage();
            return new SyncException(errMsg, e, 26);
        }
        if (e instanceof AuthorizationException) {
            errMsg = errMsg + e.getMessage();
            return new SyncException(errMsg, e, 401);
        }
        if (e instanceof DCInconsistentException) {
            errMsg = errMsg + e.getMessage();
            return new SyncException(errMsg, e, 39);
        }
        if (e instanceof UnknownPublicPartException) {
            errMsg = errMsg + e.getMessage();
            return new SyncException(errMsg, e, 30);
        }
        if (e instanceof InternalServerException) {
            errMsg = errMsg + e.getMessage();
            return new SyncException(errMsg, e, 500);
        }
        if (e instanceof UnknownBuildSpaceException) {
            errMsg = errMsg + e.getMessage();
            return new SyncException(errMsg, e, 9);
        }
        if (e instanceof UnknownVariantException) {
            errMsg = errMsg + e.getMessage();
            return new SyncException(errMsg, e, 26);
        }
        if (e instanceof CBSServerException) {
            errMsg = errMsg + e.getMessage();
            return new SyncException(errMsg, e, 16);
        }
        errMsg = errMsg + "Unknown error while getting archives: " + e.getMessage();
        return new SyncException(errMsg, e);
    }

    public static SyncException asSyncException(CommunicationException e, String errMsg) {
        if (errMsg == null) {
            errMsg = "";
        }
        if (errMsg.length() > 0) {
            errMsg = errMsg + " ";
        }
        errMsg = errMsg + e.getMessage();
        return new SyncException(errMsg, e, 24);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DownloadResult
    implements IDownloadResult {
        private long m_buildNumber;
        private File m_file;

        public DownloadResult(IArchiveResult res, File f) {
            this.m_buildNumber = res.getBuildNumber();
            this.m_file = f;
        }

        public long getBuildNumber() {
            return this.m_buildNumber;
        }

        public File getFile() {
            return this.m_file;
        }
    }

    public static interface IDownloadResult {
        public long getBuildNumber();

        public File getFile();
    }
}

