/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.cbs.util.Util;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.impl.DCProxy;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;

public class BuildSettings {
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$impl$BuildSettings == null ? (class$com$sap$tc$devconf$impl$BuildSettings = BuildSettings.class$("com.sap.tc.devconf.impl.BuildSettings")) : class$com$sap$tc$devconf$impl$BuildSettings));
    public static final String DC_NAME = "tc/bi/settings";
    public static final String DC_VENDOR = "sap.com";
    public static final String VERSION_PUBLIC_PART = "version";
    public static final String VERSION_PROP_FILE_NAME = ".versions";
    public static final String DEFAULT_BUILD_VARIANT = "default";
    public static final String SDK_SUFFIX = "_HOME";
    private static final String SDK_KEY = "jdk";
    private DCProxy m_proxy;
    private String m_versionPropertiesFile;
    private Properties m_versionProperties;
    static /* synthetic */ Class class$com$sap$tc$devconf$impl$BuildSettings;

    public BuildSettings(DevelopmentConfiguration config) throws DevConfigException {
        String thisMethod = "BuildSettingsComponent(DevelopmentConfiguration)";
        LOCATION.debugT(thisMethod, "trying to get DCProxy for build settings pseudo DC");
        this.m_proxy = config._getDCProxyLocalOrActive(DC_VENDOR, DC_NAME);
        this.m_versionProperties = new Properties();
        this.m_versionPropertiesFile = this._getVersionPropertiesFile();
    }

    public String getRequiredSDK() throws DevConfigException {
        String retVal = null;
        Iterator it = this.getSupportedSDKs().iterator();
        if (it.hasNext()) {
            retVal = (String)it.next();
        }
        return retVal;
    }

    Map.Entry getRequiredSDKWithLibrary() throws DevConfigException {
        Map.Entry retVal = null;
        Iterator it = this.getSDKsAndLibs().entrySet().iterator();
        if (it.hasNext()) {
            retVal = it.next();
        }
        return retVal;
    }

    SortedSet getSupportedSDKs() throws DevConfigException {
        String key;
        String entry;
        String thisMethod = "getSupportedJDKs";
        this.readVersionProperties();
        TreeSet<String> jdkSet = new TreeSet<String>();
        int j = 1;
        while ((entry = this.m_versionProperties.getProperty(key = SDK_KEY + j)) != null) {
            LOCATION.debugT(thisMethod, "DC allows JDK version: " + entry);
            jdkSet.add(entry);
            ++j;
        }
        return jdkSet;
    }

    Map getSDKsAndLibs() throws DevConfigException {
        String key;
        String entry;
        String thisMethod = "getJDKsAndlibs";
        this.readVersionProperties();
        HashMap<String, String> jdkMap = new HashMap<String, String>();
        int j = 1;
        while ((entry = this.m_versionProperties.getProperty(key = SDK_KEY + j)) != null) {
            LOCATION.debugT(thisMethod, "DC allows JDK version: " + entry);
            String libs = this.m_versionProperties.getProperty(entry);
            libs = Util.replaceSlashWithSeparator((String)libs);
            jdkMap.put(entry, libs);
            ++j;
        }
        return jdkMap;
    }

    void readVersionProperties() throws DevConfigException {
        DevelopmentConfiguration config = this.m_proxy.getConfiguration();
        String thisMethod = "BuildSettingsComponent(DevelopmentConfiguration)";
        this.m_versionProperties = new Properties();
        if (!this.m_proxy.isAvailableLocally()) {
            String msg = "cannot read the version property settings in " + this.m_versionPropertiesFile + " " + this.m_proxy + " must be available as local file";
            throw new DevConfigException(msg);
        }
        try {
            this.m_versionProperties = this.readVersionProprtiesFromFile();
        }
        catch (IOException e) {
            String msg = "cannot read the version property settings in " + this.m_versionPropertiesFile;
            throw new DevConfigException(msg, e);
        }
    }

    Properties readVersionProprtiesFromFile() throws IOException {
        Properties props = new Properties();
        FileInputStream in = new FileInputStream(this.m_versionPropertiesFile);
        props.load(in);
        in.close();
        return props;
    }

    String _getVersionPropertiesFile() {
        String ppRoot = this.m_proxy.getFileSystemLayout().getPublicPartRootFolder(DEFAULT_BUILD_VARIANT, VERSION_PUBLIC_PART);
        return ppRoot + File.separator + VERSION_PROP_FILE_NAME;
    }

    public DCProxy getProxy() {
        return this.m_proxy;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

