/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.cbs.client.BuildRequestStatus;
import com.sap.tc.cbs.client.IBuildSpace;
import com.sap.tc.cbs.client.IImportRequest;
import com.sap.tc.cbs.client.error.CBSServerException;
import com.sap.tc.cbs.client.error.CommunicationException;
import com.sap.tc.cbs.util.Util;
import com.sap.tc.devconf.BuildServerException;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class ArchiveSender {
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$impl$ArchiveSender == null ? (class$com$sap$tc$devconf$impl$ArchiveSender = ArchiveSender.class$("com.sap.tc.devconf.impl.ArchiveSender")) : class$com$sap$tc$devconf$impl$ArchiveSender));
    static /* synthetic */ Class class$com$sap$tc$devconf$impl$ArchiveSender;

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendArchives(IBuildSpace buildSpace, String folder) throws BuildServerException, FileNotFoundException {
        String thisMethod = "sendArchives()";
        IImportRequest request = null;
        File poolFolder = new File(folder);
        if (!poolFolder.exists()) {
            String msg = "ERROR: Folder: " + folder + "does not exist";
            throw new FileNotFoundException(msg);
        }
        request = buildSpace.createImportRequest();
        LOCATION.infoT(thisMethod, "new import request created. Id: " + request.getRequestID());
        String[] compartments = poolFolder.list();
        int c = 0;
        while (c < compartments.length) {
            String compartmentName = compartments[c];
            File cFolder = new File(poolFolder.getAbsolutePath() + File.separator + compartmentName);
            if (cFolder.isDirectory()) {
                String[] variants = cFolder.list();
                int v = 0;
                while (v < variants.length) {
                    String variantName = variants[v];
                    File vFolder = new File(cFolder.getAbsolutePath() + File.separator + variantName);
                    if (vFolder.isDirectory()) {
                        String[] vendors = vFolder.list();
                        int j = 0;
                        while (j < vendors.length) {
                            String vendorName = vendors[j];
                            File vendorFolder = new File(vFolder.getAbsolutePath() + File.separator + vendorName);
                            if (vendorFolder.isDirectory()) {
                                String[] children = vendorFolder.list();
                                int i = 0;
                                while (i < children.length) {
                                    String name = children[i];
                                    File child = new File(vendorFolder.getAbsolutePath() + File.separator + name);
                                    if (child.isDirectory()) {
                                        this.uploadComponents(child, name, request, compartmentName, variantName, vendorName);
                                    }
                                    ++i;
                                }
                            }
                            ++j;
                        }
                    }
                    ++v;
                }
            }
            ++c;
        }
        request.commit();
        LOCATION.infoT(thisMethod, "Import request comitted!");
        BuildRequestStatus status = request.getStatus();
        LOCATION.infoT(thisMethod, "Request Status: " + status);
        Object var23_27 = null;
        if (request == null) return;
        try {
            if (request.getStatus() != BuildRequestStatus.NEW) return;
            request.cancel();
            return;
        }
        catch (CBSServerException e) {
            String msg = "Error when canceling request";
            LOCATION.debugT(thisMethod, msg + " Caused by: \n " + Util.printStackTraceToString((Throwable)e));
            throw new BuildServerException(msg, e);
        }
        catch (CommunicationException e) {
            String msg = "Error when canceling request";
            LOCATION.debugT(thisMethod, msg + " Caused by: \n " + Util.printStackTraceToString((Throwable)e));
            throw new BuildServerException(msg, e);
        }
        {
            catch (CommunicationException e) {
                String msg = "Comminication with CBS failed. (" + e.getMessage() + ")";
                LOCATION.debugT(thisMethod, msg + " Caused by: \n " + Util.printStackTraceToString((Throwable)e));
                throw new BuildServerException(msg, e);
            }
            catch (CBSServerException e) {
                String msg = "Error reported by CBS: " + e.getMessage();
                LOCATION.debugT(thisMethod, msg + " Caused by: \n " + Util.printStackTraceToString((Throwable)e));
                throw new BuildServerException(msg, e);
            }
        }
        catch (Throwable throwable) {
            Object var23_28 = null;
            if (request == null) throw throwable;
            try {
                if (request.getStatus() != BuildRequestStatus.NEW) throw throwable;
                request.cancel();
                throw throwable;
            }
            catch (CBSServerException e) {
                String msg = "Error when canceling request";
                LOCATION.debugT(thisMethod, msg + " Caused by: \n " + Util.printStackTraceToString((Throwable)e));
                throw new BuildServerException(msg, e);
            }
            catch (CommunicationException e) {
                String msg = "Error when canceling request";
                LOCATION.debugT(thisMethod, msg + " Caused by: \n " + Util.printStackTraceToString((Throwable)e));
                throw new BuildServerException(msg, e);
            }
        }
    }

    private void uploadComponents(File folder, String name, IImportRequest request, String compartment, String variant, String vendor) throws CBSServerException, CommunicationException, FileNotFoundException {
        String thisMethod = "uploadComponents";
        String[] children = folder.list();
        int i = 0;
        while (i < children.length) {
            String childName = children[i];
            File child = new File(folder.getAbsolutePath() + File.separator + childName);
            if (child.isDirectory()) {
                this.uploadComponents(child, name + "/" + childName, request, compartment, variant, vendor);
            } else if ("dca.zip".equals(child.getName())) {
                LOCATION.infoT(thisMethod, "Uploading :" + child.getAbsolutePath());
                request.addDCArchive(compartment, vendor, name, variant, (InputStream)new FileInputStream(child), child.length());
            } else if ("dcia.zip".equals(child.getName())) {
                LOCATION.infoT(thisMethod, "Uploading :" + child.getAbsolutePath());
                request.addDCInterfaceArchive(compartment, vendor, name, variant, (InputStream)new FileInputStream(child), child.length());
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

