/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.cbs.util.Util;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.SyncException;
import com.sap.tc.devconf.impl.IComponentNodeHandler;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileOutputStream;

public class ArchivePackerNodeHandler
implements IComponentNodeHandler {
    private static Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$impl$ArchivePackerNodeHandler == null ? (class$com$sap$tc$devconf$impl$ArchivePackerNodeHandler = ArchivePackerNodeHandler.class$("com.sap.tc.devconf.impl.ArchivePackerNodeHandler")) : class$com$sap$tc$devconf$impl$ArchivePackerNodeHandler));
    private String m_buildVariant;
    private File m_targetFolder;
    private boolean m_sync;
    private boolean m_inactive;
    static /* synthetic */ Class class$com$sap$tc$devconf$impl$ArchivePackerNodeHandler;

    public ArchivePackerNodeHandler(String buildVariant, File targetFolder, boolean sync, boolean inactive) {
        this.m_buildVariant = buildVariant;
        this.m_targetFolder = targetFolder;
        this.m_sync = sync;
        this.m_inactive = inactive;
    }

    public void handleComponent(IDevelopmentComponentNode node) throws Exception {
        String thisMethod = "handleComponent";
        LOCATION.debugT(thisMethod, node.getVendor() + " : " + node.getName());
        IDCProxy proxy = node.getDCProxy();
        if (proxy == null) {
            String msg = "Could not get DCProxy for " + node;
            throw new SyncException(msg, null, 38);
        }
        LOCATION.debugT(thisMethod, "found DC proxy " + proxy);
        if (this.m_sync) {
            LOCATION.debugT(thisMethod, "now syncing " + proxy);
            proxy.syncAsSources(this.m_inactive, false);
        }
        if (proxy.isAvailableLocally()) {
            File dcFolder = this.getOrCreateComponentFolder(node);
            File dciaFile = new File(dcFolder.getAbsolutePath() + File.separator + "dcia.zip");
            FileOutputStream dciaStream = new FileOutputStream(dciaFile);
            LOCATION.debugT(thisMethod, "packing DCIA to " + dciaFile.getAbsolutePath());
            try {
                proxy.packComponentInterfaceArchive(this.m_buildVariant, dciaStream);
                dciaStream.close();
            }
            catch (Exception e) {
                LOCATION.catching(thisMethod, (Throwable)e);
                dciaStream.close();
                dciaFile.delete();
                String msg = "Error occur during creation of archive. Exception is not forwarded in order to continue this task\n";
                LOCATION.infoT(thisMethod, msg + ". Caused by\n" + Util.printStackTraceToString((Throwable)e));
            }
            File dcaFile = new File(dcFolder.getAbsolutePath() + File.separator + "dca.zip");
            FileOutputStream dcaStream = new FileOutputStream(dcaFile);
            LOCATION.debugT(thisMethod, "packing DCA to " + dciaFile.getAbsolutePath());
            boolean success = proxy.packRuntimeArchive(this.m_buildVariant, dcaStream);
            dcaStream.close();
            if (!success) {
                LOCATION.infoT(thisMethod, "packing DCA failed (dcproxy.packRuntimeArchive() returned false). Deleting archive file.");
                dcaFile.delete();
            }
        } else {
            LOCATION.infoT(thisMethod, " DC " + proxy + " not synced or not external. skipping ...");
        }
    }

    private File getOrCreateComponentFolder(IDevelopmentComponentNode node) {
        String vendorFolder = this.m_targetFolder.getAbsolutePath() + File.separator + node.getVendor();
        String compPart = node.getName().replace('/', File.separatorChar);
        File compFolder = new File(vendorFolder + File.separator + compPart);
        if (!compFolder.exists()) {
            compFolder.mkdirs();
        }
        return compFolder;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

