/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.dctool.impl;

import com.sap.tc.devconf.BuildException;
import com.sap.tc.devconf.RepositoryAccessException;
import com.sap.tc.devconf.SyncException;
import com.sap.tc.devconf.dctool.impl.ErrorMessages;
import com.tssap.dtr.client.lib.exceptions.ClientLibraryException;
import com.tssap.dtr.client.lib.exceptions.ExceptionCategory;

public class ErrorStrings {
    static final String NL = "\n\r";

    static String fromBuildException(BuildException e) {
        String errorString = null;
        int code = e.getErrorCode();
        switch (code) {
            case 0: {
                errorString = ErrorMessages.getString("ErrorStrings.BUILD_ERROR_UNKNOWN");
                break;
            }
            case 1: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_WRONG_COMPONENT_SYNC_MODE");
                break;
            }
            case 2: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_USED_COMPONENT_NOT_AVAILABLE");
                break;
            }
            case 3: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_USED_PUBLICPART_NOT_AVAILABLE");
                break;
            }
            case 4: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_USED_COMPONENT_NOT_BUILT");
                break;
            }
            case 5: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_USED_BUILDPLUGIN_NOT_AVAILABLE");
                break;
            }
            case 6: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_INITIALIZING_BUILDPLUGIN");
                break;
            }
            case 7: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_BUILDPLUGIN_EXCEPTION");
                break;
            }
            case 8: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_ILLEGAL_USAGE_GRAPH");
                break;
            }
            case 9: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_INVALID_DEPENDENCY");
                break;
            }
            case 10: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_DC_VALIDATION");
                break;
            }
            case 11: {
                Throwable cause = e.getCause();
                if (cause == null || !(cause instanceof SyncException)) break;
                SyncException s = (SyncException)((Object)cause);
                return ErrorStrings.fromSyncException(s);
            }
            default: {
                errorString = ErrorMessages.getString("ErrorStrings.UNKNOWN_ERROR");
            }
        }
        return errorString;
    }

    static String fromSyncException(SyncException e) {
        return ErrorStrings.fromSyncExceptionExt(e).getErrorString();
    }

    static ErrorResult fromRepositoryAccessException(RepositoryAccessException e) {
        String errorString = ErrorMessages.getString("ErrorStrings.ERROR_REMOTE_ACCESS");
        int resultCode = -6;
        Throwable cause = e.getCause();
        if (cause != null) {
            if (cause instanceof SyncException) {
                return ErrorStrings.fromSyncExceptionExt((SyncException)((Object)cause));
            }
            if (cause instanceof ClientLibraryException) {
                ClientLibraryException dtrException = (ClientLibraryException)cause;
                if (dtrException.getCategory() == ExceptionCategory.FORBIDDEN) {
                    errorString = ErrorMessages.getString("ErrorStrings.ERROR_VFS_FORBIDDEN") + " : " + dtrException.getMessage();
                    resultCode = -19;
                } else {
                    errorString = dtrException.getMessage();
                }
            }
        }
        return new ErrorResult(errorString, resultCode);
    }

    static ErrorResult fromSyncExceptionExt(SyncException e) {
        String errorString = null;
        int code = e.getErrorCode();
        int resultCode = 1000 + code;
        switch (code) {
            case -1: {
                errorString = ErrorMessages.getString("ErrorStrings.SYNC_INTERNAL_ERROR");
                break;
            }
            case 0: {
                errorString = ErrorMessages.getString("ErrorStrings.SYNC_ERROR_UNKNOWN");
                break;
            }
            case 1: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_COMPONENT_SYNC");
                break;
            }
            case 2: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_COMPDEF_READ");
                break;
            }
            case 3: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_COMPDEF_READ_XML");
                break;
            }
            case 4: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_COMPDEF_READ_IO");
                break;
            }
            case 5: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_COMPDEF_READ_PROVIDER");
                break;
            }
            case 6: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_NO_SOURCE_STATE");
                break;
            }
            case 7: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_OBJECTS_CHECKED_OUT");
                break;
            }
            case 8: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_NO_ARCHIVE_STATE");
                break;
            }
            case 9: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_NO_BUILD_SPACE");
                break;
            }
            case 10: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_DEVCONF_ALREADY_EXISTS");
                break;
            }
            case 11: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_USED_COMPONENT_NOT_FOUND");
                break;
            }
            case 12: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_USED_PUBLIC_PART_NOT_FOUND");
                break;
            }
            case 13: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_COMPONENT_NOT_LOCAL_ONLY");
                break;
            }
            case 14: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_PARENT_COMPONENT_NOT_FOUND");
                break;
            }
            case 15: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_VFS_BS_NOT_FOUND");
                break;
            }
            case 16: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_BUILD_SERVER");
                break;
            }
            case 17: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_DEFAULT_VARIANT");
                break;
            }
            case 18: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_FILE_DELETE");
                break;
            }
            case 19: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_LOCAL_FILE_READ");
                break;
            }
            case 20: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_DC_NOT_AVAILABLE_LOCALLY");
                break;
            }
            case 21: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_SDK_PATH_PROPERTY_NOT_FOUND");
                break;
            }
            case 22: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_OFFLINE");
                break;
            }
            case 23: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_WRONG_SYNC_MODE");
                break;
            }
            case 24: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_COMMUNICATION");
                break;
            }
            case 25: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_NO_COMPARTMENT");
                break;
            }
            case 26: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_NO_VARIANT");
                break;
            }
            case 27: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_NO_DC_VARIANT");
                break;
            }
            case 28: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_LOCAL_IO");
                break;
            }
            case 29: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_CBS_RESULTS_LOCKED");
                break;
            }
            case 30: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_NO_PUBLICPART");
                break;
            }
            case 100: {
                Throwable cause = e.getCause();
                if (cause instanceof ClientLibraryException) {
                    ClientLibraryException dtrEx = (ClientLibraryException)cause;
                    if (dtrEx.getCategory() == ExceptionCategory.FORBIDDEN) {
                        errorString = ErrorMessages.getString("ErrorStrings.ERROR_VFS_FORBIDDEN") + " : " + dtrEx.getMessage();
                        resultCode = -19;
                        break;
                    }
                    errorString = dtrEx.getMessage();
                    break;
                }
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_VFS");
                break;
            }
            case 32: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_LOCAL_CONFIG");
                break;
            }
            case 33: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_DC_INVALID");
                break;
            }
            case 34: {
                errorString = ErrorMessages.getString("ErrorStrings.ERROR_DC_DELETED");
                break;
            }
            case 400: {
                errorString = ErrorMessages.getString("ErrorStrings.HTTP_ERROR_BAD_REQUEST");
                break;
            }
            case 401: {
                errorString = ErrorMessages.getString("ErrorStrings.HTTP_ERROR_UNAUTHORIZED");
                break;
            }
            case 404: {
                errorString = ErrorMessages.getString("ErrorStrings.HTTP_ERROR_NOT_FOUND");
                break;
            }
            case 500: {
                errorString = ErrorMessages.getString("ErrorStrings.HTTP_FATAL_INTERNAL_SERVER_ERROR");
                break;
            }
            case 503: {
                errorString = ErrorMessages.getString("ErrorStrings.HTTP_FATAL_SERVICE_UNAVAILABLE");
                break;
            }
            default: {
                errorString = ErrorMessages.getString("ErrorStrings.SYNC_ERROR_UNKNOWN");
            }
        }
        if (errorString != null) {
            String s = e.getPublicPart();
            if (s != null && s.length() > 0) {
                errorString = errorString + "\n\r   Public Part: " + s;
            }
            if ((s = e.getComponentVendor()) != null && s.length() > 0) {
                errorString = errorString + "\n\r   DC Vendor: " + s;
            }
            if ((s = e.getComponentName()) != null && s.length() > 0) {
                errorString = errorString + "\n\r   DC Name: " + s;
            }
            s = e.getPath();
            if (e.getPath() != null) {
                errorString = errorString + "\n\r   Path: " + s;
            }
        }
        return new ErrorResult(errorString, resultCode);
    }

    public static class ErrorResult {
        private String m_errorString;
        private int m_errorCode;

        public ErrorResult(String errorString, int errorCode) {
            this.m_errorCode = errorCode;
            this.m_errorString = errorString;
        }

        public int getErrorCode() {
            return this.m_errorCode;
        }

        public String getErrorString() {
            return this.m_errorString;
        }
    }
}

