/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.dctool.impl;

import com.sap.tc.buildplugin.api.ILocalBuildProperties;
import com.sap.tc.buildtool.IBuildResult;
import com.sap.tc.buildutility.BuildTraceSettings;
import com.sap.tc.cbs.util.Util;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.SourceState;
import com.sap.tc.devconf.BuildException;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.DevelopmentConfigurationFactory;
import com.sap.tc.devconf.ICompartmentNode;
import com.sap.tc.devconf.IConnectionContext;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.ISoftwareComponentNode;
import com.sap.tc.devconf.InvalidDefinitionException;
import com.sap.tc.devconf.RepositoryAccessException;
import com.sap.tc.devconf.SyncException;
import com.sap.tc.devconf.dctool.impl.BuildListParser;
import com.sap.tc.devconf.dctool.impl.ErrorStrings;
import com.sap.tc.devconf.dctool.impl.IDCTool;
import com.sap.tc.devconf.impl.BuildSettings;
import com.sap.tc.devconf.impl.ConfigUtils;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.PropertiesConfigurator;
import com.sap.tc.logging.StreamLog;
import com.sap.tc.logging.TraceFormatter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

class DCTool
implements IDCTool {
    static final String NL = System.getProperty("line.separator");
    private static Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$dctool$impl$IDCTool == null ? (class$com$sap$tc$devconf$dctool$impl$IDCTool = DCTool.class$("com.sap.tc.devconf.dctool.impl.IDCTool")) : class$com$sap$tc$devconf$dctool$impl$IDCTool));
    private PrintStream m_userLogStream;
    private String m_configRootFolder;
    private String m_localArchiveFolder;
    private DevelopmentConfiguration m_config;
    private DevelopmentConfigurationFactory m_configFactory;
    private int m_serverity = 500;
    private SimpleDateFormat m_dateformat = new SimpleDateFormat("HH.mm:ss:SSS");
    private SimpleDateFormat m_fullFormat = new SimpleDateFormat();
    static /* synthetic */ Class class$com$sap$tc$devconf$dctool$impl$IDCTool;

    public DCTool(String configRootFolder, String localArchiveFolder, String traceLevel) {
        this.m_configRootFolder = configRootFolder;
        this.m_localArchiveFolder = localArchiveFolder;
        this.m_userLogStream = System.out;
        this.m_serverity = this.getSeverityFromString(traceLevel);
    }

    private int getSeverityFromString(String traceLevel) {
        if (traceLevel == null) {
            return 500;
        }
        if (traceLevel.equalsIgnoreCase("WARNING")) {
            return 400;
        }
        if (traceLevel.equalsIgnoreCase("DEBUG")) {
            return 100;
        }
        if (traceLevel.equalsIgnoreCase("INFO")) {
            return 300;
        }
        return 500;
    }

    public int syncDC(String compartmentName, String dcVendor, String dcName, IConnectionContext connectionContext, boolean fromActiveState) {
        IDCProxy dcproxy;
        Compartment comp;
        String thisMethod = "syncDC()";
        Object[] params = new Object[]{compartmentName, dcVendor, dcName, connectionContext.getUserName(), fromActiveState ? "active" : "inactive"};
        this.traceInfo(thisMethod, "called for {1}/{2} from compartment {0} in state {4}, user: {3}}", params);
        String msg = "Starting DC sync on " + this.m_fullFormat.format(new Date()) + " for DC {1}/{2} from compartment {0} in state {4}, user: {3}";
        this.logMessage(msg, params);
        this.traceInfo(thisMethod, "going online (if necessary)");
        int result = this.goOnline(connectionContext);
        if (result != 0) {
            return result;
        }
        boolean compartmentExists = false;
        Map compartments = this.m_config.getConfigurationData().getCompartments();
        if (compartments != null && (comp = (Compartment)compartments.get(compartmentName)) != null) {
            compartmentExists = true;
            if (!comp.hasInactiveSourceState()) {
                fromActiveState = true;
            }
        }
        if (!compartmentExists) {
            msg = "Specified compartment does not exist: " + compartmentName;
            this.traceError(thisMethod, msg);
            this.logMessage("Cannot sync DC. " + msg);
            return -15;
        }
        this.traceInfo(thisMethod, "getting DC proxy");
        try {
            dcproxy = this.m_config.getDevelopmentComponentProxy(compartmentName, dcVendor, dcName, fromActiveState);
        }
        catch (DevConfigException e) {
            result = -7;
            Throwable cause = e.getCause();
            String errorString = null;
            if (cause != null) {
                ErrorStrings.ErrorResult res;
                if (cause instanceof SyncException) {
                    SyncException syncEx = (SyncException)((Object)cause);
                    res = ErrorStrings.fromSyncExceptionExt(syncEx);
                    errorString = res.getErrorString();
                    result = res.getErrorCode();
                }
                if (cause instanceof RepositoryAccessException) {
                    RepositoryAccessException reposException = (RepositoryAccessException)((Object)cause);
                    res = ErrorStrings.fromRepositoryAccessException(reposException);
                    errorString = res.getErrorString();
                    result = res.getErrorCode();
                }
            }
            errorString = errorString != null ? errorString + NL + "   details: " + ((Throwable)((Object)e)).getMessage() : ((Throwable)((Object)e)).getMessage();
            errorString = errorString + NL + "Failed to initialize DC \"" + dcName + "\" by vendor \"" + dcVendor + "\" from compartment \"" + compartmentName + "\".";
            this.logMessage(errorString);
            this.traceError(thisMethod, errorString, (Exception)((Object)e));
            return result;
        }
        catch (Exception e) {
            String m = "Unknown error occurred. Could not get DC Proxy for " + dcVendor + "/" + dcName + "(" + compartmentName + ").";
            this.logMessage(m + "(" + e.getMessage() + ")");
            this.traceError(thisMethod, m, e);
            return -7;
        }
        this.traceInfo(thisMethod, "syncing DC as sources ...");
        try {
            dcproxy.syncAsSources(!fromActiveState, true);
        }
        catch (SyncException e1) {
            String errorString = ErrorStrings.fromSyncException(e1);
            result = 1000 + e1.getErrorCode();
            errorString = errorString != null ? errorString + NL + "   details: " + ((Throwable)((Object)e1)).getMessage() : ((Throwable)((Object)e1)).getMessage();
            errorString = errorString + NL + "Synching sources failed for " + dcVendor + "/" + dcName + "(" + compartmentName + ").";
            this.logMessage(errorString);
            this.traceError(thisMethod, errorString, (Exception)((Object)e1));
            return result;
        }
        catch (Exception e) {
            String m = "Unknown error occurred. Synching sources failed for " + dcVendor + "/" + dcName + "(" + compartmentName + ").";
            this.logMessage(m + "(" + e.getMessage() + ")");
            this.traceError(thisMethod, m, e);
            return -8;
        }
        String m = "sucessfully synched " + dcVendor + "/" + dcName + "(" + compartmentName + ") as sources";
        this.traceInfo(thisMethod, m);
        this.logMessage(m);
        return 0;
    }

    private void traceInfo(String thisMethod, String message) {
        LOCATION.infoT(thisMethod, message);
    }

    private void traceInfo(String thisMethod, String message, Object[] params) {
        LOCATION.infoT(thisMethod, message, params);
    }

    private int goOnline(IConnectionContext connectionContext) {
        int result;
        String thisMethod = " goOnline()";
        if (!this.m_config.isInOfflineMode()) {
            return 0;
        }
        if (this.m_configFactory == null && (result = this.initDevconfFactory()) != 0) {
            return result;
        }
        try {
            this.m_config = this.m_configFactory._getDevelopmentConfigurationInstance(this.m_configRootFolder, null, false, connectionContext, false);
        }
        catch (InvalidDefinitionException e) {
            String message = "Error reading development configuration definition from folder '" + this.m_configRootFolder;
            this.logMessage(message + " : " + ((Throwable)((Object)e)).getMessage());
            this.traceError(thisMethod, message, (Exception)((Object)e));
            return -5;
        }
        catch (RepositoryAccessException e) {
            String message = "Error connecting to remote server for configuration '" + this.m_config.getConfigurationData().getName() + ".";
            this.logMessage(message + " : " + ((Throwable)((Object)e)).getMessage());
            this.traceError(thisMethod, message, (Exception)((Object)e));
            return -6;
        }
        return 0;
    }

    private int goOffline() {
        int result;
        String thisMethod = " goOnline()";
        if (this.m_config.isInOfflineMode()) {
            return 0;
        }
        if (this.m_configFactory == null && (result = this.initDevconfFactory()) != 0) {
            return result;
        }
        try {
            this.m_config = this.m_configFactory._getDevelopmentConfigurationInstance(this.m_configRootFolder, null, true, null, false);
        }
        catch (InvalidDefinitionException e) {
            String message = "Error reading development configuration definition from folder '" + this.m_configRootFolder;
            this.logMessage(message + " : " + ((Throwable)((Object)e)).getMessage());
            this.traceError(thisMethod, message, (Exception)((Object)e));
            return -5;
        }
        catch (Exception e) {
            String message = "Unknown error when switching configuration into offline mode '" + this.m_config.getConfigurationData().getName() + ".";
            this.logMessage(message + " : " + e.getMessage());
            this.traceError(thisMethod, message, e);
            return -1;
        }
        return 0;
    }

    int configureLogging(PrintStream traceOutputStream) {
        try {
            StreamLog log = new StreamLog((OutputStream)traceOutputStream);
            TraceFormatter formatter = new TraceFormatter("[%s] %t %24d %l %m");
            log.setFormatter((Formatter)formatter);
            BuildTraceSettings.configureTracing((Log)log, (int)this.m_serverity);
            return 0;
        }
        catch (RuntimeException e) {
            LOCATION.catching("configureLogging", (Throwable)e);
            this.logMessage("internal error. Configuration of tracing failed.");
            this.logMessage("Details:" + Util.printStackTraceToString((Throwable)e));
            return -3;
        }
    }

    int configureLogging(File loggingPropertiesFile) {
        String thisMethod = "configureLogging(File)";
        if (!loggingPropertiesFile.exists()) {
            this.configureLogging(System.err);
            String message = "The logging properties file does not exist " + loggingPropertiesFile.getAbsolutePath();
            this.traceError(thisMethod, message);
            this.logMessage(message);
            return -2;
        }
        PropertiesConfigurator pc = new PropertiesConfigurator(loggingPropertiesFile);
        pc.configure();
        return 0;
    }

    public int initConfiguration() {
        int result;
        String thisMethod = "initConfiguration()";
        if (this.m_configFactory == null && (result = this.initDevconfFactory()) != 0) {
            return result;
        }
        try {
            this.m_config = this.m_configFactory._getDevelopmentConfigurationInstance(this.m_configRootFolder, null, true, null, false);
        }
        catch (InvalidDefinitionException e1) {
            String message = "Error reading development configuration definition from folder '" + this.m_configRootFolder + "'.";
            this.logMessage(message + " : " + ((Throwable)((Object)e1)).getMessage());
            this.traceError(thisMethod, message, (Exception)((Object)e1));
            return -5;
        }
        catch (Exception e1) {
            String message = "Error initializing development configuration from folder '" + this.m_configRootFolder + "'.";
            this.logMessage(message + " : " + e1.getMessage());
            this.traceError(thisMethod, message, e1);
            return -5;
        }
        return 0;
    }

    private int initDevconfFactory() {
        String thisMethod = "initDevconfFactory()";
        this.m_configFactory = DevelopmentConfigurationFactory.getInstance();
        try {
            this.m_configFactory.setLocalArchiveRootPath(this.m_localArchiveFolder);
        }
        catch (IOException e) {
            String message = "Error accessing local archive folder '" + this.m_localArchiveFolder;
            this.traceError(thisMethod, message, e);
            this.logMessage(message);
            return -4;
        }
        return 0;
    }

    private void logMessage(String string) {
        this.m_userLogStream.println(this.m_dateformat.format(new Date()) + ": " + string);
    }

    private void traceError(String method, String message) {
        LOCATION.errorT(method, message);
    }

    private void traceError(String thisMethod, String string, Exception e) {
        LOCATION.traceThrowableT(300, thisMethod, string, (Throwable)e);
    }

    public int buildDC(String compartmentName, String dcVendor, String dcName, String buildVariant, String jdkPath) {
        IDCProxy dcproxy;
        String thisMethod = "buildDC";
        String failed = "BUILD FAILED" + NL;
        Object[] params = new Object[]{compartmentName, dcVendor, dcName, buildVariant, jdkPath};
        String m = "called for {1}/{2} from compartment {0} in build variant{3} using JDK from " + jdkPath;
        this.traceInfo(thisMethod, m, params);
        m = "Starting component build on " + this.m_fullFormat.format(new Date()) + " for DC {1}/{2} from compartment {0} in build variant {3}";
        this.logMessage(m, params);
        int result = this.goOffline();
        if (result != 0) {
            this.logMessage(failed);
            return result;
        }
        this.traceInfo(thisMethod, "getting DC proxy");
        try {
            dcproxy = this.m_config.getDCProxyLocally(compartmentName, dcVendor, dcName);
        }
        catch (DevConfigException e) {
            result = -7;
            Throwable cause = e.getCause();
            String errorString = null;
            if (cause != null && cause instanceof SyncException) {
                SyncException syncEx = (SyncException)((Object)cause);
                errorString = ErrorStrings.fromSyncException(syncEx);
                result = 1000 + syncEx.getErrorCode();
            }
            errorString = errorString != null ? errorString + NL + "   details: " + ((Throwable)((Object)e)).getMessage() : ((Throwable)((Object)e)).getMessage();
            errorString = failed + errorString + NL + "Could not initialize " + dcVendor + "/" + dcName + "(" + compartmentName + ").";
            this.logMessage(errorString);
            this.traceError(thisMethod, errorString, (Exception)((Object)e));
            return result;
        }
        catch (Exception e) {
            String msg = failed + ".Unknown error occurred. Could not initialize " + dcVendor + "/" + dcName + "(" + compartmentName + ").";
            this.logMessage(msg + "(" + e.getMessage() + ")");
            this.traceError(thisMethod, msg, e);
            return -7;
        }
        try {
            BuildProperties bp = new BuildProperties(this.m_config);
            bp.setJDKPath(jdkPath);
            String location = this.m_config.getConfigurationData().getName();
            try {
                location = location + "@" + InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                LOCATION.catching(thisMethod, (Throwable)e);
            }
            bp.setBuildLocation(location);
            IBuildResult buildResult = dcproxy.make(buildVariant, null, bp);
            this.logBuildResult(buildResult, dcproxy);
            if (buildResult.getResultCode() == 2 || buildResult.getResultCode() == 3) {
                result = -10;
            }
        }
        catch (BuildException e1) {
            String errorString = null;
            Throwable cause = e1.getCause();
            if (e1.getErrorCode() == 11 && cause != null && cause instanceof SyncException) {
                SyncException syncEx = (SyncException)((Object)cause);
                errorString = ErrorStrings.fromSyncException(syncEx);
                result = 1000 + syncEx.getErrorCode();
            } else {
                errorString = ErrorStrings.fromBuildException(e1);
                result = 2000 + e1.getErrorCode();
            }
            errorString = errorString != null ? errorString + NL + "   details: " + ((Throwable)((Object)e1)).getMessage() : ((Throwable)((Object)e1)).getMessage();
            errorString = failed + NL + errorString + NL + "Could not build " + dcVendor + "/" + dcName + "(" + compartmentName + ").";
            this.logMessage(errorString);
            this.traceError(thisMethod, errorString, (Exception)((Object)e1));
            return result;
        }
        catch (Exception e) {
            String msg = failed + "Unknown error occurred. Could not build " + dcVendor + "/" + dcName + "(" + compartmentName + ").";
            this.logMessage(msg + "(" + e.getMessage() + ")");
            this.traceError(thisMethod, msg, e);
            return -10;
        }
        return result;
    }

    private void logMessage(String messagePattern, Object[] params) {
        this.logMessage(MessageFormat.format(messagePattern, params));
    }

    public int buildDC(String compartmentName, String dcVendor, String dcName, String jdkPath) {
        String thisMethod = "buildDC(String ,String ,String )";
        try {
            String buildVnt = this.m_config.getDefaultBuildVariant(compartmentName);
            return this.buildDC(compartmentName, dcVendor, dcName, buildVnt, jdkPath);
        }
        catch (DevConfigException e) {
            String m = "Error: Failed to get the default build variant for " + dcVendor + "/" + dcName + "(" + compartmentName + ").";
            this.logMessage(m + " : " + ((Throwable)((Object)e)).getMessage());
            this.traceError(thisMethod, m, (Exception)((Object)e));
            return -9;
        }
    }

    public int buildAll(String jdkPath) {
        IDCProxy dc;
        Iterator it;
        BuildProperties bp;
        IDCProxy[] dcs;
        String thisMethod = "buildAll()";
        ArrayList<IDCProxy> successfulDCs = new ArrayList<IDCProxy>();
        ArrayList<IDCProxy> failedDCs = new ArrayList<IDCProxy>();
        ArrayList<IDCProxy> warningDCs = new ArrayList<IDCProxy>();
        Object[] params = new Object[]{jdkPath};
        String msg = "called with JDK path {0}";
        this.traceInfo(thisMethod, msg, params);
        msg = "Starting full component build (build all) on " + this.m_fullFormat.format(new Date()) + ". using JDK path " + jdkPath;
        this.logMessage(msg);
        try {
            this.logMessage("Determining build sequence for DCs in configuration " + this.m_config.getConfigurationData().getName());
            dcs = this.m_config.getBuildOrderOfDCsAvailableAsSource(true);
        }
        catch (SyncException e) {
            String errorString = ErrorStrings.fromSyncException(e);
            int result = 1000 + e.getErrorCode();
            errorString = errorString != null ? errorString + NL + "   details: " + ((Throwable)((Object)e)).getMessage() : ((Throwable)((Object)e)).getMessage();
            errorString = errorString + NL + "Could not get determine sequence for DCs in configuration " + this.m_config.getConfigurationData().getName();
            this.logMessage(errorString);
            this.traceError(thisMethod, errorString, (Exception)((Object)e));
            return result;
        }
        catch (DevConfigException e) {
            int result = -7;
            Throwable cause = e.getCause();
            String errorString = null;
            if (cause != null && cause instanceof SyncException) {
                SyncException syncEx = (SyncException)((Object)cause);
                errorString = ErrorStrings.fromSyncException(syncEx);
                result = 1000 + syncEx.getErrorCode();
            }
            errorString = errorString != null ? errorString + NL + "   details: " + ((Throwable)((Object)e)).getMessage() : ((Throwable)((Object)e)).getMessage();
            errorString = errorString + NL + "Could not get determine sequence for DCs in configuration " + this.m_config.getConfigurationData().getName();
            this.logMessage(errorString);
            this.traceError(thisMethod, errorString, (Exception)((Object)e));
            return result;
        }
        catch (Exception e) {
            String m = "Unknown error occurred. Could not get determine sequence for DCs in configuration " + this.m_config.getConfigurationData().getName();
            this.logMessage(m + "(" + e.getMessage() + ")");
            this.traceError(thisMethod, m, e);
            return -18;
        }
        if (dcs.length == 0) {
            this.logMessage("nothing to build. No DCs locally available as source code.");
            return 0;
        }
        this.logMessage("Found " + dcs.length + " DCs that are locally availabale as source code.");
        msg = "Determined build sequence:";
        int i = 0;
        while (i < dcs.length) {
            msg = msg + NL + "   " + (i + 1) + ": " + dcs[i];
            ++i;
        }
        this.logMessage(msg);
        this.logMessage("Start building all.");
        try {
            String host;
            bp = new BuildProperties(this.m_config);
            bp.setJDKPath(jdkPath);
            try {
                host = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e1) {
                LOCATION.catching("buildAll", (Throwable)e1);
                host = null;
            }
            String location = this.m_config.getConfigurationData().getName();
            if (host != null) {
                location = location + "@" + host;
            }
            bp.setBuildLocation(location);
        }
        catch (DevConfigException e2) {
            String m = "Build of all DCs aborted. Failed to determine parameter name for required JDK.";
            this.logMessage(m + "(" + ((Throwable)((Object)e2)).getMessage() + ")");
            this.traceError(thisMethod, m, (Exception)((Object)e2));
            return -14;
        }
        int i2 = 0;
        while (i2 < dcs.length) {
            IDCProxy dc2 = dcs[i2];
            try {
                this.logNewLine();
                msg = "Starting DC build for " + dc2;
                this.logMessage(msg);
                String bv = this.m_config.getDefaultBuildVariant(dc2.getCompartment().getName());
                IBuildResult buildResult = dc2.make(bv, null, bp);
                this.logBuildResult(buildResult, dc2);
                if (buildResult.getResultCode() == 0) {
                    successfulDCs.add(dc2);
                } else if (buildResult.getResultCode() == 1) {
                    warningDCs.add(dc2);
                } else {
                    failedDCs.add(dc2);
                }
            }
            catch (DevConfigException e1) {
                String m = "BUILD FAILED." + NL + "Fatal Error: Failed to get the default build variant for " + dc2;
                this.logMessage(m + " : " + ((Throwable)((Object)e1)).getMessage());
                this.traceError(thisMethod, m, (Exception)((Object)e1));
                return -9;
            }
            catch (BuildException e1) {
                String errorString = null;
                Throwable cause = e1.getCause();
                if (e1.getErrorCode() == 11 && cause != null && cause instanceof SyncException) {
                    SyncException syncEx = (SyncException)((Object)cause);
                    errorString = ErrorStrings.fromSyncException(syncEx);
                } else {
                    errorString = ErrorStrings.fromBuildException(e1);
                }
                errorString = errorString != null ? errorString + NL + "   details: " + ((Throwable)((Object)e1)).getMessage() : ((Throwable)((Object)e1)).getMessage();
                errorString = "BUILD FAILED." + NL + errorString + NL + "Could not build " + dc2;
                this.logMessage(errorString);
                this.traceError(thisMethod, errorString, (Exception)((Object)e1));
                failedDCs.add(dc2);
            }
            ++i2;
        }
        msg = "Finished build for a total of " + dcs.length + " DCs.";
        if (!warningDCs.isEmpty()) {
            msg = msg + NL + "   Build succeeded with warnings for " + warningDCs.size() + " DCs:";
            it = warningDCs.iterator();
            while (it.hasNext()) {
                dc = (IDCProxy)it.next();
                msg = msg + NL + "      WARNING " + dc;
            }
        }
        if (!failedDCs.isEmpty()) {
            msg = msg + NL + "   Build failed for " + failedDCs.size() + " DCs:";
            it = failedDCs.iterator();
            while (it.hasNext()) {
                dc = (IDCProxy)it.next();
                msg = msg + NL + "      FAILED " + dc;
            }
        }
        if (!successfulDCs.isEmpty()) {
            msg = msg + NL + "   Build succeeded without warnings for " + successfulDCs.size() + " DCs:";
            it = successfulDCs.iterator();
            while (it.hasNext()) {
                dc = (IDCProxy)it.next();
                msg = msg + NL + "      OK " + dc;
            }
        }
        this.logMessage(msg);
        if (!failedDCs.isEmpty()) {
            return -18;
        }
        return 0;
    }

    public int buildList(String jdkPath, String buildListFile) {
        String thisMethod = "buildList()";
        Object[] params = new Object[]{jdkPath, buildListFile};
        String msg = "called with JDK path {0} and build list file {1}";
        this.traceInfo(thisMethod, msg, params);
        Properties[] props = null;
        BuildListParser blp = new BuildListParser();
        try {
            props = blp.parseBuildList(buildListFile);
        }
        catch (FileNotFoundException e) {
            String message = "Error reading build list file";
            this.logMessage(message + " : " + e.getMessage());
            this.traceError(thisMethod, message, e);
            return -20;
        }
        catch (Exception e1) {
            String message = "Error parsing build list file";
            this.logMessage(message + " : " + e1.getMessage());
            this.traceError(thisMethod, message, e1);
            return -21;
        }
        msg = "Starting component build(s) according to build list " + buildListFile + " on " + this.m_fullFormat.format(new Date()) + ". using JDK path " + jdkPath;
        this.logMessage(msg);
        int returnCode = 0;
        int errorCounter = 0;
        int successCounter = 0;
        System.out.println("Properties lenght " + props.length);
        int i = 0;
        while (i < props.length) {
            String dcName = props[i].getProperty("n");
            String dcVendor = props[i].getProperty("v");
            String compartmentName = props[i].getProperty("s");
            try {
                String buildVnt = this.m_config.getDefaultBuildVariant(compartmentName);
                returnCode = this.buildDC(compartmentName, dcVendor, dcName, buildVnt, jdkPath);
                if (returnCode == 0 || returnCode == 1) {
                    ++successCounter;
                } else {
                    ++errorCounter;
                }
            }
            catch (DevConfigException e) {
                String m = "Fatal Error: Failed to get the default build variant for " + dcVendor + "/" + dcName + "(" + compartmentName + ").";
                this.logMessage(m + " : " + ((Throwable)((Object)e)).getMessage());
                this.traceError(thisMethod, m, (Exception)((Object)e));
                return -9;
            }
            catch (Exception e) {
                String m = "Exception occured in DC build for " + dcVendor + "/" + dcName + "(" + compartmentName + ").";
                this.logMessage(m + " : " + e.getMessage());
                this.traceError(thisMethod, m, e);
                ++errorCounter;
            }
            ++i;
        }
        msg = "Finished build for a total of " + props.length + " DCs." + NL;
        msg = msg + successCounter + " build(s) succeeded, " + errorCounter + " build(s) failed.";
        this.logMessage(msg);
        if (errorCounter > 0) {
            return -22;
        }
        return 0;
    }

    private void logNewLine() {
        this.m_userLogStream.println();
    }

    private void logBuildResult(IBuildResult buildResult, IDCProxy dc) {
        String m = "";
        switch (buildResult.getResultCode()) {
            case 2: {
                m = "BUILD FAILED " + NL + "   Build failed for DC " + dc;
                break;
            }
            case 3: {
                m = "BUILD FAILED" + NL + "   Build failed  for " + dc + " because of system errors.";
                break;
            }
            case 1: {
                m = "BUILD OK WITH WARNINGS." + NL + "   Build for " + dc + " finished with warnings.";
                break;
            }
            case 0: {
                m = "BUILD OK." + NL + "   Build for " + dc + " finished sucessfully.";
            }
        }
        m = m + NL + "   Build log file: " + buildResult.getBuildLogPath();
        this.logMessage(m);
    }

    public int syncAll(IConnectionContext connectionContext, boolean fromActiveState) {
        IDevelopmentComponentNode dc;
        Iterator it;
        String thisMethod = "syncAll";
        HashSet<IDevelopmentComponentNode> successfulDCs = new HashSet<IDevelopmentComponentNode>();
        HashSet<IDevelopmentComponentNode> failedDCs = new HashSet<IDevelopmentComponentNode>();
        Object[] params = new Object[]{connectionContext.getUserName(), fromActiveState ? "active" : "inactive"};
        this.traceInfo(thisMethod, " called for sync in {1} state. user: {0}", params);
        String msg = "Starting full sync on " + this.m_fullFormat.format(new Date()) + " for configuration " + this.m_config.getConfigurationData().getName() + " in state " + (fromActiveState ? "active" : "inactive");
        this.logMessage(msg);
        List compartmentNodes = this.m_config.getCompartmentNodes();
        if (compartmentNodes != null && compartmentNodes.isEmpty()) {
            msg = "No compartments found. nothing to sync.";
            this.logMessage(msg);
            this.traceInfo(thisMethod, msg);
            return 0;
        }
        this.traceInfo(thisMethod, "going online (if necessary)");
        int result = this.goOnline(connectionContext);
        if (result != 0) {
            return result;
        }
        Iterator iterCompNodes = compartmentNodes.iterator();
        while (iterCompNodes.hasNext()) {
            String wsURL;
            ISoftwareComponentNode scnode;
            ICompartmentNode compNode = (ICompartmentNode)iterCompNodes.next();
            Compartment comp = compNode.getCompartment();
            if (!comp.hasSourceState()) {
                msg = "Compartment " + comp.getName() + " does not contain source code. Skipping ..";
                this.logMessage(msg);
                this.traceInfo(thisMethod, msg);
                continue;
            }
            if (comp.isLocal()) {
                msg = "Compartment " + comp.getName() + " is local only. Skipping ..";
                this.logMessage(msg);
                this.traceInfo(thisMethod, msg);
                continue;
            }
            if (!comp.hasInactiveSourceState() && !fromActiveState) {
                msg = "Compartment " + comp.getName() + " has no inactive source state assigned. Syncing from active state.";
                this.logMessage(msg);
                this.traceInfo(thisMethod, msg);
                fromActiveState = true;
            }
            HashSet dcnodes = new HashSet();
            SourceState srcState = comp.getSourceState();
            if (fromActiveState) {
                scnode = compNode.getActiveSCNode();
                wsURL = Util.concatenatePath((String)srcState.getRepository().getURL(), (String)ConfigUtils.getLocation(srcState), (char)'/');
            } else {
                scnode = compNode.getActiveSCNode();
                wsURL = Util.concatenatePath((String)srcState.getRepository().getURL(), (String)ConfigUtils.getInactiveLocation(srcState), (char)'/');
            }
            this.logMessage("Getting list of DCs in workspace " + wsURL);
            try {
                this.addDCNodesFromSubtree(scnode, dcnodes, failedDCs);
            }
            catch (RepositoryAccessException e) {
                ErrorStrings.ErrorResult res = ErrorStrings.fromRepositoryAccessException(e);
                String errorString = res.getErrorString();
                String m = "Failed to get component list: " + errorString;
                this.logMessage(m + " (" + ((Throwable)((Object)e)).getMessage() + ")");
                this.traceError(thisMethod, m, (Exception)((Object)e));
                return res.getErrorCode();
            }
            if (dcnodes.isEmpty()) {
                msg = "Compartment " + comp.getName() + " does not contain any components. Skipping ..";
                this.logMessage(msg);
                this.traceInfo(thisMethod, msg);
                continue;
            }
            this.logMessage("Syncing " + dcnodes.size() + " DCs in compartment " + comp.getName());
            Iterator iterDCs = dcnodes.iterator();
            while (iterDCs.hasNext()) {
                IDCProxy dcproxy;
                IDevelopmentComponentNode dcNode = (IDevelopmentComponentNode)iterDCs.next();
                this.logNewLine();
                this.logMessage("Trying to sync DC " + dcNode);
                try {
                    dcproxy = this.m_config.getDevelopmentComponentProxy(comp.getName(), dcNode.getVendor(), dcNode.getName(), fromActiveState);
                }
                catch (DevConfigException e1) {
                    result = -7;
                    Throwable cause = e1.getCause();
                    String errorString = null;
                    if (cause != null) {
                        if (cause instanceof SyncException) {
                            SyncException syncEx = (SyncException)((Object)cause);
                            errorString = ErrorStrings.fromSyncException(syncEx);
                        }
                        if (cause instanceof RepositoryAccessException) {
                            RepositoryAccessException reposException = (RepositoryAccessException)((Object)cause);
                            ErrorStrings.ErrorResult res = ErrorStrings.fromRepositoryAccessException(reposException);
                            errorString = res.getErrorString();
                        }
                    }
                    errorString = errorString != null ? errorString + NL + "   details: " + ((Throwable)((Object)e1)).getMessage() : ((Throwable)((Object)e1)).getMessage();
                    errorString = errorString + NL + "   Could not get DC Proxy for " + dcNode;
                    errorString = "*** ERROR **** Sync failed for " + dcNode + NL + "   " + errorString;
                    errorString = errorString + NL + "   Skipping DC " + dcNode;
                    this.logMessage(errorString);
                    this.traceError(thisMethod, errorString, (Exception)((Object)e1));
                    failedDCs.add(dcNode);
                    continue;
                }
                try {
                    dcproxy.syncAsSources(!fromActiveState, true);
                    this.logMessage("Sucessfully synced DC " + dcNode);
                    successfulDCs.add(dcNode);
                }
                catch (SyncException e2) {
                    String errorString = null;
                    errorString = ErrorStrings.fromSyncException(e2);
                    errorString = errorString != null ? errorString + NL + "   details: " + ((Throwable)((Object)e2)).getMessage() : ((Throwable)((Object)e2)).getMessage();
                    errorString = "*** ERROR **** Sync failed for " + dcNode + NL + "   " + errorString;
                    errorString = errorString + NL + "   Skipping DC " + dcNode;
                    this.logMessage(errorString);
                    this.traceError(thisMethod, errorString, (Exception)((Object)e2));
                    failedDCs.add(dcNode);
                }
            }
            this.logMessage("Finished syncing DCs from compartment " + comp.getName());
        }
        msg = "Finished syncing DCs.";
        if (!failedDCs.isEmpty()) {
            msg = msg + NL + "   Sync failed for " + failedDCs.size() + " DCs:";
            it = failedDCs.iterator();
            while (it.hasNext()) {
                dc = (IDevelopmentComponentNode)it.next();
                msg = msg + NL + "      FAILED " + dc;
            }
        }
        if (!successfulDCs.isEmpty()) {
            msg = msg + NL + "   Sync succeeded for " + successfulDCs.size() + " DCs:";
            it = successfulDCs.iterator();
            while (it.hasNext()) {
                dc = (IDevelopmentComponentNode)it.next();
                msg = msg + NL + "      OK " + dc;
            }
        }
        this.logMessage(msg);
        return result;
    }

    private void addDCNodesFromSubtree(ISoftwareComponentNode scnode, Set dcnodes, Set failedDCs) throws RepositoryAccessException {
        List children = scnode.getChildren();
        if (children != null) {
            Iterator it = children.iterator();
            while (it.hasNext()) {
                IDevelopmentComponentNode dcnode = (IDevelopmentComponentNode)it.next();
                dcnodes.add(dcnode);
                this.addDCNodesFromSubtree(dcnode, dcnodes, failedDCs);
            }
        }
    }

    private void addDCNodesFromSubtree(IDevelopmentComponentNode dcnode, Set dcnodes, Set failedDCs) throws RepositoryAccessException {
        List children;
        try {
            children = dcnode.getChildren();
        }
        catch (InvalidDefinitionException e) {
            LOCATION.catching("addDCNodesFromSubtree", (Throwable)((Object)e));
            String msg = "*** ERROR *** : Could not read definition of " + dcnode;
            msg = msg + NL + "   details: " + ((Throwable)((Object)e)).getMessage() + NL + "   Skipping this DC and all it's inner DCs that may exist.";
            failedDCs.add(dcnode);
            return;
        }
        if (children != null) {
            Iterator it = children.iterator();
            while (it.hasNext()) {
                IDevelopmentComponentNode childNode = (IDevelopmentComponentNode)it.next();
                dcnodes.add(childNode);
                this.addDCNodesFromSubtree(childNode, dcnodes, failedDCs);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class BuildProperties
    implements ILocalBuildProperties {
        private String m_buildLocation;
        private long m_buildCounter;
        private String m_pathJDK;
        private String m_jdkKey;

        public BuildProperties(DevelopmentConfiguration config) throws DevConfigException {
            BuildSettings settings = new BuildSettings(config);
            this.m_jdkKey = settings.getRequiredSDK() + "_HOME";
        }

        public String getProperty(String key) {
            String value = null;
            if (key.equalsIgnoreCase(this.m_jdkKey)) {
                value = this.m_pathJDK;
            }
            if (value == null) {
                value = System.getProperty(key);
            }
            return value;
        }

        public void setProperty(String key, String value) {
            if (key.equalsIgnoreCase(this.m_jdkKey)) {
                this.m_pathJDK = value;
            } else {
                ((Hashtable)System.getProperties()).put(key, value);
            }
        }

        public long getBuildCounter() {
            return this.m_buildCounter;
        }

        public String getBuildLocation() {
            return this.m_buildLocation;
        }

        public void setJDKPath(String value) {
            this.m_pathJDK = value;
        }

        public void setBuildCounter(long buildCounter) {
            this.m_buildCounter = buildCounter;
        }

        public void setBuildLocation(String buildLocation) {
            this.m_buildLocation = buildLocation;
        }

        public List getBuildPropertiesNames() {
            List nameList = null;
            return nameList;
        }
    }
}

