/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.dctool.impl;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;

public class BuildListParser {
    private static final int READ_OPTION = 0;
    private static final int READ_ARGUMENT = 1;
    private static final int SKIP_MODE = 2;
    private static final int NUMOFOPTIONS = 3;

    private StreamTokenizer getTokenizer(FileReader reader) {
        StreamTokenizer tokenizer = new StreamTokenizer(reader);
        tokenizer.wordChars(45, 45);
        tokenizer.wordChars(95, 95);
        tokenizer.wordChars(46, 46);
        tokenizer.wordChars(33, 33);
        tokenizer.wordChars(36, 36);
        tokenizer.wordChars(47, 47);
        tokenizer.ordinaryChar(61);
        tokenizer.ordinaryChar(35);
        tokenizer.eolIsSignificant(true);
        return tokenizer;
    }

    private boolean isValidOption(String opt) {
        if (opt == null) {
            return false;
        }
        return opt.equalsIgnoreCase("s") || opt.equalsIgnoreCase("n") || opt.equalsIgnoreCase("v");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties[] parseBuildList(String filename) throws FileNotFoundException, Exception {
        ArrayList<Properties> retVal = new ArrayList<Properties>();
        if (filename == null) {
            throw new FileNotFoundException("File name for build list has not been specified");
        }
        FileReader reader = null;
        reader = new FileReader(filename);
        StreamTokenizer tokenizer = this.getTokenizer(reader);
        try {
            try {
                int oldState = 0;
                int currentState = 0;
                int token = tokenizer.nextToken();
                String lastOption = null;
                String lastArgument = null;
                Properties currentProps = new Properties();
                while (true) {
                    if (token == -1) {
                        if (currentProps == null || ((Hashtable)currentProps).size() >= 3 || ((Hashtable)currentProps).size() <= 0) break;
                        throw new Exception("The last DC build specification in build list " + filename + " is incomplete");
                    }
                    String location = " at line " + tokenizer.lineno() + " of build list file " + filename;
                    switch (token) {
                        case -3: {
                            if (currentState == 2) break;
                            String word = tokenizer.sval;
                            if (currentState == 0) {
                                if (!this.isValidOption(word)) throw new Exception("Found illegal option '" + word + "'" + location);
                                lastOption = word;
                                currentState = 1;
                                break;
                            }
                            lastArgument = word;
                            if (((Hashtable)currentProps).containsKey(lastOption)) {
                                throw new Exception("Option '" + lastOption + "' occured multiple times for one DC build" + location);
                            }
                            currentProps.setProperty(lastOption, lastArgument);
                            if (((Hashtable)currentProps).size() == 3) {
                                retVal.add(currentProps);
                                currentProps = new Properties();
                            }
                            currentState = 0;
                            break;
                        }
                        case 10: {
                            if (currentState != 2) break;
                            currentState = oldState;
                            break;
                        }
                        case 35: {
                            if (currentState == 2) break;
                            oldState = currentState;
                            currentState = 2;
                            break;
                        }
                        case 61: {
                            break;
                        }
                        default: {
                            if (currentState != 2) throw new Exception("Found illegal token " + location);
                            break;
                        }
                    }
                    token = tokenizer.nextToken();
                }
                Object var14_14 = null;
            }
            catch (Exception e) {
                throw new Exception(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e1) {}
        reader.close();
        return retVal.toArray(new Properties[retVal.size()]);
    }
}

