/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.dctool;

import com.sap.tc.cbs.util.Util;
import com.sap.tc.devconf.ConnectionContext;
import com.sap.tc.devconf.IConnectionContext;
import com.sap.tc.devconf.dctool.DCToolCmdLine;
import com.sap.tc.devconf.dctool.impl.DCToolFactory;
import com.sap.tc.devconf.dctool.impl.IDCTool;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.ssl.util.PKCS7CertificateImport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.util.Iterator;
import java.util.List;

public class DCToolMain {
    private static Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$dctool$DCToolMain == null ? (class$com$sap$tc$devconf$dctool$DCToolMain = DCToolMain.class$("com.sap.tc.devconf.dctool.DCToolMain")) : class$com$sap$tc$devconf$dctool$DCToolMain));
    private static final int NOEXCEPTION = 0;
    private static final int ERROR = 99999;
    String m_ls;
    DCToolCmdLine m_cmdLine = new DCToolCmdLine();
    int m_exitValue;
    String m_jdkPath;
    String m_localArcRoot;
    static /* synthetic */ Class class$com$sap$tc$devconf$dctool$DCToolMain;

    public DCToolMain() {
        this.m_ls = System.getProperty("line.separator");
        System.err.println("Info: DCTool environment variables: ");
        this.m_jdkPath = System.getProperty("com.sap.tc.dctool.JDK_PATH");
        this.m_localArcRoot = System.getProperty("com.sap.tc.dctool.LOCALARC");
        System.err.println("   com.sap.tc.dctool.JDK_PATH: " + this.m_jdkPath);
        System.err.println("   com.sap.tc.dctool.LOCALARC: " + this.m_localArcRoot);
        if (this.m_ls.equals("")) {
            this.m_ls = "\r\n";
        }
        this.m_exitValue = 0;
    }

    public static void main(String[] args) {
        DCToolMain dcToolMain = new DCToolMain();
        dcToolMain.run(args);
        System.exit(dcToolMain.m_exitValue);
    }

    private void run(String[] args) {
        List errors = this.m_cmdLine.processCmdLine(args);
        String cmdline = new String();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-p")) {
                cmdline = cmdline + args[i] + " ***** ";
                ++i;
            } else {
                cmdline = cmdline + args[i] + " ";
            }
            ++i;
        }
        if (errors.size() > 0) {
            System.out.println("DCToolMain was called with command line:");
            System.out.println("  " + cmdline + "\n");
            System.out.println("Command line contains invalid entries:");
            Iterator it = errors.iterator();
            while (it.hasNext()) {
                String msg = (String)it.next();
                System.out.println("Error: " + msg);
            }
            System.out.println(this.m_ls + "DCToolMain is a command line tool that allows you to execute commands \r\nwith regard to component development. A certain command is specified via \r\ncommand line: -c <command>\r\n\r\nYou can execute the following commands: \r\n\r\nsync\r\nsyncall\r\nbuild\r\nbuildall\r\n\r\nYou can execute exactly one command per DCToolMain call via command line.\r\nTo get more information on a specific command use command line option -h\r\ntogether with the command name without blanks in between.\r\nFor example to get information on command build type: -h build\r\n\r\n");
            this.m_exitValue = 99999;
            return;
        }
        this.evalCmdLine(cmdline);
    }

    private void evalCmdLine(String cmdlineStr) {
        if (this.m_cmdLine.optionDefined("-h")) {
            String optArg = this.m_cmdLine.getArgument("-h");
            if (optArg != null) {
                String info = this.m_cmdLine.commandInfo(optArg) + this.m_ls;
                System.out.println(info);
                return;
            }
            System.out.println("DCToolMain is a command line tool that allows you to execute commands \r\nwith regard to component development. A certain command is specified via \r\ncommand line: -c <command>\r\n\r\nYou can execute the following commands: \r\n\r\nsync\r\nsyncall\r\nbuild\r\nbuildall\r\n\r\nYou can execute exactly one command per DCToolMain call via command line.\r\nTo get more information on a specific command use command line option -h\r\ntogether with the command name without blanks in between.\r\nFor example to get information on command build type: -h build\r\n\r\n");
            return;
        }
        if (!this.m_cmdLine.optionDefined("-c")) {
            System.out.println("Error: no command has been specified in command line." + this.m_ls);
            System.out.println("DCToolMain is a command line tool that allows you to execute commands \r\nwith regard to component development. A certain command is specified via \r\ncommand line: -c <command>\r\n\r\nYou can execute the following commands: \r\n\r\nsync\r\nsyncall\r\nbuild\r\nbuildall\r\n\r\nYou can execute exactly one command per DCToolMain call via command line.\r\nTo get more information on a specific command use command line option -h\r\ntogether with the command name without blanks in between.\r\nFor example to get information on command build type: -h build\r\n\r\n");
            this.m_exitValue = 99999;
            return;
        }
        Params p = new Params();
        System.err.println(this.m_ls + "INFO: DCToolMain was launched " + Util.normalDateFormat() + this.m_ls + "with command line: " + this.m_ls + cmdlineStr + this.m_ls + this.m_ls);
        try {
            this.execCommand(p);
        }
        catch (Exception e) {
            LOCATION.catching("evalCmdLine", (Throwable)e);
            String exceptionStr = Util.printStackTraceToString((Throwable)e);
            if (this.m_exitValue == 0) {
                this.m_exitValue = 99999;
            }
            System.err.println(exceptionStr);
        }
        System.err.println(this.m_ls + "INFO: DCToolMain finished at " + Util.normalDateFormat());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void execCommand(Params p) {
        DCToolFactory.ReturnValue retVal = null;
        if (p.devConfRootFolder != null && this.m_localArcRoot != null && p.logPropFile != null) {
            File f = new File(p.logPropFile);
            retVal = DCToolFactory.createInstance(p.devConfRootFolder, this.m_localArcRoot, System.out, f);
        } else if (p.devConfRootFolder != null && this.m_localArcRoot != null) {
            retVal = DCToolFactory.createInstance(p.devConfRootFolder, this.m_localArcRoot, p.severity);
        } else {
            if (p.devConfRootFolder == null) {
                String msg = "Mandatory parameter '-f' missing." + this.m_ls + "   parameter: root directory of your development configuration.";
                System.out.println(msg);
                this.m_exitValue = 99999;
                return;
            }
            if (this.m_localArcRoot == null) {
                String msg = "Mandatory system property \"com.sap.tc.dctool.LOCALARC\" missing." + this.m_ls + "   This property is specified via -Dcom.sap.tc.dctool.LOCALARC=<value> in the java call" + this.m_ls + "   whereas <value> represents the folder with components that are locally installed as archives.";
                System.out.println(msg);
                this.m_exitValue = 99999;
                return;
            }
        }
        if (retVal == null) {
            System.out.println("INTERNAL ERROR. Execution is stopped (creation of DCTool instance failed).");
            System.err.println("INTERNAL ERROR. Object returned by DCToolFactory is null, execution is stopped.");
            this.m_exitValue = 99999;
            return;
        }
        if (retVal.getSucesscode() != 0) {
            this.m_exitValue = retVal.getSucesscode();
            String msg = "Could not initialize configuration. Error code: " + this.m_exitValue + ". Execution is stopped.";
            System.out.println(msg);
            System.err.println(msg);
            System.err.println("DCToolFactory returned error code " + this.m_exitValue + ", execution is stopped.");
            return;
        }
        IDCTool dcTool = retVal.getInstance();
        if (p.cmd.equalsIgnoreCase("build")) {
            if (p.compartmentID != null && p.dcVendor != null && p.dcName != null && p.buildVariant != null && this.m_jdkPath != null) {
                this.m_exitValue = dcTool.buildDC(p.compartmentID, p.dcVendor, p.dcName, p.buildVariant, this.m_jdkPath);
                return;
            }
            if (p.compartmentID != null && p.dcVendor != null && p.dcName != null && this.m_jdkPath != null) {
                this.m_exitValue = dcTool.buildDC(p.compartmentID, p.dcVendor, p.dcName, this.m_jdkPath);
                return;
            }
            this.showCommandUsage(p.cmd);
            return;
        }
        if (p.cmd.equalsIgnoreCase("buildall")) {
            if (this.m_jdkPath != null) {
                this.m_exitValue = dcTool.buildAll(this.m_jdkPath);
                return;
            }
            this.showCommandUsage(p.cmd);
            return;
        }
        if (p.cmd.equalsIgnoreCase("sync")) {
            if (p.compartmentID != null && p.dcVendor != null && p.dcName != null && p.usr != null && p.pwd != null) {
                IConnectionContext ctx = this.getConnectionContext(p);
                if (ctx == null) {
                    return;
                }
                this.m_exitValue = dcTool.syncDC(p.compartmentID, p.dcVendor, p.dcName, ctx, p.active);
                return;
            }
            this.showCommandUsage(p.cmd);
            return;
        }
        if (p.cmd.equalsIgnoreCase("syncall")) {
            if (p.usr != null && p.pwd != null) {
                IConnectionContext ctx = this.getConnectionContext(p);
                if (ctx == null) {
                    return;
                }
                this.m_exitValue = dcTool.syncAll(ctx, p.active);
                return;
            }
            this.showCommandUsage(p.cmd);
            return;
        }
        if (!p.cmd.equalsIgnoreCase("buildlist")) {
            this.m_exitValue = 99999;
            System.out.println("Error: invalid command " + p.cmd + this.m_ls);
            System.out.println("DCToolMain is a command line tool that allows you to execute commands \r\nwith regard to component development. A certain command is specified via \r\ncommand line: -c <command>\r\n\r\nYou can execute the following commands: \r\n\r\nsync\r\nsyncall\r\nbuild\r\nbuildall\r\n\r\nYou can execute exactly one command per DCToolMain call via command line.\r\nTo get more information on a specific command use command line option -h\r\ntogether with the command name without blanks in between.\r\nFor example to get information on command build type: -h build\r\n\r\n");
            return;
        }
        if (this.m_jdkPath != null && p.buildListFile != null) {
            this.m_exitValue = dcTool.buildList(this.m_jdkPath, p.buildListFile);
            return;
        }
        this.showCommandUsage(p.cmd);
    }

    private IConnectionContext getConnectionContext(Params p) {
        String thisMethod = "getConnectionContext";
        File keyStoreFile = null;
        if (p.serverCertificatesKeystoreFile != null && !(keyStoreFile = new File(p.serverCertificatesKeystoreFile)).exists()) {
            this.m_exitValue = 99999;
            System.out.println("Error: invalid value for option -k. File does not exist: " + p.serverCertificatesKeystoreFile);
            return null;
        }
        KeyStore serverCertsKeyStore = null;
        if (keyStoreFile != null) {
            PKCS7CertificateImport importer = new PKCS7CertificateImport();
            try {
                serverCertsKeyStore = importer.importCertificates((InputStream)new FileInputStream(keyStoreFile), null);
            }
            catch (KeyStoreException e) {
                LOCATION.catching(thisMethod, (Throwable)e);
                this.m_exitValue = 99999;
                System.out.println("Error: failed to read key store file: ");
                System.out.print("    ");
                System.out.print(e.getMessage());
                System.out.println("(KeyStoreException)");
                System.out.println("    Check if \"" + p.serverCertificatesKeystoreFile + "\" is a valid key store file");
                return null;
            }
            catch (CertificateException e) {
                LOCATION.catching(thisMethod, (Throwable)e);
                this.m_exitValue = 99999;
                System.out.println("Error: failed to read certificates from key store file: ");
                System.out.print("    ");
                System.out.print(e.getMessage());
                System.out.println("(CertificateException)");
                System.out.println("    Check if \"" + p.serverCertificatesKeystoreFile + "\" is a valid key store file");
                return null;
            }
            catch (FileNotFoundException e) {
                LOCATION.catching(thisMethod, (Throwable)e);
                this.m_exitValue = 99999;
                System.out.println("Error: The system could not find the key store file \"" + p.serverCertificatesKeystoreFile + "\" :" + e.getMessage());
                return null;
            }
        }
        ConnectionContext ctx = new ConnectionContext(p.usr, p.pwd, serverCertsKeyStore, null);
        return ctx;
    }

    private void showCommandUsage(String cmd) {
        if (cmd == null) {
            return;
        }
        System.out.println("Invalid arguments for command " + cmd + this.m_ls);
        System.out.println(this.m_cmdLine.commandInfo(cmd));
        if (cmd.equalsIgnoreCase("build") || cmd.equalsIgnoreCase("buildall")) {
            System.out.println("System property com.sap.tc.dctool.JDK_PATH is also required." + this.m_ls + "This property is specified via -Dcom.sap.tc.dctool.JDK_PATH=<value> in the java call" + this.m_ls + "whereas <value> represents the root folder of JDK installation." + this.m_ls);
        }
        this.m_exitValue = 99999;
    }

    private String stripQuotes(String arg) {
        if (arg == null) {
            return arg;
        }
        if (arg.length() == 0) {
            return arg;
        }
        if (arg.startsWith("\"") && arg.endsWith("\"")) {
            arg = arg.substring(1, arg.length() - 1);
        }
        return arg;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Params {
        private static final String PWDSTR = "*****";
        public String logPropFile;
        public String usr;
        public String pwd;
        public String devConfRootFolder;
        public String cmd;
        public String dcName;
        public String dcVendor;
        public String compartmentID;
        public String buildVariant;
        public String severity;
        public boolean active;
        public boolean help;
        public String serverCertificatesKeystoreFile;
        public String buildListFile;

        public Params() {
            this.reset();
            this.assignParams();
        }

        public void reset() {
            this.logPropFile = null;
            this.usr = null;
            this.pwd = null;
            this.devConfRootFolder = null;
            this.cmd = null;
            this.dcName = null;
            this.dcVendor = null;
            this.compartmentID = null;
            this.buildVariant = null;
            this.severity = null;
            this.active = false;
            this.help = false;
            this.serverCertificatesKeystoreFile = null;
            this.buildListFile = null;
        }

        public void assignParams() {
            if (DCToolMain.this.m_cmdLine.optionDefined("-a")) {
                this.active = true;
            }
            if (DCToolMain.this.m_cmdLine.optionDefined("-h")) {
                this.help = true;
            }
            this.cmd = DCToolMain.this.m_cmdLine.getArgument("-c");
            this.usr = DCToolMain.this.m_cmdLine.getArgument("-u");
            this.pwd = DCToolMain.this.m_cmdLine.getArgument("-p");
            if (this.pwd != null) {
                this.pwd = DCToolMain.this.stripQuotes(this.pwd);
            }
            this.dcVendor = DCToolMain.this.m_cmdLine.getArgument("-v");
            this.dcName = DCToolMain.this.m_cmdLine.getArgument("-n");
            this.compartmentID = DCToolMain.this.m_cmdLine.getArgument("-s");
            this.devConfRootFolder = DCToolMain.this.m_cmdLine.getArgument("-f");
            this.buildVariant = DCToolMain.this.m_cmdLine.getArgument("-b");
            this.severity = DCToolMain.this.m_cmdLine.getArgument("-d");
            this.logPropFile = DCToolMain.this.m_cmdLine.getArgument("-t");
            this.serverCertificatesKeystoreFile = DCToolMain.this.m_cmdLine.getArgument("-k");
            this.buildListFile = DCToolMain.this.m_cmdLine.getArgument("-l");
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("cmd: " + this.objVal(this.cmd) + DCToolMain.this.m_ls);
            sb.append("usr: " + this.objVal(this.usr) + DCToolMain.this.m_ls);
            sb.append("pwd: *****" + DCToolMain.this.m_ls);
            sb.append("dcVendor: " + this.objVal(this.dcVendor) + DCToolMain.this.m_ls);
            sb.append("dcName: " + this.objVal(this.dcName) + DCToolMain.this.m_ls);
            sb.append("compartmentID: " + this.objVal(this.compartmentID) + DCToolMain.this.m_ls);
            sb.append("configRoot: " + this.objVal(this.devConfRootFolder) + DCToolMain.this.m_ls);
            sb.append("buildVariant: " + this.objVal(this.buildVariant) + DCToolMain.this.m_ls);
            sb.append("severity: " + this.objVal(this.severity) + DCToolMain.this.m_ls);
            sb.append("logPropFile: " + this.objVal(this.logPropFile) + DCToolMain.this.m_ls);
            sb.append("active: " + this.boolVal(this.active) + DCToolMain.this.m_ls);
            sb.append("help: " + this.boolVal(this.help) + DCToolMain.this.m_ls);
            sb.append("buildListFile: " + this.objVal(this.buildListFile) + DCToolMain.this.m_ls);
            return sb.toString();
        }

        private String boolVal(boolean b) {
            Boolean b2 = new Boolean(b);
            return b2.toString();
        }

        private String objVal(Object o) {
            if (o == null) {
                return new String("<null>");
            }
            return o.toString();
        }
    }
}

