/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.dctool;

import com.sap.tc.buildutility.GetOptions;
import java.util.HashMap;
import java.util.List;

public class DCToolCmdLine {
    private static final String LS = "\r\n";
    public static final String OPT_LOGPROP = "-t";
    public static final String OPT_USR = "-u";
    public static final String OPT_PWD = "-p";
    public static final String OPT_DEVCONF_ROOT = "-f";
    public static final String OPT_CMD = "-c";
    public static final String OPT_DCNAME = "-n";
    public static final String OPT_DCVENDOR = "-v";
    public static final String OPT_BUILDVAR = "-b";
    public static final String OPT_CPID = "-s";
    public static final String OPT_SEVERITY = "-d";
    public static final String OPT_ACTIVE = "-a";
    public static final String OPT_HELP = "-h";
    public static final String OPT_KEYSTORE = "-k";
    public static final String OPT_LIST = "-l";
    public static final String CMD_SYNC = "sync";
    public static final String CMD_SYNCALL = "syncall";
    public static final String CMD_BUILD = "build";
    public static final String CMD_BUILDALL = "buildall";
    public static final String CMD_BUILDLIST = "buildlist";
    public static final String USAGE = "DCToolMain is a command line tool that allows you to execute commands \r\nwith regard to component development. A certain command is specified via \r\ncommand line: -c <command>\r\n\r\nYou can execute the following commands: \r\n\r\nsync\r\nsyncall\r\nbuild\r\nbuildall\r\n\r\nYou can execute exactly one command per DCToolMain call via command line.\r\nTo get more information on a specific command use command line option -h\r\ntogether with the command name without blanks in between.\r\nFor example to get information on command build type: -h build\r\n\r\n";
    String[] validOpts = new String[]{"-t", "-u", "-p", "-f", "-c", "-n", "-v", "-b", "-s", "-d", "-a", "-h", "-k", "-l"};
    boolean[] argsRequired = new boolean[]{true, true, true, true, true, true, true, true, true, true, false, false, true, true};
    HashMap optionMap = new HashMap();
    List errors;

    public List processCmdLine(String[] args) {
        GetOptions getopts = new GetOptions(args, this.validOpts, this.argsRequired, false);
        List errors = getopts.getErrorList();
        if (errors.size() > 0) {
            return errors;
        }
        this.optionMap.clear();
        String lastopt = null;
        while (getopts.hasNext()) {
            String opt = getopts.getOption();
            String value = getopts.getOptionValue();
            if (opt != null) {
                if (this.optionMap.containsKey(opt)) {
                    errors.add("Option " + opt + " occured multiple times");
                } else {
                    if ((opt.equalsIgnoreCase(OPT_LOGPROP) || opt.equalsIgnoreCase(OPT_USR) || opt.equalsIgnoreCase(OPT_PWD) || opt.equalsIgnoreCase(OPT_DEVCONF_ROOT) || opt.equalsIgnoreCase(OPT_CMD) || opt.equalsIgnoreCase(OPT_DCNAME) || opt.equalsIgnoreCase(OPT_DCVENDOR) || opt.equalsIgnoreCase(OPT_BUILDVAR) || opt.equalsIgnoreCase(OPT_CPID) || opt.equalsIgnoreCase(OPT_KEYSTORE) || opt.equalsIgnoreCase(OPT_SEVERITY) || opt.equalsIgnoreCase(OPT_LIST)) && value == null) {
                        errors.add("Option " + opt + " requires an argument");
                    }
                    this.optionMap.put(opt, value);
                }
            } else if (lastopt != null && lastopt.equals(OPT_HELP) && this.optionDefined(OPT_HELP) && this.getArgument(OPT_HELP) == null) {
                this.optionMap.put(lastopt, value);
            }
            lastopt = opt;
        }
        return errors;
    }

    public boolean optionDefined(String opt) {
        return this.optionMap.containsKey(opt);
    }

    public String getArgument(String opt) {
        if (this.optionDefined(opt)) {
            return (String)this.optionMap.get(opt);
        }
        return null;
    }

    public String commandInfo(String cmd) {
        String msg = "";
        if (cmd == null) {
            return "<null> has been passed as command name";
        }
        String usrPwd = "   -u, parameter: user\r\n   -p, parameter: password\r\n";
        String helpKeyStore = "   -k, parameter: key store file with server certificates (for SSL)\r\n";
        String dcInfo = "   -n, parameter: name of development component vendor\r\n   -v, parameter: name of the development component\r\n   -s, parameter: name of the compartment\r\n";
        String rootDirs = "   -f, parameter: root directory of DTR client configuration\r\n";
        String buildVariant = "   -b, parameter: build variant of the development component\r\n";
        String active = "   -a, no parameter required, indicates if active workspace is considered\r\n";
        String logprop = "   -t, parameter: file that contains logging/tracing properties\r\n";
        String severity = "   -d, parameter: logging/tracing severity (allowed values: DEBUG|INFO|WARNING|ERROR)\r\n";
        String buildList = "   -l, parameter: build list file\r\n";
        String header1 = "Command " + cmd + " requires following options/parameters:" + LS;
        String header2 = "The following options/parameters are optional for command " + cmd + ":" + LS;
        if (cmd.equalsIgnoreCase(CMD_SYNC)) {
            msg = header1 + rootDirs + dcInfo + usrPwd + LS + header2 + active + logprop + severity + helpKeyStore;
            return msg;
        }
        if (cmd.equalsIgnoreCase(CMD_SYNCALL)) {
            msg = header1 + rootDirs + usrPwd + LS + header2 + active + logprop + severity + helpKeyStore;
            return msg;
        }
        if (cmd.equalsIgnoreCase(CMD_BUILD)) {
            msg = header1 + rootDirs + dcInfo + LS + header2 + buildVariant + logprop + severity;
            return msg;
        }
        if (cmd.equalsIgnoreCase(CMD_BUILDALL)) {
            msg = header1 + rootDirs + LS + header2 + logprop + severity;
            return msg;
        }
        if (cmd.equalsIgnoreCase(CMD_BUILDLIST)) {
            msg = header1 + rootDirs + buildList + LS + header2 + logprop + severity;
            return msg;
        }
        return "Unknown command " + cmd;
    }
}

