/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

class Node
implements Comparable {
    private static final String MSG_ILLEGAL_CLASS = "Object is not Node!";
    private static final String MSG_ILLEGAL_KEY_COMPONENT = "Key component may not be null!";
    private Comparable _key;
    private List _arcs = new ArrayList(0);
    private boolean _isPassed;
    private int _activeArcsCount;

    Node(Comparable source) {
        if (source == null) {
            throw new IllegalArgumentException(MSG_ILLEGAL_KEY_COMPONENT);
        }
        this._key = source;
    }

    public Comparable getKey() {
        return this._key;
    }

    boolean isPassed() {
        return this._isPassed;
    }

    void setPassed(boolean isPassed) {
        this._isPassed = isPassed;
    }

    public boolean hasArcsTo(Comparable target) {
        return this._arcs.contains(target);
    }

    public boolean add(Comparable object) {
        if (this._arcs.contains(object)) {
            return false;
        }
        this._arcs.add(object);
        ++this._activeArcsCount;
        return true;
    }

    public boolean addAll(Collection c) {
        boolean result = false;
        Iterator cIter = c.iterator();
        while (cIter.hasNext()) {
            boolean bl = result = this.add((Comparable)cIter.next()) || result;
        }
        return result;
    }

    void deactivateArcTo(Comparable target) {
        Iterator elements = this._arcs.iterator();
        while (elements.hasNext()) {
            Object obj = elements.next();
            if (!obj.equals(target)) continue;
            --this._activeArcsCount;
        }
    }

    void removeArcsTo(Comparable target) {
        while (this._arcs.remove(target)) {
            --this._activeArcsCount;
        }
    }

    void resetActiveArcsCount() {
        this._activeArcsCount = this._arcs.size();
    }

    int activeArcsCount() {
        return this._activeArcsCount;
    }

    Comparable[] getAddressedNodeKeys() {
        Comparable[] result = new Comparable[this._arcs.size()];
        this._arcs.toArray(result);
        return result;
    }

    public String toString() {
        return this._key + " -> " + this._arcs;
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            return 1;
        }
        if (obj == this) {
            return 0;
        }
        if (!(obj instanceof Node)) {
            if (this.getKey().getClass().equals(obj.getClass())) {
                return this.getKey().compareTo(obj);
            }
            throw new IllegalArgumentException(MSG_ILLEGAL_CLASS);
        }
        Node dn = (Node)obj;
        if (this.activeArcsCount() < dn.activeArcsCount()) {
            return -1;
        }
        if (this.activeArcsCount() > dn.activeArcsCount()) {
            return 1;
        }
        return this._key.compareTo(dn.getKey());
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }
}

