/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf;

import com.sap.tc.cbs.util.ChainedException;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.PPReference;
import com.sap.tc.devconf.IDevelopmentComponentRef;
import java.text.MessageFormat;

public class IllegalEntityReferenceException
extends ChainedException {
    public static final int ERROR_NOT_USED = 0;
    public static final int ERROR_NOT_FOUND = 1;
    public static final int ERROR_DIFFERNT_PURPOSES = 2;
    private DCReference m_referencedDC;
    private String m_referencedPP;
    private String m_referencingPP;
    private String m_referencingPublicPartPurpose;
    private String m_referencedPublicPartPurpose;
    private IDevelopmentComponentRef m_usingDC;
    private int m_errorCode;
    private static String[] _messagetext = new String[]{"public part \"{0}\" of \"{1}\" has illegal reference to public part \"{2}\" of \"{3}\" . DC must be used explicitly.", "public part \"{0}\" of \"{1}\" has reference to non-existing public part \"{2}\" of component \"{3}\".", "public part \"{0}\" of \"{1}\" with purpose \"{2}\" must not reference public part \"{3}\" of \"{4}\" with purpose \"{5}\". "};

    public static IllegalEntityReferenceException createForNotFound(Throwable cause, IDevelopmentComponentRef usingDC, String usingPP, DCReference usedDC, String usedPP, String usingPPPurpose) {
        String message = MessageFormat.format(_messagetext[1], usingPP, usingDC, usedPP, usedDC);
        IllegalEntityReferenceException e = new IllegalEntityReferenceException(message, cause);
        e.m_errorCode = 1;
        IllegalEntityReferenceException.initialize(usingDC, usingPP, usedDC, usedPP, usingPPPurpose, e);
        e.m_referencedPublicPartPurpose = "";
        return e;
    }

    public static IllegalEntityReferenceException createForNotUsed(Throwable cause, IDevelopmentComponentRef usingDC, String usingPP, DCReference usedDC, String usedPP, String usingPPPurpose) {
        String message = MessageFormat.format(_messagetext[0], usingPP, usingDC, usedPP, usedDC);
        IllegalEntityReferenceException e = new IllegalEntityReferenceException(message, cause);
        e.m_errorCode = 0;
        IllegalEntityReferenceException.initialize(usingDC, usingPP, usedDC, usedPP, usingPPPurpose, e);
        e.m_referencedPublicPartPurpose = "";
        return e;
    }

    public static IllegalEntityReferenceException createForDifferntPurposes(Throwable cause, IDevelopmentComponentRef usingDC, String usingPP, DCReference usedDC, String usedPP, String usingPPPurpose, String referencedPPPurpose) {
        String message = MessageFormat.format(_messagetext[2], usingPP, usingDC, usingPPPurpose, usedPP, usedDC, referencedPPPurpose);
        IllegalEntityReferenceException e = new IllegalEntityReferenceException(message, cause);
        e.m_errorCode = 2;
        IllegalEntityReferenceException.initialize(usingDC, usingPP, usedDC, usedPP, usingPPPurpose, e);
        e.m_referencedPublicPartPurpose = referencedPPPurpose;
        return e;
    }

    private static void initialize(IDevelopmentComponentRef usingDC, String usingPP, DCReference usedDC, String usedPP, String usingPPPurpose, IllegalEntityReferenceException e) {
        e.m_referencedDC = usedDC;
        e.m_referencedPP = usedPP;
        e.m_referencingPP = usingPP;
        e.m_usingDC = usingDC;
        e.m_referencingPublicPartPurpose = usingPPPurpose;
    }

    private IllegalEntityReferenceException(String message, Throwable cause) {
        super(message, cause);
    }

    private static String ppRefToString(PPReference ref) {
        String ppName = ref.getName();
        return ppName + " (" + ref.getComponent().getVendor() + "/" + ref.getComponent().getName() + ")";
    }

    public DCReference getReferencedDC() {
        return this.m_referencedDC;
    }

    public String getReferencedPP() {
        return this.m_referencedPP;
    }

    public String getUsingPP() {
        return this.m_referencingPP;
    }

    public IDevelopmentComponentRef getUsingDC() {
        return this.m_usingDC;
    }

    public String getReferencedPublicPartPurpose() {
        return this.m_referencedPublicPartPurpose;
    }

    public String getReferencingPublicPartPurpose() {
        return this.m_referencingPublicPartPurpose;
    }
}

