/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf;

import com.sap.tc.cbs.util.ChainedException;
import com.sap.tc.complib.DCReference;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentComponentRef;
import com.sap.tc.logging.Location;
import java.text.MessageFormat;

public class IllegalDependencyException
extends ChainedException {
    private DCReference m_reference;
    private String m_ppName = null;
    private DependencyRule m_rule;
    private IDevelopmentComponentRef m_usingDC;

    public IllegalDependencyException(DependencyRule reason, Throwable cause, IDevelopmentComponentRef usingDC, DCReference reference, String targetPP) {
        super(MessageFormat.format(reason.m_text, usingDC, reference), cause);
        this.m_reference = reference;
        this.m_ppName = targetPP;
        this.m_usingDC = usingDC;
        this.m_rule = reason;
    }

    public IllegalDependencyException(DependencyRule reason, Throwable cause, IDevelopmentComponentRef usingDC, DCReference reference) {
        super(MessageFormat.format(reason.m_text, usingDC, reference), cause);
        this.m_reference = reference;
        this.m_usingDC = usingDC;
        this.m_rule = reason;
    }

    public DCReference getReference() {
        return this.m_reference;
    }

    public DependencyRule getRule() {
        return this.m_rule;
    }

    public IDevelopmentComponentRef getUsingDC() {
        return this.m_usingDC;
    }

    public static IllegalDependencyException createException(DependencyRule reason, Throwable cause, IDevelopmentComponentRef usingDC, IDCProxy usedDC, Location logLocation, String method) {
        DCReference reference = new DCReference(usedDC.getComponent().getName(), usedDC.getComponent().getVendor());
        return new IllegalDependencyException(reason, cause, usingDC, reference);
    }

    public static class DependencyRule {
        private static String ACCESS_LIST = "Illegal reference. Access list does not allow use of {1} for {0}.";
        private static String COMPARTMENT = "Illegal reference. The compartment of {0} must explicitly use compartment of {1}.";
        private static String TO_INNER_DC = "Illegal reference. {1} is not visible for component {0}. Inner components are hidden from outside.";
        private static String FROM_INNER_DC = "Illegal reference. Inner component {0} cannot use {1}. Not allowed by parent.";
        private static String INFRASTRUCTURE = "Illegal reference. Normal component {0} may not use build infrastructure component {1}.";
        private static String SELF = "Illegal reference. {0} cannot use itself.";
        private static String NO_DC_VENDOR = "Illegal reference. No DC vendor specified.";
        private static String NO_DC_NAME = "Illegal reference. No DC name specified.";
        private static String NO_PP_NAME = "Illegal public part reference. No public part name specified.";
        private static String NO_DCREF_INPPREF = "Illegal public part reference. No development component specified.";
        private static String ANCESTOR_USAGE = "Illegal reference. Development component {0} cannot use its own ancestor {1}.";
        public static final DependencyRule RULE_ACCESS_LIST = new DependencyRule(ACCESS_LIST);
        public static final DependencyRule RULE_COMPARTMENT = new DependencyRule(COMPARTMENT);
        public static final DependencyRule RULE_TO_INNER_DC = new DependencyRule(TO_INNER_DC);
        public static final DependencyRule RULE_FROM_INNER_DC = new DependencyRule(FROM_INNER_DC);
        public static final DependencyRule RULE_INFRASTRUCTURE = new DependencyRule(INFRASTRUCTURE);
        public static final DependencyRule RULE_SELF = new DependencyRule(SELF);
        public static final DependencyRule RULE_NO_DC_VENDOR = new DependencyRule(NO_DC_VENDOR);
        public static final DependencyRule RULE_NO_DC_NAME = new DependencyRule(NO_DC_NAME);
        public static final DependencyRule RULE_NO_PP_NAME = new DependencyRule(NO_PP_NAME);
        public static final DependencyRule RULE_NO_DCREF = new DependencyRule(NO_DCREF_INPPREF);
        public static final DependencyRule RULE_ANCESTOR = new DependencyRule(ANCESTOR_USAGE);
        private String m_text;

        private DependencyRule(String text) {
            this.m_text = text;
        }
    }
}

