/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf;

import com.sap.tc.devconf.Digraph;
import com.sap.tc.logging.Location;
import java.util.List;

class DigraphTester {
    public static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$DigraphTester == null ? (class$com$sap$tc$devconf$DigraphTester = DigraphTester.class$("com.sap.tc.devconf.DigraphTester")) : class$com$sap$tc$devconf$DigraphTester));
    private String[] vertexes = new String[]{"a1", "a2", "a3", "b1", "b2", "c1", "c2", "c3"};
    static /* synthetic */ Class class$com$sap$tc$devconf$DigraphTester;

    DigraphTester() {
    }

    public static void main(String[] args) {
        new DigraphTester().test();
    }

    public void test() {
        System.out.println("\r\nEmpty Graph");
        this.test(this.getEmptyGraph());
        System.out.println("\r\nOne-Node Graph");
        this.test(this.getOneNodeGraph());
        System.out.println("\r\nLinear Graph");
        this.test(this.getLinearGraph());
        System.out.println("\r\nNon linear Graph");
        this.test(this.getGoodGraph());
        System.out.println("\r\nOne-Node Cyclical Graph");
        this.test(this.getOneNodeCyclicalGraph());
        System.out.println("\r\nCycles in Graph");
        this.test(this.getCyclicalGraph());
        System.out.println("\r\nSpecial Graph 1");
        this.test(this.getSpecialGraph1());
        System.out.println("\r\nSpecial Graph 2");
        this.test(this.getSpecialGraph2());
        System.out.println("\r\nSpecial Graph 3");
        this.test(this.getSpecialGraph3());
        System.out.println("\nTEST COMPLETE");
    }

    private void test(Digraph dg) {
        try {
            System.out.println();
            List cycle = dg.findCycle();
            if (cycle.size() > 0) {
                System.out.println("Cycle(s) building elements:");
                int i = 0;
                while (i < cycle.size()) {
                    System.out.println(cycle.get(i));
                    ++i;
                }
            }
            System.out.println();
        }
        catch (Exception e) {
            LOCATION.catching("test", (Throwable)e);
            e.printStackTrace();
        }
    }

    private Digraph getSpecialGraph1() {
        Digraph dg = new Digraph();
        this.connectNodes(dg, 0, 1);
        this.connectNodes(dg, 1, 2);
        this.connectNodes(dg, 2, 0);
        this.connectNodes(dg, 0, 2);
        return dg;
    }

    private Digraph getSpecialGraph2() {
        Digraph dg = new Digraph();
        this.connectNodes(dg, 0, 1);
        this.connectNodes(dg, 1, 2);
        this.connectNodes(dg, 2, 0);
        this.connectNodes(dg, 1, 0);
        return dg;
    }

    private Digraph getSpecialGraph3() {
        Digraph dg = new Digraph();
        this.connectNodes(dg, 0, 1);
        this.connectNodes(dg, 1, 2);
        this.connectNodes(dg, 2, 0);
        this.connectNodes(dg, 2, 1);
        return dg;
    }

    private Digraph getEmptyGraph() {
        Digraph dg = new Digraph();
        return dg;
    }

    private Digraph getOneNodeGraph() {
        Digraph dg = new Digraph();
        dg.addNode((Comparable)((Object)this.vertexes[0]));
        return dg;
    }

    private Digraph getLinearGraph() {
        Digraph dg = new Digraph();
        this.connectNodes(dg, 6, 7);
        this.connectNodes(dg, 2, 3);
        this.connectNodes(dg, 1, 2);
        this.connectNodes(dg, 5, 6);
        this.connectNodes(dg, 3, 4);
        this.connectNodes(dg, 0, 1);
        this.connectNodes(dg, 4, 5);
        return dg;
    }

    private Digraph getGoodGraph() {
        Digraph dg = new Digraph();
        this.connectNodes(dg, 0, 3);
        this.connectNodes(dg, 3, 5);
        this.connectNodes(dg, 1, 3);
        this.connectNodes(dg, 3, 6);
        this.connectNodes(dg, 1, 4);
        this.connectNodes(dg, 4, 7);
        this.connectNodes(dg, 2, 4);
        this.connectNodes(dg, 4, 6);
        this.connectNodes(dg, 1, 6);
        return dg;
    }

    private Digraph getOneNodeCyclicalGraph() {
        Digraph dg = new Digraph();
        this.connectNodes(dg, 0, 0);
        return dg;
    }

    private Digraph getCyclicalGraph() {
        Digraph dg = new Digraph();
        this.connectNodes(dg, 0, 3);
        this.connectNodes(dg, 3, 5);
        this.connectNodes(dg, 1, 3);
        this.connectNodes(dg, 3, 6);
        this.connectNodes(dg, 1, 4);
        this.connectNodes(dg, 4, 7);
        this.connectNodes(dg, 2, 4);
        this.connectNodes(dg, 4, 6);
        this.connectNodes(dg, 7, 2);
        this.connectNodes(dg, 6, 1);
        this.connectNodes(dg, 5, 3);
        return dg;
    }

    private void connectNodes(Digraph dg, int from, int to) {
        dg.addArc((Comparable)((Object)this.vertexes[from]), (Comparable)((Object)this.vertexes[to]));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

