/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf;

import com.sap.tc.devconf.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Digraph {
    private String SOURCE_IS_NULL = "Source of an arc can not be null";
    private String TARGET_IS_NULL = "Target of an arc can not be null";
    private String TARGETS_IS_NULL = "Targets collection can not be null";
    private static final String CYCLE_EXCEPTION = "Impossible to order because of cycle is detected";
    private List _nodes = new ArrayList();

    private Node getNodeByKey(Comparable key) {
        Node node = null;
        int i = 0;
        while (i < this._nodes.size()) {
            node = (Node)this._nodes.get(i);
            if (key.compareTo(node.getKey()) == 0) {
                return node;
            }
            ++i;
        }
        node = new Node(key);
        this._nodes.add(node);
        return node;
    }

    public void addNode(Comparable key) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException(this.SOURCE_IS_NULL);
        }
        this.getNodeByKey(key);
    }

    public void addArc(Comparable fromKey, Comparable toKey) throws IllegalArgumentException {
        if (fromKey == null) {
            throw new IllegalArgumentException(this.SOURCE_IS_NULL);
        }
        if (toKey == null) {
            throw new IllegalArgumentException(this.TARGET_IS_NULL);
        }
        this.getNodeByKey(toKey);
        Node node = this.getNodeByKey(fromKey);
        node.add(toKey);
    }

    public void addArcs(Comparable fromKey, Collection toKeys) throws IllegalArgumentException {
        if (toKeys == null) {
            throw new IllegalArgumentException(this.TARGETS_IS_NULL);
        }
        Iterator tKeys = toKeys.iterator();
        while (tKeys.hasNext()) {
            this.addArc(fromKey, (Comparable)tKeys.next());
        }
    }

    public List order() throws IllegalStateException {
        ArrayList<Comparable> result = new ArrayList<Comparable>(this._nodes.size());
        while (this._nodes.size() > 0) {
            Comparable key = this.getTopNode().getKey();
            result.add(key);
            this.markNodeAsPassed(key);
        }
        return result;
    }

    public List findCycle() {
        ArrayList<Comparable> resultNodes = new ArrayList<Comparable>();
        while (this._nodes.size() > 0) {
            Collections.sort(this._nodes);
            Node node = (Node)this._nodes.get(0);
            if (node.activeArcsCount() > 0) {
                ArrayList nodesInCycle = new ArrayList();
                this.detectCycle(node, nodesInCycle);
                nodesInCycle.remove(nodesInCycle.size() - 1);
                String postfix = "";
                int i = 0;
                while (i < nodesInCycle.size()) {
                    String prefix = i == 0 ? "-> " : (i == nodesInCycle.size() - 1 ? "<- " : "|  ");
                    String str = ((Node)nodesInCycle.get(i)).getKey().toString();
                    System.out.println(prefix + str + postfix);
                    ++i;
                }
                System.out.println();
                Node node0 = (Node)nodesInCycle.get(0);
                Node node1 = (Node)nodesInCycle.get(nodesInCycle.size() > 1 ? 1 : 0);
                node0.removeArcsTo(node1.getKey());
                Iterator cycleIt = nodesInCycle.iterator();
                while (cycleIt.hasNext()) {
                    Node nodeInCycle = (Node)cycleIt.next();
                    if (resultNodes.contains(nodeInCycle.getKey())) continue;
                    resultNodes.add(nodeInCycle.getKey());
                }
                continue;
            }
            this._nodes.remove(0);
            Comparable key = node.getKey();
            this.markNodeAsPassed(key);
        }
        return resultNodes;
    }

    private boolean detectCycle(Node node, List nodesInCycle) {
        boolean cycleDetected = false;
        if (!node.isPassed()) {
            node.setPassed(true);
            Comparable[] toKeys = node.getAddressedNodeKeys();
            int i = 0;
            while (i < toKeys.length) {
                if (this.detectCycle(this.getNodeByKey(toKeys[i]), nodesInCycle)) {
                    if (nodesInCycle.size() < 2 || nodesInCycle.get(0) != nodesInCycle.get(nodesInCycle.size() - 1)) {
                        nodesInCycle.add(0, node);
                    }
                    cycleDetected = true;
                    break;
                }
                ++i;
            }
            node.setPassed(false);
        } else {
            if (!nodesInCycle.contains(node)) {
                nodesInCycle.add(0, node);
            }
            cycleDetected = true;
        }
        return cycleDetected;
    }

    private Node getTopNode() throws IllegalStateException {
        Collections.sort(this._nodes);
        Node node = (Node)this._nodes.get(0);
        if (node.activeArcsCount() > 0) {
            throw new IllegalStateException("Impossible to order because of cycle is detected\r\nAt least one of used DCs is a part of the cycle:\r\n" + node);
        }
        this._nodes.remove(0);
        return node;
    }

    private void markNodeAsPassed(Comparable key) {
        Iterator nodeIt = this._nodes.iterator();
        while (nodeIt.hasNext()) {
            ((Node)nodeIt.next()).deactivateArcTo(key);
        }
    }

    public void removeArcsTo(Comparable toKey) {
        Iterator nodeIt = this._nodes.iterator();
        while (nodeIt.hasNext()) {
            ((Node)nodeIt.next()).removeArcsTo(toKey);
        }
    }

    public void removeNodeAndArcsTo(Comparable toKey) {
        Iterator nodeIt = this._nodes.iterator();
        while (nodeIt.hasNext()) {
            ((Node)nodeIt.next()).removeArcsTo(toKey);
        }
        Node node = this.getNodeByKey(toKey);
        if (node != null) {
            this._nodes.remove(node);
        }
    }

    public List listNodesWithArcsTo(Comparable toKey) {
        Iterator nodeIt = this._nodes.iterator();
        ArrayList<Comparable> returnList = new ArrayList<Comparable>();
        while (nodeIt.hasNext()) {
            Node node = (Node)nodeIt.next();
            if (!node.hasArcsTo(toKey)) continue;
            returnList.add(node.getKey());
        }
        return returnList;
    }

    public Digraph getBackwardsReachableSubgraph(Comparable startNodeKey) {
        Digraph graph = new Digraph();
        ArrayList<Comparable> remainingNodesKeys = new ArrayList<Comparable>();
        remainingNodesKeys.add(startNodeKey);
        this._listBackwardsReachables(startNodeKey, remainingNodesKeys);
        Iterator nodeIt = this._nodes.iterator();
        while (nodeIt.hasNext()) {
            Node node = (Node)nodeIt.next();
            Comparable key = node.getKey();
            if (!remainingNodesKeys.contains(key)) continue;
            graph.addNode(key);
            Comparable[] targets = node.getAddressedNodeKeys();
            int i = 0;
            while (i < targets.length) {
                Comparable targetKey = targets[i];
                if (remainingNodesKeys.contains(targetKey)) {
                    graph.addArc(key, targetKey);
                }
                ++i;
            }
        }
        return graph;
    }

    public void _listBackwardsReachables(Comparable nodeKey, List currentList) {
        List directUsers = this.listNodesWithArcsTo(nodeKey);
        Iterator iter = directUsers.iterator();
        while (iter.hasNext()) {
            Comparable key = (Comparable)iter.next();
            if (currentList.contains(key)) continue;
            currentList.add(key);
            this._listBackwardsReachables(key, currentList);
        }
    }
}

