/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf;

import com.sap.tc.cbs.client.IBuildSpace;
import com.sap.tc.cbs.util.Util;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.ConfigurationFactory;
import com.sap.tc.complib.Repository;
import com.sap.tc.complib.SourceState;
import com.sap.tc.complib.provider.ConfigurationInputProvider;
import com.sap.tc.complib.provider.FileConfigInputProvider;
import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.complib.validate.ValidationException;
import com.sap.tc.complib.xml.XMLException;
import com.sap.tc.devconf.ConnectionContext;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.DevconfModeException;
import com.sap.tc.devconf.IConnectionContext;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevConfFileMonitor;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.InvalidDefinitionException;
import com.sap.tc.devconf.ObjectsCheckedOutException;
import com.sap.tc.devconf.OfflineException;
import com.sap.tc.devconf.RepositoryAccessException;
import com.sap.tc.devconf.SyncException;
import com.sap.tc.devconf.impl.ConfigUtils;
import com.sap.tc.devconf.impl.DTRClientErrorMapper;
import com.sap.tc.devconf.impl.DcVfsListener;
import com.sap.tc.devconf.impl.DevConfFileMonitor;
import com.sap.tc.devconf.impl.DevelopmentComponentRef;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.impl.VFSHandler;
import com.sap.tc.devconf.impl.syncdb.ComponentSyncDB;
import com.sap.tc.devconf.impl.syncdb.IDCSyncEntry;
import com.sap.tc.devconf.impl.syncdb.SyncMode;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.exceptions.ClientLibraryException;
import com.tssap.dtr.client.lib.vfs.IVfsManagerListener;
import com.tssap.dtr.client.lib.vfs.VersionedFileSystemFactory;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFilterType;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.ConfigurationException;
import com.tssap.dtr.client.lib.vfs.config.IBuildServer;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;
import com.tssap.dtr.client.lib.vfs.config.ILogicalSystem;
import com.tssap.dtr.client.lib.vfs.config.IMountPoint;
import com.tssap.dtr.client.lib.vfs.config.IRepositoryServer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DevelopmentConfigurationFactory {
    public static final String DTR_WORKSPACE_ROOT = "ws/";
    private String m_clientForConfigUnderConstruction = null;
    private static final String SEPARATOR = File.separator;
    private static final int SEPARATOR_LENGTH = SEPARATOR.length();
    private static final Location LOCATION = Location.getLocation((String)"com.sap.tc.devconf.DevelopmentConfigurationFactory");
    private static String nl = System.getProperty("line.separator");
    private static DevelopmentConfigurationFactory theFactory = new DevelopmentConfigurationFactory();
    private static final int INITIAL_PING_REPEATS = 2;
    private static final int INITIAL_PING_TIMEOUT = 30000;
    private static final String PROPERTY_ARCHIVES_ROOT_FOLDER = "com.sap.tc.devconf.ArchivesRoot";
    private final HashMap m_instances = new HashMap();
    private String m_localArchiveRootPath = System.getProperty("com.sap.tc.devconf.ArchivesRoot");
    private int m_pingRepeats = 2;
    private int m_pingTimeout = 30000;
    private DevConfFileMonitor m_fileMonitor;

    private DevelopmentConfigurationFactory() {
        VersionedFileSystemFactory.addVfsManagerListener((IVfsManagerListener)DcVfsListener.getInstance());
    }

    public static DevelopmentConfigurationFactory getInstance() {
        return theFactory;
    }

    public static String getLoggingCategoryName() {
        return "/ComponentBuild/Infrastructure";
    }

    public IDevConfFileMonitor getFileMonitor() {
        return this._getFileMonitor();
    }

    public IDevelopmentConfiguration getDevelopmentConfigurationInstance(String rootFolder, IConnectionContext connectionContext) throws InvalidDefinitionException, RepositoryAccessException {
        if (connectionContext == null) {
            connectionContext = new ConnectionContext(null, null, null, null);
        }
        return this._getDevelopmentConfigurationInstance(rootFolder, null, false, connectionContext, false);
    }

    public IDevelopmentConfiguration getDevelopmentConfigurationInstance(String rootFolder, String vfsRootFolder, Category loggingCategory, boolean isLocalOnlyMode, IConnectionContext connectionContext) throws InvalidDefinitionException, RepositoryAccessException {
        return this.getDevelopmentConfigurationInstance(rootFolder, vfsRootFolder, isLocalOnlyMode, connectionContext);
    }

    public IDevelopmentConfiguration getDevelopmentConfigurationInstance(String rootFolder, String vfsRootFolder, boolean isLocalOnlyMode, IConnectionContext connectionContext) throws InvalidDefinitionException, RepositoryAccessException {
        if (connectionContext == null) {
            connectionContext = new ConnectionContext(null, null, null, null);
        }
        return this._getDevelopmentConfigurationInstance(rootFolder, vfsRootFolder, isLocalOnlyMode, connectionContext, false);
    }

    public IDevelopmentConfiguration getDevelopmentConfigurationInstance(String rootFolder, String vfsRootFolder, Category loggingCategory, boolean isLocalOnlyMode, IConnectionContext connectionContext, boolean doNotUseCBS) throws InvalidDefinitionException, DevconfModeException, RepositoryAccessException {
        return this.getDevelopmentConfigurationInstance(rootFolder, vfsRootFolder, isLocalOnlyMode, connectionContext, doNotUseCBS);
    }

    public IDevelopmentConfiguration getDevelopmentConfigurationInstance(String rootFolder, String vfsRootFolder, boolean isLocalOnlyMode, IConnectionContext connectionContext, boolean doNotUseCBS) throws InvalidDefinitionException, DevconfModeException, RepositoryAccessException {
        if (connectionContext == null) {
            connectionContext = new ConnectionContext(null, null, null, null);
        }
        return this._getDevelopmentConfigurationInstance(rootFolder, vfsRootFolder, isLocalOnlyMode, connectionContext, doNotUseCBS);
    }

    public DevelopmentConfiguration _getDevelopmentConfigurationInstance(String rootFolder, String vfsRootFolder, boolean isLocalOnlyMode, IConnectionContext connectionContext, boolean doNotUseCBS) throws InvalidDefinitionException, DevconfModeException, RepositoryAccessException {
        String thisMethod = "getDevelopmentConfigurationInstance()";
        String user = null;
        String pwd = null;
        KeyStore serverCerts = null;
        KeyStore clientCerts = null;
        if (connectionContext != null) {
            user = connectionContext.getUserName();
            pwd = connectionContext.getPassword();
            serverCerts = connectionContext.getServerCertsKeystore();
            clientCerts = connectionContext.getClientCertsKeystore();
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT(thisMethod, "rootFolder: {0}, vfsRootFolder: {1}, isLocalOnlyMode: {2}, userName: {3}", new Object[]{rootFolder, vfsRootFolder, new Boolean(isLocalOnlyMode), connectionContext == null ? null : connectionContext.getUserName()});
        }
        try {
            try {
                Object confDef;
                File f = new File(rootFolder);
                rootFolder = f.getCanonicalPath() + SEPARATOR;
                DevelopmentConfiguration conf = (DevelopmentConfiguration)this.m_instances.get(rootFolder);
                if (conf != null) {
                    this.reInitializeConfiguration(rootFolder, vfsRootFolder, isLocalOnlyMode, connectionContext, doNotUseCBS, conf);
                } else {
                    this.assureConfigFileExists(rootFolder);
                    confDef = this.readDevelopmentConfigurationDefinition(rootFolder);
                    if (confDef.isLocal() && !isLocalOnlyMode) {
                        LOCATION.infoT(thisMethod, "Cannot open local-configuration in online mode. using offline mode");
                        isLocalOnlyMode = true;
                    }
                    IConfiguration dtrConfiguration = this.getConfiguration(vfsRootFolder);
                    IClient dtrClient = null;
                    if (dtrConfiguration != null) {
                        dtrClient = this.findClient(dtrConfiguration, rootFolder);
                        String string = this.m_clientForConfigUnderConstruction = dtrClient == null ? null : dtrClient.getName();
                    }
                    if (isLocalOnlyMode) {
                        conf = new DevelopmentConfiguration(dtrConfiguration, dtrClient, (com.sap.tc.complib.DevelopmentConfiguration)confDef, rootFolder, DevelopmentConfiguration.DevConfOperationMode.LOCAL_ONLY, connectionContext, this.m_localArchiveRootPath, doNotUseCBS);
                    } else {
                        if (connectionContext != null) {
                            try {
                                dtrConfiguration.setMasterLogin(user, pwd, serverCerts, clientCerts);
                            }
                            catch (KeyStoreException e1) {
                                throw new RepositoryAccessException(e1.getMessage(), e1);
                            }
                        }
                        if (dtrClient == null) {
                            String message = "DTR client definition not found for this configuration. Configuration name '" + confDef.getName() + "'. Root folder: '" + rootFolder + "'";
                            LOCATION.infoT(thisMethod, "Throwing InvalidDefinitionException: " + message);
                            throw new InvalidDefinitionException(message);
                        }
                        conf = new DevelopmentConfiguration(dtrConfiguration, dtrClient, (com.sap.tc.complib.DevelopmentConfiguration)confDef, rootFolder, DevelopmentConfiguration.DevConfOperationMode.NORMAL, connectionContext, this.m_localArchiveRootPath, doNotUseCBS);
                        if (!doNotUseCBS) {
                            try {
                                this.initializeBuildSpaceProxy(conf, connectionContext);
                            }
                            catch (DevConfigException e) {
                                String message = "Could not initialize build space proxy: " + ((Throwable)((Object)e)).getMessage();
                                throw new RepositoryAccessException(message, (Throwable)((Object)e));
                            }
                        }
                    }
                    if (conf == null) {
                        String msg = "configuration could not be loaded";
                        throw new InvalidDefinitionException(msg, null);
                    }
                    LOCATION.infoT(thisMethod, "adding devconf instance to instance cache");
                    this.m_instances.put(conf.getConfigurationRootFolder(), conf);
                }
                confDef = conf;
                Object var19_29 = null;
                this.m_clientForConfigUnderConstruction = null;
                return confDef;
            }
            catch (IOException e) {
                String message = "Could not get canonical path for root folder " + rootFolder + ": " + e.getMessage();
                throw new InvalidDefinitionException(message, e);
            }
            catch (XMLException e) {
                String message = "Reading development configuration definition failed with XML exception. (Root folder " + rootFolder + "): " + e.getMessage();
                throw new InvalidDefinitionException(message, e);
            }
            catch (ProviderException e) {
                String message = "Reading development configuration definition failed. (Root folder " + rootFolder + "): " + e.getMessage();
                throw new InvalidDefinitionException(message, e);
            }
            catch (ValidationException e) {
                String message = "Validation of development configuration definition failed. (Root folder " + rootFolder + "): " + e.getMessage();
                throw new InvalidDefinitionException(message, e);
            }
        }
        catch (Throwable throwable) {
            Object var19_30 = null;
            this.m_clientForConfigUnderConstruction = null;
            throw throwable;
        }
    }

    private void assureConfigFileExists(String rootFolder) throws InvalidDefinitionException {
        File configFile = DevelopmentConfigurationFactory.getConfigurationFile(rootFolder);
        if (!configFile.exists()) {
            String msg = "Configuration definition file " + configFile.getAbsolutePath() + " doesn't exist";
            throw new InvalidDefinitionException(msg, null);
        }
        if (configFile.length() == 0L) {
            String msg = "Configuration definition file " + configFile.getAbsolutePath() + " is empty (0 length)";
            throw new InvalidDefinitionException(msg, null);
        }
    }

    private void reInitializeConfiguration(String rootFolder, String vfsRootFolder, boolean isLocalOnlyMode, IConnectionContext connectionContext, boolean doNotUseCBS, DevelopmentConfiguration conf) throws InvalidDefinitionException, RepositoryAccessException {
        boolean mustInitializeLocalArchiveDCs;
        String thisMethod = "reInitializeConfiguration";
        boolean _isLocalOnlyMode = isLocalOnlyMode;
        if (conf.getConfigurationData().isLocal() && !_isLocalOnlyMode) {
            LOCATION.infoT(thisMethod, "Cannot open local-configuration {0} in online mode. using offline mode", new Object[]{conf.getName()});
            _isLocalOnlyMode = true;
        }
        LOCATION.infoT(thisMethod, "found configuration instance in cache. returning existing instance");
        boolean bl = mustInitializeLocalArchiveDCs = conf.getLocalArchiveRootFolder() == null && this.m_localArchiveRootPath != null;
        if (_isLocalOnlyMode && !conf.isLocalOnlyMode()) {
            String msg = "Configuration is already instantiated in non-local mode. Try moving to local-only.";
            LOCATION.infoT(thisMethod, msg);
            this.moveToLocalConfigurationMode(conf);
        } else {
            if (!_isLocalOnlyMode && conf.isLocalOnlyMode()) {
                String msg = "Configuration is already instantiated in local-only mode. Trying upgrade to normal mode";
                LOCATION.infoT(thisMethod, msg);
                try {
                    this.upgradeLocalConfigurationMode(conf, vfsRootFolder, connectionContext, doNotUseCBS, this.m_localArchiveRootPath);
                }
                catch (KeyStoreException e1) {
                    throw new RepositoryAccessException("Going online failed. Security Keystore Error: " + e1.getMessage(), e1);
                }
            }
            if (_isLocalOnlyMode) {
                conf.assurePropertyUpdateAllowed(this.m_localArchiveRootPath);
            } else {
                IConfiguration vfsConf = this.getConfiguration(vfsRootFolder);
                conf.assurePropertyUpdateAllowed(vfsConf, this.findClient(vfsConf, rootFolder), this.m_localArchiveRootPath);
            }
            try {
                conf.updateProperties(connectionContext, this.m_localArchiveRootPath);
            }
            catch (KeyStoreException e1) {
                throw new RepositoryAccessException("Update of login data failed. Security Keystore Error: " + e1.getMessage(), e1);
            }
            catch (DevconfModeException e) {
                throw new RepositoryAccessException("Update of login data failed. Wrong development configuration mode: " + e.getMessage(), e);
            }
            catch (DevConfigException e) {
                throw new RepositoryAccessException("Update of login data failed: " + ((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
            }
        }
        if (mustInitializeLocalArchiveDCs) {
            conf.getComponentSyncDB().assureLocalEntries();
        }
    }

    com.sap.tc.complib.DevelopmentConfiguration readDevelopmentConfigurationDefinition(String confrootdir) throws IOException, XMLException, ProviderException, ValidationException {
        FileConfigInputProvider inProvider = new FileConfigInputProvider(confrootdir, ".confdef");
        com.sap.tc.complib.DevelopmentConfiguration devconfObject = ConfigurationFactory.initializeDevelopmentConfiguration((ConfigurationInputProvider)inProvider);
        return devconfObject;
    }

    public IDevelopmentConfiguration addConfiguration(String rootFolder, InputStream definition, String clientDefRootFolder, Category loggingCategory, boolean isLocalOnlyMode, IConnectionContext connectionContext, boolean doNotUseCBS) throws SyncException {
        if (connectionContext == null) {
            connectionContext = new ConnectionContext(null, null, null, null);
        }
        return this.addConfiguration(rootFolder, definition, clientDefRootFolder, loggingCategory, isLocalOnlyMode, connectionContext, doNotUseCBS, null);
    }

    public IDevelopmentConfiguration addConfiguration(String rootFolder, InputStream definition, String clientDefRootFolder, Category loggingCategory, boolean isLocalOnlyMode, IConnectionContext connectionContext) throws SyncException {
        if (connectionContext == null) {
            connectionContext = new ConnectionContext(null, null, null, null);
        }
        return this.addConfiguration(rootFolder, definition, clientDefRootFolder, loggingCategory, isLocalOnlyMode, connectionContext, false, null);
    }

    public IDevelopmentConfiguration addConfiguration(String rootFolder, InputStream definition, String clientDefRootFolder, Category loggingCategoryNotUsed, boolean isLocalOnlyMode, IConnectionContext connectionContext, boolean doNotUseCBS, String dtrClientName) throws SyncException {
        return this.addConfiguration(rootFolder, definition, clientDefRootFolder, isLocalOnlyMode, connectionContext, doNotUseCBS, dtrClientName);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IDevelopmentConfiguration addConfiguration(String rootFolder, InputStream definition, String clientDefRootFolder, boolean isLocalOnlyMode, IConnectionContext connectionContext, boolean doNotUseCBS, String dtrClientName) throws SyncException {
        block47: {
            thisMethod = "addConfiguration()";
            if (connectionContext == null) {
                connectionContext = new ConnectionContext(null, null, null, null);
            }
            configFile = null;
            dtrClient = null;
            dtrConfiguration = null;
            finishedSucessfully = false;
            confAlreadyExisted = true;
            clientAlreadyExisted = true;
            rootFolderFile = null;
            confDef = null;
            try {
                try {
                    DevelopmentConfigurationFactory.LOCATION.debugT(thisMethod, "rootFolder: {0}, definition: {1}, clientDefRootFolder: {2}, isLocalOnlyMode: {3}, userName: {4}", new Object[]{rootFolder, definition, clientDefRootFolder, new Boolean(isLocalOnlyMode), connectionContext == null ? null : connectionContext.getUserName()});
                    rootFolderFile = new File(rootFolder);
                    rootFolder = rootFolderFile.getCanonicalPath() + DevelopmentConfigurationFactory.SEPARATOR;
                    if (this.m_instances.containsKey(rootFolder)) {
                        msg = "Configuration already existing for folder " + rootFolder;
                        DevelopmentConfigurationFactory.LOCATION.debugT(thisMethod, msg + "(found in instance map)");
                        throw new SyncException(msg, null, 10);
                    }
                    if (!rootFolderFile.exists() && !rootFolderFile.mkdirs()) {
                        msg = "Cannot create configuration root folder " + rootFolder;
                        DevelopmentConfigurationFactory.LOCATION.debugT(thisMethod, msg);
                        throw new SyncException(msg, null, 10);
                    }
                    configFile = DevelopmentConfigurationFactory.getConfigurationFile(rootFolder);
                    if (configFile.exists()) {
                        msg = "Configuration definition already exists " + configFile.getAbsolutePath();
                        DevelopmentConfigurationFactory.LOCATION.debugT(thisMethod, msg);
                        throw new SyncException(msg, null, 10);
                    }
                    confAlreadyExisted = false;
                    Util.writeStreamToFile((InputStream)definition, (File)configFile);
                    confDef = this.readDevelopmentConfigurationDefinition(rootFolder);
                    if (!isLocalOnlyMode && confDef.isLocal()) {
                        DevelopmentConfigurationFactory.LOCATION.infoT(thisMethod, "Cannot open local-configuration in online mode. using offline mode");
                        isLocalOnlyMode = true;
                    }
                    if (!confDef.isLocal()) {
                        if (clientDefRootFolder == null) {
                            dtrConfiguration = Configuration.getConfiguration();
                        } else {
                            cf = new File(clientDefRootFolder);
                            clientDefRootFolder = cf.getCanonicalPath() + DevelopmentConfigurationFactory.SEPARATOR;
                            if (!(cf.exists() || (success = cf.mkdirs()) || isLocalOnlyMode)) {
                                throw new SyncException("Cannot create folder", null, 0);
                            }
                            dtrConfiguration = ConfigUtils.getConfiguration(cf);
                        }
                        if (dtrConfiguration == null) {
                            msg = "Internal Error. Could not get DTR configuration object (null)";
                            throw new SyncException(msg, null, 108);
                        }
                        desiredClientName = dtrClientName == null ? confDef.getName() : dtrClientName;
                        findClientResult = this.findOrCreateClient(dtrConfiguration, desiredClientName, rootFolder, 1, null);
                        dtrClient = findClientResult.client;
                        clientAlreadyExisted = findClientResult.created == false;
                        this.m_clientForConfigUnderConstruction = dtrClient == null ? null : dtrClient.getName();
                        dtrConfiguration.saveAll();
                    }
                    if (!isLocalOnlyMode) {
                        if (connectionContext == null) {
                            m = "Illegal attempt to add configuration for online mode without supplying connectionContext. Failed to create server definitions for online mode.";
                            throw new IllegalArgumentException(m);
                        }
                        this.createServers(confDef, dtrConfiguration, dtrClient, connectionContext);
                        dtrConfiguration.setMasterLogin(connectionContext.getUserName(), connectionContext.getPassword(), connectionContext.getServerCertsKeystore(), connectionContext.getClientCertsKeystore());
                        if (dtrClient == null) {
                            m = "DTR client definition not found for this configuration. Configuration name '" + confDef.getName() + "'. Root folder: '" + rootFolder + "'";
                            throw new SyncException(m, null, 111);
                        }
                        conf = new DevelopmentConfiguration(dtrConfiguration, dtrClient, confDef, rootFolder, DevelopmentConfiguration.DevConfOperationMode.NORMAL, connectionContext, this.m_localArchiveRootPath, doNotUseCBS);
                        if (!doNotUseCBS) {
                            try {
                                this.initializeBuildSpaceProxy(conf, connectionContext);
                            }
                            catch (DevConfigException e1) {
                                msg = "Import configuration failed. Failed to prepare CBS connection: " + e1.getMessage();
                                throw new SyncException(msg, (Throwable)e1, 43);
                            }
                        }
                        dtrConfiguration.saveAll();
                    } else {
                        conf = new DevelopmentConfiguration(dtrConfiguration, dtrClient, confDef, rootFolder, DevelopmentConfiguration.DevConfOperationMode.LOCAL_ONLY, connectionContext, this.m_localArchiveRootPath, doNotUseCBS);
                    }
                    this.m_instances.put(conf.getConfigurationRootFolder(), conf);
                    finishedSucessfully = true;
                    e1 = conf;
                    var27_28 = null;
                    this.m_clientForConfigUnderConstruction = null;
                    if (finishedSucessfully != false) return e1;
                    if (clientAlreadyExisted || dtrConfiguration == null || dtrClient == null) break block47;
                }
                catch (FileNotFoundException e) {
                    msg = "Import configuration failed. File or folder not found :" + e.getMessage();
                    throw new SyncException(msg, e, 40);
                }
                catch (IOException e) {
                    msg = "Import configuration failed. I/O Error occured :" + e.getMessage();
                    throw new SyncException(msg, e, 28);
                }
                catch (KeyStoreException e) {
                    msg = "Import configuration failed. Key Store Erroroccurred :" + e.getMessage();
                    throw new SyncException(msg, e, 44);
                }
                catch (RepositoryAccessException e) {
                    msg = "Import configuration failed:" + e.getMessage();
                    throw new SyncException(msg, (Throwable)e, 35);
                }
                catch (XMLException e) {
                    msg = "Import configuration failed with XML error: " + e.getMessage();
                    throw new SyncException(msg, e, 41);
                }
                catch (ProviderException e) {
                    msg = "Import configuration failed with XML error: " + e.getMessage();
                    throw new SyncException(msg, e, 41);
                }
                catch (ValidationException e) {
                    msg = "Import configuration failed with validation error: " + e.getMessage();
                    throw new SyncException(msg, e, 41);
                }
            }
            catch (Throwable var26_47) {
                var27_29 = null;
                this.m_clientForConfigUnderConstruction = null;
                if (finishedSucessfully != false) throw var26_47;
                if (!clientAlreadyExisted && dtrConfiguration != null && dtrClient != null) {
                    ls = dtrClient.getLogicalSystem();
                    if (ls != null) {
                        lsname = ls.getName();
                        if (dtrConfiguration.removeLogicalSystem(ls) != null) {
                            DevelopmentConfigurationFactory.LOCATION.infoT(thisMethod, "Cleanup: sucessfully deleted DTR logical system {0}", new Object[]{lsname});
                        } else {
                            DevelopmentConfigurationFactory.LOCATION.infoT(thisMethod, "Cleanup: failed to delete DTR logical system {0}", new Object[]{lsname});
                        }
                    }
                    if (dtrConfiguration.deleteClient(clname = dtrClient.getName()) != null) {
                        DevelopmentConfigurationFactory.LOCATION.infoT(thisMethod, "Cleanup: sucessfully deleted VFS client {0}", new Object[]{clname});
                    } else {
                        DevelopmentConfigurationFactory.LOCATION.infoT(thisMethod, "Cleanup: failed to delete VFS client {0}", new Object[]{clname});
                    }
                    try {
                        dtrConfiguration.saveAll();
                    }
                    catch (IOException e) {
                        DevelopmentConfigurationFactory.LOCATION.catching(thisMethod, (Throwable)e);
                        DevelopmentConfigurationFactory.LOCATION.infoT(thisMethod, "Cleanup: failed to save VFS configuration! No VFS cleanup done");
                    }
                }
                if (confAlreadyExisted != false) throw var26_47;
                if (configFile != null) {
                    configFile.delete();
                }
                if ((syncdbFile = DevelopmentConfigurationFactory.getSyncdbFile(rootFolder)).exists()) {
                    syncdbFile.delete();
                }
                if (rootFolderFile != null && rootFolderFile.exists()) {
                    rootFolderFile.delete();
                }
                if (this.m_instances == null) throw var26_47;
                this.m_instances.remove(rootFolder);
                throw var26_47;
            }
            ls = dtrClient.getLogicalSystem();
            if (ls != null) {
                lsname = ls.getName();
                if (dtrConfiguration.removeLogicalSystem(ls) != null) {
                    DevelopmentConfigurationFactory.LOCATION.infoT(thisMethod, "Cleanup: sucessfully deleted DTR logical system {0}", new Object[]{lsname});
                } else {
                    DevelopmentConfigurationFactory.LOCATION.infoT(thisMethod, "Cleanup: failed to delete DTR logical system {0}", new Object[]{lsname});
                }
            }
            if (dtrConfiguration.deleteClient(clname = dtrClient.getName()) != null) {
                DevelopmentConfigurationFactory.LOCATION.infoT(thisMethod, "Cleanup: sucessfully deleted VFS client {0}", new Object[]{clname});
            } else {
                DevelopmentConfigurationFactory.LOCATION.infoT(thisMethod, "Cleanup: failed to delete VFS client {0}", new Object[]{clname});
            }
            ** try [egrp 3[TRYBLOCK] [9 : 1338->1348)] { 
lbl171:
            // 1 sources

            dtrConfiguration.saveAll();
            break block47;
lbl173:
            // 1 sources

            catch (IOException e) {
                DevelopmentConfigurationFactory.LOCATION.catching(thisMethod, (Throwable)e);
                DevelopmentConfigurationFactory.LOCATION.infoT(thisMethod, "Cleanup: failed to save VFS configuration! No VFS cleanup done");
            }
        }
        if (confAlreadyExisted != false) return e1;
        if (configFile != null) {
            configFile.delete();
        }
        if ((syncdbFile = DevelopmentConfigurationFactory.getSyncdbFile(rootFolder)).exists()) {
            syncdbFile.delete();
        }
        if (rootFolderFile != null && rootFolderFile.exists()) {
            rootFolderFile.delete();
        }
        if (this.m_instances == null) return e1;
        this.m_instances.remove(rootFolder);
        return e1;
    }

    public void refreshConfiguration(String rootFolder, InputStream newConfigurationDefinition) throws SyncException {
    }

    private void removeSyncedDCArchives(DevelopmentConfiguration devconf) {
        String thisMethod = "removeSyncedDCArchives(DevelopmentConfiguration)";
        LOCATION.debugT(thisMethod, "devconf: {0}", new Object[]{devconf.getName()});
        ComponentSyncDB syncdb = devconf.getComponentSyncDB();
        Set entryKeys = syncdb.getEntriesKeySet();
        ArrayList<String> helpList = new ArrayList<String>();
        IDCSyncEntry entry = null;
        DevelopmentComponentRef dcRef = null;
        String key = null;
        if (entryKeys != null) {
            Iterator it = entryKeys.iterator();
            while (it.hasNext()) {
                key = (String)it.next();
                dcRef = syncdb.getDCFromKey(key);
                entry = syncdb.getEntry(dcRef);
                if (entry.getMode() != SyncMode.SYNCHED_AS_ARCHIVE) continue;
                helpList.add(key);
            }
            Iterator it2 = helpList.iterator();
            while (it2.hasNext()) {
                key = (String)it2.next();
                dcRef = syncdb.getDCFromKey(key);
                try {
                    IDCProxy pr = devconf.getDCProxyLocallyOrActive(dcRef.getCompartment(), dcRef.getVendor(), dcRef.getName());
                    devconf.unsync(pr.getCompartment(), pr.getVendor(), pr.getName());
                }
                catch (DevConfigException e) {
                    LOCATION.traceThrowableT(300, thisMethod, "Error while removing synced DC Archives.Caught DevConfigException, this exception is not forwarded.", (Throwable)((Object)e));
                }
                catch (SyncException e) {
                    LOCATION.traceThrowableT(300, thisMethod, "Error while removing synced DC Archives.Caught SyncException, this exception is not forwarded.", (Throwable)((Object)e));
                }
            }
        }
    }

    public void removeConfiguration(String rootFolder, IConnectionContext connectionContext) throws SyncException {
        this.removeConfiguration(rootFolder, null, null, connectionContext);
    }

    public void removeConfiguration(String rootFolder, String userName, String password) throws SyncException {
        this.removeConfiguration(rootFolder, null, null, userName, password);
    }

    public void removeConfiguration(String rootFolder, String vfsRootFolder, String userName, String password) throws SyncException {
        ConnectionContext connContext = new ConnectionContext(userName, password, null, null);
        this.removeConfiguration(rootFolder, vfsRootFolder, null, connContext);
    }

    public void removeConfiguration(String rootFolder, String vfsRootFolder, Category loggingCategory, String userName, String password) throws SyncException {
        ConnectionContext connContext = new ConnectionContext(userName, password, null, null);
        this.removeConfiguration(rootFolder, vfsRootFolder, loggingCategory, connContext);
    }

    public void removeConfiguration(String rootFolder, String vfsRootFolder, Category loggingCategory, IConnectionContext connectionContext) throws SyncException {
        this.removeConfiguration(rootFolder, vfsRootFolder, connectionContext);
    }

    public void removeConfiguration(String rootFolder, String vfsRootFolder, IConnectionContext connectionContext) throws SyncException {
        String thisMethod = "removeConfiguration()";
        LOCATION.debugT(thisMethod, "rootFolder: {0}, vfsRootFolder: {1}, userName: {2}, password: {3}", new Object[]{rootFolder, vfsRootFolder, connectionContext == null ? "N/A" : connectionContext.getUserName(), connectionContext == null || connectionContext.getPassword() == null ? null : "***"});
        try {
            File configFile;
            File rootFolderAsFile = new File(rootFolder);
            rootFolder = rootFolderAsFile.getCanonicalPath() + SEPARATOR;
            DevelopmentConfiguration devconf = (DevelopmentConfiguration)this.m_instances.get(rootFolder);
            IClient client = null;
            IConfiguration vfsConf = null;
            if (devconf != null) {
                if (devconf.isLocalConfiguration()) {
                    this.removeLocalConfiguration(devconf, false);
                    return;
                }
                if (devconf.isInOfflineMode()) {
                    String msg = "Cannot remove configuration while in offline mode.";
                    throw new SyncException(msg, null, 22);
                }
                this.removeSyncedDCArchives(devconf);
            }
            if ((configFile = DevelopmentConfigurationFactory.getConfigurationFile(rootFolder)).exists()) {
                boolean isLocalOnlyMode = false;
                devconf = this._getDevelopmentConfigurationInstance(rootFolder, vfsRootFolder, isLocalOnlyMode, connectionContext, false);
                if (devconf.isLocalConfiguration()) {
                    this.removeLocalConfiguration(devconf, false);
                    return;
                }
                this.assertNothingCheckedOut(devconf);
            }
            if ((vfsConf = this.getConfiguration(vfsRootFolder)) != null && (client = this.findClient(vfsConf, rootFolder)) != null) {
                Iterator mpIter = client.mountPoints();
                ArrayList<IMountPoint> mpList = new ArrayList<IMountPoint>();
                while (mpIter.hasNext()) {
                    IMountPoint mp = (IMountPoint)mpIter.next();
                    devconf.getVFSHandler().removeLocalPath(client.getAbsoluteLocalRoot() + mp.getRelativeLocalRoot());
                    mpList.add(mp);
                }
                IMountPoint[] mps = mpList.toArray(new IMountPoint[mpList.size()]);
                client.deleteMountPoints(mps);
                LOCATION.debugT(thisMethod, "Removing VFS client configuration in directory {0} ", new Object[]{vfsConf.getConfigFolder().getAbsolutePath()});
                if (client.getLogicalSystem() != null) {
                    vfsConf.removeLogicalSystem(client.getLogicalSystem());
                }
                vfsConf.deleteClient(client.getName());
                vfsConf.saveAll();
            }
            configFile.delete();
            File syncdbFile = DevelopmentConfigurationFactory.getSyncdbFile(rootFolder);
            if (syncdbFile.exists()) {
                syncdbFile.delete();
            }
            if (rootFolderAsFile.exists()) {
                rootFolderAsFile.delete();
            }
            LOCATION.debugT(thisMethod, "removing instance from cache");
            this.m_instances.remove(rootFolder);
            if (devconf != null) {
                devconf.markDeleted();
            }
        }
        catch (SyncException e) {
            throw e;
        }
        catch (IOException e) {
            String msg = "I/O error occured while removing configuration: " + e.getMessage();
            throw new SyncException(msg, e, 28);
        }
        catch (InvalidDefinitionException e) {
            String msg = "Remove vonfiguration failed. Cannot initialize configuration to check if files are checked out:  " + ((Throwable)((Object)e)).getMessage();
            throw new SyncException(msg, (Throwable)((Object)e), 28);
        }
        catch (RepositoryAccessException e) {
            String msg = "Remove configuration failed. Cannot access repoistory to check if files are checked out:  " + ((Throwable)((Object)e)).getMessage();
            throw new SyncException(msg, (Throwable)((Object)e), 35);
        }
        catch (ObjectsCheckedOutException e) {
            String msg = "Removing configuration failed. There are objects checked out: " + ((Throwable)((Object)e)).getMessage();
            throw new SyncException(msg, (Throwable)((Object)e), 7);
        }
        catch (DevConfigException e) {
            Throwable inner = e.getCause();
            String msg = "Removing configuration failed.";
            SyncException ex = null;
            ex = inner instanceof IOException ? new SyncException(msg + ": " + ((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e), 28) : (inner instanceof ClientLibraryException ? DTRClientErrorMapper.toSyncException(msg, (ClientLibraryException)inner) : new SyncException(msg + ": " + ((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e)));
            throw ex;
        }
    }

    public void removeConfigurationByForce(String rootFolder, boolean deleteCompleteContent) throws IOException {
        this.removeConfigurationByForce(rootFolder, null, deleteCompleteContent);
    }

    public void removeConfigurationByForce(String rootFolder, String vfsRootFolder, Category loggingCategory, boolean deleteCompleteContent) throws IOException {
        this.removeConfigurationByForce(rootFolder, vfsRootFolder, deleteCompleteContent);
    }

    public void removeConfigurationByForce(String rootFolder, String vfsRootFolder, boolean deleteCompleteContent) throws IOException {
        String thisMethod = "removeConfigurationByForce()";
        LOCATION.debugT(thisMethod, "rootFolder: {0}, vfsRootFolder: {1}, loggingCategory: {2}", new Object[]{rootFolder, vfsRootFolder});
        File rootFolderAsFile = new File(rootFolder);
        rootFolder = rootFolderAsFile.getCanonicalPath() + SEPARATOR;
        DevelopmentConfiguration devconf = (DevelopmentConfiguration)this.m_instances.get(rootFolder);
        if (devconf != null && devconf.isLocalConfiguration()) {
            this.removeLocalConfiguration(devconf, deleteCompleteContent);
            return;
        }
        IClient client = null;
        IConfiguration vfsConf = this.getConfiguration(vfsRootFolder);
        if (vfsConf != null && (client = this.findClient(vfsConf, rootFolder)) != null) {
            ArrayList mpList = new ArrayList();
            Iterator mpIter = client.mountPoints();
            while (mpIter.hasNext()) {
                mpList.add(mpIter.next());
            }
            IMountPoint[] mps = mpList.toArray(new IMountPoint[mpList.size()]);
            LOCATION.debugT(thisMethod, "Removing {0} mount points for VFS client with root: {1}", new Object[]{new Integer(mpList.size()), rootFolder});
            client.deleteMountPoints(mps, true);
            if (client.getLogicalSystem() != null) {
                vfsConf.removeLogicalSystem(client.getLogicalSystem());
            }
            LOCATION.debugT(thisMethod, "Removing VFS client with root: {0}", new Object[]{rootFolder});
            vfsConf.deleteClient(client.getName());
            vfsConf.saveAll();
        }
        if (deleteCompleteContent) {
            Util.deleteDirRecursively((File)rootFolderAsFile);
        } else {
            this.removeSyncedDCArchives(devconf);
            File configFile = DevelopmentConfigurationFactory.getConfigurationFile(rootFolder);
            File syncdbFile = DevelopmentConfigurationFactory.getSyncdbFile(rootFolder);
            if (configFile.exists()) {
                configFile.delete();
            }
            if (syncdbFile.exists()) {
                syncdbFile.delete();
            }
            if (rootFolderAsFile.exists()) {
                rootFolderAsFile.delete();
            }
            LOCATION.debugT(thisMethod, "removing instance from cache");
        }
        this.m_instances.remove(rootFolder);
        if (devconf != null) {
            devconf.markDeleted();
        }
    }

    private void removeLocalConfiguration(DevelopmentConfiguration devconf, boolean deleteCompleteContent) throws IOException {
        String thisMethod = "removeLocalConfiguration()";
        LOCATION.debugT(thisMethod, "configuration: \"{0}\"", new Object[]{devconf.getConfigurationData().getName()});
        File rootFolderAsFile = new File(devconf.getConfigurationRootFolder());
        String rootFolder = rootFolderAsFile.getCanonicalPath() + SEPARATOR;
        if (deleteCompleteContent) {
            Util.deleteDirRecursively((File)rootFolderAsFile);
        } else {
            File syncdbFile;
            File configFile = DevelopmentConfigurationFactory.getConfigurationFile(rootFolder);
            if (configFile.exists()) {
                configFile.delete();
            }
            if ((syncdbFile = DevelopmentConfigurationFactory.getSyncdbFile(rootFolder)).exists()) {
                syncdbFile.delete();
            }
            if (rootFolderAsFile.exists()) {
                rootFolderAsFile.delete();
            }
        }
        LOCATION.debugT(thisMethod, "removing configuration instance {0} from cache", new Object[]{devconf.getConfigurationData().getName()});
        this.m_instances.remove(rootFolder);
        devconf.markDeleted();
    }

    private void assertNothingCheckedOut(DevelopmentConfiguration devconf) throws DevConfigException {
        List checkedOutNodes;
        try {
            checkedOutNodes = devconf.listNodesWhereSomethingIsCheckedOut();
        }
        catch (IOException e) {
            String msg = "Cannot Check if files are checked out. DTR client layer reports I/O error: " + e.getMessage();
            throw new DevConfigException(msg, e);
        }
        catch (VfsException e) {
            String msg = "Cannot Check whether files are checked out. DTR client layer reports VfsException: " + e.getMessage();
            throw new DevConfigException(msg, e);
        }
        String dcmsg = "";
        if (checkedOutNodes.size() > 0) {
            Iterator checkedOutIterator = checkedOutNodes.iterator();
            while (checkedOutIterator.hasNext()) {
                IDevelopmentComponentNode checkedOutNode = (IDevelopmentComponentNode)checkedOutIterator.next();
                dcmsg = dcmsg.length() == 0 ? dcmsg + checkedOutNode.getName() : dcmsg + ", " + checkedOutNode.getName();
            }
            String msg = "Can't remove configuration as files of following development components are checked out: " + dcmsg + nl + "To remove confignuration make sure that no files of development components are checked out";
            throw new ObjectsCheckedOutException(msg);
        }
    }

    private static File getConfigurationFile(String configRootFolderPath) {
        String fileName = ".confdef";
        String path = Util.concatenatePath((String)configRootFolderPath, (String)fileName, (char)File.separatorChar);
        File file = new File(path);
        return file;
    }

    private static File getSyncdbFile(String configRootFolderPath) {
        String fileName = ".syncdb";
        String path = configRootFolderPath + fileName;
        File file = new File(path);
        return file;
    }

    private void createServers(com.sap.tc.complib.DevelopmentConfiguration conf, IConfiguration dtrConf, IClient client, IConnectionContext connectionContext) throws SyncException {
        Map compMap = conf.getCompartments();
        if (compMap == null) {
            return;
        }
        Iterator it = compMap.values().iterator();
        ConfigUtils confUtil = new ConfigUtils();
        while (it.hasNext()) {
            Repository repository;
            IRepositoryServer server;
            Compartment compartment = (Compartment)it.next();
            SourceState srcState = compartment.getSourceState();
            if (srcState == null || (server = confUtil.findOrCreateRepositoryServer(dtrConf, client, repository = srcState.getRepository(), connectionContext)) == null) continue;
            server.setFilter(DTR_WORKSPACE_ROOT, VfsFilterType.EXCLUDE);
            if (srcState.getInactiveLocation() != null) {
                server.setWorkspaceFilter(ConfigUtils.getInactiveLocation(srcState), VfsFilterType.INCLUDE);
            }
            if (srcState.getLocation() == null) continue;
            if (ConfigUtils.getInactiveLocation(srcState) != null) {
                server.setWorkspaceFilter(ConfigUtils.getLocation(srcState), VfsFilterType.READONLY);
                continue;
            }
            if (srcState.getType() == 2) {
                server.setWorkspaceFilter(ConfigUtils.getLocation(srcState), VfsFilterType.INCLUDE);
                continue;
            }
            server.setWorkspaceFilter(ConfigUtils.getLocation(srcState), VfsFilterType.READONLY);
        }
    }

    public void initializeBuildSpaceProxy(DevelopmentConfiguration conf, IConnectionContext connectionContext) throws DevConfigException {
        com.sap.tc.cbs.client.IBuildServer cbsProxy = null;
        cbsProxy = this.initializeBuildServerProxy(conf, connectionContext);
        if (cbsProxy != null) {
            IBuildSpace buildSpace = cbsProxy.getBuildSpace(conf.getConfigurationData().getName());
            conf.setBuildSpace(buildSpace);
        }
    }

    private com.sap.tc.cbs.client.IBuildServer initializeBuildServerProxy(DevelopmentConfiguration conf, IConnectionContext connectionContext) throws DevConfigException {
        VFSHandler vfsHandler = conf.getVFSHandler();
        if (conf.getBuildServer() == null) {
            return null;
        }
        try {
            IBuildServer vfsBuildServer = vfsHandler._findOrCreateBuildServer(conf.getBuildServer());
            ConfigUtils utils = new ConfigUtils();
            return utils.getBuildServerProxy(vfsBuildServer, connectionContext);
        }
        catch (IOException e) {
            String message = "Failed to create server definition for build server: " + e.getMessage();
            throw new DevConfigException(message, e);
        }
    }

    private FindOrCreateClientResult findOrCreateClient(IConfiguration vfsConf, String clientDefName, String rootFolder, int nextNumber, String clientID) throws SyncException {
        String thisMethod = "createClient(...)";
        FindOrCreateClientResult result = new FindOrCreateClientResult(false, null);
        IClient client = vfsConf.getClient(clientDefName);
        if (client != null) {
            if (client.getAbsoluteLocalRoot().equals(rootFolder)) {
                return new FindOrCreateClientResult(false, client);
            }
            return this.findOrCreateClient(vfsConf, clientDefName + " (" + nextNumber + ")", rootFolder, nextNumber + 1, clientID);
        }
        String systemName = clientDefName;
        ILogicalSystem system = vfsConf.getLogicalSystem(systemName);
        if (system == null) {
            system = vfsConf.createLogicalSystem(systemName);
        }
        client = vfsConf.createClient(clientDefName, rootFolder, system);
        result = new FindOrCreateClientResult(true, client);
        String filter = clientID != null ? clientID : this.getStandardClientID(clientDefName);
        try {
            client.setClientFilter(filter);
        }
        catch (ConfigurationException e) {
            LOCATION.traceThrowableT(300, thisMethod, "Failed to set client filter: " + filter, (Throwable)e);
            LOCATION.infoT(thisMethod, "deleting the client again");
            vfsConf.deleteClient(clientDefName);
            throw DTRClientErrorMapper.toSyncException((ClientLibraryException)e);
        }
        return result;
    }

    private String getStandardClientID(String clientDefName) {
        String thisMethod = "getStandardClientID()";
        String id = clientDefName;
        try {
            String hostname = InetAddress.getLocalHost().getHostName();
            id = id + ":" + hostname;
        }
        catch (UnknownHostException e) {
            LOCATION.catching(thisMethod, (Throwable)e);
            LOCATION.infoT(thisMethod, "Could not determine name of local host. Using client name as client ID");
        }
        return id;
    }

    private void upgradeLocalConfigurationMode(DevelopmentConfiguration conf, String vfsRootFolder, IConnectionContext connectionContext, boolean doNotUseCBS, String localArchiveRootFolder) throws InvalidDefinitionException, DevconfModeException, RepositoryAccessException, KeyStoreException {
        String rootFolder = conf.getConfigurationRootFolder();
        IConfiguration vfsConf = this.getConfiguration(vfsRootFolder);
        String clientDefName = conf.getConfigurationData().getName();
        IClient client = this.findClient(vfsConf, rootFolder);
        if (client == null) {
            String message = "DTR client definition not found for this configuration. VFS client-def name: '" + clientDefName + "'";
            throw new InvalidDefinitionException(message);
        }
        if (!doNotUseCBS) {
            try {
                this.initializeBuildSpaceProxy(conf, connectionContext);
            }
            catch (DevConfigException e) {
                String message = "Could not initialize build space proxy:" + ((Throwable)((Object)e)).getMessage();
                throw new InvalidDefinitionException(message);
            }
        }
        conf.upgradeFromLocalOnlyModeToNormal(vfsConf, client, connectionContext, localArchiveRootFolder);
    }

    private void moveToLocalConfigurationMode(DevelopmentConfiguration conf) throws InvalidDefinitionException, RepositoryAccessException {
        String thisMethod = "moveToLocalConfigurationMode()";
        LOCATION.debugT(thisMethod, "moving development configuration instance " + conf + " (" + conf.getConfigurationData().getName() + ") to local-only mode.");
        conf.goToLocalOnlyMode();
    }

    public String getLocalArchiveRootPath() {
        return this.m_localArchiveRootPath;
    }

    public void setLocalArchiveRootPath(String localArchiveRootPath) throws IOException {
        File f = new File(localArchiveRootPath);
        if (!f.exists()) {
            throw new FileNotFoundException("Folder does not exist: \"" + localArchiveRootPath + "\"");
        }
        if (!f.isDirectory()) {
            throw new IOException("\"" + localArchiveRootPath + "\" is not a directory.");
        }
        this.m_localArchiveRootPath = f.getCanonicalPath();
    }

    private IConfiguration getConfiguration(String vfsRootFolder) {
        return ConfigUtils.getConfiguration(vfsRootFolder);
    }

    private IClient findClient(IConfiguration vfsConf, String rootFolder) {
        return ConfigUtils.findClient(vfsConf, rootFolder);
    }

    public int getPingRepeats() {
        return this.m_pingRepeats;
    }

    public int getPingMillisToWait() {
        return this.m_pingTimeout;
    }

    public void setPingRepeats(int pingRepeats) {
        this.m_pingRepeats = pingRepeats;
    }

    public void setPingMillisToWait(int pingTimeout) {
        this.m_pingTimeout = pingTimeout;
    }

    public IDevelopmentConfiguration findConfigInstanceForPath(String path) {
        DevelopmentConfiguration conf = null;
        try {
            path = new File(path).getCanonicalPath();
            Iterator iterPaths = this.m_instances.keySet().iterator();
            while (iterPaths.hasNext()) {
                String rootFolder = (String)iterPaths.next();
                if (rootFolder.length() == path.length() + SEPARATOR_LENGTH) {
                    if (!rootFolder.startsWith(path) || !rootFolder.endsWith(SEPARATOR)) continue;
                    conf = (DevelopmentConfiguration)this.m_instances.get(rootFolder);
                } else {
                    if (!path.startsWith(rootFolder)) continue;
                    conf = (DevelopmentConfiguration)this.m_instances.get(rootFolder);
                }
                break;
            }
        }
        catch (IOException e) {
            LOCATION.catching("findConfigInstanceForPathInsideConfig", (Throwable)e);
            LOCATION.errorT("findConfigInstanceForPathInsideConfig", "Error when searching configuration for path {0}:{1}", new Object[]{path, e.getMessage()});
            conf = null;
        }
        return conf;
    }

    public IDevelopmentConfiguration lookupDevConfByRootPath(String rootFolder) {
        return (IDevelopmentConfiguration)this.m_instances.get(rootFolder);
    }

    private DevConfFileMonitor _getFileMonitor() {
        if (this.m_fileMonitor == null) {
            this.m_fileMonitor = new DevConfFileMonitor(this);
        }
        return this.m_fileMonitor;
    }

    public boolean isClientForExistingConfiguration(String dtrClientName) {
        String thisMethod = "isClientForExistingConfiguration";
        if (this.m_clientForConfigUnderConstruction != null && dtrClientName.equals(this.m_clientForConfigUnderConstruction)) {
            return true;
        }
        Iterator iter = this.m_instances.values().iterator();
        while (iter.hasNext()) {
            DevelopmentConfiguration conf = (DevelopmentConfiguration)iter.next();
            if (conf.isLocalConfiguration()) continue;
            IClient client = null;
            try {
                client = conf.getDTRClient();
                if (client == null || !dtrClientName.equals(client.getName())) continue;
                return true;
            }
            catch (OfflineException e) {
                LOCATION.catching(thisMethod, (Throwable)((Object)e));
                LOCATION.traceThrowableT(300, thisMethod, "Cannot get DTRClient for " + conf.getName(), (Throwable)((Object)e));
            }
        }
        return false;
    }

    public IDevelopmentConfiguration addConfiguration(String rootFolder, InputStream definition, String clientDefRootFolder, Category loggingCategory, boolean isLocalOnlyMode, String userName, String password) throws SyncException {
        return this.addConfiguration(rootFolder, definition, clientDefRootFolder, loggingCategory, isLocalOnlyMode, userName, password, false);
    }

    public IDevelopmentConfiguration addConfiguration(String rootFolder, InputStream definition, String clientDefRootFolder, Category loggingCategory, boolean isLocalOnlyMode, String userName, String password, boolean doNotUseCBS) throws SyncException {
        ConnectionContext connectionContext = new ConnectionContext(userName, password, null, null);
        return this.addConfiguration(rootFolder, definition, clientDefRootFolder, loggingCategory, isLocalOnlyMode, connectionContext, doNotUseCBS, null);
    }

    public IDevelopmentConfiguration getDevelopmentConfigurationInstance(String rootFolder, String userName, String password) throws InvalidDefinitionException, RepositoryAccessException {
        ConnectionContext connContext = new ConnectionContext(userName, password, null, null);
        return this._getDevelopmentConfigurationInstance(rootFolder, null, false, connContext, false);
    }

    public IDevelopmentConfiguration getDevelopmentConfigurationInstance(String rootFolder, String vfsRootFolder, Category loggingCategory, boolean isLocalOnlyMode, String userName, String password) throws InvalidDefinitionException, RepositoryAccessException {
        return this._getDevelopmentConfigurationInstance(rootFolder, vfsRootFolder, isLocalOnlyMode, new ConnectionContext(userName, password, null, null), false);
    }

    public IDevelopmentConfiguration getDevelopmentConfigurationInstance(String rootFolder, String vfsRootFolder, boolean isLocalOnlyMode, String userName, String password) throws InvalidDefinitionException, RepositoryAccessException {
        return this._getDevelopmentConfigurationInstance(rootFolder, vfsRootFolder, isLocalOnlyMode, new ConnectionContext(userName, password, null, null), false);
    }

    public IDevelopmentConfiguration getDevelopmentConfigurationInstance(String rootFolder, String vfsRootFolder, Category loggingCategory, boolean isLocalOnlyMode, String userName, String password, boolean doNotUseCBS) throws InvalidDefinitionException, DevconfModeException, RepositoryAccessException {
        ConnectionContext connContext = new ConnectionContext(userName, password, null, null);
        return this._getDevelopmentConfigurationInstance(rootFolder, vfsRootFolder, isLocalOnlyMode, connContext, doNotUseCBS);
    }

    public IDevelopmentConfiguration getDevelopmentConfigurationInstance(String rootFolder, String vfsRootFolder, boolean isLocalOnlyMode, String userName, String password, boolean doNotUseCBS) throws InvalidDefinitionException, DevconfModeException, RepositoryAccessException {
        ConnectionContext connContext = new ConnectionContext(userName, password, null, null);
        return this._getDevelopmentConfigurationInstance(rootFolder, vfsRootFolder, isLocalOnlyMode, connContext, doNotUseCBS);
    }

    public IDCProxy getDCFromFile(File file) throws DevConfigException {
        DevConfFileMonitor monitor = new DevConfFileMonitor(this);
        return monitor.getLocalDCProxyForFile(file);
    }

    private static class FindOrCreateClientResult {
        public boolean created;
        public IClient client;

        public FindOrCreateClientResult(boolean pCreated, IClient pClient) {
            this.created = pCreated;
            this.client = pClient;
        }
    }
}

