/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf;

import com.sap.tc.complib.BuildVariant;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.DevelopmentConfiguration;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.DevconfInconsistencyException;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DevConfUtil {
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$DevConfUtil == null ? (class$com$sap$tc$devconf$DevConfUtil = DevConfUtil.class$("com.sap.tc.devconf.DevConfUtil")) : class$com$sap$tc$devconf$DevConfUtil));
    static /* synthetic */ Class class$com$sap$tc$devconf$DevConfUtil;

    public static List getAllowedBuildVariants(DevelopmentConfiguration config, String compartment1, String buildVariant1, String compartment2) throws DevConfigException {
        List<String> list;
        String thisMethod = "getAllowedBuildVariants(String,String,String)";
        try {
            String usedVariant = DevConfUtil.getUsedBuildVariant(config, compartment1, compartment2, buildVariant1);
            if (usedVariant != null) {
                list = new ArrayList<String>();
                list.add(usedVariant);
            } else {
                list = DevConfUtil.getUsingBuildVariants(config, compartment2, compartment1, buildVariant1);
                if (list == null) {
                    list = new ArrayList(DevConfUtil.getCompartmentObject(config, compartment2).getBuildVariants().keySet());
                }
            }
        }
        catch (DevconfInconsistencyException e) {
            String msg = "Invalid compartment parameter: " + ((Throwable)((Object)e)).getMessage();
            throw new DevConfigException(msg, (Throwable)((Object)e));
        }
        return list;
    }

    public static boolean isUsing(DevelopmentConfiguration config, String compartment1, String compartment2) throws DevConfigException {
        Compartment compartmentObject1;
        try {
            compartmentObject1 = DevConfUtil.getCompartmentObject(config, compartment1);
        }
        catch (DevconfInconsistencyException e) {
            String msg = "Invalid compartment name: " + compartment1;
            throw new DevConfigException(msg, (Throwable)((Object)e));
        }
        Map variantMap = compartmentObject1.getBuildVariants();
        if (variantMap == null) {
            return false;
        }
        Set usedByCompartment1 = compartmentObject1.getUsedCompartments();
        if (usedByCompartment1 == null) {
            return false;
        }
        return usedByCompartment1.contains(compartment2);
    }

    private static Compartment getCompartmentObject(DevelopmentConfiguration config, String name) throws DevconfInconsistencyException {
        Map compartments = config.getCompartments();
        if (compartments == null) {
            throw new DevconfInconsistencyException("compartment " + name + " does not exist");
        }
        Compartment compartment = (Compartment)compartments.get(name);
        if (compartment == null) {
            throw new DevconfInconsistencyException("compartment " + name + " does not exist");
        }
        return compartment;
    }

    public static String getUsedBuildVariant(DevelopmentConfiguration config, String usingCompartment, String usedCompartment, String buildVariant) {
        String usedVariant = null;
        String thisMethod = "getUsedBuildVariant()";
        LOCATION.debugT(thisMethod, "usingCompartment: {0}, usedCompartment: {1}, buildVariant: {2}", new Object[]{usingCompartment, usedCompartment, buildVariant});
        if (usingCompartment.equals(usedCompartment)) {
            return buildVariant;
        }
        Compartment usingComp = DevConfUtil.getCompartmentObject(config, usingCompartment);
        Map variants = usingComp.getBuildVariants();
        if (variants == null) {
            String m = "Requested build variant \"" + buildVariant + "\"does not exist in compartment \"" + usingCompartment + "\"";
            throw new DevconfInconsistencyException(m);
        }
        BuildVariant variant = (BuildVariant)variants.get(buildVariant);
        if (variant == null) {
            String m = "Requested build variant \"" + buildVariant + "\"does not exist in compartment \"" + usingCompartment + "\"";
            throw new DevconfInconsistencyException(m);
        }
        Map mappedVariants = variant.getVariantMapping();
        if (mappedVariants != null) {
            usedVariant = (String)mappedVariants.get(usedCompartment);
        }
        return usedVariant;
    }

    public static List getUsingBuildVariants(DevelopmentConfiguration config, String usingCompartment, String usedCompartment, String usedBuildVariant) throws DevConfigException {
        ArrayList<BuildVariant> list = new ArrayList<BuildVariant>();
        if (usingCompartment.equals(usedCompartment)) {
            String msg = "Cannot determine using build variants: usingCompartment and usedCompartment must not be equal. compartment: " + usedCompartment + " variant:" + usedBuildVariant;
            throw new DevConfigException(msg);
        }
        Compartment usingComp = DevConfUtil.getCompartmentObject(config, usingCompartment);
        Map variants = usingComp.getBuildVariants();
        if (variants == null) {
            String msg = "No build varinats are defined for compartment " + usingCompartment;
            throw new DevconfInconsistencyException(msg);
        }
        Iterator itVariants = variants.values().iterator();
        while (itVariants.hasNext()) {
            String currentUsedVariant;
            BuildVariant usingVariant = (BuildVariant)itVariants.next();
            Map mappedVariants = usingVariant.getVariantMapping();
            if (mappedVariants == null || !(currentUsedVariant = (String)mappedVariants.get(usedCompartment)).equals(usedBuildVariant)) continue;
            list.add(usingVariant);
        }
        return list;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

