/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf;

import com.sap.tc.complib.Dependency;

public class DCUsageFilter {
    private boolean m_atRunTime;
    private boolean m_atBuildTime;
    private boolean m_atDeployTime;
    private boolean m_atDesignTime;
    private boolean m_forChildrenOnly;

    public DCUsageFilter(boolean atRunTime, boolean atBuildTime, boolean atDesignTime, boolean atDeployTime, boolean forChildrenOnly) {
        this.m_atRunTime = atRunTime;
        this.m_atBuildTime = atBuildTime;
        this.m_atDeployTime = atDeployTime;
        this.m_atDesignTime = atDesignTime;
        this.m_forChildrenOnly = forChildrenOnly;
    }

    public boolean isMatchingOne(Dependency dependency) {
        return this.isChildrenOnlyFlagCompatible(dependency) && this.atTimeFlagsMatchingAtLeastOne(dependency);
    }

    public boolean isMatchingAll(Dependency dependency) {
        return this.isChildrenOnlyFlagCompatible(dependency) && this.atTimeFlagsEqual(dependency);
    }

    private boolean isChildrenOnlyFlagCompatible(Dependency dependency) {
        return !dependency.isForChildrenOnly() || this.m_forChildrenOnly;
    }

    private boolean atTimeFlagsMatchingAtLeastOne(Dependency dep) {
        return dep.isAtBuildTime() && this.m_atBuildTime || dep.isAtRunTime() && this.m_atRunTime || dep.isAtDesignTime() && this.m_atDesignTime || dep.isAtDeployTime() && this.m_atDeployTime;
    }

    private boolean atTimeFlagsEqual(Dependency dep) {
        return dep.isAtBuildTime() == this.m_atBuildTime && dep.isAtRunTime() == this.m_atRunTime && dep.isAtDesignTime() == this.m_atDesignTime && dep.isAtDeployTime() == this.m_atDeployTime;
    }
}

