/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.inheritance;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class InheritancePlugin
extends AbstractUIPlugin {
    private static InheritancePlugin plugin;
    public static final String ID = "com.tssap.j2ee.core.inheritance";
    private static final String IMPL_EXT_PT_SIMPLE = "inheritanceModelImplementation";
    private static final String IMPLEMENTATION_TAG = "implementation";
    private static final String PLUGIN_ATTRIBUTE = "plugin";

    public InheritancePlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
    }

    public static InheritancePlugin getDefault() {
        return plugin;
    }

    public void startup() throws CoreException {
        super.startup();
        this.activateImplementation();
    }

    private void activateImplementation() {
        IExtensionPoint extPoint = this.getDescriptor().getExtensionPoint(IMPL_EXT_PT_SIMPLE);
        IExtension[] extensions = extPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement next = elements[j];
                if (IMPLEMENTATION_TAG.equals(next.getName())) {
                    String pluginId = next.getAttribute(PLUGIN_ATTRIBUTE);
                    IPluginDescriptor desc = Platform.getPluginRegistry().getPluginDescriptor(pluginId);
                    if (desc == null) {
                        this.logWarning("Could not find plugin " + pluginId + " while activating implementation plugins");
                    } else {
                        try {
                            desc.getPlugin();
                        }
                        catch (CoreException e) {
                            this.logWarning("Exception while activating implementation plugin " + pluginId, e);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public void logError(String msg) {
        this.logError(msg, null);
    }

    public void logError(String msg, Throwable e) {
        this.log(4, msg, e);
    }

    public void logWarning(String msg) {
        this.logWarning(msg, null);
    }

    public void logWarning(String msg, Throwable e) {
        this.log(2, msg, e);
    }

    public void logInfo(String msg) {
        this.logInfo(msg, null);
    }

    public void logInfo(String msg, Throwable e) {
        this.log(1, msg, e);
    }

    public void log(int severity, String msg, Throwable e) {
        this.getLog().log((IStatus)new Status(severity, ID, 0, msg, e));
    }
}

