/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils.signature;

import com.tssap.j2ee.core.inheritance.utils.ValidationUtils;
import com.tssap.j2ee.core.utils.signature.AbstractSignature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;

public class MethodSignature
extends AbstractSignature {
    private String[] myParameterTypeFQNs;
    private String[] myParameterNames;
    private String myReturnType;
    public static final char LBRACKET = '(';
    public static final char RBRACKET = ')';
    private static final char COLON = ':';
    private static final char SPACE = ' ';
    private static final String SINGLE_COMMA = ",";
    private static final String DOUBLE_COMMA = ",,";
    private static final String ARG_PREFIX = "arg";
    private static final char[] BRACKETS = new char[]{'(', ')'};

    public MethodSignature(String name, String[] parameterTypeFQNs, String[] parameterNames, String returnType) {
        super(name);
        if (parameterTypeFQNs != null && parameterNames != null && parameterNames.length != parameterTypeFQNs.length) {
            throw new IllegalArgumentException("Parameters are incorrect");
        }
        this.myParameterTypeFQNs = parameterTypeFQNs;
        this.myParameterNames = parameterNames;
        this.myReturnType = returnType;
    }

    private static MethodSignature safeCreateSignature(String name, String[] parameterTypeFQNs, String[] parameterNames, String returnType) {
        name = AbstractSignature.nullify(name);
        returnType = AbstractSignature.nullify(returnType);
        if (name != null && !ValidationUtils.getInstance().validateMethodName(name)) {
            return null;
        }
        if (returnType != null && !ValidationUtils.getInstance().validateMethodReturnType(returnType)) {
            return null;
        }
        if (parameterTypeFQNs == null) {
            parameterNames = null;
        }
        if (parameterNames != null && parameterTypeFQNs.length != parameterNames.length) {
            return null;
        }
        if (parameterTypeFQNs != null) {
            int i = 0;
            while (i < parameterTypeFQNs.length) {
                String paramName;
                String string = paramName = parameterNames == null ? ARG_PREFIX : parameterNames[i];
                if (!ValidationUtils.getInstance().validateMethodParameter(paramName, parameterTypeFQNs[i])) {
                    return null;
                }
                ++i;
            }
        }
        return new MethodSignature(name, parameterTypeFQNs, parameterNames, returnType);
    }

    public static MethodSignature fromUMLRepresentation(String uml) {
        int colon;
        if (uml == null) {
            return null;
        }
        if ((uml = uml.trim()).length() == 0) {
            return null;
        }
        int left = uml.indexOf(40);
        int right = uml.indexOf(41);
        if (left == -1 && right == -1 && (colon = uml.indexOf(58)) != -1) {
            String name = uml.substring(0, colon).trim();
            String type = uml.substring(colon + 1).trim();
            return MethodSignature.safeCreateSignature(name, null, null, type);
        }
        if (left == -1 || right == -1 || left > right) {
            return null;
        }
        String leftPart = uml.substring(0, left);
        String rightPart = uml.substring(right + 1);
        String paramsPart = uml.substring(left + 1, right);
        if (MethodSignature.hasAnyOf(leftPart, BRACKETS) || MethodSignature.hasAnyOf(rightPart, BRACKETS) || MethodSignature.hasAnyOf(paramsPart, BRACKETS)) {
            return null;
        }
        MethodSignature sig = MethodSignature.parseNameAndReturnType(leftPart, rightPart);
        if (sig == null) {
            return null;
        }
        return MethodSignature.addParsedParameters(sig, paramsPart);
    }

    private static MethodSignature parseNameAndReturnType(String leftPart, String rightPart) {
        leftPart = leftPart.trim();
        if ((rightPart = rightPart.trim()).length() == 0) {
            int blank = leftPart.indexOf(32);
            if (blank == -1) {
                return MethodSignature.safeCreateSignature(leftPart, null, null, null);
            }
            return MethodSignature.safeCreateSignature(leftPart.substring(0, blank).trim(), null, null, leftPart.substring(blank).trim());
        }
        if (rightPart.charAt(0) != ':') {
            return null;
        }
        return MethodSignature.safeCreateSignature(leftPart, null, null, rightPart.substring(1).trim());
    }

    private static MethodSignature addParsedParameters(MethodSignature sig, String paramsPart) {
        if (paramsPart.indexOf(DOUBLE_COMMA) != -1) {
            return null;
        }
        ArrayList parameterTypes = new ArrayList();
        ArrayList parameterNames = new ArrayList();
        try {
            StringTokenizer tokenizer = new StringTokenizer(paramsPart, SINGLE_COMMA);
            while (tokenizer.hasMoreTokens()) {
                MethodSignature.parseSingleParameter(parameterTypes, parameterNames, tokenizer.nextToken());
            }
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return sig.setParameters(parameterTypes.toArray(new String[parameterTypes.size()]), parameterNames.toArray(new String[parameterNames.size()]));
    }

    private static void parseSingleParameter(ArrayList parameterTypes, ArrayList parameterNames, String param) throws IllegalArgumentException {
        if ((param = param.trim()).length() == 0) {
            throw new IllegalArgumentException();
        }
        int colon = param.indexOf(58);
        if (colon != -1) {
            String name = param.substring(0, colon).trim();
            if (name.length() == 0) {
                name = MethodSignature.inventName(parameterTypes.size());
            }
            String type = param.substring(colon + 1).trim();
            MethodSignature.addParameter(parameterTypes, parameterNames, type, name);
            return;
        }
        int blank = param.indexOf(32);
        if (blank == -1) {
            MethodSignature.addParameter(parameterTypes, parameterNames, param, MethodSignature.inventName(parameterTypes.size()));
        } else {
            String type = param.substring(0, blank).trim();
            String name = param.substring(blank + 1).trim();
            MethodSignature.addParameter(parameterTypes, parameterNames, type, name);
        }
    }

    private static void addParameter(ArrayList parameterTypes, ArrayList parameterNames, String type, String name) throws IllegalArgumentException {
        if (!ValidationUtils.getInstance().validateMethodParameter(name, type)) {
            throw new IllegalArgumentException();
        }
        parameterTypes.add(type);
        parameterNames.add(name);
    }

    private static String inventName(int i) {
        return ARG_PREFIX + (i + 1);
    }

    public AbstractSignature setName(String name) {
        return MethodSignature.safeCreateSignature(name, this.getParameterTypeFQNs(), this.getParameterNames(), this.getReturnType());
    }

    public MethodSignature setParameters(String[] parameterTypeFQNs, String[] parameterNames) {
        return MethodSignature.safeCreateSignature(this.getName(), parameterTypeFQNs, parameterNames, this.getReturnType());
    }

    public MethodSignature setReturnType(String returnType) {
        return MethodSignature.safeCreateSignature(this.getName(), this.getParameterTypeFQNs(), this.getParameterNames(), returnType);
    }

    public String[] getParameterNames() {
        return this.myParameterNames;
    }

    public String[] getParameterTypeFQNs() {
        return this.myParameterTypeFQNs;
    }

    public String getReturnType() {
        return this.myReturnType;
    }

    public boolean isValid() {
        if (this.getName() == null || this.getParameterTypeFQNs() == null || this.getReturnType() == null) {
            return false;
        }
        return MethodSignature.safeCreateSignature(this.getName(), this.getParameterTypeFQNs(), this.getParameterNames(), this.getReturnType()) != null;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(AbstractSignature.unnullify(this.getReturnType())).append(' ').append(AbstractSignature.unnullify(this.getName()));
        if (this.getParameterTypeFQNs() != null) {
            result.append('(');
            int i = 0;
            int iMax = this.getParameterTypeFQNs().length;
            while (i < iMax) {
                if (i > 0) {
                    result.append(SINGLE_COMMA).append(' ');
                }
                result.append(AbstractSignature.unnullify(this.getParameterTypeFQNs()[i])).append(' ').append(AbstractSignature.unnullify(this.getParameterNames()[i]));
                ++i;
            }
            result.append(')');
        }
        return result.toString();
    }

    public String toUMLString() {
        StringBuffer result = new StringBuffer();
        result.append(AbstractSignature.unnullify(this.getName()));
        if (this.getParameterTypeFQNs() != null) {
            result.append('(');
            int i = 0;
            int iMax = this.getParameterTypeFQNs().length;
            while (i < iMax) {
                if (i > 0) {
                    result.append(SINGLE_COMMA).append(' ');
                }
                result.append(AbstractSignature.unnullify(this.getParameterNames()[i])).append(':').append(AbstractSignature.unnullify(this.getParameterTypeFQNs()[i]));
                ++i;
            }
            result.append(')');
        }
        result.append(':').append(AbstractSignature.unnullify(this.getReturnType()));
        return result.toString();
    }

    public String toUnqualifiedFullName() {
        StringBuffer result = new StringBuffer();
        result.append(AbstractSignature.unnullify(this.getName()));
        if (this.getParameterTypeFQNs() != null) {
            result.append('(');
            int i = 0;
            int iMax = this.getParameterTypeFQNs().length;
            while (i < iMax) {
                if (i > 0) {
                    result.append(SINGLE_COMMA).append(' ');
                }
                result.append(AbstractSignature.unnullify(this.getParameterTypeFQNs()[i]));
                ++i;
            }
            result.append(')');
        }
        return result.toString();
    }

    private static boolean hasAnyOf(String who, char[] what) {
        int i = 0;
        while (i < what.length) {
            if (who.indexOf(what[i]) >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean equals(Object another) {
        if (another instanceof MethodSignature) {
            MethodSignature that = (MethodSignature)another;
            return AbstractSignature.equals(this.getName(), that.getName()) && Arrays.equals(this.getParameterTypeFQNs(), that.getParameterTypeFQNs());
        }
        return false;
    }

    public int hashCode() {
        int result;
        int n = result = this.getName() == null ? 65535 : this.getName().hashCode();
        if (this.getParameterTypeFQNs() != null) {
            result += this.getParameterTypeFQNs().length * 31;
            int i = 0;
            while (i < this.getParameterTypeFQNs().length) {
                result = 17 * result + this.getParameterTypeFQNs()[i].hashCode();
                ++i;
            }
        }
        return result;
    }
}

