/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.utils.signature;

import com.tssap.j2ee.core.inheritance.utils.ValidationUtils;
import com.tssap.j2ee.core.utils.signature.AbstractSignature;

public class FieldSignature
extends AbstractSignature {
    private String myType;
    private static final char COLON = ':';
    private static final char SPACE = ' ';

    public FieldSignature(String name, String type) {
        super(name);
        this.myType = type;
    }

    public static FieldSignature fromUMLRepresentation(String uml) {
        if (uml == null) {
            return null;
        }
        if ((uml = uml.trim()).length() == 0) {
            return null;
        }
        int colonIndex = uml.indexOf(58);
        if (colonIndex == -1) {
            return FieldSignature.parseTypeNameFormat(uml);
        }
        int lastColonIndex = uml.lastIndexOf(58);
        if (colonIndex != lastColonIndex) {
            return null;
        }
        return FieldSignature.parseNameColonTypeFormat(uml, colonIndex);
    }

    private static FieldSignature parseTypeNameFormat(String uml) {
        int spaceIndex = uml.indexOf(32);
        if (spaceIndex == -1) {
            return FieldSignature.safeCreateSignature(uml, null);
        }
        return FieldSignature.safeCreateSignature(uml.substring(0, spaceIndex), uml.substring(spaceIndex + 1).trim());
    }

    private static FieldSignature parseNameColonTypeFormat(String uml, int colonIndex) {
        return FieldSignature.safeCreateSignature(uml.substring(colonIndex + 1).trim(), uml.substring(0, colonIndex).trim());
    }

    private static FieldSignature safeCreateSignature(String name, String type) {
        name = AbstractSignature.nullify(name);
        type = AbstractSignature.nullify(type);
        if (name != null && !ValidationUtils.getInstance().validateFieldName(name)) {
            return null;
        }
        if (type != null && !ValidationUtils.getInstance().validateFieldType(type)) {
            return null;
        }
        return new FieldSignature(name, type);
    }

    public AbstractSignature setName(String name) {
        return FieldSignature.safeCreateSignature(name, this.getType());
    }

    public FieldSignature setType(String type) {
        return FieldSignature.safeCreateSignature(this.getName(), type);
    }

    public String getType() {
        return this.myType;
    }

    public boolean isValid() {
        if (this.getName() == null || this.getType() == null) {
            return false;
        }
        return FieldSignature.safeCreateSignature(this.getName(), this.getType()) != null;
    }

    public String toString() {
        return AbstractSignature.unnullify(this.getType()) + ' ' + AbstractSignature.unnullify(this.getName());
    }

    public String toUMLString() {
        return AbstractSignature.unnullify(this.getName()) + ':' + AbstractSignature.unnullify(this.getType());
    }

    public String toUnqualifiedFullName() {
        return AbstractSignature.unnullify(this.getName());
    }

    public boolean equals(Object another) {
        if (another instanceof FieldSignature) {
            FieldSignature that = (FieldSignature)another;
            return AbstractSignature.equals(this.getName(), that.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName() == null ? 65535 : this.getName().hashCode();
    }
}

