/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.framework.core;

import com.sap.aii.proxy.framework.core.DataAccessException;
import com.sap.aii.proxy.framework.core.DateTimeAccessException;
import com.sap.aii.proxy.framework.core.EnumerationType;
import com.sap.aii.proxy.framework.core.XmlProxyRuntimeException;
import com.sap.aii.proxy.framework.core.XsdlProperties;
import com.sap.aii.proxy.framework.core.XsdlTypeRestrictions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public final class XmlUtils {
    private static final TimeZone timeZoneThis = TimeZone.getDefault();
    private static final TimeZone timeZoneUTC = TimeZone.getTimeZone("UTC");
    private static final Calendar calendar = Calendar.getInstance();
    private static final Calendar calendarUTC = Calendar.getInstance(timeZoneUTC);
    private static String timeZoneOffsetString = null;
    private static Object lock = new Object();
    private static SimpleDateFormat timeFormat = null;
    private static SimpleDateFormat dateTimeFormat = null;
    private static SimpleDateFormat dateFormat = null;
    private static SimpleDateFormat gDayFormat = null;
    private static SimpleDateFormat gMonthDayFormat = null;
    private static SimpleDateFormat gMonthFormat = null;
    private static SimpleDateFormat gYearMonthFormat = null;
    private static SimpleDateFormat gYearFormat = null;
    private static SimpleDateFormat durationFormat = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$util$Calendar;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class array$Ljava$lang$String;

    public static final boolean isJavaType(Object o) {
        return o != null && XmlUtils.isJavaType(o.getClass());
    }

    public static final boolean isJavaType(Class c) {
        return c != null && (c.isPrimitive() || c.isArray() || XmlUtils.isJavaType(c.getName()));
    }

    public static final boolean isJavaType(String type) {
        if (type == null) {
            return false;
        }
        return type.equals("java.lang.String") || type.equals("String") || type.equals("java.lang.Integer") || type.equals("Integer") || type.equals("java.lang.Long") || type.equals("Long") || type.equals("java.lang.Short") || type.equals("Short") || type.equals("java.lang.Float") || type.equals("Float") || type.equals("java.lang.Double") || type.equals("Double") || type.equals("java.lang.Byte") || type.equals("Byte") || type.equals("java.lang.Boolean") || type.equals("Boolean") || type.equals("java.math.BigDecimal") || type.equals("BigDecimal") || type.equals("java.math.BigInteger") || type.equals("BigInteger") || type.equals("java.util.Calendar") || type.equals("Calendar") || type.equals("java.sql.Date") || type.equals("Date") || type.equals("java.sql.Time") || type.equals("Time") || type.equals("java.lang.Object") || type.equals("Object") || type.equals("boolean") || type.equals("byte") || type.equals("int") || type.equals("long") || type.equals("short") || type.equals("float") || type.equals("double");
    }

    static final boolean isEnumerationType(Class c) {
        boolean isEnumerationType = false;
        if (c != null) {
            try {
                isEnumerationType = Class.forName("com.sap.aii.proxy.framework.core.EnumerationType").isAssignableFrom(c);
            }
            catch (Exception e) {
                throw new XmlProxyRuntimeException("Error checking c against EnumerationType", (Throwable)e);
            }
        }
        return isEnumerationType;
    }

    public static final boolean isEnumerationType(Object o) {
        return o != null && XmlUtils.isEnumerationType(o.getClass());
    }

    public static final boolean isEnumerationType(String type) {
        if (type == null) {
            return false;
        }
        try {
            Class<?> c = Class.forName(type);
            return XmlUtils.isEnumerationType(c);
        }
        catch (Exception exception) {
            return false;
        }
    }

    static final Object getInstance(Class javaClass, String value, XsdlProperties props) {
        String xmlType;
        SimpleDateFormat dateFormat;
        if (javaClass == null) {
            return null;
        }
        Object result = null;
        if (javaClass.equals(class$java$lang$String == null ? (class$java$lang$String = XmlUtils.class$("java.lang.String")) : class$java$lang$String)) {
            result = value == null ? new String() : String.valueOf(value);
        } else if (javaClass.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = XmlUtils.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            result = value == null ? new Integer(0) : Integer.valueOf(value);
        } else if (javaClass.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = XmlUtils.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            result = value == null ? new Byte(0) : Byte.valueOf(value);
        } else if (javaClass.equals(class$java$lang$Short == null ? (class$java$lang$Short = XmlUtils.class$("java.lang.Short")) : class$java$lang$Short)) {
            result = value == null ? new Short(0) : Short.valueOf(value);
        } else if (javaClass.equals(class$java$lang$Long == null ? (class$java$lang$Long = XmlUtils.class$("java.lang.Long")) : class$java$lang$Long)) {
            result = value == null ? new Long(0L) : Long.valueOf(value);
        } else if (javaClass.equals(class$java$lang$Float == null ? (class$java$lang$Float = XmlUtils.class$("java.lang.Float")) : class$java$lang$Float)) {
            result = value == null ? new Float(0.0f) : Float.valueOf(value);
        } else if (javaClass.equals(class$java$lang$Double == null ? (class$java$lang$Double = XmlUtils.class$("java.lang.Double")) : class$java$lang$Double)) {
            result = value == null ? new Double(0.0) : Double.valueOf(value);
        } else if (javaClass.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = XmlUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            result = value == null ? new Boolean(false) : Boolean.valueOf(value);
        } else if (javaClass.equals(class$java$math$BigInteger == null ? (class$java$math$BigInteger = XmlUtils.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            result = new BigInteger(value == null ? "0" : value);
        } else if (javaClass.equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = XmlUtils.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            result = new BigDecimal(value == null ? "0" : value);
        }
        if (result != null) {
            XsdlTypeRestrictions restrictions;
            if (props != null && (restrictions = props.getRestrictions()) != null) {
                BigInteger scale;
                Set enumeration = restrictions.getEnumeration();
                if (enumeration != null && !enumeration.isEmpty() && !enumeration.contains(value)) {
                    throw EnumerationType.createIllegalArgumentException(props.getName(), value);
                }
                if (javaClass.equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = XmlUtils.class$("java.math.BigDecimal")) : class$java$math$BigDecimal) && (scale = restrictions.getFractionDigits()) != null) {
                    int intScale = scale.intValue();
                    result = ((BigDecimal)result).setScale(intScale);
                }
            }
            return result;
        }
        if (javaClass.equals(class$java$util$Calendar == null ? (class$java$util$Calendar = XmlUtils.class$("java.util.Calendar")) : class$java$util$Calendar)) {
            dateFormat = null;
            xmlType = null;
            if (props != null && (xmlType = props.getXmlType()) != null) {
                dateFormat = XmlUtils.getDateFormat(xmlType);
            }
            if (dateFormat != null) {
                ParsePosition parsePosition;
                java.util.Date parsedDate;
                if (value == null) {
                    value = xmlType != null && xmlType.endsWith("ime") ? "00:00:00" : "0000-00-00";
                }
                TimeZone timeZone = TimeZone.getTimeZone("UTC");
                int offsetInMSec = 0;
                int length = value.length();
                if (length >= 1 && value.charAt(length - 1) == 'Z' || length >= 3 && value.charAt(length - 3) == ':' && length >= 6 && (value.charAt(length - 6) == '+' || value.charAt(length - 6) == '-')) {
                    if (value.charAt(length - 1) == 'Z') {
                        value = value.substring(0, length - 1);
                    } else {
                        boolean isPositiveOffset = value.charAt(length - 6) == '+';
                        SimpleDateFormat offsetFormat = new SimpleDateFormat("HH:mm");
                        offsetFormat.setTimeZone(timeZoneUTC);
                        java.util.Date offset = null;
                        try {
                            offset = offsetFormat.parse(value.substring(length - 5));
                        }
                        catch (ParseException ex) {
                            if (xmlType != null && xmlType.indexOf("urn:sap-com:document:sap:rfc:functions") >= 0) {
                                return value;
                            }
                            String valueString = value.substring(length - 5);
                            String expected = offsetFormat.toPattern() + " for offset";
                            if (xmlType != null) {
                                if (xmlType.indexOf("dateTime") >= 0) {
                                    throw new DateTimeAccessException(DateTimeAccessException.createMsg_IS_INCOMPATIBLE_DATETIME(valueString, expected), value);
                                }
                                if (xmlType.indexOf("date") >= 0) {
                                    throw new DateTimeAccessException(DateTimeAccessException.createMsg_IS_INCOMPATIBLE_DATE(valueString, expected), value);
                                }
                                if (xmlType.indexOf("time") >= 0) {
                                    throw new DateTimeAccessException(DateTimeAccessException.createMsg_IS_INCOMPATIBLE_TIME(valueString, expected), value);
                                }
                            }
                            throw new DataAccessException(DataAccessException.createMsg_UNKNOWN_DATE_OR_TIME_FORMAT(valueString, expected));
                        }
                        calendarUTC.setTime(offset);
                        offsetInMSec = (calendarUTC.get(12) + 60 * calendarUTC.get(10)) * 60000;
                        if (!isPositiveOffset) {
                            offsetInMSec = -offsetInMSec;
                        }
                        value = value.substring(0, length - 6);
                    }
                    if (xmlType != null && xmlType.endsWith("ime")) {
                        timeZone.setRawOffset(offsetInMSec);
                        dateFormat.setTimeZone(timeZone);
                    }
                }
                if ((parsedDate = dateFormat.parse(value, parsePosition = new ParsePosition(0))) == null) {
                    if (xmlType != null && xmlType.indexOf("urn:sap-com:document:sap:rfc:functions") >= 0) {
                        return value;
                    }
                    String expected = dateFormat.toPattern();
                    if (xmlType != null) {
                        if (xmlType.indexOf("dateTime") >= 0) {
                            throw new DateTimeAccessException(DateTimeAccessException.createMsg_IS_INCOMPATIBLE_DATETIME(value, expected), value);
                        }
                        if (xmlType.indexOf("date") >= 0) {
                            throw new DateTimeAccessException(DateTimeAccessException.createMsg_IS_INCOMPATIBLE_DATE(value, expected), value);
                        }
                        if (xmlType.indexOf("time") >= 0) {
                            throw new DateTimeAccessException(DateTimeAccessException.createMsg_IS_INCOMPATIBLE_TIME(value, expected), value);
                        }
                    }
                    throw new DataAccessException(DataAccessException.createMsg_UNKNOWN_DATE_OR_TIME_FORMAT(value, expected));
                }
                int mSecs = XmlUtils.getMSecs(value, parsePosition);
                Calendar result2 = Calendar.getInstance(timeZone);
                result2.setTime(parsedDate);
                if (mSecs != 0) {
                    result2.set(14, mSecs);
                }
                result2.getTime();
                return result2;
            }
        }
        if (javaClass.equals(class$java$sql$Date == null ? (class$java$sql$Date = XmlUtils.class$("java.sql.Date")) : class$java$sql$Date) || javaClass.equals(class$java$sql$Time == null ? (class$java$sql$Time = XmlUtils.class$("java.sql.Time")) : class$java$sql$Time)) {
            dateFormat = null;
            xmlType = null;
            if (props != null && (xmlType = props.getXmlType()) != null) {
                dateFormat = XmlUtils.getDateFormat(xmlType);
            }
            if (dateFormat != null) {
                ParsePosition parsePosition;
                java.util.Date parsedDate;
                if (javaClass.equals(class$java$sql$Date == null ? (class$java$sql$Date = XmlUtils.class$("java.sql.Date")) : class$java$sql$Date) && xmlType != null && xmlType.indexOf("duration") > 0) {
                    if (value == null) {
                        value = "P0Y0M0DT0H0M0S";
                    }
                    SimpleDateFormat durationFormat = !value.startsWith("-") ? dateFormat : new SimpleDateFormat("'-P'yyyy'Y'MM'M'dd'DT'HH'H'mm'M'ss.SSS'S'");
                    durationFormat.setTimeZone(timeZoneUTC);
                    java.util.Date date = null;
                    try {
                        date = durationFormat.parse(value);
                    }
                    catch (ParseException e) {
                        String expected = durationFormat.toPattern() + " for duration";
                        if (xmlType != null) {
                            if (xmlType.indexOf("dateTime") >= 0) {
                                throw new DateTimeAccessException(DateTimeAccessException.createMsg_IS_INCOMPATIBLE_DATETIME(value, expected), value);
                            }
                            if (xmlType.indexOf("date") >= 0) {
                                throw new DateTimeAccessException(DateTimeAccessException.createMsg_IS_INCOMPATIBLE_DATE(value, expected), value);
                            }
                            if (xmlType.indexOf("time") >= 0) {
                                throw new DateTimeAccessException(DateTimeAccessException.createMsg_IS_INCOMPATIBLE_TIME(value, expected), value);
                            }
                        }
                        throw new DataAccessException(DataAccessException.createMsg_UNKNOWN_DATE_OR_TIME_FORMAT(value, expected));
                    }
                    return new Date(date.getTime());
                }
                if (value == null) {
                    value = javaClass.equals(class$java$sql$Date == null ? (class$java$sql$Date = XmlUtils.class$("java.sql.Date")) : class$java$sql$Date) ? "0000-00-00" : "00:00:00";
                }
                int offsetInMSec = 0;
                int length = value.length();
                if (length >= 1 && value.charAt(length - 1) == 'Z' || length >= 3 && value.charAt(length - 3) == ':' && length >= 6 && (value.charAt(length - 6) == '+' || value.charAt(length - 6) == '-')) {
                    if (value.charAt(length - 1) == 'Z') {
                        value = value.substring(0, length - 1);
                    } else {
                        boolean isPositiveOffset = value.charAt(length - 6) == '+';
                        SimpleDateFormat offsetFormat = new SimpleDateFormat("HH:mm");
                        offsetFormat.setTimeZone(timeZoneUTC);
                        java.util.Date offset = null;
                        try {
                            offset = offsetFormat.parse(value.substring(length - 5));
                        }
                        catch (ParseException ex) {
                            if (xmlType != null && xmlType.indexOf("urn:sap-com:document:sap:rfc:functions") >= 0) {
                                return value;
                            }
                            String valueString = value.substring(length - 5);
                            String expected = offsetFormat.toPattern() + " for offset";
                            if (xmlType != null) {
                                if (xmlType.indexOf("dateTime") >= 0) {
                                    throw new DateTimeAccessException(DateTimeAccessException.createMsg_IS_INCOMPATIBLE_DATETIME(valueString, expected), value);
                                }
                                if (xmlType.indexOf("date") >= 0) {
                                    throw new DateTimeAccessException(DateTimeAccessException.createMsg_IS_INCOMPATIBLE_DATE(valueString, expected), value);
                                }
                                if (xmlType.indexOf("time") >= 0) {
                                    throw new DateTimeAccessException(DateTimeAccessException.createMsg_IS_INCOMPATIBLE_TIME(valueString, expected), value);
                                }
                            }
                            throw new DataAccessException(DataAccessException.createMsg_UNKNOWN_DATE_OR_TIME_FORMAT(valueString, expected));
                        }
                        calendarUTC.setTime(offset);
                        offsetInMSec = (calendarUTC.get(12) + 60 * calendarUTC.get(10)) * 60000;
                        if (!isPositiveOffset) {
                            offsetInMSec = -offsetInMSec;
                        }
                        value = value.substring(0, length - 6);
                    }
                    if (javaClass.equals(class$java$sql$Time == null ? (class$java$sql$Time = XmlUtils.class$("java.sql.Time")) : class$java$sql$Time) || xmlType != null && xmlType.indexOf("dateTime") > 0) {
                        TimeZone timeZone = TimeZone.getDefault();
                        timeZone.setRawOffset(offsetInMSec);
                        dateFormat.setTimeZone(timeZone);
                    }
                }
                if ((parsedDate = dateFormat.parse(value, parsePosition = new ParsePosition(0))) == null) {
                    if (xmlType != null && xmlType.indexOf("urn:sap-com:document:sap:rfc:functions") >= 0) {
                        return value;
                    }
                    String expected = dateFormat.toPattern();
                    if (xmlType != null) {
                        if (xmlType.indexOf("dateTime") >= 0) {
                            throw new DateTimeAccessException(DateTimeAccessException.createMsg_IS_INCOMPATIBLE_DATETIME(value, expected), value);
                        }
                        if (xmlType.indexOf("date") >= 0) {
                            throw new DateTimeAccessException(DateTimeAccessException.createMsg_IS_INCOMPATIBLE_DATE(value, expected), value);
                        }
                        if (xmlType.indexOf("time") >= 0) {
                            throw new DateTimeAccessException(DateTimeAccessException.createMsg_IS_INCOMPATIBLE_TIME(value, expected), value);
                        }
                    }
                    throw new DataAccessException(DataAccessException.createMsg_UNKNOWN_DATE_OR_TIME_FORMAT(value, expected));
                }
                long time = XmlUtils.getTimeWithMSec(parsedDate.getTime(), value, parsePosition);
                if (javaClass.equals(class$java$sql$Date == null ? (class$java$sql$Date = XmlUtils.class$("java.sql.Date")) : class$java$sql$Date)) {
                    return new Date(time);
                }
                return new Time(time);
            }
            return null;
        }
        if (javaClass.equals(array$Ljava$lang$String == null ? (array$Ljava$lang$String = XmlUtils.class$("[Ljava.lang.String;")) : array$Ljava$lang$String)) {
            Vector<String> vector = new Vector<String>();
            if (value != null) {
                StringTokenizer tokenizer = new StringTokenizer(value, " ");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    vector.add(token);
                }
            }
            String[] array = new String[vector.size()];
            return vector.toArray(array);
        }
        return null;
    }

    static final String valueAsString(Object value, XsdlProperties props) {
        if (value == null) {
            return null;
        }
        String result = null;
        if (value instanceof String || value instanceof Integer || value instanceof Byte || value instanceof Short || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Boolean || value instanceof BigInteger || value instanceof BigDecimal) {
            result = value.toString();
        }
        if (result != null) {
            XsdlTypeRestrictions restrictions;
            if (props != null && (restrictions = props.getRestrictions()) != null) {
                BigInteger scale;
                Set enumeration = restrictions.getEnumeration();
                if (enumeration != null && !enumeration.isEmpty() && !enumeration.contains(result)) {
                    throw EnumerationType.createIllegalArgumentException(props.getName(), result);
                }
                if (!(value instanceof String) && value instanceof BigDecimal && (scale = restrictions.getFractionDigits()) != null) {
                    int intScale = scale.intValue();
                    value = ((BigDecimal)value).setScale(intScale);
                    result = value.toString();
                }
            }
            return result;
        }
        if (value instanceof Calendar) {
            SimpleDateFormat dateFormat = null;
            String xmlType = null;
            if (props != null && (xmlType = props.getXmlType()) != null) {
                dateFormat = XmlUtils.getDateFormat(xmlType);
            }
            if (dateFormat != null) {
                java.util.Date valueAsDate = ((Calendar)value).getTime();
                if (xmlType != null && xmlType.endsWith("ime")) {
                    dateFormat = XmlUtils.getDateFormatWithMSec(dateFormat, xmlType, valueAsDate);
                    return dateFormat.format(valueAsDate) + timeZoneOffsetString;
                }
                return dateFormat.format(valueAsDate);
            }
            return null;
        }
        if (value instanceof Date || value instanceof Time) {
            SimpleDateFormat dateFormat = null;
            String xmlType = null;
            if (props != null && (xmlType = props.getXmlType()) != null) {
                dateFormat = XmlUtils.getDateFormat(xmlType);
            }
            if (dateFormat != null) {
                if (value instanceof Time || xmlType != null && xmlType.indexOf("dateTime") > 0) {
                    dateFormat = XmlUtils.getDateFormatWithMSec(dateFormat, xmlType, (java.util.Date)value);
                    return dateFormat.format((java.util.Date)value) + timeZoneOffsetString;
                }
                if (xmlType != null && xmlType.indexOf("duration") > 0) {
                    int msec = (int)((Date)value).getTime();
                    SimpleDateFormat durationFormat = msec >= 0 ? dateFormat : new SimpleDateFormat("'-P'yyyy'Y'MM'M'dd'DT'HH'H'mm'M'ss.SSS'S'");
                    durationFormat.setTimeZone(timeZoneUTC);
                    String valueString = durationFormat.format(value);
                    return valueString;
                }
                return dateFormat.format((java.util.Date)value);
            }
            return null;
        }
        if (value instanceof String[]) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < ((String[])value).length) {
                if (buffer.length() > 0) {
                    buffer.append(' ');
                }
                buffer.append(((String[])value)[i]);
                ++i;
            }
            return new String(buffer);
        }
        return null;
    }

    private static SimpleDateFormat getDateFormat(String xmlType) {
        if (xmlType == null) {
            return null;
        }
        if (xmlType.indexOf("time") >= 0) {
            Object object = lock;
            synchronized (object) {
                if (timeFormat == null) {
                    timeFormat = new SimpleDateFormat("HH:mm:ss");
                } else {
                    timeFormat.applyPattern("HH:mm:ss");
                }
                timeFormat.setTimeZone(timeZoneThis);
            }
            return timeFormat;
        }
        if (xmlType.indexOf("dateTime") >= 0) {
            Object object = lock;
            synchronized (object) {
                if (dateTimeFormat == null) {
                    dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                } else {
                    dateTimeFormat.applyPattern("yyyy-MM-dd'T'HH:mm:ss");
                }
                dateTimeFormat.setTimeZone(timeZoneThis);
            }
            return dateTimeFormat;
        }
        if (xmlType.indexOf("date") >= 0) {
            Object object = lock;
            synchronized (object) {
                if (dateFormat == null) {
                    dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                }
            }
            return dateFormat;
        }
        if (xmlType.indexOf("gDay") >= 0) {
            Object object = lock;
            synchronized (object) {
                if (gDayFormat == null) {
                    gDayFormat = new SimpleDateFormat("---dd");
                }
            }
            return gDayFormat;
        }
        if (xmlType.indexOf("gMonthDay") >= 0) {
            Object object = lock;
            synchronized (object) {
                if (gMonthDayFormat == null) {
                    gMonthDayFormat = new SimpleDateFormat("--MM-dd");
                }
            }
            return gMonthDayFormat;
        }
        if (xmlType.indexOf("gMonth") >= 0) {
            Object object = lock;
            synchronized (object) {
                if (gMonthFormat == null) {
                    gMonthFormat = new SimpleDateFormat("--MM--");
                }
            }
            return gMonthFormat;
        }
        if (xmlType.indexOf("gYearMonth") >= 0) {
            Object object = lock;
            synchronized (object) {
                if (gYearMonthFormat == null) {
                    gYearMonthFormat = new SimpleDateFormat("yyyy-MM");
                }
            }
            return gYearMonthFormat;
        }
        if (xmlType.indexOf("gYear") >= 0) {
            Object object = lock;
            synchronized (object) {
                if (gYearFormat == null) {
                    gYearFormat = new SimpleDateFormat("yyyy");
                }
            }
            return gYearFormat;
        }
        if (xmlType.indexOf("duration") >= 0) {
            Object object = lock;
            synchronized (object) {
                if (durationFormat == null) {
                    durationFormat = new SimpleDateFormat("'P'yyyy'Y'MM'M'dd'DT'HH'H'mm'M'ss.SSS'S'");
                    durationFormat.setTimeZone(timeZoneUTC);
                }
            }
            return durationFormat;
        }
        return null;
    }

    private static int getMSecs(String value, ParsePosition parsePosition) {
        int parsePos;
        int mSecs = 0;
        int length = value == null ? 0 : value.length();
        int n = parsePos = parsePosition == null ? 0 : parsePosition.getIndex();
        if (parsePos < length && value != null && value.charAt(parsePos) == '.') {
            ++parsePos;
            int fraction = 100;
            while (parsePos < length) {
                int fractionSec = Integer.parseInt(value.substring(parsePos, parsePos + 1));
                mSecs += fractionSec * fraction;
                fraction /= 10;
                ++parsePos;
            }
        }
        return mSecs;
    }

    private static long getTimeWithMSec(long time, String value, ParsePosition parsePosition) {
        int parsePos;
        int length = value == null ? 0 : value.length();
        int n = parsePos = parsePosition == null ? 0 : parsePosition.getIndex();
        if (parsePos < length && value != null && value.charAt(parsePos) == '.') {
            ++parsePos;
            long fraction = 100L;
            while (parsePos < length) {
                long fractionSec = Long.parseLong(value.substring(parsePos, parsePos + 1));
                time += fractionSec * fraction;
                fraction /= 10L;
                ++parsePos;
            }
        }
        return time;
    }

    private static SimpleDateFormat getDateFormatWithMSec(SimpleDateFormat dateFormat, String xmlType, java.util.Date value) {
        long time;
        long l = time = value == null ? 0L : value.getTime();
        if (time < 0L) {
            time = -time;
        }
        StringBuffer buffer = new StringBuffer();
        if (xmlType != null) {
            if (xmlType.indexOf("time") >= 0) {
                buffer.append("HH:mm:ss");
            } else if (xmlType.indexOf("dateTime") >= 0) {
                buffer.append("yyyy-MM-dd'T'HH:mm:ss");
            }
        }
        long fraction = 1000L;
        while (time > 0L) {
            if ((time -= time / fraction * fraction) > 0L) {
                if (fraction == 1000L) {
                    buffer.append(".S");
                } else {
                    buffer.append("S");
                }
            }
            fraction /= 10L;
        }
        if (dateFormat != null) {
            dateFormat.applyPattern(buffer.toString());
        }
        return dateFormat;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        long timeZoneOffsetInMSec = calendar.get(15) + calendar.get(16);
        Time timeZoneOffset = new Time(timeZoneOffsetInMSec);
        SimpleDateFormat timeZoneOffsetFormat = timeZoneOffsetInMSec >= 0L ? new SimpleDateFormat("+HH:mm") : new SimpleDateFormat("-HH:mm");
        timeZoneOffsetFormat.setTimeZone(timeZoneUTC);
        timeZoneOffsetString = timeZoneOffsetInMSec == 0L ? "Z" : timeZoneOffsetFormat.format(timeZoneOffset);
    }
}

