/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.framework.core;

import com.sap.aii.proxy.framework.core.BaseType;
import com.sap.aii.proxy.framework.core.XmlAnyAttribute;
import com.sap.aii.proxy.framework.core.XmlContentHandlerImpl;
import com.sap.aii.proxy.framework.core.XmlProxyRuntimeException;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class XmlParser {
    private static final String COMMENT_BEGIN = "<!-- ";
    private static final String COMMENT_END = " -->";
    private static final String ELEMENT_BEGIN = "<";
    private static final String ELEMENT_END_BEGIN = "</";
    private static final String ELEMENT_CLOSE = ">";
    private static final String ELEMENT_END = "/>";
    private static final String EQUALS = "=";
    private static final String EQUALS_BEGIN = "=\"";
    private static final String EQUALS_END = "\"";
    private static final String INSTRUCTION_BEGIN = "<?";
    private static final String INSTRUCTION_END = "?>";
    private static final String NAME_SEPARATOR = ":";
    private static final String XML_NAMESPACE_PREFIX = "xmlns";
    private static final String XML_VERSION_NAME = "xml version";
    private static final String XML_VERSION = "1.0";
    private static final String XML_STANDALONE_NO = "standalone=\"no\"";
    private static final String SPACE = " ";
    private static final String QUOTE = "\"";
    private static final String EMPTY_STRING = "";
    private static final String DOCUMENT_BUILDER_FACTORY_URI = "com.inqmy.lib.jaxp.DocumentBuilderFactoryImpl";
    private static final String PARSER_FACTORY_URI = "com.inqmy.lib.jaxp.SAXParserFactoryImpl";
    private static final Location loc = Location.getLocation((String)(class$com$sap$aii$proxy$framework$core$XmlParser == null ? (class$com$sap$aii$proxy$framework$core$XmlParser = XmlParser.class$("com.sap.aii.proxy.framework.core.XmlParser")) : class$com$sap$aii$proxy$framework$core$XmlParser).getName());
    private XMLReader parser;
    static /* synthetic */ Class class$com$sap$aii$proxy$framework$core$XmlParser;

    public XmlParser() {
        String _methodName = "XmlParser()";
        try {
            SAXParserFactory f = SAXParserFactory.newInstance();
            f.setNamespaceAware(true);
            f.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            this.parser = f.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException e) {
            if (loc.beLogged(500)) {
                loc.logT(500, _methodName, "Error configuring parser. Exception: {0}", new Object[]{e.getMessage()});
            }
            throw new XmlProxyRuntimeException("Error configuring parser: " + e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            if (loc.beLogged(500)) {
                loc.logT(500, _methodName, "Error instantiating parser. Exception: {0}", new Object[]{e.getMessage()});
            }
            throw new XmlProxyRuntimeException("Error instantiating parser: " + e.getMessage(), (Throwable)e);
        }
    }

    public void parseDocument(String document, BaseType baseType) {
        if (document == null) {
            return;
        }
        String _methodName = "parseDocument(...)";
        try {
            this.parser.setContentHandler(new XmlContentHandlerImpl(baseType));
            this.parser.parse(new InputSource(new StringReader(document)));
        }
        catch (IOException e) {
            if (loc.beLogged(500)) {
                loc.logT(500, _methodName, "Error reading document. Exception: {0}", new Object[]{e.getMessage()});
            }
            throw new XmlProxyRuntimeException("Error reading document: " + e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            if (loc.beLogged(500)) {
                loc.logT(500, _methodName, "Error parsing document. Exception: {0}", new Object[]{e.getMessage()});
            }
            throw new XmlProxyRuntimeException("Error parsing document: " + e.getMessage(), (Throwable)e);
        }
    }

    public void parseStream(InputStream stream, BaseType baseType) {
        if (stream == null) {
            return;
        }
        String _methodName = "parseStream(...)";
        try {
            this.parser.setContentHandler(new XmlContentHandlerImpl(baseType));
            this.parser.parse(new InputSource(stream));
        }
        catch (SAXException e) {
            if (loc.beLogged(500)) {
                loc.logT(500, _methodName, "Error parsing stream. Exception: {0}", new Object[]{e.getMessage()});
            }
            throw new XmlProxyRuntimeException("Error parsing stream: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            if (loc.beLogged(500)) {
                loc.logT(500, _methodName, "Error reading stream. Exception: {0}", new Object[]{e.getMessage()});
            }
            throw new XmlProxyRuntimeException("Error reading stream: " + e.getMessage(), (Throwable)e);
        }
    }

    public static String extractElement(String prefix, String tagName, String document) {
        if (document == null) {
            return null;
        }
        String qTagName = new String((prefix == null || prefix.length() == 0 ? EMPTY_STRING : prefix + NAME_SEPARATOR) + tagName);
        String startTag = ELEMENT_BEGIN + qTagName;
        int beginIndex = document.indexOf(startTag);
        if (beginIndex < 0) {
            return null;
        }
        String endTag = ELEMENT_END_BEGIN + qTagName;
        int endIndex = document.indexOf(endTag, beginIndex);
        endIndex = endIndex < 0 ? document.indexOf(ELEMENT_END, beginIndex) + 2 : document.indexOf(ELEMENT_CLOSE, endIndex) + 1;
        String result = document.substring(beginIndex, endIndex);
        return result;
    }

    public static String extractNextElement(String prefix, String tagName, String document, String element) {
        int startIndex;
        if (document == null) {
            return null;
        }
        String tag = new String((prefix == null || prefix.length() == 0 ? EMPTY_STRING : prefix + NAME_SEPARATOR) + tagName);
        int tmpIndex = document.indexOf(tag, startIndex = element == null || element == document ? 0 : document.indexOf(element) + element.length() - 1);
        if (tmpIndex == -1) {
            return null;
        }
        String buffer = document.substring(0, tmpIndex);
        int beginIndex = buffer.lastIndexOf(ELEMENT_BEGIN);
        int endIndex = document.indexOf(ELEMENT_CLOSE, document.indexOf(tag, tmpIndex + tag.length())) + 1;
        String result = document.substring(beginIndex, endIndex);
        return result;
    }

    public static Object[] extractAttributes(String prefix, String tagName, String document) {
        int endIndex;
        if (document == null) {
            return null;
        }
        String tag = new String((prefix == null || prefix.length() == 0 ? EMPTY_STRING : prefix + NAME_SEPARATOR) + tagName);
        int tmpIndex = document.indexOf(tag);
        if (tmpIndex == -1) {
            return null;
        }
        String buffer = document.substring(0, tmpIndex);
        int beginIndex = buffer.lastIndexOf(ELEMENT_BEGIN);
        String element = document.substring(beginIndex, endIndex = document.indexOf(ELEMENT_CLOSE, tmpIndex) + 1);
        if ((tmpIndex = element.indexOf(EQUALS)) == -1) {
            return null;
        }
        Vector<XmlAnyAttribute> attrs = new Vector<XmlAnyAttribute>();
        while (tmpIndex >= 0) {
            String attr_name;
            String attr_namespace;
            String attr_prefix;
            buffer = element.substring(0, tmpIndex);
            String lhs = buffer.substring(buffer.lastIndexOf(SPACE) + 1);
            int sepIndex = lhs.indexOf(NAME_SEPARATOR);
            if (sepIndex >= 0) {
                attr_prefix = lhs.substring(0, sepIndex);
                attr_namespace = null;
                attr_name = lhs.substring(sepIndex + 1);
            } else {
                attr_namespace = null;
                attr_prefix = null;
                attr_name = lhs;
            }
            sepIndex = element.indexOf("\"", tmpIndex + 2);
            String attr_value = sepIndex > 0 ? element.substring(tmpIndex + 2, sepIndex) : element.substring(tmpIndex + 2);
            attr_value = XmlParser.decodeEntityRefs(attr_value);
            if (attr_prefix != null && attr_prefix.equals(XML_NAMESPACE_PREFIX)) {
                attr_namespace = attr_value;
            } else {
                attrs.add(new XmlAnyAttribute(attr_prefix, attr_namespace, attr_name, attr_value));
            }
            tmpIndex = element.indexOf(EQUALS, tmpIndex + 1);
        }
        return attrs.toArray();
    }

    public static String extractValue(String element) {
        int endIndex;
        if (element == null) {
            return null;
        }
        int beginIndex = element.indexOf(ELEMENT_CLOSE) + 1;
        if (beginIndex >= (endIndex = element.lastIndexOf(ELEMENT_BEGIN))) {
            return null;
        }
        String result = element.substring(beginIndex, endIndex);
        result = XmlParser.decodeEntityRefs(result.trim());
        return result;
    }

    static String decodeEntityRefs(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int offset = 0;
        int incr = 0;
        int length = string.length();
        String substitute = null;
        int i = 0;
        while (i < length) {
            if (string.charAt(i) == '&') {
                if (i + 5 <= length && string.substring(i + 1, i + 5).equals("amp;")) {
                    substitute = "&";
                    incr = 4;
                } else if (i + 4 <= length && string.substring(i + 1, i + 4).equals("lt;")) {
                    substitute = ELEMENT_BEGIN;
                    incr = 3;
                } else if (i + 4 <= length && string.substring(i + 1, i + 4).equals("gt;")) {
                    substitute = ELEMENT_CLOSE;
                    incr = 3;
                } else if (i + 6 <= length && string.substring(i + 1, i + 6).equals("quot;")) {
                    substitute = "\"";
                    incr = 5;
                } else if (i + 6 <= length && string.substring(i + 1, i + 6).equals("apos;")) {
                    substitute = "'";
                    incr = 5;
                }
            }
            if (substitute != null) {
                if (offset < i) {
                    buffer.append(string.substring(offset, i));
                }
                offset = i + incr;
                buffer.append(substitute);
                substitute = null;
            }
            ++i;
        }
        if (offset == 0) {
            return string;
        }
        if (offset < length) {
            buffer.append(string.substring(offset));
        }
        return new String(buffer);
    }

    static String decodeEntityRefs(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int offset = 0;
        int incr = 0;
        int length = stringBuffer.length();
        String substitute = null;
        int i = 0;
        while (i < length) {
            if (stringBuffer.charAt(i) == '&') {
                if (i + 5 <= length && stringBuffer.substring(i + 1, i + 5).equals("amp;")) {
                    substitute = "&";
                    incr = 4;
                } else if (i + 4 <= length && stringBuffer.substring(i + 1, i + 4).equals("lt;")) {
                    substitute = ELEMENT_BEGIN;
                    incr = 3;
                } else if (i + 4 <= length && stringBuffer.substring(i + 1, i + 4).equals("gt;")) {
                    substitute = ELEMENT_CLOSE;
                    incr = 3;
                } else if (i + 6 <= length && stringBuffer.substring(i + 1, i + 6).equals("quot;")) {
                    substitute = "\"";
                    incr = 5;
                } else if (i + 6 <= length && stringBuffer.substring(i + 1, i + 6).equals("apos;")) {
                    substitute = "'";
                    incr = 5;
                }
            }
            if (substitute != null) {
                if (offset < i) {
                    buffer.append(stringBuffer.substring(offset, i));
                }
                offset = i + incr;
                buffer.append(substitute);
                substitute = null;
            }
            ++i;
        }
        if (offset == 0) {
            return new String(stringBuffer);
        }
        if (offset < length) {
            buffer.append(stringBuffer.substring(offset));
        }
        return new String(buffer);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

