/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.framework.core;

import com.sap.aii.proxy.framework.core.XmlSystemAccess;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public final class XmlInboundServer {
    private static final String JPF_SERVER_DEFAULT_HOST = "localhost";
    private static final String JPF_SERVER_PORT = "1080";
    private static final String JPF_SERVICE_NAME = "/sap/xi/engine?type=entry";
    private static final String JPF_FLAG_FILENAME_KEY = "com.sap.aii.proxy.framework.flagFilename";
    private static final String JPF_FLAG_FILENAME = "jpf_inbound_server_flag";
    private static final String JPF_SERVER_INTERVAL_KEY = "com.sap.aii.proxy.framework.serverIntervalInMSec";
    private static final String JPF_SERVER_INTERVAL = "2000";
    private static final String JPF_SERVER_URL_KEY = "com.sap.aii.proxy.framework.serverURL";
    private static final String JPF_SERVER_URL = "http://localhost:1080/sap/xi/engine?type=entry";
    private static final String fileSeparator = System.getProperty("file.separator");
    private static final String pathSeparator = System.getProperty("path.separator");
    private static final String workDirectory = System.getProperty("user.dir");
    private static final String homeDirectory = System.getProperty("user.home");
    private static final String javaClassPath = System.getProperty("java.class.path");
    private static final Location loc = Location.getLocation((String)(class$com$sap$aii$proxy$framework$core$XmlInboundServer == null ? (class$com$sap$aii$proxy$framework$core$XmlInboundServer = XmlInboundServer.class$("com.sap.aii.proxy.framework.core.XmlInboundServer")) : class$com$sap$aii$proxy$framework$core$XmlInboundServer).getName());
    private static String flagFilename = null;
    private static File registryFile = XmlSystemAccess.getRegistryFile();
    private static Properties properties = XmlSystemAccess.getProperties();
    private static Object lock = new Object();
    static /* synthetic */ Class class$com$sap$aii$proxy$framework$core$XmlInboundServer;

    public static void main(String[] args) {
        String _methodName = "main(...)";
        XmlSystemAccess.initLogging();
        if (loc.beLogged(500)) {
            loc.logT(500, _methodName, "As of XI 3.0, JPR no longer supports J2SE applications (inbound as well as outbound).");
        }
        System.out.println("As of XI 3.0, JPR no longer supports J2SE applications (inbound as well as outbound).");
    }

    public void run() {
    }

    private static final boolean isStarted() {
        File file = new File(flagFilename);
        return file.exists();
    }

    private static final boolean setStarted(boolean isStarted) {
        String _methodName = "setStarted(...)";
        File file = new File(flagFilename);
        if (isStarted) {
            if (file.exists()) {
                if (loc.beLogged(400)) {
                    loc.logT(400, _methodName, "Inbound Server already running - not started");
                    loc.logT(400, _methodName, "Check for flag file {0} in work directory", new Object[]{file.getPath()});
                    System.out.println("Inbound Server already running - not started");
                    System.out.println("Check for flag file " + file.getPath() + " in work directory");
                }
                return false;
            }
            try {
                FileWriter fw = new FileWriter(flagFilename, true);
                fw.write("isStarted");
                ((Writer)fw).close();
            }
            catch (IOException e) {
                if (loc.beLogged(500)) {
                    loc.logT(500, _methodName, "Error writing file {0}", new Object[]{flagFilename});
                }
                return false;
            }
            return true;
        }
        return file.delete();
    }

    public static void registerInterface(String interfaceName, String value) {
        String previousValue;
        String _methodName;
        block16: {
            _methodName = "registerInterface(...)";
            if (interfaceName == null || interfaceName.length() == 0) {
                if (loc.beLogged(500)) {
                    loc.logT(500, _methodName, "No interface name given");
                }
                return;
            }
            previousValue = null;
            File regFile = XmlSystemAccess.getRegistryFile();
            if (regFile == null) {
                if (loc.beLogged(500)) {
                    loc.logT(500, _methodName, "No registry file. Cannot register interface {0}", new Object[]{interfaceName});
                    System.out.println("No registry file. Cannot register interface " + interfaceName);
                }
                return;
            }
            try {
                Properties registry = new Properties();
                Object object = lock;
                synchronized (object) {
                    registry.load(new FileInputStream(regFile));
                    previousValue = ((Hashtable)registry).put(interfaceName, value);
                    registry.store(new FileOutputStream(regFile), null);
                }
            }
            catch (IOException e) {
                if (!loc.beLogged(500)) break block16;
                loc.logT(500, _methodName, "Error updating registry file. Cannot register interface {0}. Exception: ", new Object[]{interfaceName, e.getMessage()});
            }
        }
        if (previousValue == null) {
            if (loc.beLogged(300)) {
                loc.logT(300, _methodName, "Interface {0} registered with value {1}", new Object[]{interfaceName, value});
                System.out.println("Interface " + interfaceName + " registered with value " + value);
            }
        } else if (previousValue.equals(value)) {
            if (loc.beLogged(300)) {
                loc.logT(300, _methodName, "Interface {0} already registered with value {1}", new Object[]{interfaceName, value});
                System.out.println("Interface " + interfaceName + " already registered with value " + value);
            }
        } else if (loc.beLogged(300)) {
            loc.logT(300, _methodName, "Interface {0} registered with value {1}, overwriting value {2}", new Object[]{interfaceName, value, previousValue});
            System.out.println("Interface " + interfaceName + " registered with value " + value + ", overwriting value " + previousValue);
        }
    }

    public static void unregisterInterface(String interfaceName, String methodName) {
        block20: {
            String _methodName = "unregisterInterface(...)";
            if (interfaceName == null || interfaceName.length() == 0) {
                if (loc.beLogged(500)) {
                    loc.logT(500, _methodName, "No interface name given");
                    System.out.println("No registry file name given");
                }
                return;
            }
            File regFile = XmlSystemAccess.getRegistryFile();
            if (regFile == null) {
                if (loc.beLogged(500)) {
                    loc.logT(500, _methodName, "No registry file. Cannot unregister interface {0}", new Object[]{interfaceName});
                    System.out.println("No registry file. Cannot unregister interface " + interfaceName);
                }
                return;
            }
            try {
                Properties registry = new Properties();
                Object object = lock;
                synchronized (object) {
                    registry.load(new FileInputStream(regFile));
                    boolean changed = false;
                    Object logInfo = null;
                    if (methodName == null) {
                        if (((Hashtable)registry).remove(interfaceName) == null) {
                            if (loc.beLogged(300)) {
                                loc.logT(300, _methodName, "Interface {0} not found to unregister", new Object[]{interfaceName});
                                System.out.println("Interface " + interfaceName + " not found to unregister");
                            }
                        } else {
                            if (loc.beLogged(300)) {
                                loc.logT(300, _methodName, "Interface {0} unregistered", new Object[]{interfaceName});
                                System.out.println("Interface " + interfaceName + " unregistered");
                            }
                            changed = true;
                        }
                    } else {
                        String value = (String)((Hashtable)registry).get(interfaceName);
                        if (value != null && value.equals(methodName)) {
                            ((Hashtable)registry).remove(interfaceName);
                            if (loc.beLogged(300)) {
                                loc.logT(300, _methodName, "Interface {0} unregistered", new Object[]{interfaceName});
                                System.out.println("Interface " + interfaceName + " unregistered");
                            }
                            changed = true;
                        } else if (loc.beLogged(300)) {
                            loc.logT(300, _methodName, "Interface {0} and method {1} not found to unregister", new Object[]{interfaceName, methodName});
                            System.out.println("Interface " + interfaceName + " and method " + methodName + " not found to unregister");
                        }
                    }
                    if (changed) {
                        registry.store(new FileOutputStream(regFile), null);
                    }
                }
            }
            catch (IOException e) {
                if (!loc.beLogged(500)) break block20;
                loc.logT(500, _methodName, "Error updating registry file. Cannot unregister interface {0}", new Object[]{interfaceName});
            }
        }
    }

    private static void registerInterfaces(String regFilename) {
        block14: {
            String _methodName = "registerInterfaces(...)";
            if (regFilename == null || regFilename.length() == 0) {
                if (loc.beLogged(500)) {
                    loc.logT(500, _methodName, "No registry file name given");
                    System.out.println("No registry file name given");
                }
                return;
            }
            File regFile = XmlSystemAccess.getRegistryFile();
            if (regFile == null) {
                if (loc.beLogged(500)) {
                    loc.logT(500, _methodName, "No registry file. Cannot register interfaces from file {0}", new Object[]{regFilename});
                    System.out.println("No registry file. Cannot register interfaces from file " + regFilename);
                }
                return;
            }
            try {
                Properties registry = new Properties();
                File regFile2 = new File(regFilename);
                if (!regFile2.exists()) {
                    if (loc.beLogged(500)) {
                        loc.logT(500, _methodName, "Registry file {0} not found", new Object[]{regFilename});
                        System.out.println("Registry file " + regFilename + " not found");
                    }
                    return;
                }
                int count = 0;
                Object object = lock;
                synchronized (object) {
                    registry.load(new FileInputStream(regFile));
                    Properties registry2 = new Properties();
                    registry2.load(new FileInputStream(regFile2));
                    Enumeration<?> enumeration = registry2.propertyNames();
                    while (enumeration.hasMoreElements()) {
                        String value;
                        Object key = enumeration.nextElement();
                        String previousValue = ((Hashtable)registry).put(key, value = (String)((Hashtable)registry2).get(key));
                        if (previousValue != null && previousValue.equals(value)) continue;
                        ++count;
                    }
                    if (count > 0) {
                        registry.store(new FileOutputStream(regFile), null);
                    }
                }
                if (loc.beLogged(300)) {
                    loc.logT(300, _methodName, "{0} interface(s) registered from file {1}", new Object[]{Integer.toString(count), regFilename});
                    System.out.println(Integer.toString(count) + " interface(s) registered from file " + regFilename);
                }
            }
            catch (IOException e) {
                if (!loc.beLogged(500)) break block14;
                loc.logT(500, _methodName, "Error updating registry file. Cannot register interfaces from file {0} not found", new Object[]{regFilename});
            }
        }
    }

    private static void unregisterInterfaces(String regFilename) {
        block17: {
            String _methodName = "unregisterInterfaces(...)";
            File regFile = XmlSystemAccess.getRegistryFile();
            if (regFile == null) {
                if (loc.beLogged(500)) {
                    loc.logT(500, _methodName, "No registry file. Cannot unregister interfaces from file {0}", new Object[]{regFilename});
                    System.out.println("No registry file. Cannot unregister interfaces from file " + regFilename);
                }
                return;
            }
            try {
                Properties registry = new Properties();
                int count = 0;
                if (regFilename == null) {
                    Object object = lock;
                    synchronized (object) {
                        registry.load(new FileInputStream(regFile));
                        XmlInboundServer.backupRegistry(registry, registryFile);
                        count = ((Hashtable)registry).size();
                        ((Hashtable)registry).clear();
                        registry.store(new FileOutputStream(regFile), null);
                    }
                    if (loc.beLogged(300)) {
                        loc.logT(300, _methodName, "{0} interface(s) unregistered", new Object[]{Integer.toString(count)});
                        System.out.println(Integer.toString(count) + " interface(s) unregistered");
                    }
                    break block17;
                }
                File regFile2 = new File(regFilename);
                if (!regFile2.exists()) {
                    if (loc.beLogged(500)) {
                        loc.logT(500, _methodName, "Registry file {0} not found", new Object[]{regFilename});
                        System.out.println("Registry file " + regFilename + " not found");
                    }
                    return;
                }
                Object object = lock;
                synchronized (object) {
                    registry.load(new FileInputStream(regFile));
                    Properties registry2 = new Properties();
                    registry2.load(new FileInputStream(regFile2));
                    Enumeration<?> enumeration = registry2.propertyNames();
                    count = 0;
                    while (enumeration.hasMoreElements()) {
                        Object key = enumeration.nextElement();
                        if (((Hashtable)registry).remove(key) == null) continue;
                        ++count;
                    }
                    if (count > 0) {
                        registry.store(new FileOutputStream(regFile), null);
                    }
                }
                if (loc.beLogged(300)) {
                    loc.logT(300, _methodName, "{0} interface(s) unregistered from file {1}", new Object[]{Integer.toString(count), regFilename});
                    System.out.println(Integer.toString(count) + " interface(s) unregistered from file " + regFilename);
                }
            }
            catch (IOException e) {
                if (!loc.beLogged(500)) break block17;
                loc.logT(500, _methodName, "Error updating registry file. Cannot unregister interfaces from file {0} not found", new Object[]{regFilename});
            }
        }
    }

    private static void backupRegistry(Properties registry, File registryFile) {
        block2: {
            String _methodName = "backupRegistry(...)";
            String pathname = registryFile.getPath();
            String bakFilename = pathname.concat(".bak");
            File bakFile = new File(bakFilename);
            try {
                registry.store(new FileOutputStream(bakFile), null);
            }
            catch (IOException e) {
                if (!loc.beLogged(500)) break block2;
                loc.logT(500, _methodName, "Error backing up registry to file {0}", new Object[]{bakFilename});
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MyShutDownHook
    implements Runnable {
        private MyShutDownHook() {
        }

        public void run() {
            String _methodName = "run()";
            File file = new File(flagFilename);
            if (file.delete() && loc.beLogged(300)) {
                loc.logT(300, _methodName, "VM going down - Inbound Server flag file deleted");
                System.out.println("VM going down - Inbound Server flag file deleted");
            }
        }
    }
}

