/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.framework.core;

import com.sap.aii.proxy.framework.core.BaseTypeData;
import com.sap.aii.proxy.framework.core.BaseTypeDescriptor;
import com.sap.aii.proxy.framework.core.DataAccessException;
import com.sap.aii.proxy.framework.core.DataSet;
import com.sap.aii.proxy.framework.core.DateTimeAccessException;
import com.sap.aii.proxy.framework.core.XsdlAttributeProperties;
import com.sap.aii.proxy.framework.core.XsdlElementProperties;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.util.Arrays;
import java.util.Iterator;

final class XmlBaseTypeData
implements BaseTypeData,
DataSet {
    private static final long serialVersionUID = 2009092002L;
    protected Object[] attributeValue;
    protected Object[] elementValue;
    protected boolean[] isDefaultedAttribute;
    protected boolean[] isDefaultedElement;
    protected boolean[] isFixedAttribute;
    protected boolean[] isFixedElement;

    public XmlBaseTypeData(BaseTypeDescriptor baseTypeDescriptor) {
        int count = baseTypeDescriptor.getAttributeCount();
        this.attributeValue = new Object[count];
        this.isDefaultedAttribute = new boolean[count];
        this.isFixedAttribute = new boolean[count];
        int i = 0;
        while (i < count) {
            XsdlAttributeProperties properties = baseTypeDescriptor.getAttributeProperties(i);
            if (properties != null) {
                Object value = properties.getDefaultValue();
                if (value != null) {
                    this.attributeValue[i] = value;
                    this.isDefaultedAttribute[i] = true;
                } else {
                    this.isDefaultedAttribute[i] = false;
                    value = properties.getFixedValue();
                    if (value != null) {
                        this.attributeValue[i] = value;
                        this.isFixedAttribute[i] = true;
                    } else {
                        this.isFixedAttribute[i] = false;
                    }
                }
            }
            ++i;
        }
        count = baseTypeDescriptor.getElementCount();
        this.elementValue = new Object[count];
        this.isDefaultedElement = new boolean[count];
        this.isFixedElement = new boolean[count];
        int i2 = 0;
        while (i2 < count) {
            XsdlElementProperties properties = baseTypeDescriptor.getElementProperties(i2);
            if (properties != null) {
                Object value = properties.getDefaultValue();
                if (value != null) {
                    this.elementValue[i2] = value;
                    this.isDefaultedElement[i2] = true;
                } else {
                    this.isDefaultedElement[i2] = false;
                    value = properties.getFixedValue();
                    if (value != null) {
                        this.elementValue[i2] = value;
                        this.isFixedElement[i2] = true;
                    } else {
                        this.isFixedElement[i2] = false;
                    }
                }
            }
            ++i2;
        }
    }

    public final int getAttributeCount() {
        return this.attributeValue.length;
    }

    public final boolean hasAttributeValue(int i) {
        return this.attributeValue[i] != null;
    }

    public final boolean isAttributeDefaulted(int i) {
        return this.isDefaultedAttribute[i];
    }

    public final boolean isAttributeFixed(int i) {
        return this.isFixedAttribute[i];
    }

    public final Object getAttributeValue(int i) {
        return this.attributeValue[i];
    }

    public final int getAttributeValueAsInt(int i) {
        return (Integer)this.attributeValue[i];
    }

    public final long getAttributeValueAsLong(int i) {
        return (Long)this.attributeValue[i];
    }

    public final short getAttributeValueAsShort(int i) {
        return (Short)this.attributeValue[i];
    }

    public final byte getAttributeValueAsByte(int i) {
        return (Byte)this.attributeValue[i];
    }

    public final byte[] getAttributeValueAsByteArray(int i) {
        return (byte[])this.attributeValue[i];
    }

    public float getAttributeValueAsFloat(int i) {
        return ((Float)this.attributeValue[i]).floatValue();
    }

    public final double getAttributeValueAsDouble(int i) {
        return (Double)this.attributeValue[i];
    }

    public final boolean getAttributeValueAsBoolean(int i) {
        return (Boolean)this.attributeValue[i];
    }

    public final BigDecimal getAttributeValueAsBigDecimal(int i) {
        return (BigDecimal)this.attributeValue[i];
    }

    public final BigInteger getAttributeValueAsBigInteger(int i) {
        return (BigInteger)this.attributeValue[i];
    }

    public final String getAttributeValueAsString(int i) {
        return (String)this.attributeValue[i];
    }

    public String[] getAttributeValueAsStringArray(int i) {
        return (String[])this.attributeValue[i];
    }

    public final Date getAttributeValueAsDate(int i) {
        if (this.attributeValue[i] instanceof Date) {
            return (Date)this.attributeValue[i];
        }
        if (this.attributeValue[i] instanceof String) {
            throw new DateTimeAccessException(DateTimeAccessException.createMsg_IS_INCOMPATIBLE_DATE((String)this.attributeValue[i]), (String)this.attributeValue[i]);
        }
        throw new DataAccessException(DataAccessException.createMsg_UNKNOWN_DATE_TYPE());
    }

    public final Time getAttributeValueAsTime(int i) {
        if (this.attributeValue[i] instanceof Time) {
            return (Time)this.attributeValue[i];
        }
        if (this.attributeValue[i] instanceof String) {
            throw new DateTimeAccessException(DateTimeAccessException.createMsg_IS_INCOMPATIBLE_TIME((String)this.attributeValue[i]), (String)this.attributeValue[i]);
        }
        throw new DataAccessException(DataAccessException.createMsg_UNKNOWN_TIME_TYPE());
    }

    public final void setAttributeValue(int i, Object value) {
        if (this.isFixedAttribute[i]) {
            throw new DataAccessException(DataAccessException.createMsg_IS_FIXED_ATTRIBUTE());
        }
        this.attributeValue[i] = value;
        this.isDefaultedAttribute[i] = false;
    }

    public final void setAttributeValue(int i, int value) {
        this.setAttributeValue(i, new Integer(value));
    }

    public final void setAttributeValue(int i, long value) {
        this.setAttributeValue(i, new Long(value));
    }

    public final void setAttributeValue(int i, short value) {
        this.setAttributeValue(i, new Short(value));
    }

    public final void setAttributeValue(int i, byte value) {
        this.setAttributeValue(i, new Byte(value));
    }

    public final void setAttributeValue(int i, byte[] value) {
        this.setAttributeValue(i, (Object)value);
    }

    public final void setAttributeValue(int i, float value) {
        this.setAttributeValue(i, new Float(value));
    }

    public final void setAttributeValue(int i, double value) {
        this.setAttributeValue(i, new Double(value));
    }

    public final void setAttributeValue(int i, boolean value) {
        this.setAttributeValue(i, new Boolean(value));
    }

    public final void deleteAttributeValue(int i) {
        this.attributeValue[i] = null;
        this.isDefaultedAttribute[i] = false;
        this.isFixedAttribute[i] = false;
    }

    public final int getElementCount() {
        return this.elementValue.length;
    }

    public final boolean hasElementValue(int i) {
        return this.elementValue[i] != null;
    }

    public final boolean isElementDefaulted(int i) {
        return this.isDefaultedElement[i];
    }

    public final boolean isElementFixed(int i) {
        return this.isFixedElement[i];
    }

    public final Object getElementValue(int i) {
        return this.elementValue[i];
    }

    public final int getElementValueAsInt(int i) {
        return (Integer)this.elementValue[i];
    }

    public final long getElementValueAsLong(int i) {
        return (Long)this.elementValue[i];
    }

    public final short getElementValueAsShort(int i) {
        return (Short)this.elementValue[i];
    }

    public final byte getElementValueAsByte(int i) {
        return (Byte)this.elementValue[i];
    }

    public final byte[] getElementValueAsByteArray(int i) {
        return (byte[])this.elementValue[i];
    }

    public final float getElementValueAsFloat(int i) {
        return ((Float)this.elementValue[i]).floatValue();
    }

    public final double getElementValueAsDouble(int i) {
        return (Double)this.elementValue[i];
    }

    public final boolean getElementValueAsBoolean(int i) {
        return (Boolean)this.elementValue[i];
    }

    public final BigInteger getElementValueAsBigInteger(int i) {
        return (BigInteger)this.elementValue[i];
    }

    public final BigDecimal getElementValueAsBigDecimal(int i) {
        return (BigDecimal)this.elementValue[i];
    }

    public final String getElementValueAsString(int i) {
        return (String)this.elementValue[i];
    }

    public String[] getElementValueAsStringArray(int i) {
        return (String[])this.elementValue[i];
    }

    public final Date getElementValueAsDate(int i) {
        if (this.elementValue[i] instanceof Date) {
            return (Date)this.elementValue[i];
        }
        if (this.elementValue[i] instanceof String) {
            throw new DateTimeAccessException(DateTimeAccessException.createMsg_IS_INCOMPATIBLE_DATE((String)this.elementValue[i]), (String)this.elementValue[i]);
        }
        throw new DataAccessException(DataAccessException.createMsg_UNKNOWN_DATE_TYPE());
    }

    public final Time getElementValueAsTime(int i) {
        if (this.elementValue[i] instanceof Time) {
            return (Time)this.elementValue[i];
        }
        if (this.elementValue[i] instanceof String) {
            throw new DateTimeAccessException(DateTimeAccessException.createMsg_IS_INCOMPATIBLE_TIME((String)this.elementValue[i]), (String)this.elementValue[i]);
        }
        throw new DataAccessException(DataAccessException.createMsg_UNKNOWN_TIME_TYPE());
    }

    public final void setElementValue(int i, Object value) {
        if (this.isFixedElement[i]) {
            throw new DataAccessException(DataAccessException.createMsg_IS_FIXED_ELEMENT());
        }
        this.elementValue[i] = value;
        this.isDefaultedElement[i] = false;
    }

    public final void setElementValue(int i, int value) {
        this.setElementValue(i, new Integer(value));
    }

    public final void setElementValue(int i, long value) {
        this.setElementValue(i, new Long(value));
    }

    public final void setElementValue(int i, short value) {
        this.setElementValue(i, new Short(value));
    }

    public final void setElementValue(int i, byte value) {
        this.setElementValue(i, new Byte(value));
    }

    public final void setElementValue(int i, byte[] value) {
        this.setElementValue(i, (Object)value);
    }

    public final void setElementValue(int i, float value) {
        this.setElementValue(i, new Float(value));
    }

    public final void setElementValue(int i, double value) {
        this.setElementValue(i, new Double(value));
    }

    public final void setElementValue(int i, boolean value) {
        this.setElementValue(i, new Boolean(value));
    }

    public final void deleteElementValue(int i) {
        this.elementValue[i] = null;
        this.isDefaultedElement[i] = false;
        this.isFixedElement[i] = false;
    }

    public Iterator getAttributeIterator() {
        return Arrays.asList(this.attributeValue).iterator();
    }

    public Iterator getElementIterator() {
        return Arrays.asList(this.elementValue).iterator();
    }
}

