/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.framework.core;

import com.sap.aii.proxy.framework.core.AbstractType;
import com.sap.aii.proxy.framework.core.BaseProxyDescriptor;
import com.sap.aii.proxy.framework.core.BaseTypeDescriptor;
import com.sap.aii.proxy.framework.core.JcoProxyRuntimeException;
import java.io.Serializable;
import java.util.Hashtable;

final class JcoBaseProxyDescriptor
implements BaseProxyDescriptor,
Serializable {
    private static final long serialVersionUID = 3014102003L;
    static final String FAULT_EXTENSION = "_Exception";
    protected String name = null;
    protected Hashtable wsdlMethodNames = null;
    protected Hashtable abapFunctionNames = null;
    protected Hashtable argClassNames = null;
    protected Hashtable resultClassNames = null;
    protected Hashtable resultTypeNames = null;
    protected Hashtable faultMessageDescriptors = null;
    protected Hashtable resultTypeClasses = null;
    protected Class proxyClass = null;

    JcoBaseProxyDescriptor(String name, Object[][][] methodsAndTypes, Class proxyClass) {
        this.name = name;
        this.wsdlMethodNames = new Hashtable();
        this.abapFunctionNames = new Hashtable();
        this.argClassNames = new Hashtable();
        this.resultClassNames = new Hashtable();
        this.resultTypeNames = new Hashtable();
        this.faultMessageDescriptors = new Hashtable();
        this.proxyClass = proxyClass;
        String methodName = null;
        String abapMethodName = null;
        int i = 0;
        while (i < methodsAndTypes.length) {
            Object[][] methods = methodsAndTypes[i];
            int j = 0;
            while (j < methods.length) {
                Object[] namePair = methods[j];
                if (j == 0) {
                    methodName = (String)namePair[0];
                    abapMethodName = (String)namePair[2];
                    this.wsdlMethodNames.put(namePair[1], methodName);
                    this.abapFunctionNames.put(methodName, abapMethodName);
                } else if (j == 1) {
                    this.argClassNames.put(methodName, namePair[1]);
                } else if (namePair[1] instanceof Class) {
                    if (j == 2 && namePair.length < 3) {
                        this.resultClassNames.put(methodName, ((Class)namePair[1]).getName());
                    }
                    this.resultTypeNames.put(namePair[0], ((Class)namePair[1]).getName());
                    if (namePair.length == 3) {
                        try {
                            AbstractType faultMessage = (AbstractType)((Class)namePair[2]).newInstance();
                            this.faultMessageDescriptors.put(methodName, faultMessage.baseTypeDescriptor);
                        }
                        catch (Exception e) {
                            throw new JcoProxyRuntimeException("Fault message cannot be instantiated", (Throwable)e);
                        }
                    }
                } else {
                    if (j == 2 && namePair.length < 3) {
                        this.resultClassNames.put(methodName, namePair[1]);
                    }
                    this.resultTypeNames.put(namePair[0], namePair[1]);
                    if (namePair.length == 3) {
                        try {
                            Class<?> faultMessageClass = this.getClassLoader() == null ? Class.forName((String)namePair[2]) : Class.forName((String)namePair[2], true, this.getClassLoader());
                            AbstractType faultMessage = (AbstractType)faultMessageClass.newInstance();
                            this.faultMessageDescriptors.put(methodName, faultMessage.baseTypeDescriptor);
                        }
                        catch (Exception e) {
                            throw new JcoProxyRuntimeException("Fault message cannot be instantiated", (Throwable)e);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    ClassLoader getClassLoader() {
        return this.proxyClass == null ? null : this.proxyClass.getClassLoader();
    }

    BaseTypeDescriptor getFaultMessageDescriptor(String methodName) {
        return (BaseTypeDescriptor)this.faultMessageDescriptors.get(methodName);
    }

    public String getWsdlName(String methodName) {
        return (String)this.wsdlMethodNames.get(methodName);
    }

    public String getAbapFunctionName(String methodName) {
        return (String)this.abapFunctionNames.get(methodName);
    }

    public String getArgumentClassName(String methodName) {
        return (String)this.argClassNames.get(methodName);
    }

    public String getResultClassName(String methodName) {
        return (String)this.resultClassNames.get(methodName);
    }

    public Hashtable getResultTypeList(String methodName) {
        return (Hashtable)this.resultTypeNames.get(methodName);
    }

    public String getResultTypeAsString(String methodName) {
        return (String)this.resultTypeNames.get(methodName);
    }

    public boolean isXml() {
        return false;
    }

    public boolean isJco() {
        return true;
    }
}

