/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.framework.core;

import com.sap.aii.proxy.framework.core.AbstractList;
import com.sap.aii.proxy.framework.core.AbstractType;
import com.sap.aii.proxy.framework.core.AttributeMetaData;
import com.sap.aii.proxy.framework.core.BaseTypeDescriptor;
import com.sap.aii.proxy.framework.core.ElementMetaData;
import com.sap.aii.proxy.framework.core.MetaDataAccessException;
import com.sap.aii.proxy.framework.core.QName;
import com.sap.aii.proxy.framework.core.TypeMetaData;
import com.sap.aii.proxy.framework.core.XmlBaseTypeDescriptor;
import com.sap.aii.proxy.framework.core.XsdlAttributeProperties;
import com.sap.aii.proxy.framework.core.XsdlElementProperties;
import com.sap.aii.proxy.framework.core.XsdlTypeRestrictions;
import com.sap.aii.util.xml.xdom.InvalidArgumentException;
import com.sap.aii.util.xml.xdom.XDOMException;
import com.sap.aii.util.xml.xdom.XDocument;
import com.sap.aii.util.xml.xdom.XElement;
import com.sap.aii.util.xml.xdom.io.XDOMInputter;
import java.math.BigInteger;

abstract class BaseTypeMetaData
implements AbstractType.BaseTypeMetaData,
TypeMetaData,
AttributeMetaData,
ElementMetaData {
    private static final String TYPE_DESCRIPTOR_XPATH = "ifr:descriptor[1]";
    private static final String TYPE_PROPERTIES_XPATH = "ifr:properties[1]";
    private static final String TYPE_DEFINITION_XPATH = "ifr:definition[1]";
    private static final String ELEMENT_DESCRIPTOR_XPATH = "ifr:descriptor[1]";
    private static final String ELEMENT_PROPERTIES_XPATH = "ifr:properties[1]";
    private static final String ELEMENT_DEFINITION_XPATH = "ifr:definition[1]";
    protected BaseTypeDescriptor baseTypeDescriptor = null;
    protected String typeMetadataXml = null;
    protected String[] elementMetadataXml = null;
    protected int attributeIndex = -1;
    protected XsdlAttributeProperties attributeProperties = null;
    protected XsdlTypeRestrictions attributeRestrictions = null;
    protected int elementIndex = -1;
    protected XsdlElementProperties elementProperties = null;
    protected XsdlTypeRestrictions elementRestrictions = null;
    private XDOMInputter xdomInputter = null;
    private XDocument xDocument = null;
    private XElement descriptorElement = null;
    private XElement propertiesElement = null;
    private XElement definitionElement = null;

    BaseTypeMetaData() {
    }

    public abstract AttributeMetaData getAttribute(int var1);

    public ElementMetaData getElement(int i) {
        this.elementIndex = i;
        return this;
    }

    public abstract BigInteger getLength();

    public abstract BigInteger getDecimals();

    public abstract boolean isList();

    public String getName() {
        this.checkInstance();
        if (this.attributeIndex >= 0) {
            return this.attributeProperties.getName();
        }
        return this.elementProperties.getName();
    }

    public String getType() {
        this.checkInstance();
        if (this.attributeIndex >= 0) {
            return this.attributeProperties.getXmlType();
        }
        return this.elementProperties.getXmlType();
    }

    public final String getDescription(String language) {
        boolean isElement = this.checkInstance();
        if (this.descriptorElement == null) {
            String xPath = isElement ? "ifr:descriptor[1]" : "ifr:descriptor[1]";
            String metadataXml = isElement ? this.elementMetadataXml[this.elementIndex] : this.typeMetadataXml;
            this.descriptorElement = this.findElement(xPath, metadataXml);
        }
        XElement element = null;
        if (this.descriptorElement != null) {
            int i = 1;
            while (true) {
                String langAttr;
                String xPath = "ifr:description[" + Integer.toString(i) + "]";
                try {
                    element = this.descriptorElement.findElement(xPath);
                }
                catch (InvalidArgumentException e) {
                    throw new MetaDataAccessException(MetaDataAccessException.createMsg_ERROR_PARSING_FOR_NODE(xPath), (Throwable)e);
                }
                if (language == null || element == null || (langAttr = element.getAttributeValue("language")) != null && langAttr.equals(language)) break;
                ++i;
            }
        }
        String description = element == null ? null : element.getText();
        return description;
    }

    public String getRelease() {
        return this.getPropertyValue("release");
    }

    public String getSourceSystem() {
        return this.getPropertyValue("sourceSystem");
    }

    public String getCategory() {
        return this.getPropertyValue("category");
    }

    public BigInteger getInternalLength1() {
        String intString = this.getDefinitionValue("internalLength1");
        return intString == null ? null : new BigInteger(intString);
    }

    public BigInteger getFieldCount() {
        this.checkInstance();
        if (this.elementIndex < 0) {
            return null;
        }
        int count = this.baseTypeDescriptor.getElementProperties(this.elementIndex).getDescriptor().getElementCount();
        return new BigInteger(Integer.toString(count));
    }

    public String getFieldName(int i) {
        this.checkInstance();
        if (this.elementIndex < 0) {
            return null;
        }
        return this.baseTypeDescriptor.getElementProperties(this.elementIndex).getDescriptor().getElementProperties(i).getName();
    }

    public String getFieldType(int i) {
        this.checkInstance();
        if (this.elementIndex < 0) {
            return null;
        }
        return this.baseTypeDescriptor.getElementProperties(this.elementIndex).getDescriptor().getElementProperties(i).getXmlType();
    }

    public final String getItemType() {
        if (!this.isList()) {
            return null;
        }
        String itemType = null;
        XsdlElementProperties props = this.baseTypeDescriptor.getElementProperties(this.elementIndex);
        BaseTypeDescriptor itemDescriptor = props.getDescriptor();
        if (itemDescriptor == null) {
            try {
                Class javaClass = props.getJavaClass();
                AbstractList list = (AbstractList)javaClass.newInstance();
                itemType = list.getItemType();
            }
            catch (Exception e) {
                throw new MetaDataAccessException(MetaDataAccessException.createMsg_ERROR_ITEM_META_DATA(this.elementIndex), (Throwable)e);
            }
        } else {
            QName wsdlName = itemDescriptor.getWsdlName();
            if (wsdlName != null) {
                itemType = wsdlName.toString();
            }
        }
        return itemType;
    }

    public final boolean isSimpleType() {
        String value = this.getAttributeValue("category");
        return value == null ? false : value.equals("simple");
    }

    public boolean hasHelpValues() {
        String booleanString = this.getPropertyValue("helpValuesSupported");
        return booleanString == null ? false : booleanString.equals("true");
    }

    public boolean hasFixedValues() {
        String booleanString = this.getPropertyValue("fixedValuesListDefined");
        return booleanString == null ? false : booleanString.equals("true");
    }

    public boolean isMixedCase() {
        String booleanString = this.getPropertyValue("mixedCaseSupported");
        return booleanString == null ? false : booleanString.equals("true");
    }

    public boolean isSignedNumber() {
        String booleanString = this.getPropertyValue("signedNumber");
        return booleanString == null ? false : booleanString.equals("true");
    }

    public String getDataElementName() {
        return this.getDefinitionAttributeValue("scalarType", "name");
    }

    public String getDataElementType() {
        return this.getDefinitionValue("scalarType[1]/ifr:definition[1]/ifr:type");
    }

    public BigInteger getOutputLength() {
        String intString = this.getDefinitionValue("scalarType[1]/ifr:definition[1]/ifr:outputLength");
        return intString == null ? null : new BigInteger(intString);
    }

    protected boolean checkInstance() {
        boolean isOkay = false;
        if (this.attributeIndex >= 0) {
            if (this.attributeProperties == null) {
                if (this.baseTypeDescriptor == null) {
                    throw new MetaDataAccessException(MetaDataAccessException.createMsg_NO_ATTRIBUTE_META_DATA(this.attributeIndex));
                }
                this.attributeProperties = this.baseTypeDescriptor.getAttributeProperties(this.attributeIndex);
                if (this.attributeProperties == null) {
                    throw new MetaDataAccessException(MetaDataAccessException.createMsg_NO_ATTRIBUTE_META_DATA(this.attributeIndex));
                }
                this.attributeRestrictions = this.attributeProperties.getRestrictions();
            }
            isOkay = true;
        } else if (this.elementIndex >= 0) {
            if (this.elementProperties == null) {
                if (this.baseTypeDescriptor == null) {
                    throw new MetaDataAccessException(MetaDataAccessException.createMsg_NO_DESCRIPTOR(this.elementIndex));
                }
                this.elementProperties = this.baseTypeDescriptor.getElementProperties(this.elementIndex);
                if (this.elementProperties == null) {
                    throw new MetaDataAccessException(MetaDataAccessException.createMsg_NO_ELEMENT_META_DATA(this.elementIndex));
                }
                this.elementRestrictions = this.elementProperties.getRestrictions();
            }
            if (this.elementMetadataXml == null) {
                this.elementMetadataXml = new String[this.baseTypeDescriptor.getElementCount()];
            }
            if (this.elementMetadataXml[this.elementIndex] == null) {
                this.elementMetadataXml[this.elementIndex] = this.elementProperties.getMetadataXml();
            }
            isOkay = true;
        } else if (this.typeMetadataXml == null) {
            this.typeMetadataXml = ((XmlBaseTypeDescriptor)this.baseTypeDescriptor).getMetadataXml();
        }
        return isOkay;
    }

    private final String getAttributeValue(String name) {
        if (!this.checkInstance() || this.xDocument == null) {
            return null;
        }
        XElement root = this.xDocument.getRoot();
        String value = root == null ? null : root.getAttributeValue(name);
        return value;
    }

    private final String getPropertyValue(String name) {
        boolean isElement = this.checkInstance();
        if (this.propertiesElement == null) {
            String xPath = isElement ? "ifr:properties[1]" : "ifr:properties[1]";
            String metadataXml = isElement ? this.elementMetadataXml[this.elementIndex] : this.typeMetadataXml;
            this.propertiesElement = this.findElement(xPath, metadataXml);
        }
        XElement element = null;
        if (this.propertiesElement != null) {
            String xPath = "ifr:" + name + "[1]";
            try {
                element = this.propertiesElement.findElement(xPath);
            }
            catch (InvalidArgumentException e) {
                throw new MetaDataAccessException(MetaDataAccessException.createMsg_ERROR_PARSING_FOR_NODE(xPath), (Throwable)e);
            }
        }
        String property = element == null ? null : element.getText();
        return property;
    }

    private final String getDefinitionValue(String name) {
        XElement element = this.getDefinition(name);
        String definition = element == null ? null : element.getText();
        return definition;
    }

    private final String getDefinitionAttributeValue(String elementName, String attrName) {
        XElement element = this.getDefinition(elementName);
        String value = element == null ? null : element.getAttributeValue(attrName);
        return value;
    }

    private final XElement getDefinition(String name) {
        boolean isElement = this.checkInstance();
        if (this.definitionElement == null) {
            String xPath = isElement ? "ifr:definition[1]" : "ifr:definition[1]";
            String metadataXml = isElement ? this.elementMetadataXml[this.elementIndex] : this.typeMetadataXml;
            this.definitionElement = this.findElement(xPath, metadataXml);
        }
        XElement element = null;
        if (this.definitionElement != null) {
            String xPath = "ifr:" + name + "[1]";
            try {
                element = this.definitionElement.findElement(xPath);
            }
            catch (InvalidArgumentException e) {
                throw new MetaDataAccessException(MetaDataAccessException.createMsg_ERROR_PARSING_FOR_NODE(xPath), (Throwable)e);
            }
        }
        return element;
    }

    protected int getElementIndex() {
        return this.elementIndex;
    }

    private final XElement findElement(String xPath, String metadataXml) {
        if (metadataXml == null) {
            return null;
        }
        if (this.xDocument == null) {
            if (this.xdomInputter == null) {
                this.xdomInputter = new XDOMInputter();
            }
            try {
                this.xDocument = this.xdomInputter.read(metadataXml);
            }
            catch (XDOMException e) {
                throw new MetaDataAccessException(MetaDataAccessException.createMsg_ERROR_PARSING_META_DATA(metadataXml), (Throwable)e);
            }
        }
        XElement rootElement = this.xDocument == null ? null : this.xDocument.getRoot();
        XElement element = null;
        if (rootElement != null) {
            try {
                element = rootElement.findElement(xPath);
            }
            catch (InvalidArgumentException e) {
                throw new MetaDataAccessException(MetaDataAccessException.createMsg_ERROR_PARSING_FOR_NODE(xPath), (Throwable)e);
            }
        }
        return element;
    }
}

