/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ear.urimap;

import com.tssap.j2ee.core.ear.Ear;
import com.tssap.j2ee.core.ear.EarProject;
import com.tssap.j2ee.core.ear.EjbModule;
import com.tssap.j2ee.core.ear.WebModule;
import com.tssap.j2ee.core.ejbjar.EjbJarProject;
import com.tssap.j2ee.core.webapp.WebAppProject;
import com.tssap.j2ee.internal.core.ear.EarImplPlugin;
import com.tssap.util.projectinfo.IProjectInfoPropertyListener;
import com.tssap.util.projectinfo.ProjectInfo;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;

class SapUriPatcher
implements IProjectInfoPropertyListener {
    private static SapUriPatcher ourInstance;

    SapUriPatcher() {
    }

    public void propertyChanged(IProject project, String property, String oldValue, String newValue) {
        WebAppProject webAppProject;
        if (!"j2ee.archive.name".equals(property)) {
            return;
        }
        EarImplPlugin.logInfo("project [" + project + "] archive name changed " + oldValue + " -> " + newValue);
        EjbJarProject ejbJarProject = EjbJarProject.getInstance((IProject)project);
        if (ejbJarProject != null) {
            this.ejbJarUriChanged(ejbJarProject, oldValue, newValue);
        }
        if ((webAppProject = WebAppProject.getInstance((IProject)project)) != null) {
            this.webAppUriChanged(webAppProject, oldValue, newValue);
        }
    }

    private void ejbJarUriChanged(EjbJarProject project, String oldUri, String newUri) {
        List ears = this.getEars();
        if (ears == null || ears.isEmpty()) {
            return;
        }
        int i = ears.size() - 1;
        while (i >= 0) {
            Ear ear = (Ear)ears.get(i);
            if (ear == null || !ear.isValid()) {
                return;
            }
            EjbModule[] modules = ear.getEjbModules();
            if (modules != null && modules.length != 0) {
                int j = 0;
                while (j < modules.length) {
                    EjbModule module = modules[j];
                    if (SapUriPatcher.equals(oldUri, module.getUri())) {
                        if (newUri == null) {
                            if (module.canDelete()) {
                                module.delete();
                            } else {
                                EarImplPlugin.logWarning("Unable to synchronize (delete) ejb module " + oldUri);
                            }
                        } else if (module.canSetUri(newUri)) {
                            module.setUri(newUri);
                        } else {
                            EarImplPlugin.logWarning("Unable to synchronize (update to " + newUri + ") ejb module " + oldUri);
                        }
                    }
                    ++j;
                }
            }
            --i;
        }
    }

    private void webAppUriChanged(WebAppProject project, String oldUri, String newUri) {
        List ears = this.getEars();
        if (ears == null || ears.isEmpty()) {
            return;
        }
        int i = ears.size() - 1;
        while (i >= 0) {
            Ear ear = (Ear)ears.get(i);
            if (ear == null || !ear.isValid()) {
                return;
            }
            WebModule[] modules = ear.getWebModules();
            if (modules != null && modules.length != 0) {
                int j = 0;
                while (j < modules.length) {
                    WebModule module = modules[j];
                    if (SapUriPatcher.equals(oldUri, module.getUri())) {
                        if (module.canSetUri(newUri)) {
                            module.setUri(newUri);
                        } else {
                            EarImplPlugin.logWarning("Unable to synchronize web module uri " + oldUri);
                        }
                    }
                    ++j;
                }
            }
            --i;
        }
    }

    private List getEars() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (projects == null || projects.length == 0) {
            return null;
        }
        ArrayList<Ear> earsList = null;
        int i = 0;
        while (i < projects.length) {
            Ear[] ears;
            EarProject earProject = EarProject.getInstance((IProject)projects[i]);
            if (earProject != null && (ears = earProject.getEars()) != null && ears.length != 0) {
                if (earsList == null) {
                    earsList = new ArrayList<Ear>(projects.length);
                }
                int j = 0;
                while (j < ears.length) {
                    earsList.add(ears[j]);
                    ++j;
                }
            }
            ++i;
        }
        return earsList;
    }

    private static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static SapUriPatcher getInstance() {
        if (ourInstance == null) {
            ourInstance = new SapUriPatcher();
            ProjectInfo.addPropertyListener((IProjectInfoPropertyListener)ourInstance);
        }
        return ourInstance;
    }
}

