/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ear.urimap;

import com.tssap.j2ee.core.descriptor.UriResolver;
import com.tssap.j2ee.core.ear.EarProject;
import com.tssap.j2ee.core.ejbjar.EjbJarProject;
import com.tssap.j2ee.core.webapp.WebAppProject;
import com.tssap.j2ee.internal.core.ear.urimap.SapUriPatcher;
import com.tssap.util.projectinfo.ProjectInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public final class SapUriMapper
extends UriResolver {
    public static final String TSSAPINFO_ARCHIVE_NAME = "j2ee.archive.name";
    private static final String EAR_DD = "/META-INF/ear.xml";
    private static final String EJB_JAR_DD = "/META-INF/ejb-jar.xml";
    private static final String WEB_APP_DD = "/WEB-INF/web.xml";

    public SapUriMapper() {
        SapUriPatcher.getInstance();
    }

    protected String getUriImpl(IFile ear, IFile descriptor) {
        if (descriptor == null) {
            return null;
        }
        IPath dd = descriptor.getFullPath();
        if (dd.segmentCount() < 1) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(dd.segment(0));
        if (project == null || !project.isAccessible()) {
            return null;
        }
        return SapUriMapper.getJarPath(project);
    }

    protected IFile getDescriptorImpl(IFile ear, String uri) {
        IProject[] projects;
        if (uri == null || uri.trim().length() == 0) {
            return null;
        }
        if (ear == null || !ear.isAccessible()) {
            projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        } else {
            try {
                projects = ear.getProject().getReferencedProjects();
            }
            catch (CoreException ce) {
                projects = null;
            }
        }
        if (projects == null || projects.length == 0) {
            return null;
        }
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (project != null && project.isAccessible() && uri.equals(SapUriMapper.getJarPath(project))) {
                if (EarProject.getInstance((IProject)project) != null) {
                    return project.getFile(EAR_DD);
                }
                if (EjbJarProject.getInstance((IProject)project) != null) {
                    return project.getFile(EJB_JAR_DD);
                }
                if (WebAppProject.getInstance((IProject)project) == null) break;
                return project.getFile(WEB_APP_DD);
            }
            ++i;
        }
        return null;
    }

    public static String getJarPath(IProject project) {
        return ProjectInfo.getProperty((IProject)project, (String)TSSAPINFO_ARCHIVE_NAME);
    }
}

