/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ear.urimap;

import com.tssap.j2ee.core.descriptor.DescriptorStorage;
import com.tssap.j2ee.core.ear.Ear;
import com.tssap.j2ee.core.utils.FileUtils;
import com.tssap.j2ee.internal.core.ear.EarImplPlugin;
import com.tssap.j2ee.internal.core.ear.urimap.IURIMapping;
import com.tssap.j2ee.internal.core.ear.urimap.URIMapEntry;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultURIMapper
implements IURIMapping {
    private IResourceDeltaVisitor myResourceDeltaVisitor = new IResourceDeltaVisitor(){

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (DefaultURIMapper.this.myResourcesToSkip.remove(resource)) {
                return false;
            }
            if (DefaultURIMapper.this.myMapperFile.equals((Object)resource)) {
                DefaultURIMapper.this.myDocument = null;
                DefaultURIMapper.this.myMappings = null;
                return false;
            }
            return true;
        }
    };
    private HashMap myMappings;
    private IFile myMapperFile;
    private Document myDocument;
    private Ear myApplication;
    private Set myResourcesToSkip = new HashSet();
    private static String ourDtd;
    private static final String DTD_PATH = "templates/urimap_1_0.dtd";
    private static final Path MAPPER_FILE;
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String URIMAP_SYSTEM_ID = "http://www.borland.com/dtd/urimap_1_0.dtd";
    private static final String URIMAP_TITLE = "-//Borland International, Inc.//DTD J2EE Uri Map 1.0//EN";
    private static final String URIMAP_DTD = "<!DOCTYPE urimap PUBLIC \"-//Borland International, Inc.//DTD J2EE Uri Map 1.0//EN\" \"http://www.borland.com/dtd/urimap_1_0.dtd\">";
    private static final String DEFAULT_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE urimap PUBLIC \"-//Borland International, Inc.//DTD J2EE Uri Map 1.0//EN\" \"http://www.borland.com/dtd/urimap_1_0.dtd\"><urimap></urimap>";
    static final String MODULE_TAG = "module";
    static final String PATH_TAG = "path";
    static final String URI_TAG = "uri";
    static final String[] MODULE_ORDER;

    public DefaultURIMapper(Ear application) {
        this.myApplication = application;
        this.myMapperFile = application.getFile().getParent().getFile((IPath)MAPPER_FILE);
    }

    public IFile getModuleDD(String uri) {
        String path = this.getModuleDDAsString(uri);
        if (path == null) {
            return null;
        }
        IResource file = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (file == null || file.getType() != 1) {
            return null;
        }
        return (IFile)file;
    }

    public String getModuleDDAsString(String uri) {
        if (this.myDocument == null && !this.readMapperFile()) {
            return null;
        }
        return this.findPath(uri);
    }

    public String getModuleURI(IFile moduleDD) {
        URIMapEntry entry = this.getURIMapEntry(moduleDD);
        if (entry == null) {
            return null;
        }
        return entry.getURI();
    }

    public String getModuleURI(String moduleDD) {
        URIMapEntry entry = this.getURIMapEntry(moduleDD);
        if (entry == null) {
            return null;
        }
        return entry.getURI();
    }

    public String newModuleURI(IFile newModuleDD, String proposedURI) {
        if (this.myDocument == null && !this.readMapperFile()) {
            return null;
        }
        if (proposedURI == null) {
            proposedURI = newModuleDD.getProject().getName();
        }
        String newModulePath = this.getPath(newModuleDD);
        String result = proposedURI;
        if (!this.canUseURIForSpecifiedPath(proposedURI, newModulePath)) {
            int i = 1;
            while (!this.canUseURIForSpecifiedPath(result = proposedURI + i, newModulePath)) {
                ++i;
            }
        }
        this.createMapping(newModuleDD, result);
        return result;
    }

    private boolean canUseURIForSpecifiedPath(String uri, String expectedModulePath) {
        String actualModulePath = this.findPath(uri);
        if (actualModulePath == null) {
            return true;
        }
        return actualModulePath.equals(expectedModulePath);
    }

    public void removeModule(String uri) {
        if (this.myDocument == null && !this.readMapperFile()) {
            return;
        }
        String path = this.findPath(uri);
        if (path == null) {
            return;
        }
        URIMapEntry entry = this.getURIMapEntry(path);
        entry.delete();
        this.save();
    }

    private boolean readMapperFile() {
        if (this.myDocument != null) {
            return true;
        }
        if (!this.myMapperFile.exists()) {
            try {
                this.myResourcesToSkip.add(this.myMapperFile);
                this.myMapperFile.create((InputStream)new ByteArrayInputStream(DEFAULT_TEMPLATE.getBytes()), false, null);
            }
            catch (CoreException e) {
                return false;
            }
        }
        this.myDocument = DescriptorStorage.readDescriptor((IFile)this.myMapperFile, (String)URIMAP_SYSTEM_ID, (String)this.getDtd());
        if (this.myDocument == null) {
            return false;
        }
        this.myMappings = new HashMap();
        NodeList nodes = this.myDocument.getDocumentElement().getChildNodes();
        int i = 0;
        int iMax = nodes.getLength();
        while (i < iMax) {
            URIMapEntry entry;
            String path;
            Element element;
            Node node = nodes.item(i);
            if (node.getNodeType() == 1 && MODULE_TAG.equals((element = (Element)node).getNodeName()) && (path = (entry = new URIMapEntry(element)).getPath()) != null) {
                this.myMappings.put(path, entry);
            }
            ++i;
        }
        return true;
    }

    private void createMapping(IFile newModuleDD, String uri) {
        Element newMapping = this.myDocument.createElement(MODULE_TAG);
        URIMapEntry newEntry = new URIMapEntry(newMapping);
        newEntry.setPath(this.getPath(newModuleDD));
        newEntry.setURI(uri);
        this.myDocument.getDocumentElement().appendChild(newMapping);
        this.myMappings.put(newEntry.getPath(), newEntry);
        this.save();
    }

    private String findPath(String uri) {
        if (uri == null) {
            return null;
        }
        Iterator it = this.myMappings.keySet().iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            URIMapEntry entry = this.getURIMapEntry(path);
            if (!uri.equals(entry.getURI())) continue;
            return path;
        }
        return null;
    }

    private URIMapEntry getURIMapEntry(String path) {
        if (this.myDocument == null && !this.readMapperFile()) {
            return null;
        }
        return (URIMapEntry)this.myMappings.get(path);
    }

    private URIMapEntry getURIMapEntry(IFile file) {
        return this.getURIMapEntry(this.getPath(file));
    }

    private String getPath(IFile file) {
        return file.getFullPath().toString();
    }

    private void save() {
        this.myResourcesToSkip.add(this.myMapperFile);
        DescriptorStorage.writeDescriptor((Document)this.myDocument, (IFile)this.myMapperFile, null, null);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            event.getDelta().accept(this.myResourceDeltaVisitor);
        }
        catch (CoreException ce) {
            EarImplPlugin.logError("Unable to process resource delta", ce);
        }
    }

    protected String getDtd() {
        if (ourDtd == null) {
            ourDtd = FileUtils.getFileContents((String)DTD_PATH, (String)"", (Plugin)EarImplPlugin.getDefault());
        }
        return ourDtd;
    }

    static {
        MAPPER_FILE = new Path(".urimap");
        MODULE_ORDER = new String[]{URI_TAG, PATH_TAG};
    }
}

