/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ear;

import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.ear.WebModule;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.internal.core.descriptor.DescriptorEntityImpl;
import com.tssap.j2ee.internal.core.ear.AbstractModule;
import com.tssap.j2ee.internal.core.ear.EarChildOrder;
import com.tssap.j2ee.internal.core.ear.EarImpl;
import com.tssap.j2ee.internal.core.util.DomUtils;
import org.w3c.dom.Element;

final class WebModuleImpl
extends AbstractModule
implements WebModule {
    public WebModuleImpl(EarImpl ear, Element element) {
        super(ear, element);
    }

    public String toString() {
        return "WebModule \"" + this.getUri() + "\"";
    }

    public void delete() {
        if (!this.edit(null)) {
            return;
        }
        String oldUri = this.getUri();
        super.delete();
        this.update(oldUri);
    }

    private Element getWebElement() {
        return DomUtils.getChildElement((Element)this.getElement(), (String)"web");
    }

    public String getUri() {
        return DomUtils.getChildTextNodeValue((Element)this.getWebElement(), (String)this.getUriTag());
    }

    public boolean canSetUri(String uri) {
        if (DescriptorEntityImpl.isNull((String)uri)) {
            return false;
        }
        return DescriptorEntityImpl.equals((Object)uri, (Object)this.getUri()) || this.getEarImpl().getWebModule(uri) == null;
    }

    public void setUri(String uri) {
        if (!this.canSetUri(uri)) {
            throw new IllegalArgumentException(uri);
        }
        if (uri.equals(this.getUri())) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        String oldUri = this.getUri();
        DomUtils.setChildTextNodeValue((Element)this.getWebElement(), (String[])EarChildOrder.WEB, (String)this.getUriTag(), (String)uri);
        this.update(oldUri);
        this.changed((DescriptorEntity)this);
    }

    public String getContextRoot() {
        return DomUtils.getChildTextNodeValue((Element)this.getWebElement(), (String)"context-root");
    }

    public boolean canSetContextRoot(String contextRoot) {
        return contextRoot != null;
    }

    public void setContextRoot(String contextRoot) {
        if (!this.canSetContextRoot(contextRoot)) {
            throw new IllegalArgumentException(contextRoot);
        }
        if (DescriptorEntityImpl.equals((Object)this.getContextRoot(), (Object)contextRoot)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        DomUtils.setChildTextNodeValue((Element)this.getWebElement(), (String[])EarChildOrder.WEB, (String)"context-root", (String)contextRoot);
        this.changed((DescriptorEntity)this);
    }

    public WebApp getReferencedWebApp() {
        return this.getEarImpl().getReferencedWebApp(this);
    }

    protected String getUriTag() {
        return "web-uri";
    }

    protected void update(String oldUri) {
        this.getEarImpl().updateWebModule(oldUri);
    }
}

