/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ear;

import com.tssap.j2ee.core.descriptor.AbstractJ2eeDescriptorProject;
import com.tssap.j2ee.core.descriptor.DescriptorDeltaListener;
import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.ear.Ear;
import com.tssap.j2ee.core.ear.EarProject;
import com.tssap.j2ee.core.ejbjar.EjbJarProject;
import com.tssap.j2ee.core.utils.FileUtils;
import com.tssap.j2ee.core.webapp.WebAppProject;
import com.tssap.j2ee.internal.core.ear.EarImpl;
import com.tssap.j2ee.internal.core.ear.EarImplPlugin;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.util.UpdateCommand;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IJavaProject;

public final class EarProjectImpl
extends EarProject {
    private Map myEars = new HashMap();
    private IResourceChangeListener myResourceChangeListener;
    private IResourceDeltaVisitor myResourceDeltaVisitor;
    private static final String TEMPLATE_PATH = "templates/application.xml";
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String EAR_DTD = "<!DOCTYPE application PUBLIC \"-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN\" \"http://java.sun.com/dtd/application_1_3.dtd\">";
    private static final String DEFAULT_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE application PUBLIC \"-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN\" \"http://java.sun.com/dtd/application_1_3.dtd\"><ejb-jar></ejb-jar>";
    private static String ourTemplate;

    public void setProject(IProject project) {
        super.setProject(project);
        this.myEars.clear();
        String fixedLocation = EarProjectImpl.getFixedLocation();
        EarImplPlugin.logInfo("Fixed location [" + fixedLocation + "]");
        if (fixedLocation != null) {
            IFile file = project.getFile(fixedLocation);
            if (file.exists()) {
                EarImplPlugin.logInfo("Fixed descriptor file found [" + file.getFullPath() + "]");
                this.addEar(file);
            }
        } else {
            try {
                IJavaProject javaProject = this.getJavaProject();
                final IPath output = javaProject == null ? null : javaProject.getOutputLocation();
                project.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) {
                        IFolder folder;
                        if (!resource.isAccessible()) {
                            return false;
                        }
                        if (resource instanceof IFolder && output != null && output.equals((Object)(folder = (IFolder)resource).getFullPath())) {
                            return false;
                        }
                        if (resource instanceof IFile && "application.xml".equals(resource.getName())) {
                            EarImplPlugin.logInfo("Descriptor file found [" + resource.getFullPath() + "]");
                            EarProjectImpl.this.addEar((IFile)resource);
                        }
                        return true;
                    }
                });
            }
            catch (CoreException ce) {
                EarImplPlugin.logError("Exception while reading descriptor files in the project [" + project + "]", ce);
            }
        }
    }

    protected Ear addEar(IFile file) {
        EarImpl ear = (EarImpl)((Object)this.myEars.remove(EarProjectImpl.getLocation(file)));
        if (!file.isAccessible()) {
            return null;
        }
        if (ear == null) {
            ear = new EarImpl(file, this);
        } else {
            ear.reload();
        }
        this.myEars.put(EarProjectImpl.getLocation(file), ear);
        return ear;
    }

    public Ear getEar(IFile file) {
        EarImpl ear = (EarImpl)((Object)this.myEars.get(EarProjectImpl.getLocation(file)));
        if (ear == null) {
            return null;
        }
        if (ear.isFileModified()) {
            ear = (EarImpl)this.addEar(file);
        }
        return ear;
    }

    public Ear[] getEars() {
        if (this.myEars.isEmpty()) {
            return null;
        }
        ArrayList ears = new ArrayList(this.myEars.values());
        int i = ears.size() - 1;
        while (i >= 0) {
            EarImpl ear = (EarImpl)((Object)ears.get(i));
            if (ear.isFileModified()) {
                this.addEar(ear.getFile());
            }
            --i;
        }
        ears = new ArrayList(this.myEars.values());
        return ears.toArray(new Ear[ears.size()]);
    }

    public boolean canCreateEar(IFile file) {
        if (file.exists()) {
            return false;
        }
        IContainer folder = file.getParent();
        if (!folder.isAccessible() || folder.isReadOnly()) {
            return false;
        }
        Ear ear = this.getEar(file);
        return ear == null;
    }

    public Ear createEar(IFile file) {
        if (!this.canCreateEar(file)) {
            throw new IllegalArgumentException();
        }
        ByteArrayInputStream source = new ByteArrayInputStream(this.getTemplate().getBytes());
        try {
            file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ce) {
            EarImplPlugin.logError("Unable to create file [" + file + "]", ce);
            return null;
        }
        return this.addEar(file);
    }

    public EjbJarProject[] getReferencedEjbJarProjects() {
        ArrayList ejbJarProjects = new ArrayList();
        this.addEjbJarProject(this.getProject(), ejbJarProjects);
        try {
            IProject[] projects = this.getProject().getReferencedProjects();
            if (projects != null && projects.length > 0) {
                int i = 0;
                while (i < projects.length) {
                    this.addEjbJarProject(projects[i], ejbJarProjects);
                    ++i;
                }
            }
        }
        catch (CoreException ce) {
            EarImplPlugin.logError("Unable to retrieve referenced projects", ce);
        }
        return ejbJarProjects.toArray(new EjbJarProject[ejbJarProjects.size()]);
    }

    protected void addEjbJarProject(IProject project, Collection ejbJarProjects) {
        if (project == null || !project.isAccessible()) {
            return;
        }
        try {
            EjbJarProject ejbJarProject;
            if (project.hasNature("com.tssap.j2ee.core.ejbjar.ejbJarNature") && (ejbJarProject = EjbJarProject.getInstance((IProject)project)) != null) {
                ejbJarProjects.add(ejbJarProject);
            }
        }
        catch (CoreException ce) {
            EarImplPlugin.logError("Unable to retrieve referenced ejb jar project for the [" + project + "]", ce);
        }
    }

    public WebAppProject[] getReferencedWebAppProjects() {
        ArrayList webAppProjects = new ArrayList();
        this.addWebAppProject(this.getProject(), webAppProjects);
        try {
            IProject[] projects = this.getProject().getReferencedProjects();
            if (projects != null && projects.length > 0) {
                int i = 0;
                while (i < projects.length) {
                    this.addWebAppProject(projects[i], webAppProjects);
                    ++i;
                }
            }
        }
        catch (CoreException ce) {
            EarImplPlugin.logError("Unable to retrieve referenced projects", ce);
        }
        return webAppProjects.toArray(new WebAppProject[webAppProjects.size()]);
    }

    protected void addWebAppProject(IProject project, Collection webAppProjects) {
        if (project == null || !project.isAccessible()) {
            return;
        }
        try {
            WebAppProject webAppProject;
            if (project.hasNature("com.tssap.j2ee.core.webapp.webAppNature") && (webAppProject = WebAppProject.getInstance((IProject)project)) != null) {
                webAppProjects.add(webAppProject);
            }
        }
        catch (CoreException ce) {
            EarImplPlugin.logError("Unable to retrieve referenced ejb jar project for the [" + project + "]", ce);
        }
    }

    public void addDescriptorDeltaListener(DescriptorDeltaListener listener) {
        super.addDescriptorDeltaListener(listener);
        this.registerResourceChangeListener();
    }

    public void removeDescriptorDeltaListener(DescriptorDeltaListener listener) {
        super.removeDescriptorDeltaListener(listener);
        if (!this.hasDescriptorDeltaListeners()) {
            this.unregisterResourceChangeListener();
            this.myResourceChangeListener = null;
        }
    }

    private void fileAdded(IFile file) {
        Ear ear = this.addEar(file);
        if (ear != null) {
            EarImplPlugin.logInfo("Descriptor added [" + file + "]");
            this.descriptorEntityAdded((DescriptorEntity)ear);
            this.clearDescriptorDeltaFired();
        }
    }

    private void fileRemoved(IFile file) {
        Ear cachedEar = (Ear)this.myEars.remove(EarProjectImpl.getLocation(file));
        if (cachedEar != null) {
            EarImplPlugin.logInfo("Descriptor removed [" + file + "]");
            this.descriptorEntityRemoved((DescriptorEntity)cachedEar);
            this.clearDescriptorDeltaFired();
        }
    }

    private void fileChanged(IFile file) {
        Ear cachedEar = this.getEar(file);
        Ear ear = this.addEar(file);
        if (cachedEar != null) {
            if (ear != null) {
                EarImplPlugin.logInfo("Descriptor changed [" + file + "]");
                this.descriptorEntityTotallyChanged((DescriptorEntity)ear);
                this.clearDescriptorDeltaFired();
            } else {
                EarImplPlugin.logInfo("Descriptor removed [" + file + "], it became invalid");
                this.descriptorEntityRemoved((DescriptorEntity)cachedEar);
                this.clearDescriptorDeltaFired();
            }
        } else if (ear != null) {
            EarImplPlugin.logInfo("Descriptor added [" + file + "], it was invalid before");
            this.descriptorEntityAdded((DescriptorEntity)ear);
            this.clearDescriptorDeltaFired();
        }
    }

    private void registerResourceChangeListener() {
        this.myResourceChangeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IProject project = EarProjectImpl.this.getProject();
                if (project == null || !project.isAccessible()) {
                    return;
                }
                if (1 == event.getType()) {
                    try {
                        if (EarProjectImpl.this.myResourceDeltaVisitor == null) {
                            EarProjectImpl.this.myResourceDeltaVisitor = new EarResourceDeltaVisitor();
                            EarImplPlugin.logInfo("Resource delta visitor instantiated");
                        }
                        event.getDelta().accept(EarProjectImpl.this.myResourceDeltaVisitor);
                    }
                    catch (CoreException ce) {
                        EarImplPlugin.logError("Exception while processing resource delta", ce);
                    }
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.myResourceChangeListener);
        EarImplPlugin.logInfo("Resource delta listener registered");
    }

    private void unregisterResourceChangeListener() {
        if (this.myResourceChangeListener == null) {
            return;
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.myResourceChangeListener);
        EarImplPlugin.logInfo("Resource delta listener unregistered");
    }

    private static String getLocation(IFile file) {
        return file.getProjectRelativePath().toString();
    }

    protected String getTemplate() {
        if (ourTemplate == null) {
            ourTemplate = FileUtils.getFileContents((String)TEMPLATE_PATH, (String)DEFAULT_TEMPLATE, (Plugin)EarImplPlugin.getDefault());
        }
        return ourTemplate;
    }

    public static String getFixedLocation() {
        return AbstractJ2eeDescriptorProject.getFixedLocation((Plugin)EarImplPlugin.getDefault());
    }

    protected String[] getRequiredLibraries() {
        return new String[0];
    }

    static /* synthetic */ void access$500(EarProjectImpl x0, IFile x1) {
        x0.fileAdded(x1);
    }

    static /* synthetic */ void access$600(EarProjectImpl x0, IFile x1) {
        x0.fileChanged(x1);
    }

    static /* synthetic */ void access$700(EarProjectImpl x0, IFile x1) {
        x0.fileRemoved(x1);
    }

    private class EarResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private final String myFixedLocation = EarProjectImpl.getFixedLocation();

        private EarResourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) {
            IResource resource = delta.getResource();
            if (resource instanceof IWorkspaceRoot) {
                return true;
            }
            if (!EarProjectImpl.this.getProject().equals((Object)resource.getProject())) {
                return false;
            }
            if (this.myFixedLocation != null) {
                if (!(resource instanceof IFile)) {
                    return true;
                }
                IFile file = (IFile)resource;
                if (this.myFixedLocation.equals(file.getProjectRelativePath().toString())) {
                    this.process(delta);
                }
            } else {
                try {
                    IFolder folder;
                    IPath output;
                    IJavaProject javaProject = EarProjectImpl.this.getJavaProject();
                    IPath iPath = output = javaProject == null ? null : javaProject.getOutputLocation();
                    if (resource instanceof IFolder && output != null && output.equals((Object)(folder = (IFolder)resource).getFullPath())) {
                        return false;
                    }
                }
                catch (CoreException ce) {
                    return false;
                }
                if (!(resource instanceof IFile)) {
                    return true;
                }
                IFile file = (IFile)resource;
                if (!"application.xml".equals(file.getName())) {
                    return true;
                }
                this.process(delta);
            }
            return true;
        }

        private void process(IResourceDelta delta) {
            if (EarProjectImpl.super.isDescriptorDeltaFired()) {
                EarProjectImpl.super.clearDescriptorDeltaFired();
                return;
            }
            int kind = delta.getKind();
            IFile file = (IFile)delta.getResource();
            ModelAccess.runCommandLater((Runnable)new UpdateCommand(this, kind, file){
                private final /* synthetic */ int val$kind;
                private final /* synthetic */ IFile val$file;
                private final /* synthetic */ EarResourceDeltaVisitor this$1;
                {
                    this.this$1 = this$1;
                    this.val$kind = val$kind;
                    this.val$file = val$file;
                }

                public void run() {
                    if ((this.val$kind & 1) > 0) {
                        EarProjectImpl.access$500(EarResourceDeltaVisitor.access$400(this.this$1), this.val$file);
                    } else if ((this.val$kind & 4) > 0) {
                        EarProjectImpl.access$600(EarResourceDeltaVisitor.access$400(this.this$1), this.val$file);
                    } else if ((this.val$kind & 2) > 0) {
                        EarProjectImpl.access$700(EarResourceDeltaVisitor.access$400(this.this$1), this.val$file);
                    }
                }
            });
        }

        static /* synthetic */ EarProjectImpl access$400(EarResourceDeltaVisitor x0) {
            return x0.EarProjectImpl.this;
        }
    }
}

